/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rdf;

import java.net.URI;
import org.dspace.app.rest.test.AbstractWebClientIntegrationTest;
import org.dspace.builder.CommunityBuilder;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.rdf.RDFUtil;
import org.dspace.rdf.conversion.RDFConverter;
import org.dspace.rdf.factory.RDFFactoryImpl;
import org.dspace.rdf.storage.RDFStorage;
import org.dspace.rdf.storage.RDFStorageImpl;
import org.dspace.services.ConfigurationService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"rdf.enabled = true"})
public class RdfIT
extends AbstractWebClientIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private SiteService siteService;
    @Autowired
    private RDFConverter rdfConverter;
    @Autowired
    private RDFFactoryImpl rdfFactory;
    @Spy
    RDFStorage rdfStorage = new RDFStorageImpl();
    private final String SERIALIZE_PATH = "/rdf/handle";
    private final String REDIRECTION_PATH = "/rdf/resource";

    @Before
    public void onlyRunIfConfigExists() {
        try {
            Class.forName("org.dspace.app.configuration.RDFWebConfig");
        }
        catch (ClassNotFoundException ce) {
            Assume.assumeNoException((Throwable)ce);
        }
        this.rdfFactory.setStorage(this.rdfStorage);
    }

    @Test
    public void serializationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Test Community").build();
        this.context.commit();
        this.context.restoreAuthSystemState();
        String communityIdentifier = RDFUtil.generateIdentifier((Context)this.context, (DSpaceObject)community);
        String siteIdentifier = RDFUtil.generateIdentifier((Context)this.context, (DSpaceObject)this.siteService.findSite(this.context));
        ((RDFStorage)Mockito.doReturn((Object)this.rdfConverter.convert(this.context, (DSpaceObject)community)).when((Object)this.rdfStorage)).load(communityIdentifier);
        ResponseEntity<String> response = this.getResponseAsString("/rdf/handle/" + community.getHandle());
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)HttpStatus.OK));
        Assert.assertThat((Object)response.getHeaders().getContentType().toString(), (Matcher)CoreMatchers.equalTo((Object)"text/turtle;charset=UTF-8"));
        Assert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)communityIdentifier));
        Assert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)("dspace:isPartOfRepository  <" + siteIdentifier + ">;")));
    }

    @Test
    public void redirectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Test Community").build();
        this.context.commit();
        this.context.restoreAuthSystemState();
        String communityHandle = community.getHandle();
        ResponseEntity<String> response = this.getResponseAsString("/rdf/resource/" + communityHandle);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)HttpStatus.SEE_OTHER));
        Assert.assertThat((Object)response.getHeaders().getLocation(), (Matcher)CoreMatchers.equalTo((Object)URI.create(this.configurationService.getProperty("dspace.ui.url") + "/handle/" + communityHandle + "/")));
    }
}

