/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.time.Period;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.CharEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.app.rest.matcher.BitstreamFormatMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BitstreamFormatBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.disseminate.CitationDocumentServiceImpl;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.services.ConfigurationService;
import org.dspace.statistics.ObjectCount;
import org.dspace.statistics.SolrLoggerServiceImpl;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.dspace.statistics.service.SolrLoggerService;
import org.dspace.storage.bitstore.factory.StorageServiceFactory;
import org.dspace.storage.bitstore.service.BitstreamStorageService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class BitstreamRestControllerIT
extends AbstractControllerIntegrationTest {
    protected SolrLoggerService solrLoggerService = StatisticsServiceFactory.getInstance().getSolrLoggerService();
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private CitationDocumentServiceImpl citationDocumentService;
    @Autowired
    private BitstreamService bitstreamService;
    @Autowired
    private ResourcePolicyService resourcePolicyService;
    @Autowired
    private BitstreamFormatService bitstreamFormatService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CollectionService collectionService;
    private Bitstream bitstream;
    private BitstreamFormat supportedFormat;
    private BitstreamFormat knownFormat;
    private BitstreamFormat unknownFormat;

    @BeforeClass
    public static void clearStatistics() throws Exception {
        StatisticsServiceFactory.getInstance().getSolrLoggerService().removeIndex("*:*");
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("citation-page.enable_globally", (Object)false);
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).build();
        this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)IOUtils.toInputStream((String)"test", (String)org.apache.commons.codec.CharEncoding.UTF_8)).withFormat("test format").build();
        this.unknownFormat = this.bitstreamFormatService.findUnknown(this.context);
        this.knownFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withMimeType("known test mime type").withDescription("known test description").withShortDescription("known test short description").withSupportLevel(1).build();
        this.supportedFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withMimeType("supported mime type").withDescription("supported description").withShortDescription("supported short description").withSupportLevel(2).build();
        this.bitstream.setFormat(this.context, this.supportedFormat);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void retrieveFullBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "0123456789";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Item publicItem1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test bitstream").withDescription("This is a bitstream to test range requests").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.head((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().longValue("Content-Length", (long)bitstreamContent.getBytes().length)).andExpect(MockMvcResultMatchers.header().string("Content-Type", "text/plain;charset=UTF-8")).andExpect(MockMvcResultMatchers.header().string("ETag", "\"" + this.bitstream.getChecksum() + "\"")).andExpect(MockMvcResultMatchers.content().bytes(new byte[0]));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().longValue("Content-Length", (long)bitstreamContent.getBytes().length)).andExpect(MockMvcResultMatchers.header().string("Accept-Ranges", "bytes")).andExpect(MockMvcResultMatchers.header().string("ETag", "\"" + this.bitstream.getChecksum() + "\"")).andExpect(MockMvcResultMatchers.content().contentType("text/plain;charset=UTF-8")).andExpect(MockMvcResultMatchers.content().bytes(bitstreamContent.getBytes()));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.head((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0]).header("If-None-Match", new Object[]{this.bitstream.getChecksum()})).andExpect(MockMvcResultMatchers.status().isNotModified());
        this.checkNumberOfStatsRecords(this.bitstream, 3);
    }

    @Test
    public void retrieveRangeBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "0123456789";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Item publicItem1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test bitstream").withDescription("This is a bitstream to test range requests").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0]).header("Range", new Object[]{"bytes=1-3"})).andExpect(MockMvcResultMatchers.status().is(206)).andExpect(MockMvcResultMatchers.header().longValue("Content-Length", 3L)).andExpect(MockMvcResultMatchers.header().string("Accept-Ranges", "bytes")).andExpect(MockMvcResultMatchers.header().string("ETag", "\"" + this.bitstream.getChecksum() + "\"")).andExpect(MockMvcResultMatchers.header().string("Content-Range", "bytes 1-3/10")).andExpect(MockMvcResultMatchers.content().contentType("text/plain;charset=UTF-8")).andExpect(MockMvcResultMatchers.content().bytes("123".getBytes()));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0]).header("Range", new Object[]{"bytes=4-"})).andExpect(MockMvcResultMatchers.status().is(206)).andExpect(MockMvcResultMatchers.header().longValue("Content-Length", 6L)).andExpect(MockMvcResultMatchers.header().string("Accept-Ranges", "bytes")).andExpect(MockMvcResultMatchers.header().string("ETag", "\"" + this.bitstream.getChecksum() + "\"")).andExpect(MockMvcResultMatchers.header().string("Content-Range", "bytes 4-9/10")).andExpect(MockMvcResultMatchers.content().contentType("text/plain;charset=UTF-8")).andExpect(MockMvcResultMatchers.content().bytes("456789".getBytes()));
        this.checkNumberOfStatsRecords(this.bitstream, 0);
    }

    @Test
    public void testBitstreamName() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).build();
        String bitstreamContent = "0123456789";
        String bitstreamName = "\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).build();
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName(bitstreamName).build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment;filename=\"" + MimeUtility.encodeText((String)bitstreamName) + "\""));
    }

    @Test
    public void testBitstreamNotFound() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + UUID.randomUUID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testEmbargoedBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "Embargoed!";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Item publicItem1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType("text/plain").withEmbargoPeriod(Period.ofMonths(6)).build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.checkNumberOfStatsRecords(this.bitstream, 0);
    }

    @Test
    public void embargoedBitstreamForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "Embargoed!";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Item publicItem1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType("text/plain").withEmbargoPeriod(Period.ofMonths(3)).build();
        }
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.checkNumberOfStatsRecords(this.bitstream, 0);
    }

    @Test
    public void expiredEmbargoedBitstreamTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "Embargoed!";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Item publicItem1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("Public item 1").withIssueDate("2015-10-17").withAuthor("Smith, Donald").build();
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType("text/plain").withEmbargoPeriod(Period.ofMonths(-3)).build();
        }
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.checkNumberOfStatsRecords(this.bitstream, 2);
    }

    @Test
    public void embargoedBitstreamAccessGrantByAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson adminParentCommunity = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminCommunity@mail.com").withPassword("qwerty02").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{adminParentCommunity}).build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        EPerson adminChild2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminChil2@mail.com").withPassword("qwerty05").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 2").withAdminGroup(new EPerson[]{adminChild2}).build();
        EPerson adminCollection1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminCollection1@mail.com").withPassword("qwerty03").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withAdminGroup(new EPerson[]{adminCollection1}).build();
        EPerson adminCollection2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminCol2@mail.com").withPassword("qwerty01").build();
        org.dspace.content.Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withAdminGroup(new EPerson[]{adminCollection2}).build();
        String bitstreamContent = "Embargoed!";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("Test").withIssueDate("2018-10-18").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").withEmbargoPeriod(Period.ofWeeks(2)).build();
        }
        this.context.restoreAuthSystemState();
        String tokenAdminParentCommunity = this.getAuthToken(adminParentCommunity.getEmail(), "qwerty02");
        this.getClient(tokenAdminParentCommunity).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        String tokenAdminCollection1 = this.getAuthToken(adminCollection1.getEmail(), "qwerty03");
        this.getClient(tokenAdminCollection1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.checkNumberOfStatsRecords(bitstream, 2);
        String tokenAdminCollection2 = this.getAuthToken(adminCollection2.getEmail(), "qwerty01");
        this.getClient(tokenAdminCollection2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenAdminChild2 = this.getAuthToken(adminChild2.getEmail(), "qwerty05");
        this.getClient(tokenAdminCollection2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.checkNumberOfStatsRecords(bitstream, 2);
    }

    @Test
    public void testPrivateBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
        Group internalGroup = GroupBuilder.createGroup((Context)this.context).withName("Internal Group").build();
        String bitstreamContent = "Private!";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType("text/plain").withReaderGroup(internalGroup).build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.checkNumberOfStatsRecords(this.bitstream, 0);
    }

    @Test
    public void testBitstreamDefaultReadInheritanceFromCollection() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Group internalGroup = GroupBuilder.createGroup((Context)this.context).withName("Internal Group").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.authorizeService.removePoliciesActionFilter(this.context, (DSpaceObject)col1, 9);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)col1, 9, internalGroup);
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
        this.authorizeService.removePoliciesActionFilter(this.context, (DSpaceObject)publicItem1, 9);
        String bitstreamContent = "Private!";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test Restricted Bitstream").withDescription("This bitstream is restricted").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.checkNumberOfStatsRecords(this.bitstream, 0);
    }

    @Test
    public void restrictedGroupBitstreamForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Group restrictedGroup = GroupBuilder.createGroup((Context)this.context).withName("Restricted Group").addMember(this.eperson).build();
        String bitstreamContent = "Private!";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("item 1").withIssueDate("2013-01-17").withAuthor("Doe, John").build();
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType("text/plain").withReaderGroup(restrictedGroup).build();
        }
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.checkNumberOfStatsRecords(this.bitstream, 1);
        String tokenEPerson2 = this.getAuthToken(eperson2.getEmail(), "qwerty02");
        this.getClient(tokenEPerson2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.checkNumberOfStatsRecords(this.bitstream, 1);
    }

    @Test
    public void restrictedSpecialGroupBitstreamTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Group restrictedGroup = GroupBuilder.createGroup((Context)this.context).withName("Restricted Group").build();
        String bitstreamContent = "Private!";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("item 1").withIssueDate("2013-01-17").withAuthor("Doe, John").build();
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType("text/plain").withReaderGroup(restrictedGroup).build();
        }
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.configurationService.setProperty("authentication-password.login.specialgroup", (Object)"Restricted Group");
        authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.checkNumberOfStatsRecords(this.bitstream, 1);
    }

    @Test
    public void restrictedGroupBitstreamAccessGrantByAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson adminParentCommunity = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminCommunity@mail.com").withPassword("qwerty00").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{adminParentCommunity}).build();
        EPerson adminChild1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminChild1@mail.com").withPassword("qwerty05").build();
        Community child1 = CommunityBuilder.createCommunity((Context)this.context).withName("Sub Community").withAdminGroup(new EPerson[]{adminChild1}).build();
        EPerson adminCol1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("admin1@mail.com").withPassword("qwerty01").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withAdminGroup(new EPerson[]{adminCol1}).build();
        EPerson adminCol2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("admin2@mail.com").withPassword("qwerty02").build();
        org.dspace.content.Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").withAdminGroup(new EPerson[]{adminCol2}).build();
        Group restrictedGroup = GroupBuilder.createGroup((Context)this.context).withName("Restricted Group").addMember(this.eperson).build();
        String bitstreamContent = "Private!";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("item").withIssueDate("2018-10-17").withAuthor("Doe, John").build();
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Test Embargoed Bitstream").withDescription("This bitstream is embargoed").withMimeType("text/plain").withReaderGroup(restrictedGroup).build();
        }
        this.context.restoreAuthSystemState();
        String tokenAdminParentCommuity = this.getAuthToken(adminParentCommunity.getEmail(), "qwerty00");
        this.getClient(tokenAdminParentCommuity).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        String tokenAdminCol1 = this.getAuthToken(adminCol1.getEmail(), "qwerty01");
        this.getClient(tokenAdminCol1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.checkNumberOfStatsRecords(this.bitstream, 2);
        String tokenAdminCol2 = this.getAuthToken(adminCol2.getEmail(), "qwerty02");
        this.getClient(tokenAdminCol2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenAdminChild1 = this.getAuthToken(adminChild1.getEmail(), "qwerty05");
        this.getClient(tokenAdminCol2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.checkNumberOfStatsRecords(this.bitstream, 2);
    }

    private void checkNumberOfStatsRecords(Bitstream bitstream, int expectedNumberOfStatsRecords) throws SolrServerException, IOException {
        SolrLoggerServiceImpl.ResultProcessor rs = new SolrLoggerServiceImpl.ResultProcessor((SolrLoggerServiceImpl)this.solrLoggerService);
        rs.commit();
        ObjectCount objectCount = this.solrLoggerService.queryTotal("type:0 AND id:" + bitstream.getID(), null, 1);
        Assert.assertEquals((long)expectedNumberOfStatsRecords, (long)objectCount.getCount());
    }

    @Test
    public void retrieveCitationCoverpageOfBitstream() throws Exception {
        this.configurationService.setProperty("citation-page.enable_globally", (Object)true);
        this.citationDocumentService.afterPropertiesSet();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        File originalPdf = new File(testProps.getProperty("test.bitstream"));
        try (FileInputStream is = new FileInputStream(originalPdf);){
            Item publicItem1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("Public item citation cover page test 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test bitstream").withDescription("This is a bitstream to test the citation cover page.").withMimeType("application/pdf").build();
        }
        this.context.restoreAuthSystemState();
        byte[] content = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Content-Length", CoreMatchers.not((Matcher)CoreMatchers.nullValue()))).andExpect(MockMvcResultMatchers.header().string("ETag", CoreMatchers.not((Matcher)CoreMatchers.nullValue()))).andExpect(MockMvcResultMatchers.header().string("Accept-Ranges", "bytes")).andExpect(MockMvcResultMatchers.content().contentType("application/pdf;charset=UTF-8")).andReturn().getResponse().getContentAsByteArray();
        String pdfText = this.extractPDFText(content);
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)pdfText, (CharSequence)"Public item citation cover page test 1"));
        Assert.assertEquals((long)65L, (long)this.getNumberOfPdfPages(content));
        String etagHeader = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andReturn().getResponse().getHeader("ETag");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.head((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0]).header("If-None-Match", new Object[]{etagHeader})).andExpect(MockMvcResultMatchers.status().isNotModified());
        this.checkNumberOfStatsRecords(this.bitstream, 3);
    }

    /*
     * Exception decompiling
     */
    private String extractPDFText(byte[] content) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getNumberOfPdfPages(byte[] content) throws IOException {
        try (ByteArrayInputStream source = new ByteArrayInputStream(content);){
            int n;
            block11: {
                PDDocument pdfDoc = PDDocument.load((InputStream)source);
                try {
                    n = pdfDoc.getNumberOfPages();
                    if (pdfDoc == null) break block11;
                }
                catch (Throwable throwable) {
                    if (pdfDoc != null) {
                        try {
                            pdfDoc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pdfDoc.close();
            }
            return n;
        }
    }

    @Test
    public void getBitstreamFormatUnauthorized() throws Exception {
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)this.bitstream, 0);
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)this.bitstream.getBundles().get(0), 0);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/format"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getBitstreamFormatForbidden() throws Exception {
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)this.bitstream, 0);
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)this.bitstream.getBundles().get(0), 0);
        this.getClient(this.getAuthToken(this.eperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/format"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getBitstreamFormat() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/format"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BitstreamFormatMatcher.matchBitstreamFormat(this.supportedFormat.getID(), this.supportedFormat.getMIMEType(), this.supportedFormat.getDescription(), this.supportedFormat.getShortDescription(), "SUPPORTED")));
    }

    @Test
    public void updateBitstreamFormatBadRequest() throws Exception {
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/format"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api//api/core/bitstreamformat/-1")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/format"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api//api/core/bitstreamformat/" + this.knownFormat.getID() + "\nhttp://localhost/api//api/core/bitstreamformat/" + this.supportedFormat.getID())).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void updateBitstreamFormatNotFound() throws Exception {
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + UUID.randomUUID() + "/format"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api//api/core/bitstreamformat/" + this.unknownFormat.getID())).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void updateBitstreamFormatUnauthorized() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/format"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api//api/core/bitstreamformat/" + this.knownFormat.getID())).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void updateBitstreamFormatForbidden() throws Exception {
        this.getClient(this.getAuthToken(this.eperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/format"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api//api/core/bitstreamformat/" + this.knownFormat.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void updateBitstreamFormatEPerson() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(1).withDspaceObject((DSpaceObject)this.bitstream).build();
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(this.eperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/format"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api//api/core/bitstreamformat/" + this.knownFormat.getID())).andExpect(MockMvcResultMatchers.status().isOk());
        this.bitstream = (Bitstream)this.context.reloadEntity((ReloadableEntity)this.bitstream);
        Assert.assertThat((Object)this.knownFormat, (Matcher)Matchers.equalTo((Object)this.bitstream.getFormat(this.context)));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.bitstreamService.getMetadataByMetadataString((DSpaceObject)this.bitstream, "dc.format")));
    }

    @Test
    public void updateBitstreamFormatAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/format"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api//api/core/bitstreamformat/" + this.unknownFormat.getID())).andExpect(MockMvcResultMatchers.status().isOk());
        this.bitstream = (Bitstream)this.context.reloadEntity((ReloadableEntity)this.bitstream);
        Assert.assertThat((Object)this.unknownFormat, (Matcher)Matchers.equalTo((Object)this.bitstream.getFormat(this.context)));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.bitstreamService.getMetadataByMetadataString((DSpaceObject)this.bitstream, "dc.format")));
    }

    @Test
    public void closeInputStreamsRegularDownload() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        String bitstreamContent = "0123456789";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Item publicItem1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test bitstream").withDescription("This is a bitstream to test range requests").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        BitstreamStorageService bitstreamStorageService = StorageServiceFactory.getInstance().getBitstreamStorageService();
        InputStream inputStream = bitstreamStorageService.retrieve(this.context, this.bitstream);
        InputStream inputStreamSpy = (InputStream)Mockito.spy((Object)inputStream);
        BitstreamStorageService bitstreamStorageServiceSpy = (BitstreamStorageService)Mockito.spy((Object)bitstreamStorageService);
        ReflectionTestUtils.setField((Object)this.bitstreamService, (String)"bitstreamStorageService", (Object)bitstreamStorageServiceSpy);
        ((BitstreamStorageService)Mockito.doReturn((Object)inputStreamSpy).when((Object)bitstreamStorageServiceSpy)).retrieve((Context)ArgumentMatchers.any(), (Bitstream)ArgumentMatchers.eq((Object)this.bitstream));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        ((BitstreamStorageService)Mockito.verify((Object)bitstreamStorageServiceSpy, (VerificationMode)Mockito.times((int)1))).retrieve((Context)ArgumentMatchers.any(), (Bitstream)ArgumentMatchers.eq((Object)this.bitstream));
        ((InputStream)Mockito.verify((Object)inputStreamSpy, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void closeInputStreamsDownloadWithCoverPage() throws Exception {
        this.configurationService.setProperty("citation-page.enable_globally", (Object)true);
        this.citationDocumentService.afterPropertiesSet();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        File originalPdf = new File(testProps.getProperty("test.bitstream"));
        try (FileInputStream is = new FileInputStream(originalPdf);){
            Item publicItem1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("Public item citation cover page test 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
            this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test bitstream").withDescription("This is a bitstream to test the citation cover page.").withMimeType("application/pdf").build();
        }
        this.context.restoreAuthSystemState();
        BitstreamStorageService bitstreamStorageService = StorageServiceFactory.getInstance().getBitstreamStorageService();
        InputStream inputStreamSpy = (InputStream)Mockito.spy((Object)bitstreamStorageService.retrieve(this.context, this.bitstream));
        BitstreamStorageService bitstreamStorageServiceSpy = (BitstreamStorageService)Mockito.spy((Object)bitstreamStorageService);
        ReflectionTestUtils.setField((Object)this.bitstreamService, (String)"bitstreamStorageService", (Object)bitstreamStorageServiceSpy);
        ((BitstreamStorageService)Mockito.doReturn((Object)inputStreamSpy).when((Object)bitstreamStorageServiceSpy)).retrieve((Context)ArgumentMatchers.any(), (Bitstream)ArgumentMatchers.eq((Object)this.bitstream));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        ((BitstreamStorageService)Mockito.verify((Object)bitstreamStorageServiceSpy, (VerificationMode)Mockito.times((int)1))).retrieve((Context)ArgumentMatchers.any(), (Bitstream)ArgumentMatchers.eq((Object)this.bitstream));
        ((InputStream)Mockito.verify((Object)inputStreamSpy, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void checkContentDispositionOfFormats() throws Exception {
        Bitstream csv;
        Bitstream txt;
        Bitstream xml;
        Bitstream rtf;
        this.configurationService.setProperty("webui.content_disposition_format", (Object)new String[]{"text/richtext", "text/xml", "txt"});
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).build();
        String content = "Test Content";
        try (InputStream is = IOUtils.toInputStream((String)content, (String)CharEncoding.UTF_8);){
            rtf = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("text/richtext").build();
            xml = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("text/xml").build();
            txt = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("text/plain").build();
            csv = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("text/csv").build();
        }
        this.context.restoreAuthSystemState();
        this.verifyBitstreamDownload(rtf, "text/richtext;charset=UTF-8", true);
        this.verifyBitstreamDownload(xml, "text/xml;charset=UTF-8", true);
        this.verifyBitstreamDownload(txt, "text/plain;charset=UTF-8", true);
        this.verifyBitstreamDownload(csv, "text/csv;charset=UTF-8", false);
    }

    @Test
    public void checkHardcodedContentDispositionFormats() throws Exception {
        Bitstream svg;
        Bitstream unknown;
        Bitstream xml;
        Bitstream rdf;
        Bitstream js;
        Bitstream html;
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).build();
        String content = "Test Content";
        try (InputStream is = IOUtils.toInputStream((String)content, (String)CharEncoding.UTF_8);){
            html = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("text/html").build();
            js = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("text/javascript").build();
            rdf = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("application/rdf+xml; charset=utf-8").build();
            xml = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("text/xml").build();
            unknown = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("application/octet-stream").build();
            svg = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("image/svg+xml").build();
        }
        this.context.restoreAuthSystemState();
        this.verifyBitstreamDownload(html, "text/html;charset=UTF-8", true);
        this.verifyBitstreamDownload(js, "text/javascript;charset=UTF-8", true);
        this.verifyBitstreamDownload(rdf, "application/rdf+xml;charset=UTF-8", true);
        this.verifyBitstreamDownload(xml, "text/xml;charset=UTF-8", true);
        this.verifyBitstreamDownload(unknown, "application/octet-stream;charset=UTF-8", true);
        this.verifyBitstreamDownload(svg, "application/octet-stream;charset=UTF-8", true);
    }

    @Test
    public void checkWildcardContentDispositionFormats() throws Exception {
        Bitstream pdf;
        Bitstream mpg;
        Bitstream jpg;
        Bitstream csv;
        this.configurationService.setProperty("webui.content_disposition_format", (Object)"*");
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).build();
        String content = "Test Content";
        try (InputStream is = IOUtils.toInputStream((String)content, (String)CharEncoding.UTF_8);){
            csv = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("text/csv").build();
            jpg = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("image/jpeg").build();
            mpg = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("video/mpeg").build();
            pdf = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withMimeType("application/pdf").build();
        }
        this.context.restoreAuthSystemState();
        this.verifyBitstreamDownload(csv, "text/csv;charset=UTF-8", true);
        this.verifyBitstreamDownload(jpg, "image/jpeg;charset=UTF-8", true);
        this.verifyBitstreamDownload(mpg, "video/mpeg;charset=UTF-8", true);
        this.verifyBitstreamDownload(pdf, "application/pdf;charset=UTF-8", true);
    }

    private void verifyBitstreamDownload(Bitstream file, String contentType, boolean shouldDownload) throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        String header = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + file.getID() + "/content"), (Object[])new Object[0]).header("Accept", new Object[]{contentType})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(contentType)).andReturn().getResponse().getHeader("content-disposition");
        if (shouldDownload) {
            Assert.assertTrue((String)("Content-Disposition should contain 'attachment' for " + contentType), (boolean)header.contains("attachment"));
            Assert.assertFalse((String)("Content-Disposition should NOT contain 'inline' for " + contentType), (boolean)header.contains("inline"));
        } else {
            Assert.assertTrue((String)("Content-Disposition should contain 'inline' for " + contentType), (boolean)header.contains("inline"));
            Assert.assertFalse((String)("Content-Disposition should NOT contain 'attachment' for " + contentType), (boolean)header.contains("attachment"));
        }
    }

    @Test
    public void contentLengthAndEtagUsesOriginalBitstream() throws Exception {
        this.givenPdf(false, originalPdf -> {
            String originalMd5 = BitstreamRestControllerIT.md5Checksum(originalPdf);
            long originalLength = Files.size(originalPdf.toPath());
            Assert.assertThat((Object)originalLength, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().longValue("Content-Length", originalLength)).andExpect(MockMvcResultMatchers.header().string("ETag", "\"" + originalMd5 + "\""));
        });
    }

    private static String md5Checksum(File file) throws IOException {
        String md5;
        try (FileInputStream is = new FileInputStream(file);){
            md5 = DigestUtils.md5Hex((InputStream)is);
        }
        return md5;
    }

    @Test
    public void withCoverPageContentLengthAndEtagChanges() throws Exception {
        this.givenPdf(true, originalPdf -> {
            String originalMd5 = BitstreamRestControllerIT.md5Checksum(originalPdf);
            long originalLength = Files.size(originalPdf.toPath());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Content-Length", CoreMatchers.not((Object)Long.toString(originalLength)))).andExpect(MockMvcResultMatchers.header().string("ETag", CoreMatchers.not((Object)("\"" + originalMd5 + "\""))));
        });
    }

    @Test
    public void etagAndContentLengthIsStable() {
        this.givenPdf(false, ignored -> {
            String etag1 = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andReturn().getResponse().getHeader("Etag");
            String etag2 = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andReturn().getResponse().getHeader("Etag");
            Assert.assertThat((Object)etag1, (Matcher)Matchers.equalTo((Object)etag2));
        });
    }

    @Test
    public void withCoverPageEtagAndContentLengthIsStable() {
        this.givenPdf(true, ignored -> {
            String etag1 = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andReturn().getResponse().getHeader("Etag");
            String etag2 = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream.getID() + "/content"), (Object[])new Object[0])).andReturn().getResponse().getHeader("Etag");
            Assert.assertThat((Object)etag1, (Matcher)Matchers.equalTo((Object)etag2));
        });
    }

    private void givenPdf(boolean coverPageEnabled, ThrowingConsumer<File> block) {
        this.configurationService.setProperty("citation-page.enable_globally", (Object)coverPageEnabled);
        try {
            this.citationDocumentService.afterPropertiesSet();
            this.context.turnOffAuthorisationSystem();
            this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
            org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
            File originalPdf = new File(testProps.getProperty("test.bitstream"));
            try (FileInputStream is = new FileInputStream(originalPdf);){
                Item publicItem1 = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("Public item citation cover page test 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
                this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Test bitstream").withDescription("This is a bitstream to test the citation cover page.").withMimeType("application/pdf").build();
            }
            this.context.restoreAuthSystemState();
            block.accept(originalPdf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

