/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import org.dspace.app.rest.matcher.AccessConditionOptionMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class BulkAccessConditionRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Test
    public void findAllByAdminUserTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/bulkaccessconditionoptions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bulkaccessconditionoptions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"default")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.itemAccessConditionOptions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AccessConditionOptionMatcher.matchAccessConditionOption("openaccess", false, false, null, null), AccessConditionOptionMatcher.matchAccessConditionOption("embargo", true, false, "+36MONTHS", null), AccessConditionOptionMatcher.matchAccessConditionOption("administrator", false, false, null, null), AccessConditionOptionMatcher.matchAccessConditionOption("lease", false, true, null, "+6MONTHS")})), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.bitstreamAccessConditionOptions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AccessConditionOptionMatcher.matchAccessConditionOption("openaccess", false, false, null, null), AccessConditionOptionMatcher.matchAccessConditionOption("embargo", true, false, "+36MONTHS", null), AccessConditionOptionMatcher.matchAccessConditionOption("administrator", false, false, null, null), AccessConditionOptionMatcher.matchAccessConditionOption("lease", false, true, null, "+6MONTHS")})))})));
    }

    @Test
    public void findAllByAdminUserOfAnCommunityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CommunityBuilder.createCommunity((Context)this.context).withName("community").withAdminGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/bulkaccessconditionoptions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findAllByAdminUserOfAnCollectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("collection").withAdminGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/bulkaccessconditionoptions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findAllByAdminUserOfAnItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("collection").build();
        ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("item").withAdminUser(this.eperson).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/bulkaccessconditionoptions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findAllByNormalUserTest() throws Exception {
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/bulkaccessconditionoptions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllByAnonymousUserTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/bulkaccessconditionoptions", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneByAdminTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/bulkaccessconditionoptions/default", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"default"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.itemAccessConditionOptions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AccessConditionOptionMatcher.matchAccessConditionOption("openaccess", false, false, null, null), AccessConditionOptionMatcher.matchAccessConditionOption("embargo", true, false, "+36MONTHS", null), AccessConditionOptionMatcher.matchAccessConditionOption("administrator", false, false, null, null), AccessConditionOptionMatcher.matchAccessConditionOption("lease", false, true, null, "+6MONTHS")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.bitstreamAccessConditionOptions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AccessConditionOptionMatcher.matchAccessConditionOption("openaccess", false, false, null, null), AccessConditionOptionMatcher.matchAccessConditionOption("embargo", true, false, "+36MONTHS", null), AccessConditionOptionMatcher.matchAccessConditionOption("administrator", false, false, null, null), AccessConditionOptionMatcher.matchAccessConditionOption("lease", false, true, null, "+6MONTHS")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"bulkaccessconditionoption")));
    }

    @Test
    public void findOneByAdminOfAnCommunityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CommunityBuilder.createCommunity((Context)this.context).withName("community").withAdminGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/bulkaccessconditionoptions/default", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findOneByAdminOfAnCollectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("collection").withAdminGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/bulkaccessconditionoptions/default", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findOneByAdminOfAnItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("collection").build();
        ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("item").withAdminUser(this.eperson).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/bulkaccessconditionoptions/default", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findOneByNormalUserTest() throws Exception {
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/bulkaccessconditionoptions/default", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneByAnonymousUserTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/bulkaccessconditionoptions/default", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneNotFoundTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/bulkaccessconditionoptions/wrong", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

