/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dspace.app.rest.matcher.ContentReportMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.model.FilteredCollectionsQuery;
import org.dspace.app.rest.model.FilteredItemsQueryPredicate;
import org.dspace.app.rest.model.FilteredItemsQueryRest;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.contentreport.Filter;
import org.dspace.contentreport.FilteredCollection;
import org.dspace.contentreport.QueryOperator;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ContentReportRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;

    @Test
    public void testFilteredCollections() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("contentreport.enable", (Object)Boolean.TRUE);
        TestKit testKit = this.setupCollectionsAndItems();
        Collection col1 = testKit.collections.get(0);
        Collection col2 = testKit.collections.get(1);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        Map<Filter, Integer> valuesCol1 = Map.of(Filter.IS_DISCOVERABLE, 1);
        FilteredCollection fcol1 = FilteredCollection.of((String)col1.getName(), (String)col1.getHandle(), (String)this.parentCommunity.getName(), (String)this.parentCommunity.getHandle(), (int)1, (int)1, valuesCol1, (boolean)true);
        Map<Filter, Integer> valuesCol2 = Map.of(Filter.IS_DISCOVERABLE, 2);
        FilteredCollection fcol2 = FilteredCollection.of((String)col2.getName(), (String)col2.getHandle(), (String)this.parentCommunity.getName(), (String)this.parentCommunity.getHandle(), (int)2, (int)2, valuesCol2, (boolean)true);
        FilteredCollectionsQuery query = FilteredCollectionsQuery.of(Set.of(Filter.IS_DISCOVERABLE));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/contentreport/filteredcollections?" + query.toQueryString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ContentReportMatcher.matchFilteredCollectionProperties(fcol1), ContentReportMatcher.matchFilteredCollectionProperties(fcol2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"type", (Matcher)Matchers.is((Object)"filteredcollectionsreport"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.summary", ContentReportMatcher.matchFilteredCollectionSummary(3, 3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/contentreport/filteredcollections")));
    }

    @Test
    public void testFilteredCollectionsUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("contentreport.enable", (Object)Boolean.TRUE);
        this.setupCollectionsAndItems();
        this.context.restoreAuthSystemState();
        FilteredCollectionsQuery query = FilteredCollectionsQuery.of(Set.of(Filter.IS_DISCOVERABLE));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/contentreport/filteredcollections?" + query.toQueryString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testFilteredCollectionsOff() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("contentreport.enable", (Object)Boolean.FALSE);
        this.setupCollectionsAndItems();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        FilteredCollectionsQuery query = FilteredCollectionsQuery.of(Set.of(Filter.IS_DISCOVERABLE));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/contentreport/filteredcollections?" + query.toQueryString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testFilteredItems() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("contentreport.enable", (Object)Boolean.TRUE);
        TestKit testKit = this.setupCollectionsAndItems();
        Item publicItem2 = testKit.items.get(1);
        Item publicItem3 = testKit.items.get(2);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        FilteredItemsQueryRest query = FilteredItemsQueryRest.of(null, List.of(FilteredItemsQueryPredicate.of((String)"dc.contributor.author", (QueryOperator)QueryOperator.EQUALS, (String)"Doe, Jane")), (int)100, null, List.of("dc.subject"));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/contentreport/filtereditems?" + query.toQueryString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.itemCount", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.items", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ContentReportRestRepositoryIT.matchItemProperties(publicItem2), ContentReportRestRepositoryIT.matchItemProperties(publicItem3)})));
    }

    @Test
    public void testFilteredItemsUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("contentreport.enable", (Object)Boolean.TRUE);
        this.setupCollectionsAndItems();
        this.context.restoreAuthSystemState();
        FilteredItemsQueryRest query = FilteredItemsQueryRest.of(null, List.of(FilteredItemsQueryPredicate.of((String)"dc.contributor.author", (QueryOperator)QueryOperator.EQUALS, (String)"Doe, Jane")), (int)100, null, List.of("dc.subject"));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/contentreport/filtereditems?" + query.toQueryString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testFilteredItemsOff() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("contentreport.enable", (Object)Boolean.FALSE);
        this.setupCollectionsAndItems();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        FilteredItemsQueryRest query = FilteredItemsQueryRest.of(null, List.of(FilteredItemsQueryPredicate.of((String)"dc.contributor.author", (QueryOperator)QueryOperator.EQUALS, (String)"Doe, Jane")), (int)100, null, List.of("dc.subject"));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/contentreport/filtereditems?" + query.toQueryString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private static Matcher<? super Object> matchItemProperties(Item item) {
        return Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)item.getID().toString())), JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)item.getName())), JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.is((Object)item.getHandle())), JsonPathMatchers.hasJsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)item.isArchived())), JsonPathMatchers.hasJsonPath((String)"$.discoverable", (Matcher)Matchers.is((Object)item.isDiscoverable())), JsonPathMatchers.hasJsonPath((String)"$.withdrawn", (Matcher)Matchers.is((Object)item.isWithdrawn())), JsonPathMatchers.hasJsonPath((String)"$.lastModified", (Matcher)Matchers.is((Matcher)Matchers.notNullValue())), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"filtered-item"))});
    }

    private TestKit setupCollectionsAndItems() {
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("My Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        LocalDate today = LocalDate.now();
        LocalDate pastDate = today.minusDays(10L);
        String fmtPastDate = DateTimeFormatter.ISO_DATE.format(pastDate);
        LocalDate futureDate = today.plusDays(10L);
        String fmtFutureDate = DateTimeFormatter.ISO_DATE.format(futureDate);
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate(fmtPastDate).withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate(fmtPastDate).withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 3").withIssueDate(fmtFutureDate).withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        TestKit kit = new TestKit();
        kit.collections.add(col1);
        kit.collections.add(col2);
        kit.items.add(item1);
        kit.items.add(item2);
        kit.items.add(item3);
        return kit;
    }

    private static class TestKit {
        public final List<Collection> collections = new ArrayList<Collection>();
        public final List<Item> items = new ArrayList<Item>();

        private TestKit() {
        }
    }
}

