/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.ArrayList;
import java.util.HashMap;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.discovery.IndexingService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.service.IdentifierService;
import org.dspace.services.ConfigurationService;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class DuplicateDetectionRestIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    ItemService itemService;
    @Autowired
    IndexingService indexingService;
    @Autowired
    CollectionService collectionService;
    @Autowired
    HandleService handleService;
    @Autowired
    WorkspaceItemService workspaceItemService;
    @Autowired
    XmlWorkflowItemService workflowItemService;
    @Autowired
    IdentifierService identifierService;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    XmlWorkflowService workflowService;
    @Autowired
    EPersonService ePersonService;
    private Collection col;
    private Collection simpleCol;
    private final String item1IssueDate = "2011-10-17";
    private final String item1Subject = "ExtraEntry 1";
    private final String item1Title = "Public item I";
    private final String item1Author = "Smith, Donald";
    private final String item2Subject = "ExtraEntry 2";
    private final String item2IssueDate = "2012-10-17";
    private EPerson anotherEPerson;

    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("duplicate.enable", (Object)true);
        this.configurationService.setProperty("duplicate.comparison.distance", (Object)1);
        this.configurationService.setProperty("duplicate.comparison.normalise.lowercase", (Object)true);
        this.configurationService.setProperty("duplicate.comparison.normalise.whitespace", (Object)true);
        this.configurationService.setProperty("duplicate.comparison.solr.field", (Object)"deduplication_keyword");
        this.configurationService.setProperty("duplicate.comparison.metadata.field", (Object)new String[]{"dc.title"});
        this.configurationService.setProperty("duplicate.preview.metadata.field", (Object)new String[]{"dc.date.issued", "dc.subject"});
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test Collection").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        this.simpleCol = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test Collection without Workflow").build();
        this.eperson.setFirstName(this.context, "first");
        this.eperson.setLastName(this.context, "last");
        this.anotherEPerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("test-another-user@email.com").withNameInMetadata("first", "last").withCanLogin(true).withLanguage(I18nUtil.getDefaultLocale().getLanguage()).withPassword(this.password).build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void searchDuplicatesBySearchMethodTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem workspaceItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)this.simpleCol).withTitle("Public item I").withSubject("ExtraEntry 1").withIssueDate("2011-10-17").withAuthor("Smith, Donald").withSubmitter(this.eperson).build();
        WorkspaceItem workspaceItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)this.simpleCol).withTitle("Public item II").withIssueDate("2012-10-17").withAuthor("Smith, Donald X.").withSubject("ExtraEntry 2").withSubmitter(this.eperson).build();
        WorkspaceItem workspaceItem3 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)this.simpleCol).withTitle("Public item I").withTitle("Public item III").withIssueDate("2013-10-17").withAuthor("Smith, Donald Y.").withSubject("ExtraEntry 3").withSubmitter(this.eperson).build();
        XmlWorkflowItem wfi1 = (XmlWorkflowItem)this.workflowService.start(this.context, workspaceItem1);
        XmlWorkflowItem wfi2 = (XmlWorkflowItem)this.workflowService.start(this.context, workspaceItem2);
        Item item1 = wfi1.getItem();
        Item item2 = wfi2.getItem();
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/duplicates/search/findByItem?uuid=" + item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.potentialDuplicateResources", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.potentialDuplicateResources[0].uuid", (Object[])new Object[0]).value((Object)item2.getID().toString())).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.potentialDuplicateResources[0].metadata['dc.subject'][0].value", (Object[])new Object[0]).value((Object)"ExtraEntry 2")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.potentialDuplicateResources[0].metadata['dc.date.issued'][0].value", (Object[])new Object[0]).value((Object)"2012-10-17")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.potentialDuplicateResources[0].metadata['dc.contributor.author']", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.potentialDuplicateResources[0].metadata['dc.title']", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void submissionSectionDataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection workspaceCollection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity, (String)"123456789/test-duplicate-detection").withName("Test Collection Workspace").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)this.col).withTitle("Submission section test I").withIssueDate("2011-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry 1").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)this.col).withTitle("Submission section test II").withIssueDate("2012-10-17").withAuthor("Smith, Donald X.").withSubject("ExtraEntry 2").build();
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)this.col).withTitle("Submission section test III").withIssueDate("2013-10-17").withAuthor("Smith, Donald Y.").withSubject("ExtraEntry 3").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)workspaceCollection).withTitle("Submission section test 1").withSubject("ExtraEntry 2").withIssueDate("2012-10-17").withAuthor("Smith, Donald").withSubmitter(this.eperson).build();
        String submitterToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates.potentialDuplicates", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates.potentialDuplicates[0].uuid", (Object[])new Object[0]).value((Object)item1.getID().toString())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates.potentialDuplicates[0].metadata['dc.subject'][0].value", (Object[])new Object[0]).value((Object)"ExtraEntry 1")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates.potentialDuplicates[0].metadata['dc.date.issued'][0].value", (Object[])new Object[0]).value((Object)"2011-10-17")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates.potentialDuplicates[0].metadata['dc.contributor.author']", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates.potentialDuplicates[0].metadata['dc.title']", (Object[])new Object[0]).doesNotExist());
        ArrayList<Object> updateOperations = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "Submission section test II");
        updateOperations.add(new ReplaceOperation("/sections/traditionalpageone/dc.title/0", value));
        String patchBody = this.getPatchContent(updateOperations);
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist());
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates.potentialDuplicates", (Matcher)Matchers.hasSize((int)3)));
        updateOperations = new ArrayList();
        value.put("value", "Research article");
        updateOperations.add((Operation)new ReplaceOperation("/sections/traditionalpageone/dc.title/0", value));
        patchBody = this.getPatchContent(updateOperations);
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist());
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates.potentialDuplicates", (Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void submissionSectionWorkspaceItemVisibilityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity, (String)"123456789/test-duplicate-detection").withName("Test Collection with Duplicate Detection").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)this.col).withTitle("Unique title").withSubject("ExtraEntry 1").withIssueDate("2011-10-17").withAuthor("Smith, Donald").withSubmitter(this.eperson).build();
        WorkspaceItem workspaceItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)this.col).withTitle("Unique title").withSubject("ExtraEntry 2").withIssueDate("2012-10-17").withAuthor("Smith, Donald").withSubmitter(this.eperson).build();
        WorkspaceItem workspaceItem3 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)this.col).withTitle("Unique title").withSubject("asdf").withIssueDate("2000-01-01").withAuthor("asdfasf").withSubmitter(this.admin).build();
        String submitterToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates.potentialDuplicates", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.duplicates.potentialDuplicates[0].uuid", (Object[])new Object[0]).value((Object)workspaceItem2.getItem().getID().toString()));
    }

    @Test
    public void submissionSectionWorkflowItemVisibilityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection workflowCol = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test Collection with Duplicate Detection").withWorkflowGroup("reviewer", new EPerson[]{this.admin}).build();
        XmlWorkflowItem workflowItem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)workflowCol).withTitle("Unique title").withSubmitter(this.anotherEPerson).build();
        XmlWorkflowItem workflowItem2 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)workflowCol).withTitle("Unique title").withSubmitter(this.eperson).build();
        this.context.restoreAuthSystemState();
        this.context.setCurrentUser(this.admin);
        String reviewerToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/duplicates/search/findByItem?uuid=" + workflowItem1.getItem().getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.potentialDuplicateResources", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.potentialDuplicateResources[0].uuid", (Object[])new Object[0]).value((Object)workflowItem2.getItem().getID().toString()));
        this.getClient(this.getAuthToken(this.anotherEPerson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/duplicates/search/findByItem?uuid=" + workflowItem1.getItem().getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.potentialDuplicateResources", (Object[])new Object[0]).doesNotExist());
    }
}

