/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ItemFilterRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Test
    public void findOneUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/itemfilters/test", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.getClient(this.getAuthToken(this.eperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/itemfilters/test", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneNotFoundTest() throws Exception {
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/itemfilters/test", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneTest() throws Exception {
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/itemfilters/always_true_filter", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"always_true_filter"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/config/itemfilters/always_true_filter")));
    }

    @Test
    public void findAllUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/itemfilters", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllForbiddenTest() throws Exception {
        this.getClient(this.getAuthToken(this.eperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/itemfilters", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllPaginatedSortedTest() throws Exception {
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/itemfilters", (Object[])new Object[0]).param("size", new String[]{"30"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)30))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.itemfilters", (Matcher)Matchers.contains((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"always_true_filter")), JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"demo_filter")), JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"doi-filter")), JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"in-outfit-collection_condition")), JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)"type_filter"))})));
    }
}

