/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.UUID;
import org.dspace.app.rest.matcher.QATopicMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.QAEventBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class QATopicRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;

    @Test
    public void findAllNotImplementedTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("qaevents.sources", (Object)new String[]{"openaire", "test-source"});
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 2").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144301\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 3").withTopic("ENRICH/MORE/PID").withMessage("{\"pids[0].type\":\"pmid\",\"pids[0].value\":\"10.2307/2144302\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 4").withTopic("ENRICH/MISSING/ABSTRACT").withMessage("{\"test\": \"Test...\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 4").withSource("test-source").withTopic("TOPIC/TEST").withMessage("{\"abstracts[0]\": \"Descrizione delle caratteristiche...\"}").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/openaire:ENRICH!MISSING!PID", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QATopicMatcher.matchQATopicEntry("ENRICH/MISSING/PID", 2)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/openaire:ENRICH!MISSING!ABSTRACT", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QATopicMatcher.matchQATopicEntry("ENRICH/MISSING/ABSTRACT", 1)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/test-source:TOPIC!TEST", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", QATopicMatcher.matchQATopicEntry("test-source", "TOPIC/TEST", 1)));
    }

    @Test
    public void findOneNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("qaevent.sources", (Object)new String[]{"openaire"});
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/ENRICH!MISSING!PID", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/unknown-source:ENRICH!MISSING!ABSTRACT", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/openaire:not-existing-topic", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/openaire:ENRICH!MISSING!PID", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/openaire:ENRICH!MISSING!ABSTRACT", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/openaire:ENRICH!MISSING!PID", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/openaire:ENRICH!MISSING!ABSTRACT", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findBySourceTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("qaevents.sources", (Object)new String[]{"openaire", "test-source", "test-source-2"});
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 2").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144301\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 3").withTopic("ENRICH/MORE/PID").withMessage("{\"pids[0].type\":\"pmid\",\"pids[0].value\":\"10.2307/2144302\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 4").withTopic("ENRICH/MISSING/ABSTRACT").withMessage("{\"abstracts[0]\": \"Descrizione delle caratteristiche...\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 5").withTopic("TEST/TOPIC").withSource("test-source").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 6").withTopic("TEST/TOPIC").withSource("test-source").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 7").withTopic("TEST/TOPIC/2").withSource("test-source").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/bySource", (Object[])new Object[0]).param("source", new String[]{"openaire"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancetopics", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QATopicMatcher.matchQATopicEntry("ENRICH/MISSING/PID", 2), QATopicMatcher.matchQATopicEntry("ENRICH/MISSING/ABSTRACT", 1), QATopicMatcher.matchQATopicEntry("ENRICH/MORE/PID", 1)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/bySource", (Object[])new Object[0]).param("source", new String[]{"test-source"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancetopics", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QATopicMatcher.matchQATopicEntry("test-source", "TEST/TOPIC/2", 1), QATopicMatcher.matchQATopicEntry("test-source", "TEST/TOPIC", 2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/bySource", (Object[])new Object[0]).param("source", new String[]{"test-source-2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancetopics", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findBySourcePaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("qaevent.sources", (Object)new String[]{"openaire", "test-source", "test-source-2"});
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").withSource("openaire").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 2").withTopic("ENRICH/MISSING/PID").withSource("openaire").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144301\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 3").withTopic("ENRICH/MORE/PID").withSource("openaire").withMessage("{\"pids[0].type\":\"pmid\",\"pids[0].value\":\"10.2307/2144302\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 4").withTopic("ENRICH/MISSING/ABSTRACT").withSource("openaire").withMessage("{\"abstracts[0]\": \"Descrizione delle caratteristiche...\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 5").withTopic("TEST/TOPIC").withSource("test-source").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 6").withTopic("TEST/TOPIC").withSource("test-source").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom 7").withTopic("TEST/TOPIC/2").withSource("test-source").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/bySource", (Object[])new Object[0]).param("source", new String[]{"openaire"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancetopics", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/bySource", (Object[])new Object[0]).param("source", new String[]{"openaire"}).param("size", new String[]{"2"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancetopics", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/bySource", (Object[])new Object[0]).param("source", new String[]{"test-source"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findBySourceUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/bySource", (Object[])new Object[0]).param("source", new String[]{"openaire"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findBySourceForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        QAEventBuilder.createTarget((Context)this.context, (Collection)col1, (String)"Science and Freedom").withTopic("ENRICH/MISSING/PID").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/bySource", (Object[])new Object[0]).param("source", new String[]{"openaire"})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByTargetTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("qaevent.sources", (Object)new String[]{"openaire", "test-source", "test-source-2"});
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Science and Freedom").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Science and Freedom 2").build();
        QAEventBuilder.createTarget((Context)this.context, (Item)item1).withSource("openaire").withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144300\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Item)item1).withSource("openaire").withTopic("ENRICH/MISSING/ABSTRACT").withMessage("{\"abstracts[0]\": \"Descrizione delle caratteristiche...\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Item)item1).withTopic("TEST/TOPIC").withSource("test-source").build();
        QAEventBuilder.createTarget((Context)this.context, (Item)item1).withTopic("TEST/TOPIC/2").withSource("test-source").build();
        QAEventBuilder.createTarget((Context)this.context, (Item)item2).withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"doi\",\"pids[0].value\":\"10.2307/2144301\"}").build();
        QAEventBuilder.createTarget((Context)this.context, (Item)item2).withTopic("ENRICH/MISSING/PID").withMessage("{\"pids[0].type\":\"pmid\",\"pids[0].value\":\"2144301\"}").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/byTarget", (Object[])new Object[0]).param("target", new String[]{item1.getID().toString()}).param("source", new String[]{"openaire"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancetopics", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QATopicMatcher.matchQATopicEntry("openaire", "ENRICH/MISSING/PID", item1.getID().toString(), 1), QATopicMatcher.matchQATopicEntry("openaire", "ENRICH/MISSING/ABSTRACT", item1.getID().toString(), 1)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/byTarget", (Object[])new Object[0]).param("target", new String[]{item2.getID().toString()}).param("source", new String[]{"openaire"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancetopics", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QATopicMatcher.matchQATopicEntry("openaire", "ENRICH/MISSING/PID", item2.getID().toString(), 2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/byTarget", (Object[])new Object[0]).param("target", new String[]{UUID.randomUUID().toString()}).param("source", new String[]{"openaire"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancetopics", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/byTarget", (Object[])new Object[0]).param("target", new String[]{item2.getID().toString()}).param("source", new String[]{"test-source"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.qualityassurancetopics", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByTargetZeroEventsOpenaireTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Science and Freedom").build();
        QAEventBuilder.createTarget((Context)this.context, (Item)item1).withTopic("ENRICH/MISSING/PID").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/byTarget", (Object[])new Object[0]).param("source", new String[]{"openaire"}).param("target", new String[]{item1.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByTargetZeroEventsAnotherSourceTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Science and Freedom").build();
        QAEventBuilder.createTarget((Context)this.context, (Item)item1).withTopic("ENRICH/MISSING/PID").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/byTarget", (Object[])new Object[0]).param("target", new String[]{item1.getID().toString()}).param("source", new String[]{"test-source"})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByTargetBadRequest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Science and Freedom").build();
        QAEventBuilder.createTarget((Context)this.context, (Item)item1).withSource("test-source").withTopic("ENRICH/MISSING/PID").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/byTarget", (Object[])new Object[0]).param("source", new String[]{"test-source"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/qualityassurancetopics/search/byTarget", (Object[])new Object[0]).param("target", new String[]{item1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }
}

