/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import jakarta.servlet.http.Cookie;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.app.rest.converter.RequestItemConverter;
import org.dspace.app.rest.matcher.RequestCopyMatcher;
import org.dspace.app.rest.model.RequestItemRest;
import org.dspace.app.rest.repository.RequestItemRepository;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RequestItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.exparity.hamcrest.date.DateMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class RequestItemRepositoryIT
extends AbstractControllerIntegrationTest {
    public static final String URI_ROOT = "http://localhost/api/tools/itemrequests";
    public static final String URI_SINGULAR_ROOT = "http://localhost/api/tools/itemrequest";
    @Autowired(required=true)
    RequestItemConverter requestItemConverter;
    @Autowired(required=true)
    RequestItemService requestItemService;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    private ConfigurationService configurationService;
    private Collection collection;
    private Item item;
    private Bitstream bitstream;

    @Before
    public void init() throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.eperson);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").withAdminGroup(new EPerson[]{this.eperson}).build();
        this.item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Item").build();
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
        this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testFindAll() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)URI_ROOT, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void testFindOneAuthenticated() throws Exception {
        RequestItem request = RequestItemBuilder.createRequestItem((Context)this.context, (Item)this.item, (Bitstream)this.bitstream).build();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String uri = "http://localhost/api/tools/itemrequests/" + request.getToken();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)uri, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RequestCopyMatcher.matchRequestCopy(request))));
    }

    @Test
    public void testFindOneNotAuthenticated() throws Exception {
        RequestItem request = RequestItemBuilder.createRequestItem((Context)this.context, (Item)this.item, (Bitstream)this.bitstream).build();
        String uri = "http://localhost/api/tools/itemrequests/" + request.getToken();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)uri, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RequestCopyMatcher.matchRequestCopy(request))));
    }

    @Test
    public void testFindOneNonexistent() throws Exception {
        String uri = "http://localhost/api/tools/itemrequests/impossible";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)uri, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAndReturnAuthenticated() throws SQLException, AuthorizeException, IOException, Exception {
        RequestItemRest rir = new RequestItemRest();
        rir.setAllfiles(true);
        rir.setItemId(this.item.getID().toString());
        rir.setRequestEmail(this.eperson.getEmail());
        rir.setRequestName(this.eperson.getFullName());
        rir.setRequestMessage("Please send me a copy of this.");
        ObjectMapper mapper = new ObjectMapper();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)URI_ROOT, (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)rir)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Object[])new Object[0]).doesNotExist());
        }
        finally {
            Iterator itemRequests = this.requestItemService.findByItem(this.context, this.item);
            String token = null;
            Iterator it = itemRequests;
            while (it.hasNext()) {
                RequestItem requestItem = (RequestItem)it.next();
                if (!requestItem.getReqEmail().equals(this.eperson.getEmail())) continue;
                Assert.assertEquals((Object)this.eperson.getFullName(), (Object)requestItem.getReqName());
                Assert.assertEquals((Object)this.item.getID(), (Object)requestItem.getItem().getID());
                Assert.assertEquals((Object)"Please send me a copy of this.", (Object)requestItem.getReqMessage());
                Assert.assertEquals((Object)true, (Object)requestItem.isAllfiles());
                Assert.assertNotNull((Object)requestItem.getToken());
                token = requestItem.getToken();
            }
            RequestItemBuilder.deleteRequestItem(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAndReturnNotAuthenticated() throws SQLException, AuthorizeException, IOException, Exception {
        System.out.println("createAndReturn (not authenticated)");
        RequestItemRest rir = new RequestItemRest();
        rir.setAllfiles(false);
        rir.setBitstreamId(this.bitstream.getID().toString());
        rir.setItemId(this.item.getID().toString());
        rir.setRequestEmail("jsmith@example.com");
        rir.setRequestMessage("Please send me a copy of this.");
        rir.setRequestName("John Smith");
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)URI_ROOT, (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)rir)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Object[])new Object[0]).doesNotExist());
        }
        finally {
            Iterator itemRequests = this.requestItemService.findByItem(this.context, this.item);
            String token = null;
            Iterator it = itemRequests;
            while (it.hasNext()) {
                RequestItem requestItem = (RequestItem)it.next();
                if (!requestItem.getReqEmail().equals("jsmith@example.com")) continue;
                Assert.assertEquals((Object)this.item.getID(), (Object)requestItem.getItem().getID());
                Assert.assertEquals((Object)"Please send me a copy of this.", (Object)requestItem.getReqMessage());
                Assert.assertEquals((Object)"John Smith", (Object)requestItem.getReqName());
                Assert.assertEquals((Object)this.bitstream.getID(), (Object)requestItem.getBitstream().getID());
                Assert.assertEquals((Object)false, (Object)requestItem.isAllfiles());
                Assert.assertNotNull((Object)requestItem.getToken());
                token = requestItem.getToken();
            }
            RequestItemBuilder.deleteRequestItem(token);
        }
    }

    @Test
    public void testCreateAndReturnBadRequest() throws SQLException, AuthorizeException, IOException, Exception {
        System.out.println("createAndReturn (bad requests)");
        RequestItemRest rir = new RequestItemRest();
        rir.setBitstreamId(this.bitstream.getID().toString());
        rir.setItemId(this.item.getID().toString());
        rir.setRequestEmail(this.eperson.getEmail());
        rir.setRequestMessage("Please send me a copy of this.");
        rir.setRequestName(this.eperson.getFullName());
        rir.setAllfiles(false);
        ObjectMapper mapper = new ObjectMapper();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        rir.setBitstreamId(null);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)URI_ROOT, (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)rir)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        rir.setBitstreamId(UUID.randomUUID().toString());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)URI_ROOT, (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)rir)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        rir.setBitstreamId(this.bitstream.getID().toString());
        rir.setItemId(null);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)URI_ROOT, (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)rir)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        rir.setItemId(UUID.randomUUID().toString());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)URI_ROOT, (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)rir)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        rir.setItemId(this.item.getID().toString());
        rir.setRequestEmail(null);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)URI_ROOT, (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)rir)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        rir.setRequestEmail("<script>window.location='http://evil.example.com/';</script>");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)URI_ROOT, (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)rir)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void testCreateWithInvalidCSRF() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        token = token.replace("Bearer ", "");
        Cookie[] cookies = new Cookie[]{new Cookie("Authorization-cookie", token)};
        RequestItemRest rir = new RequestItemRest();
        rir.setBitstreamId(this.bitstream.getID().toString());
        rir.setItemId(this.item.getID().toString());
        rir.setRequestEmail("jsmith@example.com");
        rir.setRequestMessage("Please send me a copy of this.");
        rir.setRequestName("John Smith");
        rir.setAllfiles(false);
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)URI_ROOT, (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)rir)).contentType(this.contentType).with(this.invalidCsrfToken()).secure(true).cookie(cookies)).andExpect(MockMvcResultMatchers.status().isForbidden()).andExpect(MockMvcResultMatchers.status().reason(Matchers.containsString((String)"Invalid CSRF token"))).andExpect(MockMvcResultMatchers.cookie().exists("DSPACE-XSRF-COOKIE")).andExpect(MockMvcResultMatchers.header().exists("DSPACE-XSRF-TOKEN"));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testDelete() throws Exception {
        System.out.println("delete");
        RequestItem request = RequestItemBuilder.createRequestItem((Context)this.context, (Item)this.item, (Bitstream)this.bitstream).build();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("http://localhost/api/tools/itemrequests/" + request.getToken()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void testUntrustedOrigin() throws Exception {
        System.out.println("testUntrustedOrigin");
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.okay", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"status")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)URI_ROOT, (Object[])new Object[0]).header("Origin", new Object[]{"https://example.org"})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authn/logout", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void testPut() throws Exception {
        System.out.println("put");
        RequestItem itemRequest = RequestItemBuilder.createRequestItem((Context)this.context, (Item)this.item, (Bitstream)this.bitstream).build();
        Map<String, String> parameters = Map.of("acceptRequest", "true", "subject", "subject", "responseMessage", "Request accepted", "suggestOpenAccess", "true");
        String content = new ObjectMapper().writer().writeValueAsString(parameters);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        AtomicReference requestTokenRef = new AtomicReference();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("http://localhost/api/tools/itemrequests/" + itemRequest.getToken()), (Object[])new Object[0]).contentType(this.contentType).content(content)).andExpect(MockMvcResultMatchers.status().isOk()).andDo(result -> requestTokenRef.set((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"token", (Predicate[])new Predicate[0])));
        RequestItem foundRequest = this.requestItemService.findByToken(this.context, (String)requestTokenRef.get());
        Assert.assertTrue((String)"acceptRequest should be true", (boolean)foundRequest.isAccept_request());
        MatcherAssert.assertThat((String)"decision_date must be within a minute of now", (Object)foundRequest.getDecision_date(), (Matcher)DateMatchers.within((long)1L, (ChronoUnit)ChronoUnit.MINUTES, (Date)new Date()));
    }

    @Test
    public void testPutUnauthenticated() throws Exception {
        System.out.println("put unauthenticated request");
        RequestItem itemRequest = RequestItemBuilder.createRequestItem((Context)this.context, (Item)this.item, (Bitstream)this.bitstream).build();
        ObjectWriter mapperWriter = new ObjectMapper().writer();
        Map<String, String> parameters = Map.of("acceptRequest", "true", "subject", "put unauthenticated", "responseMessage", "Request accepted", "suggestOpenAccess", "false");
        String content = mapperWriter.writeValueAsString(parameters);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.put((String)("http://localhost/api/tools/itemrequests/" + itemRequest.getToken()), (Object[])new Object[0]).contentType(this.contentType).content(content)).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testPutBadRequest() throws Exception {
        RequestItem itemRequest = RequestItemBuilder.createRequestItem((Context)this.context, (Item)this.item, (Bitstream)this.bitstream).build();
        ObjectWriter mapperWriter = new ObjectMapper().writer();
        Map<String, String> parameters = Map.of("subject", "subject", "responseMessage", "Request accepted");
        String content = mapperWriter.writeValueAsString(parameters);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("http://localhost/api/tools/itemrequests/" + itemRequest.getToken()), (Object[])new Object[0]).contentType(this.contentType).content(content)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void testPutCompletedRequest() throws Exception {
        RequestItem itemRequest = RequestItemBuilder.createRequestItem((Context)this.context, (Item)this.item, (Bitstream)this.bitstream).withAcceptRequest(false).withDecisionDate(new Date()).build();
        Map<String, String> parameters = Map.of("acceptRequest", "true", "subject", "subject", "responseMessage", "Request accepted");
        ObjectWriter mapperWriter = new ObjectMapper().writer();
        String content = mapperWriter.writeValueAsString(parameters);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("http://localhost/api/tools/itemrequests/" + itemRequest.getToken()), (Object[])new Object[0]).contentType(this.contentType).content(content)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void testGetDomainClass() {
        RequestItemRepository instance = new RequestItemRepository();
        Class instanceClass = instance.getDomainClass();
        Assert.assertEquals((String)"Wrong domain class", RequestItemRest.class, (Object)instanceClass);
    }

    @Test
    public void testGetLinkTokenEmailWithSubPath() throws MalformedURLException, URISyntaxException {
        RequestItemRepository instance = (RequestItemRepository)this.applicationContext.getBean("tools.itemrequests", RequestItemRepository.class);
        String currentDspaceUrl = this.configurationService.getProperty("dspace.ui.url");
        String newDspaceUrl = currentDspaceUrl + "/subdir";
        this.configurationService.setProperty("dspace.ui.url", (Object)newDspaceUrl);
        String expectedUrl = newDspaceUrl + "/request-a-copy/token";
        String generatedLink = instance.getLinkTokenEmail("token");
        Assert.assertEquals((Object)expectedUrl, (Object)generatedLink);
        this.configurationService.reloadConfig();
    }

    @Test
    public void testGetLinkTokenEmailWithoutSubPath() throws MalformedURLException, URISyntaxException {
        RequestItemRepository instance = (RequestItemRepository)this.applicationContext.getBean("tools.itemrequests", RequestItemRepository.class);
        String currentDspaceUrl = this.configurationService.getProperty("dspace.ui.url");
        String expectedUrl = currentDspaceUrl + "/request-a-copy/token";
        String generatedLink = instance.getLinkTokenEmail("token");
        Assert.assertEquals((Object)expectedUrl, (Object)generatedLink);
        this.configurationService.reloadConfig();
    }
}

