/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.CharEncoding;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.ResourcePolicyMatcher;
import org.dspace.app.rest.model.ResourcePolicyRest;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.RemoveOperation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ResourcePolicyRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    ResourcePolicyService resourcePolicyService;

    @Test
    public void findAllTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.admin, null).withDspaceObject((DSpaceObject)community).withAction(0).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void findAllUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.admin, null).withDspaceObject((DSpaceObject)community).withAction(0).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(0).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ResourcePolicyMatcher.matchResourcePolicy(resourcePolicy)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()))));
    }

    @Test
    public void findOneResourcePolicyOfAnonymousGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupAnonymous = EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous");
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)groupAnonymous).withDspaceObject((DSpaceObject)community).withAction(0).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withDspaceObject((DSpaceObject)community).withAction(0).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneNotFoundTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My collection").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)collection).withAction(1).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson2.getEmail(), "qwerty02");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        String authToken1 = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findOneAccessGrantToAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(1).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ResourcePolicyMatcher.matchResourcePolicy(resourcePolicy))));
    }

    @Test
    public void findOneAccessGrantToSameUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group1 = GroupBuilder.createGroup((Context)this.context).withName("My group").build();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").withGroupMembership(group1).build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My collection").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group1).withDspaceObject((DSpaceObject)collection).withAction(3).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ResourcePolicyMatcher.matchResourcePolicy(resourcePolicy))));
        String authTokenEperson2 = this.getAuthToken(eperson2.getEmail(), "qwerty02");
        this.getClient(authTokenEperson2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneResoucesPolicyByEpersonUuidTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("myemail@mail.com").withPassword("qwerty01").build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("Xemail@mail.com").withPassword("qwerty02").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        Community community2 = CommunityBuilder.createCommunity((Context)this.context).withName("My community_2").build();
        ResourcePolicy resourcePolicyOfEPerson1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(3).build();
        ResourcePolicy resourcePolicyOfEPerson2 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson2, null).withDspaceObject((DSpaceObject)community2).withAction(4).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/eperson", (Object[])new Object[0]).param("uuid", new String[]{eperson1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.contains(ResourcePolicyMatcher.matchResourcePolicy(resourcePolicyOfEPerson1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.not((Matcher)Matchers.is(ResourcePolicyMatcher.matchResourcePolicy(resourcePolicyOfEPerson2))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/authz/resourcepolicies/search/eperson"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findResoucesPoliciesByEpersonUuidAndResourceUuidTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("myemail@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My collection").build();
        ResourcePolicy resourcePolicyOfCommunity = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(0).build();
        ResourcePolicy secondResourcePolicyOfCommunity = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(4).build();
        ResourcePolicy resourcePolicyOfCollection = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)collection).withAction(4).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/eperson", (Object[])new Object[0]).param("uuid", new String[]{eperson1.getID().toString()}).param("resource", new String[]{community.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicy(resourcePolicyOfCommunity), ResourcePolicyMatcher.matchResourcePolicy(secondResourcePolicyOfCommunity)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.not((Matcher)Matchers.is(ResourcePolicyMatcher.matchResourcePolicy(resourcePolicyOfCollection))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/authz/resourcepolicies/search/eperson"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findResoucesPoliciesEPersonWithoutParametersBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("myemail@mail.com").withPassword("qwerty01").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/eperson", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findResoucesPoliciesByEPersonUuidUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("myemail@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(0).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/eperson", (Object[])new Object[0]).param("uuid", new String[]{eperson1.getID().toString()}).param("resource", new String[]{community.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findResourcesPoliciesByEPersonNotFoundTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/eperson", (Object[])new Object[0]).param("uuid", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findResourcesPoliciesByEPersonUuidForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        Community community2 = CommunityBuilder.createCommunity((Context)this.context).withName("My 2 community").build();
        ResourcePolicy resourcePolicyOfEPerson1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(1).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        ResourcePolicy resourcePolicyOfEPerson2 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson2, null).withDspaceObject((DSpaceObject)community2).withAction(3).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/eperson", (Object[])new Object[0]).param("uuid", new String[]{eperson2.getID().toString()}).param("resource", new String[]{community2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findResourcePoliciesOfOneResourceWithoutActionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        Community community2 = CommunityBuilder.createCommunity((Context)this.context).withName("My second community").build();
        ResourcePolicy firstResourcePolicyOfEPerson1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(11).build();
        ResourcePolicy firstResourcePolicyOfEPerson2 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson2, null).withDspaceObject((DSpaceObject)community2).withAction(3).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        ResourcePolicy resourcePolicyAnonymous = this.authorizeService.findByTypeGroupAction(this.context, (DSpaceObject)community, EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous"), 0);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{community.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicy(firstResourcePolicyOfEPerson1), ResourcePolicyMatcher.matchResourcePolicy(resourcePolicyAnonymous)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.not((Matcher)Matchers.is(ResourcePolicyMatcher.matchResourcePolicy(firstResourcePolicyOfEPerson2))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/authz/resourcepolicies/search/resource"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    @Ignore
    public void findResourcePoliciesOfOneResourceWithActionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        Community community2 = CommunityBuilder.createCommunity((Context)this.context).withName("My 2 community").build();
        ResourcePolicy firstResourcePolicyOfEPerson1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(11).build();
        ResourcePolicy firstResourcePolicyOfEPerson2 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson2, null).withDspaceObject((DSpaceObject)community).withAction(3).build();
        ResourcePolicy secondResourcePolicyOfEPerson2 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson2, null).withDspaceObject((DSpaceObject)community2).withAction(3).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{community.getID().toString()}).param("action", new String[]{"ADD"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.contains(ResourcePolicyMatcher.matchResourcePolicy(firstResourcePolicyOfEPerson2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.not((Matcher)Matchers.is(ResourcePolicyMatcher.matchResourcePolicy(secondResourcePolicyOfEPerson2))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/authz/resourcepolicies/search/resource"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String authToken2 = this.getAuthToken(eperson2.getEmail(), "qwerty02");
        this.getClient(authToken2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{community.getID().toString()}).param("action", new String[]{"ADD"})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findResourcePoliciesOfOneResourcePaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        EPerson eperson3 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson3@mail.com").withPassword(this.password).build();
        EPerson eperson4 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson4@mail.com").withPassword(this.password).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy firstResourcePolicyOfEPerson1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(11).build();
        ResourcePolicy firstResourcePolicyOfEPerson2 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson2, null).withDspaceObject((DSpaceObject)community).withAction(3).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        ResourcePolicy firstResourcePolicyOfEPerson3 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson3, null).withDspaceObject((DSpaceObject)community).withAction(2).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        ResourcePolicy firstResourcePolicyOfEPerson4 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson4, null).withDspaceObject((DSpaceObject)community).withAction(1).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        ResourcePolicy resourcePolicyAnonymous = this.authorizeService.findByTypeGroupAction(this.context, (DSpaceObject)community, EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous"), 0);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{community.getID().toString()}).param("page", new String[]{"0"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"resourcepolicy"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/authz/resourcepolicies/search/resource"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{community.getID().toString()}).param("page", new String[]{"1"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"resourcepolicy"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Object[])new Object[0]).value(Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{community.getID().toString()}).param("page", new String[]{"2"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"resourcepolicy"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Object[])new Object[0]).value(Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findResoucesPoliciesOfResourceWithoutParametersBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findResoucesPoliciesByResourceUuidUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("myemail@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(0).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{community.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findResourcePoliciesNotFoundTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findResourcesPoliciesByResourceUuidForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        Community community2 = CommunityBuilder.createCommunity((Context)this.context).withName("My 2 community").build();
        ResourcePolicy resourcePolicyOfEPerson1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(4).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        ResourcePolicy resourcePolicyOfEPerson2 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson2, null).withDspaceObject((DSpaceObject)community2).withAction(3).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/eperson", (Object[])new Object[0]).param("uuid", new String[]{eperson2.getID().toString()}).param("resource", new String[]{community2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findResourcePoliciesByGroupUuidTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group1 = GroupBuilder.createGroup((Context)this.context).withName("My group").build();
        Group group2 = GroupBuilder.createGroup((Context)this.context).withName("My 2 group").build();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").withGroupMembership(group1).withGroupMembership(group2).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        Community community2 = CommunityBuilder.createCommunity((Context)this.context).withName("My 2 community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My collection").build();
        ResourcePolicy firstResourcePolicyOfGroup1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group1).withDspaceObject((DSpaceObject)community).withAction(3).build();
        ResourcePolicy secondResourcePolicyOfGroup1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group1).withDspaceObject((DSpaceObject)community).withAction(0).build();
        ResourcePolicy collectionResourcePolicyOfGroup1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group1).withDspaceObject((DSpaceObject)collection).withAction(1).build();
        ResourcePolicy firstResourcePolicyOfGroup2 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group2).withDspaceObject((DSpaceObject)community2).withAction(3).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0]).param("uuid", new String[]{group1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicy(firstResourcePolicyOfGroup1), ResourcePolicyMatcher.matchResourcePolicy(secondResourcePolicyOfGroup1), ResourcePolicyMatcher.matchResourcePolicy(collectionResourcePolicyOfGroup1)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.not((Matcher)Matchers.is(ResourcePolicyMatcher.matchResourcePolicy(firstResourcePolicyOfGroup2))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/authz/resourcepolicies/search/group"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        String authToken2 = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0]).param("uuid", new String[]{group2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.contains(ResourcePolicyMatcher.matchResourcePolicy(firstResourcePolicyOfGroup2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/authz/resourcepolicies/search/group"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findResourcePoliciesByGroupUuidAndResourceUuidTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group1 = GroupBuilder.createGroup((Context)this.context).withName("My group").build();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("myemail@mail.com").withPassword("qwerty01").withGroupMembership(group1).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        Community community2 = CommunityBuilder.createCommunity((Context)this.context).withName("My second community").build();
        ResourcePolicy firstResourcePolicyOfGroup1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group1).withDspaceObject((DSpaceObject)community).withAction(3).build();
        ResourcePolicy secondResourcePolicyOfGroup1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group1).withDspaceObject((DSpaceObject)community2).withAction(1).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0]).param("uuid", new String[]{group1.getID().toString()}).param("resource", new String[]{community.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.contains(ResourcePolicyMatcher.matchResourcePolicy(firstResourcePolicyOfGroup1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.not((Matcher)Matchers.is(ResourcePolicyMatcher.matchResourcePolicy(secondResourcePolicyOfGroup1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/authz/resourcepolicies/search/group"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findResoucesPoliciesByGroupWithoutParametersBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findResoucesPoliciesByGroupUuidUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group1 = GroupBuilder.createGroup((Context)this.context).withName("My group").build();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@gmail.com").withPassword("qwerty01").withGroupMembership(group1).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy firstResourcePolicyOfGroup1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group1).withDspaceObject((DSpaceObject)community).withAction(3).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0]).param("uuid", new String[]{group1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findGroupNotFoundTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0]).param("uuid", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findResourcesPoliciesByGroupUuidForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group1 = GroupBuilder.createGroup((Context)this.context).withName("My group").build();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").withGroupMembership(group1).build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy resourcePolicyOfGroup1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group1).withDspaceObject((DSpaceObject)community).withAction(1).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson2.getEmail(), "qwerty02");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0]).param("uuid", new String[]{group1.getID().toString()}).param("resource", new String[]{community.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findResourcesPoliciesByGroupAnonymousTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupAnonymous = EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous");
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy resourcePolicyOfGroup1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)groupAnonymous).withDspaceObject((DSpaceObject)community).withAction(1).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0]).param("uuid", new String[]{groupAnonymous.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0]).param("uuid", new String[]{groupAnonymous.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createWithEPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        AtomicReference idRef = new AtomicReference();
        try {
            Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
            EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
            this.context.restoreAuthSystemState();
            ObjectMapper mapper = new ObjectMapper();
            ResourcePolicyRest resourcePolicyRest = new ResourcePolicyRest();
            resourcePolicyRest.setPolicyType(ResourcePolicy.TYPE_SUBMISSION);
            resourcePolicyRest.setAction(Constants.actionText[0]);
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authz/resourcepolicies", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)resourcePolicyRest)).param("resource", new String[]{community.getID().toString()}).param("eperson", new String[]{eperson1.getID().toString()}).param("projections", new String[]{"full"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ResourcePolicyMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicyRest.getName())), JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicyRest.getDescription())), JsonPathMatchers.hasJsonPath((String)"$.policyType", (Matcher)Matchers.is((Object)resourcePolicyRest.getPolicyType())), JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)resourcePolicyRest.getAction())), JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)resourcePolicyRest.getStartDate())), JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)resourcePolicyRest.getEndDate())), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)resourcePolicyRest.getType()))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            String authToken1 = this.getAuthToken(eperson1.getEmail(), "qwerty01");
            this.getClient(authToken1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + idRef.get()))));
        }
        finally {
            ResourcePolicyBuilder.delete((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createWithGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        AtomicReference idRef = new AtomicReference();
        try {
            Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
            EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
            Group group1 = GroupBuilder.createGroup((Context)this.context).withName("Group 1").addMember(eperson1).build();
            this.context.restoreAuthSystemState();
            ObjectMapper mapper = new ObjectMapper();
            ResourcePolicyRest resourcePolicyRest = new ResourcePolicyRest();
            resourcePolicyRest.setPolicyType(ResourcePolicy.TYPE_SUBMISSION);
            resourcePolicyRest.setAction(Constants.actionText[0]);
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authz/resourcepolicies", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)resourcePolicyRest)).param("resource", new String[]{community.getID().toString()}).param("group", new String[]{group1.getID().toString()}).param("projections", new String[]{"full"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ResourcePolicyMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicyRest.getName())), JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicyRest.getDescription())), JsonPathMatchers.hasJsonPath((String)"$.policyType", (Matcher)Matchers.is((Object)resourcePolicyRest.getPolicyType())), JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)resourcePolicyRest.getAction())), JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)resourcePolicyRest.getStartDate())), JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)resourcePolicyRest.getEndDate())), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)resourcePolicyRest.getType()))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            String authToken1 = this.getAuthToken(eperson1.getEmail(), "qwerty01");
            this.getClient(authToken1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + idRef.get()))));
        }
        finally {
            ResourcePolicyBuilder.delete((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void createWithoutGroupOrPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My commynity").build();
        this.context.restoreAuthSystemState();
        ObjectMapper mapper = new ObjectMapper();
        ResourcePolicyRest resourcePolicyRest = new ResourcePolicyRest();
        resourcePolicyRest.setPolicyType(ResourcePolicy.TYPE_SUBMISSION);
        resourcePolicyRest.setAction(Constants.actionText[11]);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authz/resourcepolicies", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)resourcePolicyRest)).param("resource", new String[]{community.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{community.getID().toString()}).param("action", new String[]{"ADMIN"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/authz/resourcepolicies/search/resource"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void createOneUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My commynity").build();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.context.restoreAuthSystemState();
        ObjectMapper mapper = new ObjectMapper();
        ResourcePolicyRest resourcePolicyRest = new ResourcePolicyRest();
        resourcePolicyRest.setPolicyType(ResourcePolicy.TYPE_SUBMISSION);
        resourcePolicyRest.setAction(Constants.actionText[11]);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authz/resourcepolicies", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)resourcePolicyRest)).param("resource", new String[]{community.getID().toString()}).param("eperson", new String[]{eperson1.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{community.getID().toString()}).param("action", new String[]{"ADMIN"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/authz/resourcepolicies/search/resource"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void createOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My commynity").build();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.context.restoreAuthSystemState();
        ObjectMapper mapper = new ObjectMapper();
        ResourcePolicyRest resourcePolicyRest = new ResourcePolicyRest();
        resourcePolicyRest.setPolicyType(ResourcePolicy.TYPE_SUBMISSION);
        resourcePolicyRest.setAction(Constants.actionText[11]);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authz/resourcepolicies", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)resourcePolicyRest)).param("resource", new String[]{community.getID().toString()}).param("eperson", new String[]{eperson1.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        String authToken2 = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{community.getID().toString()}).param("action", new String[]{"ADMIN"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/authz/resourcepolicies/search/resource"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createPolicyByCollectionAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson colAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("colAdmin@mail.test").withPassword(this.password).build();
        EPerson colAdmin2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("colAdmin2@mail.test").withPassword(this.password).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("colSubmitter@mail.test").withPassword(this.password).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My top commynity").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My collection").withAdminGroup(new EPerson[]{colAdmin}).withSubmitterGroup(new EPerson[]{submitter}).withEntityType("Publication").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My Second Collection").withAdminGroup(new EPerson[]{colAdmin2}).withSubmitterGroup(new EPerson[]{submitter}).withEntityType("Publication").build();
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)"ThisIsSomeDummyText", (String)CharEncoding.UTF_8);){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publication, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        ResourcePolicyRest resourcePolicyRest = new ResourcePolicyRest();
        resourcePolicyRest.setPolicyType(ResourcePolicy.TYPE_CUSTOM);
        resourcePolicyRest.setAction(Constants.actionText[1]);
        resourcePolicyRest.setName("Test for collection admin");
        String authcolAdminToken = this.getAuthToken(colAdmin.getEmail(), this.password);
        String authcolAdmin2Token = this.getAuthToken(colAdmin2.getEmail(), this.password);
        String authSubmitterToken = this.getAuthToken(submitter.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(authSubmitterToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authz/resourcepolicies", (Object[])new Object[0]).content(new ObjectMapper().writeValueAsBytes((Object)resourcePolicyRest)).param("resource", new String[]{bitstream.getID().toString()}).param("eperson", new String[]{submitter.getID().toString()}).param("projections", new String[]{"full"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(authcolAdmin2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authz/resourcepolicies", (Object[])new Object[0]).content(new ObjectMapper().writeValueAsBytes((Object)resourcePolicyRest)).param("resource", new String[]{bitstream.getID().toString()}).param("eperson", new String[]{submitter.getID().toString()}).param("projections", new String[]{"full"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(authcolAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authz/resourcepolicies", (Object[])new Object[0]).content(new ObjectMapper().writeValueAsBytes((Object)resourcePolicyRest)).param("resource", new String[]{bitstream.getID().toString()}).param("eperson", new String[]{submitter.getID().toString()}).param("projections", new String[]{"full"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ResourcePolicyMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicyRest.getName())), JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicyRest.getDescription())), JsonPathMatchers.hasJsonPath((String)"$.policyType", (Matcher)Matchers.is((Object)resourcePolicyRest.getPolicyType())), JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)resourcePolicyRest.getAction())), JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)resourcePolicyRest.getStartDate())), JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)resourcePolicyRest.getEndDate())), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)resourcePolicyRest.getType()))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authSubmitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + idRef.get()))));
            this.getClient(authcolAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + idRef.get()))));
        }
        finally {
            ResourcePolicyBuilder.delete((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createPolicyBySubCommunityAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson comAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("comAdmin@mail.test").withPassword(this.password).build();
        EPerson comAdmin2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("comAdmin2@mail.test").withPassword(this.password).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("colSubmitter@mail.test").withPassword(this.password).build();
        Community community = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("My First Commynity").withAdminGroup(new EPerson[]{comAdmin}).build();
        Community community2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("My Second Commynity").withAdminGroup(new EPerson[]{comAdmin2}).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My collection").withSubmitterGroup(new EPerson[]{submitter}).withEntityType("Publication").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)community2).withName("My Second Collection").withSubmitterGroup(new EPerson[]{submitter}).withEntityType("Publication").build();
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        this.context.restoreAuthSystemState();
        ResourcePolicyRest resourcePolicyRest = new ResourcePolicyRest();
        resourcePolicyRest.setPolicyType(ResourcePolicy.TYPE_CUSTOM);
        resourcePolicyRest.setAction(Constants.actionText[1]);
        resourcePolicyRest.setName("Test for collection admin");
        String authcomAdminToken = this.getAuthToken(comAdmin.getEmail(), this.password);
        String authcomAdmin2Token = this.getAuthToken(comAdmin2.getEmail(), this.password);
        String authSubmitterToken = this.getAuthToken(submitter.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(authSubmitterToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authz/resourcepolicies", (Object[])new Object[0]).content(new ObjectMapper().writeValueAsBytes((Object)resourcePolicyRest)).param("resource", new String[]{publication.getID().toString()}).param("eperson", new String[]{submitter.getID().toString()}).param("projections", new String[]{"full"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(authcomAdmin2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authz/resourcepolicies", (Object[])new Object[0]).content(new ObjectMapper().writeValueAsBytes((Object)resourcePolicyRest)).param("resource", new String[]{publication.getID().toString()}).param("eperson", new String[]{submitter.getID().toString()}).param("projections", new String[]{"full"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(authcomAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authz/resourcepolicies", (Object[])new Object[0]).content(new ObjectMapper().writeValueAsBytes((Object)resourcePolicyRest)).param("resource", new String[]{publication.getID().toString()}).param("eperson", new String[]{submitter.getID().toString()}).param("projections", new String[]{"full"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ResourcePolicyMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicyRest.getName())), JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicyRest.getDescription())), JsonPathMatchers.hasJsonPath((String)"$.policyType", (Matcher)Matchers.is((Object)resourcePolicyRest.getPolicyType())), JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)resourcePolicyRest.getAction())), JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)resourcePolicyRest.getStartDate())), JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)resourcePolicyRest.getEndDate())), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)resourcePolicyRest.getType()))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authSubmitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + idRef.get()))));
            this.getClient(authcomAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + idRef.get()))));
            this.getClient(authcomAdmin2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        }
        finally {
            ResourcePolicyBuilder.delete((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createPolicyByCommunityAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson rootComAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("rootComAdmin@mail.test").withPassword(this.password).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("colSubmitter@mail.test").withPassword(this.password).build();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Root Community").withAdminGroup(new EPerson[]{rootComAdmin}).build();
        Community community = CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("My First Commynity").build();
        Community community2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("My Second Commynity").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My collection").withSubmitterGroup(new EPerson[]{submitter}).withEntityType("Publication").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)community2).withName("My Second Collection").withSubmitterGroup(new EPerson[]{submitter}).withEntityType("Publication").build();
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        Collection collection2 = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My Second Collection").withSubmitterGroup(new EPerson[]{submitter}).withEntityType("Publication").build();
        Item publication2 = ItemBuilder.createItem((Context)this.context, (Collection)collection2).withTitle("Item of second collection").build();
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)"ThisIsSomeDummyText", (String)CharEncoding.UTF_8);){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publication2, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        ResourcePolicyRest resourcePolicyRest = new ResourcePolicyRest();
        resourcePolicyRest.setPolicyType(ResourcePolicy.TYPE_CUSTOM);
        resourcePolicyRest.setAction(Constants.actionText[1]);
        resourcePolicyRest.setName("Test for collection admin");
        ResourcePolicyRest resourcePolicyRest2 = new ResourcePolicyRest();
        resourcePolicyRest2.setPolicyType(ResourcePolicy.TYPE_CUSTOM);
        resourcePolicyRest2.setAction(Constants.actionText[1]);
        resourcePolicyRest2.setName("Test for root community admin");
        String authSubmitterToken = this.getAuthToken(submitter.getEmail(), this.password);
        String authRootAdminToken = this.getAuthToken(rootComAdmin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        AtomicReference idRef2 = new AtomicReference();
        try {
            this.getClient(authRootAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authz/resourcepolicies", (Object[])new Object[0]).content(new ObjectMapper().writeValueAsBytes((Object)resourcePolicyRest)).param("resource", new String[]{publication.getID().toString()}).param("eperson", new String[]{submitter.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ResourcePolicyMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicyRest.getName())), JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicyRest.getDescription())), JsonPathMatchers.hasJsonPath((String)"$.policyType", (Matcher)Matchers.is((Object)resourcePolicyRest.getPolicyType())), JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)resourcePolicyRest.getAction())), JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)resourcePolicyRest.getStartDate())), JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)resourcePolicyRest.getEndDate())), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)resourcePolicyRest.getType()))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authRootAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authz/resourcepolicies", (Object[])new Object[0]).content(new ObjectMapper().writeValueAsBytes((Object)resourcePolicyRest)).param("resource", new String[]{bitstream.getID().toString()}).param("eperson", new String[]{submitter.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ResourcePolicyMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicyRest.getName())), JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicyRest.getDescription())), JsonPathMatchers.hasJsonPath((String)"$.policyType", (Matcher)Matchers.is((Object)resourcePolicyRest.getPolicyType())), JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)resourcePolicyRest.getAction())), JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)resourcePolicyRest.getStartDate())), JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)resourcePolicyRest.getEndDate())), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)resourcePolicyRest.getType()))}))).andDo(result -> idRef2.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authSubmitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + idRef.get()))));
            this.getClient(authSubmitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + idRef2.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + idRef2.get()))));
        }
        finally {
            ResourcePolicyBuilder.delete((Integer)((Integer)idRef.get()));
            ResourcePolicyBuilder.delete((Integer)((Integer)idRef2.get()));
        }
    }

    @Test
    public void deleteOne() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(11).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteOneUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)community).withAction(2).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My collection").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withDspaceObject((DSpaceObject)collection).withAction(3).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ResourcePolicyMatcher.matchResourcePolicy(resourcePolicy)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()))));
    }

    @Test
    public void deleteOneNotFoundTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/authz/resourcepolicies/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deletePolicyByCollectionAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson colAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("colAdmin@mail.test").withPassword(this.password).build();
        EPerson colAdmin2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("colAdmin2@mail.test").withPassword(this.password).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("colSubmitter@mail.test").withPassword(this.password).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My top commynity").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My collection").withAdminGroup(new EPerson[]{colAdmin}).withSubmitterGroup(new EPerson[]{submitter}).withEntityType("Publication").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My Second Collection").withAdminGroup(new EPerson[]{colAdmin2}).withSubmitterGroup(new EPerson[]{submitter}).withEntityType("Publication").build();
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)"ThisIsSomeDummyText", (String)CharEncoding.UTF_8);){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publication, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String authcolAdminToken = this.getAuthToken(colAdmin.getEmail(), this.password);
        String authcolAdmin2Token = this.getAuthToken(colAdmin2.getEmail(), this.password);
        String authSubmitterToken = this.getAuthToken(submitter.getEmail(), this.password);
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)submitter, null).withDspaceObject((DSpaceObject)bitstream).withAction(0).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.getClient(authSubmitterToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/authz/resourcepolicies/" + rp.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + rp.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + rp.getID()))));
        this.getClient(authcolAdmin2Token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/authz/resourcepolicies/" + rp.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + rp.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + rp.getID()))));
        this.getClient(authcolAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/authz/resourcepolicies/" + rp.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + rp.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deletePolicyBySubCommunityAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson comAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("comAdmin@mail.test").withPassword(this.password).build();
        EPerson comAdmin2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("comAdmin2@mail.test").withPassword(this.password).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("colSubmitter@mail.test").withPassword(this.password).build();
        Community community = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("My First Commynity").withAdminGroup(new EPerson[]{comAdmin}).build();
        Community community2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("My Second Commynity").withAdminGroup(new EPerson[]{comAdmin2}).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My collection").withSubmitterGroup(new EPerson[]{submitter}).withEntityType("Publication").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)community2).withName("My Second Collection").withSubmitterGroup(new EPerson[]{submitter}).withEntityType("Publication").build();
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        this.context.restoreAuthSystemState();
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)submitter, null).withDspaceObject((DSpaceObject)publication).withAction(1).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String authcomAdminToken = this.getAuthToken(comAdmin.getEmail(), this.password);
        String authcomAdmin2Token = this.getAuthToken(comAdmin2.getEmail(), this.password);
        this.getClient(authcomAdmin2Token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/authz/resourcepolicies/" + rp.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + rp.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + rp.getID()))));
        this.getClient(authcomAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/authz/resourcepolicies/" + rp.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + rp.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void patchReplaceStartDateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2019);
        calendar.set(2, 9);
        calendar.set(5, 31);
        Date data = calendar.getTime();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)publicItem1).withStartDate(data).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        Calendar newCalendar = Calendar.getInstance();
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        newCalendar.set(1, 2020);
        newCalendar.set(2, 0);
        newCalendar.set(5, 1);
        Date newDate = newCalendar.getTime();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/startDate", (Object)formatDate.format(newDate));
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicy.getRpName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicy.getRpDescription())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)formatDate.format(newDate))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)resourcePolicy.getEndDate())))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)formatDate.format(newDate))))));
    }

    @Test
    public void patchReplaceEndDateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2019);
        calendar.set(2, 9);
        calendar.set(5, 31);
        Date date = calendar.getTime();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)publicItem1).withEndDate(date).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        Calendar newCalendar = Calendar.getInstance();
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        newCalendar.set(1, 2020);
        newCalendar.set(2, 0);
        newCalendar.set(5, 1);
        Date newDate = newCalendar.getTime();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/endDate", (Object)formatDate.format(newDate));
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicy.getRpName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicy.getRpDescription())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)formatDate.format(newDate))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)resourcePolicy.getStartDate())))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)formatDate.format(newDate))))));
    }

    @Test
    public void patchAddStartDateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)publicItem1).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        Calendar newCalendar = Calendar.getInstance();
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        newCalendar.set(1, 2019);
        newCalendar.set(2, 9);
        newCalendar.set(5, 31);
        Date newDate = newCalendar.getTime();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/startDate", (Object)formatDate.format(newDate));
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicy.getRpName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicy.getRpDescription())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)formatDate.format(newDate))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)resourcePolicy.getEndDate())))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)formatDate.format(newDate))))));
    }

    @Test
    public void patchAddEndDateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)publicItem1).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        Calendar newCalendar = Calendar.getInstance();
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        Date newDate = new Date();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/endDate", (Object)formatDate.format(newDate));
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicy.getRpName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicy.getRpDescription())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)resourcePolicy.getStartDate())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)formatDate.format(newDate))))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)formatDate.format(newDate))))));
    }

    @Test
    public void patchRemoveStartDateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2019);
        calendar.set(2, 9);
        calendar.set(5, 31);
        Date data = calendar.getTime();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)publicItem1).withStartDate(data).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation removeOperation = new RemoveOperation("/startDate");
        ops.add((Operation)removeOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicy.getRpName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicy.getRpDescription())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)resourcePolicy.getEndDate())))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.nullValue()))));
    }

    @Test
    public void patchReplaceStartDateBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2019);
        calendar.set(2, 9);
        calendar.set(5, 31);
        Date date = calendar.getTime();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)publicItem1).withStartDate(date).withDescription("my description").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String wrongStartDate = "";
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/startDate", (Object)wrongStartDate);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)formatDate.format(date))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicy.getRpDescription())))));
    }

    @Test
    public void patchReplaceStartDateUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2010);
        calendar.set(2, 5);
        calendar.set(5, 15);
        Date date = calendar.getTime();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(1).withDspaceObject((DSpaceObject)item).withStartDate(date).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        Calendar calendar2 = Calendar.getInstance();
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        calendar2.set(1, 2021);
        calendar2.set(2, 2);
        calendar2.set(5, 21);
        Date newDate = calendar2.getTime();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/startDate", (Object)formatDate.format(newDate));
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)formatDate.format(date))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicy.getRpDescription())))));
    }

    @Test
    public void patchReplaceStartDateForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2019);
        calendar.set(2, 9);
        calendar.set(5, 31);
        Date date = calendar.getTime();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)item).withStartDate(date).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        Calendar calendar2 = Calendar.getInstance();
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        calendar2.set(1, 2020);
        calendar2.set(2, 0);
        calendar2.set(5, 1);
        Date newData = calendar2.getTime();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/startDate", (Object)formatDate.format(newData));
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        String authToken2 = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)formatDate.format(date))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicy.getRpDescription())))));
    }

    @Test
    public void patchReplaceStartDateNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.context.restoreAuthSystemState();
        Calendar calendar2 = Calendar.getInstance();
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        calendar2.set(1, 2020);
        calendar2.set(2, 0);
        calendar2.set(5, 1);
        Date newData = calendar2.getTime();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/startDate", (Object)formatDate.format(newData));
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/authz/resourcepolicies/2147483647", (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void patchReplaceEndDateBeforeStartDateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        Calendar calendarStartDate = Calendar.getInstance();
        calendarStartDate.set(1, 2019);
        calendarStartDate.set(2, 10);
        calendarStartDate.set(5, 21);
        Date startDate = calendarStartDate.getTime();
        Calendar calendarEndDate = Calendar.getInstance();
        calendarEndDate.set(1, 2020);
        calendarEndDate.set(2, 10);
        calendarEndDate.set(5, 21);
        Date endDate = calendarEndDate.getTime();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)eperson1, null).withAction(0).withDspaceObject((DSpaceObject)publicItem1).withStartDate(startDate).withEndDate(endDate).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        Calendar newEndDateCalendar = Calendar.getInstance();
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        newEndDateCalendar.set(1, 2018);
        newEndDateCalendar.set(2, 10);
        newEndDateCalendar.set(5, 21);
        Date newEndDate = newEndDateCalendar.getTime();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/endDate", (Object)formatDate.format(newEndDate));
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)formatDate.format(startDate))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)formatDate.format(endDate))))));
    }

    @Test
    public void patchReplaceDescriptionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)publicItem1).withDescription("my description").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String newDescription = "New Description";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/description", (Object)newDescription);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicy.getRpName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)newDescription)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)newDescription)))));
    }

    @Test
    public void patchAddDescriptionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)item).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String description = "My Description";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation replaceOperation = new AddOperation("/description", (Object)description);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicy.getRpName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)description)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)description)))));
    }

    @Test
    public void patchRemoveDescriptionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)item).withDescription("my description").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation replaceOperation = new RemoveOperation("/description");
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicy.getRpName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.nullValue()))));
    }

    @Test
    public void patchReplaceDescriptionUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(1).withDspaceObject((DSpaceObject)item).withDescription("My Description").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String newDescription = "New Description";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/description", (Object)newDescription);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicy.getRpDescription())))));
    }

    @Test
    public void patchReplaceDescriptionForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)item).withDescription("My Description").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String newDescription = "New Description";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/description", (Object)newDescription);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void patchRemoveDescriptionNotFoundTest() throws Exception {
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation removeOperation = new RemoveOperation("/description");
        ops.add((Operation)removeOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/authz/resourcepolicies/2147483647", (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void patchReplaceDescriptionBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)publicItem1).withDescription("my description").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String newDescription = "";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/description", (Object)newDescription);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)resourcePolicy.getRpDescription())))));
    }

    @Test
    public void patchReplaceNameTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item myItem = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)myItem).withName("My name").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String newName = "New Name";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/name", (Object)newName);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)newName)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)newName)))));
    }

    @Test
    public void patchReplaceNameBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item myItem = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)myItem).withName("My name").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String errorName = "";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/name", (Object)errorName);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicy.getRpName())))));
    }

    @Test
    public void patchAddNameTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item myItem = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)myItem).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String name = "My Name";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation replaceOperation = new AddOperation("/name", (Object)name);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)))));
    }

    @Test
    public void patchAddActionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{this.eperson}).build();
        Item myItem = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(0).withDspaceObject((DSpaceObject)myItem).withName("My Name").build();
        this.context.restoreAuthSystemState();
        String action = Constants.actionText[1];
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/action", (Object)action);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)action))})));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)action))})));
    }

    @Test
    public void patchReplaceActionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{this.eperson}).build();
        Item myItem = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(0).withDspaceObject((DSpaceObject)myItem).withName("My name").withPolicyType(ResourcePolicy.TYPE_SUBMISSION).build();
        this.context.restoreAuthSystemState();
        String newAction = Constants.actionText[1];
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/action", (Object)newAction);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)newAction))})));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)newAction))})));
    }

    @Test
    public void patchReplaceActionUnauthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(1).withDspaceObject((DSpaceObject)item).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        int newAction = 3;
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/action", (Object)newAction);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()]))})));
    }

    @Test
    public void patchReplaceActionForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(0).withDspaceObject((DSpaceObject)item).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        int newAction = 1;
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/action", (Object)newAction);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void patchReplaceActionNotFoundTest() throws Exception {
        int action = 1;
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/policyType", (Object)action);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/authz/resourcepolicies/2147483647", (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void patchReplaceActionUnprocessableEntityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{this.eperson}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(0).withDspaceObject((DSpaceObject)publicItem1).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        int newAction = -1;
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/action", (Object)newAction);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchAddPolicyTypeTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{this.eperson}).build();
        Item myItem = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(0).withDspaceObject((DSpaceObject)myItem).withName("My Name").build();
        this.context.restoreAuthSystemState();
        String policyType = ResourcePolicy.TYPE_CUSTOM;
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/policyType", (Object)policyType);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.policyType", (Matcher)Matchers.is((Object)policyType)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.policyType", (Matcher)Matchers.is((Object)policyType)))));
    }

    @Test
    public void patchRemovePolicyTypeTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{this.eperson}).build();
        Item myItem = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(0).withDspaceObject((DSpaceObject)myItem).withName("My Name").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation removeOperation = new RemoveOperation("/policyType");
        ops.add((Operation)removeOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()]))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.policyType", (Object[])new Object[0]).doesNotExist());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()]))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.policyType", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void patchReplacePolicyTypeTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{this.eperson}).build();
        Item myItem = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(0).withDspaceObject((DSpaceObject)myItem).withName("My name").withPolicyType(ResourcePolicy.TYPE_SUBMISSION).build();
        this.context.restoreAuthSystemState();
        String newPolicyType = ResourcePolicy.TYPE_CUSTOM;
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/policyType", (Object)newPolicyType);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.policyType", (Matcher)Matchers.is((Object)newPolicyType)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.policyType", (Matcher)Matchers.is((Object)newPolicyType)))));
    }

    @Test
    public void patchReplacePolicyTypeUnauthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(1).withDspaceObject((DSpaceObject)item).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String newPolicyType = ResourcePolicy.TYPE_SUBMISSION;
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/policyType", (Object)newPolicyType);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.policyType", (Matcher)Matchers.is((Object)resourcePolicy.getRpType())))));
    }

    @Test
    public void patchReplacePolicyTypeForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(0).withDspaceObject((DSpaceObject)item).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String newPolicyType = ResourcePolicy.TYPE_SUBMISSION;
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/policyType", (Object)newPolicyType);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void patchRemovePolicyTypeNotFoundTest() throws Exception {
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation removeOperation = new RemoveOperation("/policyType");
        ops.add((Operation)removeOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/authz/resourcepolicies/2147483647", (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void patchReplacePolicyTypeBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{this.eperson}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(0).withDspaceObject((DSpaceObject)publicItem1).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String newPolicyType = "";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/policyType", (Object)newPolicyType);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void patchAddNameBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item myItem = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)myItem).withName("My name").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String name = "Add Name";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation replaceOperation = new AddOperation("/name", (Object)name);
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicy.getRpName())))));
    }

    @Test
    public void patchRemoveNameTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item myItem = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)myItem).withName("My Name").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation replaceOperation = new RemoveOperation("/name");
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.nullValue()))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.nullValue()))));
    }

    @Test
    public void patchRemoveNameForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item myItem = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)myItem).withName("My Name").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation replaceOperation = new RemoveOperation("/name");
        ops.add((Operation)replaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicy.getRpName())))));
    }

    @Test
    public void patchSuccessfulMultipleOperationsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        Calendar calendarStartDate = Calendar.getInstance();
        calendarStartDate.set(1, 2017);
        calendarStartDate.set(2, 0);
        calendarStartDate.set(5, 1);
        Date startDate = calendarStartDate.getTime();
        Calendar calendarEndDate = Calendar.getInstance();
        calendarEndDate.set(1, 2022);
        calendarEndDate.set(2, 11);
        calendarEndDate.set(5, 31);
        Date endDate = calendarEndDate.getTime();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)publicItem1).withStartDate(startDate).withEndDate(endDate).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        String addName = "My Name";
        AddOperation addNameOperation = new AddOperation("/name", (Object)addName);
        ops.add((Operation)addNameOperation);
        String addDescription = "My Description";
        AddOperation addDescriptionOperation = new AddOperation("/description", (Object)addDescription);
        ops.add((Operation)addDescriptionOperation);
        String newName = "New Name";
        ReplaceOperation replaceNameOperation = new ReplaceOperation("/name", (Object)newName);
        ops.add((Operation)replaceNameOperation);
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendarNewStartDate = Calendar.getInstance();
        calendarNewStartDate.set(1, 2018);
        calendarNewStartDate.set(2, 1);
        calendarNewStartDate.set(5, 1);
        Date newStartDate = calendarNewStartDate.getTime();
        ReplaceOperation replaceStartDateOperation = new ReplaceOperation("/startDate", (Object)formatDate.format(newStartDate));
        ops.add((Operation)replaceStartDateOperation);
        RemoveOperation removeEndDateOperation = new RemoveOperation("/endDate");
        ops.add((Operation)removeEndDateOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)newName)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)addDescription)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)formatDate.format(newStartDate))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)newName)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.is((Object)formatDate.format(newStartDate))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.is((Object)addDescription)))));
    }

    @Test
    public void patchWithMultipleOperationsFailTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withAdminGroup(new EPerson[]{eperson1}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").build();
        Calendar calendarEndDate = Calendar.getInstance();
        calendarEndDate.set(1, 2022);
        calendarEndDate.set(2, 11);
        calendarEndDate.set(5, 31);
        Date endDate = calendarEndDate.getTime();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)EPersonServiceFactory.getInstance().getGroupService().findByName(this.context, "Anonymous")).withAction(0).withDspaceObject((DSpaceObject)publicItem1).withName("My Name").withEndDate(endDate).withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        String newName = "New Name";
        ReplaceOperation replaceNameOperation = new ReplaceOperation("/name", (Object)newName);
        ops.add((Operation)replaceNameOperation);
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendarNewStartDate = Calendar.getInstance();
        calendarNewStartDate.set(1, 2018);
        calendarNewStartDate.set(2, 1);
        calendarNewStartDate.set(5, 1);
        Date newStartDate = calendarNewStartDate.getTime();
        ReplaceOperation replaceStartDateOperation = new ReplaceOperation("/startDate", (Object)formatDate.format(newStartDate));
        ops.add((Operation)replaceStartDateOperation);
        RemoveOperation removeEndDateOperation = new RemoveOperation("/endDate");
        ops.add((Operation)removeEndDateOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(eperson1.getEmail(), "qwerty01");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.action", (Matcher)Matchers.is((Object)Constants.actionText[resourcePolicy.getAction()])), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)resourcePolicy.getRpName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.startDate", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.endDate", (Matcher)Matchers.is((Object)formatDate.format(endDate))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.description", (Matcher)Matchers.nullValue()))));
    }

    @Test
    public void discoverableNestedLinkTest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.resourcepolicies.href", (Matcher)Matchers.is((Object)"http://localhost/api/authz/resourcepolicies")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.resourcepolicies-search.href", (Matcher)Matchers.is((Object)"http://localhost/api/authz/resourcepolicies/search")))));
    }

    @Test
    public void findResourcePoliciesByGroupUuidPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group1 = GroupBuilder.createGroup((Context)this.context).withName("My group").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        Community community2 = CommunityBuilder.createCommunity((Context)this.context).withName("My 2 community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("My collection").build();
        ResourcePolicy rpCommunityADD = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group1).withDspaceObject((DSpaceObject)community).withAction(3).build();
        ResourcePolicy rpCommunityREAD = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group1).withDspaceObject((DSpaceObject)community).withAction(0).build();
        ResourcePolicy rpCommunity2READ = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group1).withDspaceObject((DSpaceObject)community2).withAction(0).build();
        ResourcePolicy rpCollectionWRITE = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group1).withDspaceObject((DSpaceObject)collection).withAction(1).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0]).param("uuid", new String[]{group1.getID().toString()}).param("page", new String[]{"0"}).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"resourcepolicy"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Object[])new Object[0]).value(Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0]).param("uuid", new String[]{group1.getID().toString()}).param("page", new String[]{"1"}).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"resourcepolicy"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Object[])new Object[0]).value(Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0]).param("uuid", new String[]{group1.getID().toString()}).param("page", new String[]{"2"}).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"resourcepolicy"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Object[])new Object[0]).value(Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0]).param("uuid", new String[]{group1.getID().toString()}).param("page", new String[]{"3"}).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"resourcepolicy"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Object[])new Object[0]).value(Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4)));
    }

    @Test
    public void resourcepolicySerchMethodWithSingleModelTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicy/search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void resourcepolicySerchMethodWithPluralModelTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.eperson.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)"/api/authz/resourcepolicies/search/eperson")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.group.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)"/api/authz/resourcepolicies/search/group")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.resource.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)"/api/authz/resourcepolicies/search/resource")})));
    }

    @Test
    public void patchReplaceEPersonAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson newEPerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("newEPerson@mail.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(3).withDspaceObject((DSpaceObject)col).withDescription("My Description").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.group", (Matcher)Matchers.nullValue()));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID() + "/eperson"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/epersons/" + newEPerson.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)newEPerson.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.group", (Matcher)Matchers.nullValue()));
    }

    @Test
    public void patchReplaceEPersonForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson newEPerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("newEPerson@mail.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(3).withDspaceObject((DSpaceObject)col).withDescription("My Description").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.group", (Matcher)Matchers.nullValue()));
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID() + "/eperson"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/epersons/" + newEPerson.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.group", (Matcher)Matchers.nullValue()));
    }

    @Test
    public void patchReplaceEPersonUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson newEPerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("newEPerson@mail.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(3).withDspaceObject((DSpaceObject)col).withDescription("My Description").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.group", (Matcher)Matchers.nullValue()));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID() + "/eperson"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/epersons/" + newEPerson.getID())).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.group", (Matcher)Matchers.nullValue()));
    }

    @Test
    public void patchReplaceGroupAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group originGroup = GroupBuilder.createGroup((Context)this.context).withName("origin Test Group").build();
        Group newGroup = GroupBuilder.createGroup((Context)this.context).withName("testGroupName").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)originGroup).withAction(3).withDspaceObject((DSpaceObject)col).withDescription("My Description").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.group.id", (Matcher)Matchers.is((Object)originGroup.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", (Matcher)Matchers.nullValue()));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID() + "/group"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/groups/" + newGroup.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.group.id", (Matcher)Matchers.is((Object)newGroup.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", (Matcher)Matchers.nullValue()));
    }

    @Test
    public void patchReplaceGroupForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group originGroup = GroupBuilder.createGroup((Context)this.context).withName("origin Test Group").build();
        Group newGroup = GroupBuilder.createGroup((Context)this.context).withName("testGroupName").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)originGroup).withAction(3).withDspaceObject((DSpaceObject)col).withDescription("My Description").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.group.id", (Matcher)Matchers.is((Object)originGroup.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", (Matcher)Matchers.nullValue()));
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID() + "/group"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/groups/" + newGroup.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.group.id", (Matcher)Matchers.is((Object)originGroup.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", (Matcher)Matchers.nullValue()));
    }

    @Test
    public void patchReplaceGroupUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group originGroup = GroupBuilder.createGroup((Context)this.context).withName("origin Test Group").build();
        Group newGroup = GroupBuilder.createGroup((Context)this.context).withName("testGroupName").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        ResourcePolicy resourcePolicy = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)originGroup).withAction(3).withDspaceObject((DSpaceObject)col).withDescription("My Description").withPolicyType(ResourcePolicy.TYPE_CUSTOM).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.group.id", (Matcher)Matchers.is((Object)originGroup.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", (Matcher)Matchers.nullValue()));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID() + "/group"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/groups/" + newGroup.getID())).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicy.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.group.id", (Matcher)Matchers.is((Object)originGroup.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", (Matcher)Matchers.nullValue()));
    }

    @Test
    public void updateResourcePolicyOfEPersonToGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("My group").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy resourcePolicyOfEPerson = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withDspaceObject((DSpaceObject)community).withAction(0).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/resourcepolicies/" + resourcePolicyOfEPerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ResourcePolicyMatcher.matchResourcePolicy(resourcePolicyOfEPerson)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/authz/resourcepolicies/" + resourcePolicyOfEPerson.getID()))));
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/authz/resourcepolicies/" + resourcePolicyOfEPerson.getID() + "/group"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/groups/" + group.getID())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void updateResourcePolicyOfGroupToEPersonTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("My group").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy resourcePolicyOfGroup = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group).withDspaceObject((DSpaceObject)community).withAction(3).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/group", (Object[])new Object[0]).param("uuid", new String[]{group.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicy(resourcePolicyOfGroup)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/authz/resourcepolicies/search/group"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/authz/resourcepolicies/" + resourcePolicyOfGroup.getID() + "/eperson"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/epersons/" + this.eperson.getID())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void updateEPersonOfNotExistingResourcePolicyTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/api/authz/resourcepolicies/2147483647/eperson", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/epersons/" + this.eperson.getID())).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void updateGroupOfNotExistingResourcePolicyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("My group").build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/api/authz/resourcepolicies/2147483647/group", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/groups/" + group.getID())).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void updateResourcePolicyOfGroupWithEmptyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("My group").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy resourcePolicyOfGroup = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group).withDspaceObject((DSpaceObject)community).withAction(3).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/authz/resourcepolicies/" + resourcePolicyOfGroup.getID() + "/group"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void updateResourcePolicyOfGroupWithMultipleGroupsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group1 = GroupBuilder.createGroup((Context)this.context).withName("My group").build();
        Group group2 = GroupBuilder.createGroup((Context)this.context).withName("My group2").build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy resourcePolicyOfGroup = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)group1).withDspaceObject((DSpaceObject)community).withAction(3).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/authz/resourcepolicies/" + resourcePolicyOfGroup.getID() + "/group"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/groups/" + group1.getID() + "\n/api/eperson/groups/" + group2.getID())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void updateResourcePolicyOfEPersonWithEmptyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy rpOfEPerson = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withDspaceObject((DSpaceObject)community).withAction(0).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/authz/resourcepolicies/" + rpOfEPerson.getID() + "/eperson"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void updateResourcePolicyOfEPersonWithMultipleEPersonsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword(this.password).build();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword(this.password).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("My community").build();
        ResourcePolicy rpOfEPerson = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withDspaceObject((DSpaceObject)community).withAction(0).build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/authz/resourcepolicies/" + rpOfEPerson.getID() + "/eperson"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/epersons/" + eperson1.getID() + "\n/api/eperson/epersons/" + eperson2.getID())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }
}

