/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.app.matcher.LambdaMatcher;
import org.dspace.app.rest.AbstractLiveImportIntegrationTest;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.liveimportclient.service.LiveImportClientImpl;
import org.dspace.importer.external.ror.service.RorImportMetadataSourceServiceImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class RorImportMetadataSourceServiceIT
extends AbstractLiveImportIntegrationTest {
    @Autowired
    private LiveImportClientImpl liveImportClient;
    @Autowired
    private RorImportMetadataSourceServiceImpl rorServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tesGetRecords() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClient.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("ror-records.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            this.liveImportClient.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(jsonResponse, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            Collection recordsImported = this.rorServiceImpl.getRecords("test query", 0, 2);
            MatcherAssert.assertThat((Object)recordsImported, (Matcher)Matchers.hasSize((int)20));
            ImportRecord record = (ImportRecord)recordsImported.iterator().next();
            MatcherAssert.assertThat((Object)record.getValueList(), (Matcher)Matchers.hasSize((int)11));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.legalName"), this.is("The University of Texas"));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.identifier.ror"), this.is("https://ror.org/02f6dcw23"));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.alternateName"), this.is("UTHSCSA"));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.url"), this.is("http://www.uthscsa.edu/"));
            MatcherAssert.assertThat((Object)record.getSingleValue("dc.type"), this.is("Education"));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.address.addressCountry"), this.is("US"));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.foundingDate"), this.is("1959"));
            MatcherAssert.assertThat((Object)record.getValue("organization", "identifier", "crossrefid"), (Matcher)Matchers.hasSize((int)2));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.identifier.isni"), this.is("0000 0001 0629 5880"));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.parentOrganization"), this.is("The University of Texas System"));
        }
        finally {
            this.liveImportClient.setHttpClient(originalHttpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tesCount() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClient.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("ror-records.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            this.liveImportClient.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(jsonResponse, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            Integer count = this.rorServiceImpl.count("test");
            MatcherAssert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)200));
        }
        finally {
            this.liveImportClient.setHttpClient(originalHttpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tesGetRecord() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClient.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("ror-record.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            this.liveImportClient.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(jsonResponse, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            ImportRecord record = this.rorServiceImpl.getRecord("https://ror.org/01sps7q28");
            MatcherAssert.assertThat((Object)record.getValueList(), (Matcher)Matchers.hasSize((int)9));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.legalName"), this.is("The University of Texas Health Science Center at Tyler"));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.identifier.ror"), this.is("https://ror.org/01sps7q28"));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.alternateName"), this.is("UTHSCT"));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.url"), this.is("https://www.utsystem.edu/institutions/university-texas-health-science-center-tyler"));
            MatcherAssert.assertThat((Object)record.getSingleValue("dc.type"), this.is("Healthcare"));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.address.addressCountry"), this.is("US"));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.foundingDate"), this.is("1947"));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.identifier.isni"), this.is("0000 0000 9704 5790"));
            MatcherAssert.assertThat((Object)record.getSingleValue("organization.parentOrganization"), this.is("The University of Texas System"));
        }
        finally {
            this.liveImportClient.setHttpClient(originalHttpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tesGetRecordsCount() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClient.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream rorResponse = ((Object)((Object)this)).getClass().getResourceAsStream("ror-records.json");){
            String rorJsonResponse = IOUtils.toString((InputStream)rorResponse, (Charset)Charset.defaultCharset());
            this.liveImportClient.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(rorJsonResponse, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            int tot = this.rorServiceImpl.getRecordsCount("test query");
            Assert.assertEquals((long)200L, (long)tot);
        }
        finally {
            this.liveImportClient.setHttpClient(originalHttpClient);
        }
    }

    private Matcher<Optional<String>> is(String value) {
        return LambdaMatcher.matches(optionalValue -> optionalValue.isPresent() && ((String)optionalValue.get()).equals(value));
    }
}

