/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.app.rest.AbstractLiveImportIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.liveimportclient.service.LiveImportClientImpl;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.scielo.service.ScieloImportMetadataSourceServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class ScieloImportMetadataSourceServiceIT
extends AbstractLiveImportIntegrationTest {
    @Autowired
    private LiveImportClientImpl liveImportClientImpl;
    @Autowired
    private ScieloImportMetadataSourceServiceImpl scieloServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scieloImportMetadataGetRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream scieloResp = ((Object)((Object)this)).getClass().getResourceAsStream("scielo-test.txt");){
            String scieloRipResp = IOUtils.toString((InputStream)scieloResp, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(scieloRipResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            Collection recordsImported = this.scieloServiceImpl.getRecords("test query", 0, 2);
            Assert.assertEquals((long)2L, (long)recordsImported.size());
            this.matchRecords(new ArrayList<ImportRecord>(recordsImported), collection2match);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scieloImportMetadataGetRecordsCountTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("scielo-test.txt");){
            String scieloResp = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(scieloResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            int tot = this.scieloServiceImpl.getRecordsCount("test query");
            Assert.assertEquals((long)2L, (long)tot);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void scieloImportMetadataFindMatchingRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item testItem = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("test item").withIssueDate("2021").build();
        this.context.restoreAuthSystemState();
        this.scieloServiceImpl.findMatchingRecords(testItem);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void scieloImportMetadataGetRecordsCountByQueryTest() throws Exception {
        Query q = new Query();
        q.addParameter("query", (Object)"test query");
        this.scieloServiceImpl.getRecordsCount(q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scieloImportMetadataGetRecordsByIdTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream scieloResp = ((Object)((Object)this)).getClass().getResourceAsStream("scielo-single-record.txt");){
            String scieloRipResp = IOUtils.toString((InputStream)scieloResp, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(scieloRipResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            collection2match.remove(1);
            ImportRecord record = this.scieloServiceImpl.getRecord("S0185-30582021000200231-mex");
            Assert.assertNotNull((Object)record);
            List<ImportRecord> recordsImported = Arrays.asList(record);
            this.matchRecords(new ArrayList<ImportRecord>(recordsImported), collection2match);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    private ArrayList<ImportRecord> getRecords() {
        ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
        ArrayList<MetadatumDTO> metadatums = new ArrayList<MetadatumDTO>();
        MetadatumDTO ispartof = this.createMetadatumDTO("dc", "relation", "ispartof", "Nova tellus");
        MetadatumDTO date = this.createMetadatumDTO("dc", "date", "issued", "2021");
        MetadatumDTO citation = this.createMetadatumDTO("oaire", "citation", "issue", "2");
        MetadatumDTO doi = this.createMetadatumDTO("dc", "identifier", "doi", "10.19130/iifl.nt.2021.39.2.901");
        MetadatumDTO endPage = this.createMetadatumDTO("oaire", "citation", "endPage", "236");
        MetadatumDTO subject = this.createMetadatumDTO("dc", "subject", null, "Roma");
        MetadatumDTO subject2 = this.createMetadatumDTO("dc", "subject", null, "Historia");
        MetadatumDTO subject3 = this.createMetadatumDTO("dc", "subject", null, "ritos funerarios");
        MetadatumDTO subject4 = this.createMetadatumDTO("dc", "subject", null, "inframundo");
        MetadatumDTO subject5 = this.createMetadatumDTO("dc", "subject", null, "epitafios");
        MetadatumDTO author = this.createMetadatumDTO("dc", "contributor", "author", "Torres Marzo, Ricardo");
        MetadatumDTO title = this.createMetadatumDTO("dc", "title", null, "Requena Jim\u00e9nez, Miguel, Los espacios de la muerte en Roma, Madrid, S\u00edntesis, 2021, 365 p\u00e1gs. m\u00e1s bibliograf\u00eda en l\u00ednea, ISBN 978-84-135759-6-4.");
        MetadatumDTO volume = this.createMetadatumDTO("oaire", "citation", "volume", "39");
        MetadatumDTO issn = this.createMetadatumDTO("dc", "identifier", "issn", "0185-3058");
        MetadatumDTO other = this.createMetadatumDTO("dc", "identifier", "other", "S0185-30582021000200231-mex");
        MetadatumDTO startPage = this.createMetadatumDTO("oaire", "citation", "startPage", "231");
        metadatums.add(ispartof);
        metadatums.add(date);
        metadatums.add(citation);
        metadatums.add(doi);
        metadatums.add(endPage);
        metadatums.add(subject);
        metadatums.add(subject2);
        metadatums.add(subject3);
        metadatums.add(subject4);
        metadatums.add(subject5);
        metadatums.add(author);
        metadatums.add(title);
        metadatums.add(volume);
        metadatums.add(issn);
        metadatums.add(other);
        metadatums.add(startPage);
        ImportRecord firstrRecord = new ImportRecord(metadatums);
        ArrayList<MetadatumDTO> metadatums2 = new ArrayList<MetadatumDTO>();
        MetadatumDTO ispartof2 = this.createMetadatumDTO("dc", "relation", "ispartof", "Revista de Derecho Privado");
        MetadatumDTO date2 = this.createMetadatumDTO("dc", "date", "issued", "2021");
        MetadatumDTO citation2 = this.createMetadatumDTO("oaire", "citation", "issue", "41");
        MetadatumDTO doi2 = this.createMetadatumDTO("dc", "identifier", "doi", "10.18601/01234366.n41.14");
        MetadatumDTO endPage2 = this.createMetadatumDTO("oaire", "citation", "endPage", "418");
        MetadatumDTO subject6 = this.createMetadatumDTO("dc", "subject", null, "sopravvenienza contrattuale");
        MetadatumDTO subject7 = this.createMetadatumDTO("dc", "subject", null, "covro");
        MetadatumDTO subject8 = this.createMetadatumDTO("dc", "subject", null, "buona fede in senso oggettivo");
        MetadatumDTO subject9 = this.createMetadatumDTO("dc", "subject", null, "obbligo di rinegoziare");
        MetadatumDTO subject10 = this.createMetadatumDTO("dc", "subject", null, "revisione del contratto");
        MetadatumDTO author2 = this.createMetadatumDTO("dc", "contributor", "author", "MAGRI, GEO");
        MetadatumDTO title2 = this.createMetadatumDTO("dc", "title", null, "Rinegoziazione e revisione del contratto. Tribunale di Roma, Sez. VI, 27 agosto 2020");
        MetadatumDTO issn2 = this.createMetadatumDTO("dc", "identifier", "issn", "0123-4366");
        MetadatumDTO other2 = this.createMetadatumDTO("dc", "identifier", "other", "S0123-43662021000200397-col");
        MetadatumDTO startPage2 = this.createMetadatumDTO("oaire", "citation", "startPage", "397");
        MetadatumDTO description = this.createMetadatumDTO("dc", "description", "abstract", "ABSTRACT: The Tribunal of Rome imposes an obligation to renegotiate long-term contracts, the balance of which has been modified by the covro pandemic. The decision establishes a general obligation for the parties to execute the contract in good faith and gives the judge the possibility of a judicial review. This is a long-awaited decision in doctrine which complies with the indications of the Supreme Court of Cassation expressed in its memorandum 56/2020.");
        metadatums2.add(ispartof2);
        metadatums2.add(date2);
        metadatums2.add(citation2);
        metadatums2.add(doi2);
        metadatums2.add(endPage2);
        metadatums2.add(subject6);
        metadatums2.add(subject7);
        metadatums2.add(subject8);
        metadatums2.add(subject9);
        metadatums2.add(subject10);
        metadatums2.add(author2);
        metadatums2.add(title2);
        metadatums2.add(issn2);
        metadatums2.add(other2);
        metadatums2.add(startPage2);
        metadatums2.add(description);
        ImportRecord secondRecord = new ImportRecord(metadatums2);
        records.add(firstrRecord);
        records.add(secondRecord);
        return records;
    }
}

