/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.codec.CharEncoding;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.matcher.UsageReportMatcher;
import org.dspace.app.rest.model.UsageReportPointCityRest;
import org.dspace.app.rest.model.UsageReportPointCountryRest;
import org.dspace.app.rest.model.UsageReportPointDateRest;
import org.dspace.app.rest.model.UsageReportPointDsoTotalVisitsRest;
import org.dspace.app.rest.model.UsageReportPointRest;
import org.dspace.app.rest.model.ViewEventRest;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.builder.SiteBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class StatisticsRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    protected AuthorizeService authorizeService;
    private Community communityNotVisited;
    private Community communityVisited;
    private Collection collectionNotVisited;
    private Collection collectionVisited;
    private Item itemNotVisitedWithBitstreams;
    private Item itemVisited;
    private Bitstream bitstreamNotVisited;
    private Bitstream bitstreamVisited;
    private String loggedInToken;
    private String adminToken;

    @BeforeClass
    public static void clearStatistics() throws Exception {
        StatisticsServiceFactory.getInstance().getSolrLoggerService().removeIndex("*:*");
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("solr-statistics.autoCommit", (Object)false);
        this.configurationService.setProperty("usage-statistics.authorization.admin.usage", (Object)true);
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        this.communityNotVisited = CommunityBuilder.createSubCommunity((Context)this.context, (Community)community).build();
        this.communityVisited = CommunityBuilder.createSubCommunity((Context)this.context, (Community)community).build();
        this.collectionNotVisited = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        this.collectionVisited = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        this.itemVisited = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionNotVisited).build();
        this.itemNotVisitedWithBitstreams = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionNotVisited).build();
        this.bitstreamNotVisited = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.itemNotVisitedWithBitstreams, (InputStream)IOUtils.toInputStream((String)"test", (String)CharEncoding.UTF_8)).withName("BitstreamNotVisitedName").build();
        this.bitstreamVisited = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.itemNotVisitedWithBitstreams, (InputStream)IOUtils.toInputStream((String)"test", (String)CharEncoding.UTF_8)).withName("BitstreamVisitedName").build();
        this.loggedInToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void usagereports_withoutId_NotImplementedException() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/statistics/usagereports", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(HttpStatus.METHOD_NOT_ALLOWED.value()));
    }

    @Test
    public void usagereports_notProperUUIDAndReportId_Exception() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/statistics/usagereports/notProperUUIDAndReportId", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void usagereports_nonValidUUIDpart_Exception() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/statistics/usagereports/notAnUUID_TotalVisits", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void usagereports_nonValidReportIDpart_Exception() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_NotValidReport"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(HttpStatus.NOT_FOUND.value()));
    }

    @Test
    public void usagereports_nonValidReportIDpart_Exception_By_Anonymous_Unauthorized_Test() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_NotValidReport"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void usagereports_nonValidReportIDpart_Exception_By_Anonymous_Test() throws Exception {
        this.configurationService.setProperty("usage-statistics.authorization.admin.usage", (Object)false);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_NotValidReport"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void usagereports_NonExistentUUID_Exception() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + UUID.randomUUID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(HttpStatus.NOT_FOUND.value()));
    }

    @Test
    public void usagereport_onlyAdminReadRights() throws Exception {
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.itemNotVisitedWithBitstreams);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void usagereport_onlyAdminReadRights_unvalidToken() throws Exception {
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.itemNotVisitedWithBitstreams);
        this.getClient("unvalidToken").perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void usagereport_loggedInUserReadRights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.itemNotVisitedWithBitstreams);
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withDspaceObject((DSpaceObject)this.itemNotVisitedWithBitstreams).withAction(0).build();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        String anotherLoggedInUserToken = this.getAuthToken(eperson1.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(anotherLoggedInUserToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void usagereport_loggedInUserReadRights_and_usage_statistics_admin_is_false_Test() throws Exception {
        this.configurationService.setProperty("usage-statistics.authorization.admin.usage", (Object)false);
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.itemNotVisitedWithBitstreams);
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withDspaceObject((DSpaceObject)this.itemNotVisitedWithBitstreams).withAction(0).build();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        String anotherLoggedInUserToken = this.getAuthToken(eperson1.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(anotherLoggedInUserToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void totalVisitsReport_Community_Visited() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("community");
        viewEventRest.setTargetId(this.communityVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.communityVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.communityVisited.getID() + "_TotalVisits", "TotalVisits", List.of(this.getExpectedDsoViews((DSpaceObject)this.communityVisited, 1))))));
    }

    @Test
    public void totalVisitsReport_Community_NotVisited() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.communityNotVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.communityNotVisited.getID() + "_TotalVisits", "TotalVisits", List.of(this.getExpectedDsoViews((DSpaceObject)this.communityNotVisited, 0))))));
    }

    @Test
    public void totalVisitsReport_Collection_Visited() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("collection");
        viewEventRest.setTargetId(this.collectionVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.collectionVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.collectionVisited.getID() + "_TotalVisits", "TotalVisits", List.of(this.getExpectedDsoViews((DSpaceObject)this.collectionVisited, 2))))));
    }

    @Test
    public void totalVisitsReport_Collection_NotVisited() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.collectionNotVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.collectionNotVisited.getID() + "_TotalVisits", "TotalVisits", List.of(this.getExpectedDsoViews((DSpaceObject)this.collectionNotVisited, 0))))));
    }

    @Test
    public void totalVisitsReport_Item_Visited() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("item");
        viewEventRest.setTargetId(this.itemVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TotalVisits", "TotalVisits", List.of(this.getExpectedDsoViews((DSpaceObject)this.itemVisited, 1))))));
    }

    @Test
    public void totalVisitsReport_Item_NotVisited() throws Exception {
        List<UsageReportPointDsoTotalVisitsRest> expectedPoints = List.of(this.getExpectedDsoViews((DSpaceObject)this.itemNotVisitedWithBitstreams, 0));
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits", "TotalVisits", expectedPoints))));
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.configurationService.setProperty("usage-statistics.authorization.admin.usage", (Object)false);
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits", "TotalVisits", expectedPoints))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemNotVisitedWithBitstreams.getID() + "_TotalVisits", "TotalVisits", expectedPoints))));
    }

    @Test
    public void totalVisitsReport_Bitstream_Visited() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("bitstream");
        viewEventRest.setTargetId(this.bitstreamVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        List<UsageReportPointDsoTotalVisitsRest> expectedPoints = List.of(this.getExpectedDsoViews((DSpaceObject)this.bitstreamVisited, 1));
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.bitstreamVisited.getID() + "_TotalVisits", "TotalVisits", expectedPoints))));
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.configurationService.setProperty("usage-statistics.authorization.admin.usage", (Object)false);
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.bitstreamVisited.getID() + "_TotalVisits", "TotalVisits", expectedPoints))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.bitstreamVisited.getID() + "_TotalVisits", "TotalVisits", expectedPoints))));
    }

    @Test
    public void totalVisitsReport_Bitstream_NotVisited() throws Exception {
        List<UsageReportPointDsoTotalVisitsRest> expectedPoints = List.of(this.getExpectedDsoViews((DSpaceObject)this.bitstreamNotVisited, 0));
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamNotVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.bitstreamNotVisited.getID() + "_TotalVisits", "TotalVisits", expectedPoints))));
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamNotVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamNotVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.configurationService.setProperty("usage-statistics.authorization.admin.usage", (Object)false);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamNotVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.bitstreamNotVisited.getID() + "_TotalVisits", "TotalVisits", expectedPoints))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamNotVisited.getID() + "_TotalVisits"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.bitstreamNotVisited.getID() + "_TotalVisits", "TotalVisits", expectedPoints))));
    }

    @Test
    public void totalVisitsPerMonthReport_Item_Visited() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("item");
        viewEventRest.setTargetId(this.itemVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        List<UsageReportPointRest> expectedPoints = this.getListOfVisitsPerMonthsPoints(1);
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemVisited.getID() + "_TotalVisitsPerMonth"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TotalVisitsPerMonth", "TotalVisitsPerMonth", expectedPoints))));
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemVisited.getID() + "_TotalVisitsPerMonth"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemVisited.getID() + "_TotalVisitsPerMonth"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.configurationService.setProperty("usage-statistics.authorization.admin.usage", (Object)false);
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemVisited.getID() + "_TotalVisitsPerMonth"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TotalVisitsPerMonth", "TotalVisitsPerMonth", expectedPoints))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemVisited.getID() + "_TotalVisitsPerMonth"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TotalVisitsPerMonth", "TotalVisitsPerMonth", expectedPoints))));
    }

    @Test
    public void totalVisitsPerMonthReport_Item_NotVisited() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalVisitsPerMonth"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemNotVisitedWithBitstreams.getID() + "_TotalVisitsPerMonth", "TotalVisitsPerMonth", this.getListOfVisitsPerMonthsPoints(0)))));
    }

    @Test
    public void totalVisitsPerMonthReport_Collection_Visited() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("collection");
        viewEventRest.setTargetId(this.collectionVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.collectionVisited.getID() + "_TotalVisitsPerMonth"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.collectionVisited.getID() + "_TotalVisitsPerMonth", "TotalVisitsPerMonth", this.getListOfVisitsPerMonthsPoints(2)))));
    }

    @Test
    public void TotalDownloadsReport_Bitstream() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("bitstream");
        viewEventRest.setTargetId(this.bitstreamVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        List<UsageReportPointDsoTotalVisitsRest> expectedPoints = List.of(this.getExpectedDsoViews((DSpaceObject)this.bitstreamVisited, 1));
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamVisited.getID() + "_TotalDownloads"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.bitstreamVisited.getID() + "_TotalDownloads", "TotalDownloads", expectedPoints))));
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamVisited.getID() + "_TotalDownloads"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamVisited.getID() + "_TotalDownloads"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.configurationService.setProperty("usage-statistics.authorization.admin.usage", (Object)false);
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamVisited.getID() + "_TotalDownloads"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.bitstreamVisited.getID() + "_TotalDownloads", "TotalDownloads", expectedPoints))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.bitstreamVisited.getID() + "_TotalDownloads"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.bitstreamVisited.getID() + "_TotalDownloads", "TotalDownloads", expectedPoints))));
    }

    @Test
    public void TotalDownloadsReport_Item() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("bitstream");
        viewEventRest.setTargetId(this.bitstreamVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalDownloads"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemNotVisitedWithBitstreams.getID() + "_TotalDownloads", "TotalDownloads", List.of(this.getExpectedDsoViews((DSpaceObject)this.bitstreamVisited, 1))))));
    }

    @Test
    public void TotalDownloadsReport_Item_NotVisited() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TotalDownloads"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemNotVisitedWithBitstreams.getID() + "_TotalDownloads", "TotalDownloads", List.of()))));
    }

    @Test
    public void TotalDownloadsReport_NotSupportedDSO_Collection() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.collectionVisited.getID() + "_TotalDownloads"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void topCountriesReport_Collection_Visited() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("collection");
        viewEventRest.setTargetId(this.collectionVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        List<UsageReportPointCountryRest> expectedPoints = List.of(this.getExpectedCountryViews("US", "United States", 1));
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.collectionVisited.getID() + "_TopCountries"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.collectionVisited.getID() + "_TopCountries", "TopCountries", expectedPoints))));
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.collectionVisited.getID() + "_TopCountries"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.collectionVisited.getID() + "_TopCountries"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.configurationService.setProperty("usage-statistics.authorization.admin.usage", (Object)false);
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.collectionVisited.getID() + "_TopCountries"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.collectionVisited.getID() + "_TopCountries", "TopCountries", expectedPoints))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.collectionVisited.getID() + "_TopCountries"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.collectionVisited.getID() + "_TopCountries", "TopCountries", expectedPoints))));
    }

    @Test
    public void topCountriesReport_Community_Visited() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("community");
        viewEventRest.setTargetId(this.communityVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.communityVisited.getID() + "_TopCountries"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.communityVisited.getID() + "_TopCountries", "TopCountries", List.of(this.getExpectedCountryViews("US", "United States", 2))))));
    }

    @Test
    public void topCountriesReport_Item_NotVisited() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemNotVisitedWithBitstreams.getID() + "_TopCountries"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemNotVisitedWithBitstreams.getID() + "_TopCountries", "TopCountries", List.of()))));
    }

    @Test
    public void topCitiesReport_Item_Visited() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("item");
        viewEventRest.setTargetId(this.itemVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        List<UsageReportPointCityRest> expectedPoints = List.of(this.getExpectedCityViews("New York", 1));
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemVisited.getID() + "_TopCities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TopCities", "TopCities", expectedPoints))));
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemVisited.getID() + "_TopCities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemVisited.getID() + "_TopCities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.configurationService.setProperty("usage-statistics.authorization.admin.usage", (Object)false);
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemVisited.getID() + "_TopCities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TopCities", "TopCities", expectedPoints))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.itemVisited.getID() + "_TopCities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TopCities", "TopCities", expectedPoints))));
    }

    @Test
    public void topCitiesReport_Community_Visited() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("community");
        viewEventRest.setTargetId(this.communityVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.communityVisited.getID() + "_TopCities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.communityVisited.getID() + "_TopCities", "TopCities", List.of(this.getExpectedCityViews("New York", 3))))));
    }

    @Test
    public void topCitiesReport_Collection_NotVisited() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/" + this.collectionNotVisited.getID() + "_TopCities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(UsageReportMatcher.matchUsageReport(this.collectionNotVisited.getID() + "_TopCities", "TopCities", List.of()))));
    }

    @Test
    public void usagereportsSearch_notProperURI_Exception() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/statistics/usagereports/search/object?uri=BadUri", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(HttpStatus.BAD_REQUEST.value()));
    }

    @Test
    public void usagereportsSearch_noURI_Exception() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/statistics/usagereports/search/object", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(HttpStatus.BAD_REQUEST.value()));
    }

    @Test
    public void usagereportsSearch_NonExistentUUID_Exception() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/search/object?uri=http://localhost:8080/server/api/core/items/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(HttpStatus.NOT_FOUND.value()));
    }

    @Test
    public void usagereportSearch_onlyAdminReadRights() throws Exception {
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.itemNotVisitedWithBitstreams);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/search/object?uri=http://localhost:8080/server/api/core/items/" + this.itemNotVisitedWithBitstreams.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/search/object?uri=http://localhost:8080/server/api/core/items/" + this.itemNotVisitedWithBitstreams.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void usagereportSearch_onlyAdminReadRights_unvalidToken() throws Exception {
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.itemNotVisitedWithBitstreams);
        this.getClient("unvalidToken").perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/search/object?uri=http://localhost:8080/server/api/core/items/" + this.itemNotVisitedWithBitstreams.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void usagereportSearch_loggedInUserReadRights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.itemNotVisitedWithBitstreams);
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withDspaceObject((DSpaceObject)this.itemNotVisitedWithBitstreams).withAction(0).build();
        EPerson eperson1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        String anotherLoggedInUserToken = this.getAuthToken(eperson1.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/search/object?uri=http://localhost:8080/server/api/core/items/" + this.itemNotVisitedWithBitstreams.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(this.loggedInToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/search/object?uri=http://localhost:8080/server/api/core/items/" + this.itemNotVisitedWithBitstreams.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(anotherLoggedInUserToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/search/object?uri=http://localhost:8080/server/api/core/items/" + this.itemNotVisitedWithBitstreams.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void usageReportsSearch_Site() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Site site = SiteBuilder.createSite((Context)this.context).build();
        Item itemVisited2 = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionNotVisited).build();
        this.context.restoreAuthSystemState();
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("item");
        viewEventRest.setTargetId(this.itemVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        ViewEventRest viewEventRest2 = new ViewEventRest();
        viewEventRest2.setTargetType("item");
        viewEventRest2.setTargetId(itemVisited2.getID());
        ObjectMapper mapper2 = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper2.writeValueAsBytes((Object)viewEventRest2)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper2.writeValueAsBytes((Object)viewEventRest2)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/search/object?uri=http://localhost:8080/server/api/core/sites/" + site.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.usagereports", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.usagereports", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{UsageReportMatcher.matchUsageReport(site.getID() + "_TotalVisits", "TotalVisits", List.of(this.getExpectedDsoViews((DSpaceObject)this.itemVisited, 1), this.getExpectedDsoViews((DSpaceObject)itemVisited2, 2)))})));
    }

    @Test
    public void usageReportsSearch_Community_Visited() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("community");
        viewEventRest.setTargetId(this.communityVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/search/object?uri=http://localhost:8080/server/api/core/communities/" + this.communityVisited.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.usagereports", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.usagereports", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{UsageReportMatcher.matchUsageReport(this.communityVisited.getID() + "_TotalVisits", "TotalVisits", List.of(this.getExpectedDsoViews((DSpaceObject)this.communityVisited, 1))), UsageReportMatcher.matchUsageReport(this.communityVisited.getID() + "_TotalVisitsPerMonth", "TotalVisitsPerMonth", this.getListOfVisitsPerMonthsPoints(1)), UsageReportMatcher.matchUsageReport(this.communityVisited.getID() + "_TopCities", "TopCities", List.of(this.getExpectedCityViews("New York", 1))), UsageReportMatcher.matchUsageReport(this.communityVisited.getID() + "_TopCountries", "TopCountries", List.of(this.getExpectedCountryViews("US", "United States", 1)))})));
    }

    @Test
    public void usageReportsSearch_Collection_NotVisited() throws Exception {
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/search/object?uri=http://localhost:8080/server/api/core/collections/" + this.collectionNotVisited.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.usagereports", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.usagereports", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{UsageReportMatcher.matchUsageReport(this.collectionNotVisited.getID() + "_TotalVisits", "TotalVisits", List.of(this.getExpectedDsoViews((DSpaceObject)this.collectionNotVisited, 0))), UsageReportMatcher.matchUsageReport(this.collectionNotVisited.getID() + "_TotalVisitsPerMonth", "TotalVisitsPerMonth", this.getListOfVisitsPerMonthsPoints(0)), UsageReportMatcher.matchUsageReport(this.collectionNotVisited.getID() + "_TopCities", "TopCities", List.of()), UsageReportMatcher.matchUsageReport(this.collectionNotVisited.getID() + "_TopCountries", "TopCountries", List.of())})));
    }

    @Test
    public void usageReportsSearch_Item_Visited_FileNotVisited() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("item");
        viewEventRest.setTargetId(this.itemVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/search/object?uri=http://localhost:8080/server/api/core/items/" + this.itemVisited.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.usagereports", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.usagereports", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TotalVisits", "TotalVisits", List.of(this.getExpectedDsoViews((DSpaceObject)this.itemVisited, 1))), UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TotalVisitsPerMonth", "TotalVisitsPerMonth", this.getListOfVisitsPerMonthsPoints(1)), UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TopCities", "TopCities", List.of(this.getExpectedCityViews("New York", 1))), UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TopCountries", "TopCountries", List.of(this.getExpectedCountryViews("US", "United States", 1))), UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TotalDownloads", "TotalDownloads", List.of())})));
    }

    @Test
    public void usageReportsSearch_ItemVisited_FilesVisited() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bitstream bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.itemVisited, (InputStream)IOUtils.toInputStream((String)"test", (String)CharEncoding.UTF_8)).withName("bitstream1").build();
        Bitstream bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.itemVisited, (InputStream)IOUtils.toInputStream((String)"test", (String)CharEncoding.UTF_8)).withName("bitstream2").build();
        this.context.restoreAuthSystemState();
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("item");
        viewEventRest.setTargetId(this.itemVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        ViewEventRest viewEventRestBit1 = new ViewEventRest();
        viewEventRestBit1.setTargetType("bitstream");
        viewEventRestBit1.setTargetId(bitstream1.getID());
        ViewEventRest viewEventRestBit2 = new ViewEventRest();
        viewEventRestBit2.setTargetType("bitstream");
        viewEventRestBit2.setTargetId(bitstream2.getID());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRestBit1)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRestBit2)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRestBit2)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/search/object?uri=http://localhost:8080/server/api/core/items/" + this.itemVisited.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.usagereports", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.usagereports", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TotalVisits", "TotalVisits", List.of(this.getExpectedDsoViews((DSpaceObject)this.itemVisited, 1))), UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TotalVisitsPerMonth", "TotalVisitsPerMonth", this.getListOfVisitsPerMonthsPoints(1)), UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TopCities", "TopCities", List.of(this.getExpectedCityViews("New York", 1))), UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TopCountries", "TopCountries", List.of(this.getExpectedCountryViews("US", "United States", 1))), UsageReportMatcher.matchUsageReport(this.itemVisited.getID() + "_TotalDownloads", "TotalDownloads", List.of(this.getExpectedDsoViews((DSpaceObject)bitstream1, 1), this.getExpectedDsoViews((DSpaceObject)bitstream2, 2)))})));
    }

    @Test
    public void usageReportsSearch_Bitstream_Visited() throws Exception {
        ViewEventRest viewEventRest = new ViewEventRest();
        viewEventRest.setTargetType("bitstream");
        viewEventRest.setTargetId(this.bitstreamVisited.getID());
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/viewevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)viewEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        List<UsageReportPointDsoTotalVisitsRest> expectedTotalVisits = List.of(this.getExpectedDsoViews((DSpaceObject)this.bitstreamVisited, 1));
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/usagereports/search/object?uri=http://localhost:8080/server/api/core/items/" + this.bitstreamVisited.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.usagereports", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.usagereports", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{UsageReportMatcher.matchUsageReport(this.bitstreamVisited.getID() + "_TotalVisits", "TotalVisits", expectedTotalVisits), UsageReportMatcher.matchUsageReport(this.bitstreamVisited.getID() + "_TotalVisitsPerMonth", "TotalVisitsPerMonth", this.getListOfVisitsPerMonthsPoints(1)), UsageReportMatcher.matchUsageReport(this.bitstreamVisited.getID() + "_TopCities", "TopCities", List.of(this.getExpectedCityViews("New York", 1))), UsageReportMatcher.matchUsageReport(this.bitstreamVisited.getID() + "_TopCountries", "TopCountries", List.of(this.getExpectedCountryViews("US", "United States", 1))), UsageReportMatcher.matchUsageReport(this.bitstreamVisited.getID() + "_TotalDownloads", "TotalDownloads", expectedTotalVisits)})));
    }

    private List<UsageReportPointRest> getListOfVisitsPerMonthsPoints(int viewsLastMonth) {
        ArrayList<UsageReportPointRest> expectedPoints = new ArrayList<UsageReportPointRest>();
        int nrOfMonthsBack = 6;
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i <= nrOfMonthsBack; ++i) {
            UsageReportPointDateRest expectedPoint = new UsageReportPointDateRest();
            if (i > 0) {
                expectedPoint.addValue("views", Integer.valueOf(0));
            } else {
                expectedPoint.addValue("views", Integer.valueOf(viewsLastMonth));
            }
            String month = cal.getDisplayName(2, 2, new Locale("en"));
            expectedPoint.setId(month + " " + cal.get(1));
            expectedPoints.add((UsageReportPointRest)expectedPoint);
            cal.add(2, -1);
        }
        return expectedPoints;
    }

    private UsageReportPointDsoTotalVisitsRest getExpectedDsoViews(DSpaceObject dso, int views) {
        UsageReportPointDsoTotalVisitsRest point = new UsageReportPointDsoTotalVisitsRest();
        point.addValue("views", Integer.valueOf(views));
        point.setType(StringUtils.lowerCase((String)Constants.typeText[dso.getType()]));
        point.setId(dso.getID().toString());
        point.setLabel(dso.getName());
        return point;
    }

    private UsageReportPointCountryRest getExpectedCountryViews(String id, String label, int views) {
        UsageReportPointCountryRest point = new UsageReportPointCountryRest();
        point.addValue("views", Integer.valueOf(views));
        point.setId(id);
        point.setLabel(label);
        return point;
    }

    private UsageReportPointCityRest getExpectedCityViews(String id, int views) {
        UsageReportPointCityRest point = new UsageReportPointCityRest();
        point.addValue("views", Integer.valueOf(views));
        point.setId(id);
        return point;
    }
}

