/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.app.rest.AbstractLiveImportIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.liveimportclient.service.LiveImportClientImpl;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.vufind.VuFindImportMetadataSourceServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class VuFindImportMetadataSourceServiceIT
extends AbstractLiveImportIntegrationTest {
    @Autowired
    private LiveImportClientImpl liveImportClientImpl;
    @Autowired
    private VuFindImportMetadataSourceServiceImpl vuFindService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void vuFindImportMetadataGetRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream vuFindRespIS = ((Object)((Object)this)).getClass().getResourceAsStream("vuFind-generic.json");){
            String vuFindResp = IOUtils.toString((InputStream)vuFindRespIS, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(vuFindResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            Collection recordsImported = this.vuFindService.getRecords("test query", 0, 2);
            Assert.assertEquals((long)2L, (long)recordsImported.size());
            this.matchRecords(new ArrayList<ImportRecord>(recordsImported), collection2match);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void vuFindImportMetadataGetRecordsCountTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream vuFindRespIS = ((Object)((Object)this)).getClass().getResourceAsStream("vuFind-generic.json");){
            String vuFindResp = IOUtils.toString((InputStream)vuFindRespIS, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(vuFindResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            int tot = this.vuFindService.getRecordsCount("test query");
            Assert.assertEquals((long)1994L, (long)tot);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void vuFindImportMetadataGetRecordByIdTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream vuFindByIdResp = ((Object)((Object)this)).getClass().getResourceAsStream("vuFind-by-id.json");){
            String vuFindResp = IOUtils.toString((InputStream)vuFindByIdResp, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(vuFindResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            collection2match.remove(1);
            ImportRecord recordImported = this.vuFindService.getRecord("653510");
            Assert.assertNotNull((Object)recordImported);
            List<ImportRecord> recordsImported = Arrays.asList(recordImported);
            this.matchRecords(new ArrayList<ImportRecord>(recordsImported), collection2match);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void vuFindImportMetadataFindMatchingRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        org.dspace.content.Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item testItem = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)col1).withTitle("test item").withIssueDate("2021").build();
        this.context.restoreAuthSystemState();
        this.vuFindService.findMatchingRecords(testItem);
    }

    private ArrayList<ImportRecord> getRecords() {
        ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
        ArrayList<MetadatumDTO> metadatums = new ArrayList<MetadatumDTO>();
        MetadatumDTO identifierOther = this.createMetadatumDTO("dc", "identifier", "other", "653510");
        MetadatumDTO language = this.createMetadatumDTO("dc", "language", "iso", "Italian");
        MetadatumDTO title = this.createMetadatumDTO("dc", "title", null, "La pianta marmorea di Roma antica: Forma urbis Romae /");
        MetadatumDTO subject = this.createMetadatumDTO("dc", "subject", null, "Rome (Italy)");
        MetadatumDTO subject2 = this.createMetadatumDTO("dc", "subject", null, "Maps");
        MetadatumDTO subject3 = this.createMetadatumDTO("dc", "subject", null, "Early works to 1800.");
        MetadatumDTO subject4 = this.createMetadatumDTO("dc", "subject", null, "Rome (Italy)");
        MetadatumDTO subject5 = this.createMetadatumDTO("dc", "subject", null, "Antiquities");
        MetadatumDTO subject6 = this.createMetadatumDTO("dc", "subject", null, "Maps.");
        MetadatumDTO identifier = this.createMetadatumDTO("dc", "identifier", null, "http://hdl.handle.net/20.500.12390/231");
        metadatums.add(identifierOther);
        metadatums.add(language);
        metadatums.add(title);
        metadatums.add(identifier);
        metadatums.add(subject);
        metadatums.add(subject2);
        metadatums.add(subject3);
        metadatums.add(subject4);
        metadatums.add(subject5);
        metadatums.add(subject6);
        ImportRecord firstrRecord = new ImportRecord(metadatums);
        ArrayList<MetadatumDTO> metadatums2 = new ArrayList<MetadatumDTO>();
        MetadatumDTO identifierOther2 = this.createMetadatumDTO("dc", "identifier", "other", "1665326");
        MetadatumDTO language2 = this.createMetadatumDTO("dc", "language", "iso", "English");
        MetadatumDTO title2 = this.createMetadatumDTO("dc", "title", null, "Expert frames : scientific and policy practices of Roma classification /");
        MetadatumDTO subject7 = this.createMetadatumDTO("dc", "subject", null, "Public opinion");
        MetadatumDTO subject8 = this.createMetadatumDTO("dc", "subject", null, "Europe.");
        MetadatumDTO subject9 = this.createMetadatumDTO("dc", "subject", null, "Stereotypes (Social psychology)");
        MetadatumDTO subject10 = this.createMetadatumDTO("dc", "subject", null, "Romanies");
        MetadatumDTO subject11 = this.createMetadatumDTO("dc", "subject", null, "Public opinion.");
        MetadatumDTO identifier2 = this.createMetadatumDTO("dc", "identifier", null, "http://ezproxy.villanova.edu/login?URL=http://www.jstor.org/stable/10.7829/j.ctt1ggjj08");
        metadatums2.add(identifierOther2);
        metadatums2.add(language2);
        metadatums2.add(title2);
        metadatums2.add(identifier2);
        metadatums2.add(subject7);
        metadatums2.add(subject8);
        metadatums2.add(subject9);
        metadatums2.add(subject10);
        metadatums2.add(subject11);
        ImportRecord secondRecord = new ImportRecord(metadatums2);
        records.add(firstrRecord);
        records.add(secondRecord);
        return records;
    }
}

