/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.converter.CommunityConverter;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.converter.SiteConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.GroupService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class AdministratorFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    GroupService groupService;
    @Autowired
    AuthorizeService authService;
    @Autowired
    CommunityService communityService;
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private CommunityConverter communityConverter;
    @Autowired
    private CollectionConverter collectionConverter;
    @Autowired
    private SiteConverter siteConverter;
    private SiteService siteService;
    private EPerson adminComA;
    private EPerson adminComB;
    private EPerson adminColA;
    private EPerson adminColB;
    private EPerson adminItemA;
    private EPerson adminItemB;
    private Community communityA;
    private Community subCommunityOfA;
    private Community communityB;
    private Collection collectionA;
    private Collection collectionB;
    private Item itemInCollectionA;
    private Item itemInCollectionB;
    private AuthorizationFeature administratorFeature;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.siteService = ContentServiceFactory.getInstance().getSiteService();
        this.administratorFeature = this.authorizationFeatureService.find("administratorOf");
        this.initAdminsAndObjects();
    }

    private void initAdminsAndObjects() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.adminComA = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminComA@example.com").withPassword(this.password).build();
        this.adminComB = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminComB@example.com").withPassword(this.password).build();
        this.adminColA = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminColA@example.com").withPassword(this.password).build();
        this.adminColB = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminColB@example.com").withPassword(this.password).build();
        this.adminItemA = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminItemA@example.com").withPassword(this.password).build();
        this.adminItemB = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminItemB@example.com").withPassword(this.password).build();
        this.communityA = CommunityBuilder.createCommunity((Context)this.context).withName("Community A").withAdminGroup(new EPerson[]{this.adminComA}).build();
        this.subCommunityOfA = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.communityA).withName("Sub Community of CommunityA").build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("Community B").withAdminGroup(new EPerson[]{this.adminComB}).build();
        this.collectionA = CollectionBuilder.createCollection((Context)this.context, (Community)this.subCommunityOfA).withName("Collection A").withAdminGroup(new EPerson[]{this.adminColA}).build();
        this.collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityB).withName("Collection B").withAdminGroup(new EPerson[]{this.adminColB}).build();
        this.itemInCollectionA = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionA).withTitle("Item in Collection A").withAdminUser(this.adminItemA).build();
        this.itemInCollectionB = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionB).withTitle("Item in Collection B").withAdminUser(this.adminItemB).build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void communityWithAdministratorFeatureTest() throws Exception {
        CommunityRest communityRestA = this.communityConverter.convert(this.communityA, DefaultProjection.DEFAULT);
        CommunityRest communityRestB = this.communityConverter.convert(this.communityB, DefaultProjection.DEFAULT);
        CommunityRest SubCommunityOfARest = this.communityConverter.convert(this.subCommunityOfA, DefaultProjection.DEFAULT);
        String tokenAdminComA = this.getAuthToken(this.adminComA.getEmail(), this.password);
        String tokenAdminComB = this.getAuthToken(this.adminComB.getEmail(), this.password);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        Authorization authAdminSiteComA = new Authorization(this.admin, this.administratorFeature, (BaseObjectRest)communityRestA);
        Authorization authAdminComAComA = new Authorization(this.adminComA, this.administratorFeature, (BaseObjectRest)communityRestA);
        Authorization authAdminComASubComA = new Authorization(this.adminComA, this.administratorFeature, (BaseObjectRest)SubCommunityOfARest);
        Authorization authAdminComBComB = new Authorization(this.adminComB, this.administratorFeature, (BaseObjectRest)communityRestB);
        Authorization authAdminComBComA = new Authorization(this.adminComB, this.administratorFeature, (BaseObjectRest)communityRestA);
        Authorization authAdminComBSubComA = new Authorization(this.adminComB, this.administratorFeature, (BaseObjectRest)SubCommunityOfARest);
        Authorization authAdminColAComA = new Authorization(this.adminColA, this.administratorFeature, (BaseObjectRest)communityRestA);
        Authorization authAdminItemAComA = new Authorization(this.adminItemA, this.administratorFeature, (BaseObjectRest)communityRestA);
        Authorization authEPersonComA = new Authorization(this.eperson, this.administratorFeature, (BaseObjectRest)communityRestA);
        Authorization authAnonymousComA = new Authorization(null, this.administratorFeature, (BaseObjectRest)communityRestA);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSiteComA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminSiteComA))));
        this.getClient(tokenAdminComA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminComAComA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminComAComA))));
        this.getClient(tokenAdminComA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminComASubComA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminComASubComA))));
        this.getClient(tokenAdminComB).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminComBComB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminComBComB))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminComBComA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminComBSubComA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminColAComA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminItemAComA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authEPersonComA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAnonymousComA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void collectionWithAdministratorFeatureTest() throws Exception {
        CollectionRest collectionRestA = this.collectionConverter.convert(this.collectionA, DefaultProjection.DEFAULT);
        CollectionRest collectionRestB = this.collectionConverter.convert(this.collectionB, DefaultProjection.DEFAULT);
        String tokenAdminColA = this.getAuthToken(this.adminColA.getEmail(), this.password);
        String tokenAdminColB = this.getAuthToken(this.adminColB.getEmail(), this.password);
        String tokenAdminComA = this.getAuthToken(this.adminComA.getEmail(), this.password);
        String tokenAdminComB = this.getAuthToken(this.adminComB.getEmail(), this.password);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        Authorization authAdminSiteColA = new Authorization(this.admin, this.administratorFeature, (BaseObjectRest)collectionRestA);
        Authorization authAdminComAColA = new Authorization(this.adminComA, this.administratorFeature, (BaseObjectRest)collectionRestA);
        Authorization authAdminColAColA = new Authorization(this.adminColA, this.administratorFeature, (BaseObjectRest)collectionRestA);
        Authorization authAdminSiteColB = new Authorization(this.admin, this.administratorFeature, (BaseObjectRest)collectionRestB);
        Authorization authAdminComBColB = new Authorization(this.adminComB, this.administratorFeature, (BaseObjectRest)collectionRestB);
        Authorization authAdminColBColB = new Authorization(this.adminColB, this.administratorFeature, (BaseObjectRest)collectionRestB);
        Authorization authAdminColBColA = new Authorization(this.adminColB, this.administratorFeature, (BaseObjectRest)collectionRestA);
        Authorization authAdminComBColA = new Authorization(this.adminComB, this.administratorFeature, (BaseObjectRest)collectionRestA);
        Authorization authAdminItemAColA = new Authorization(this.adminItemA, this.administratorFeature, (BaseObjectRest)collectionRestA);
        Authorization authEPersonColA = new Authorization(this.eperson, this.administratorFeature, (BaseObjectRest)collectionRestA);
        Authorization authAnonymousColA = new Authorization(null, this.administratorFeature, (BaseObjectRest)collectionRestA);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSiteColA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminSiteColA))));
        this.getClient(tokenAdminComA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminComAColA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminComAColA))));
        this.getClient(tokenAdminColA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminColAColA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminColAColA))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSiteColB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminSiteColB))));
        this.getClient(tokenAdminComB).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminComBColB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminComBColB))));
        this.getClient(tokenAdminColB).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminColBColB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminColBColB))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminColBColA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminComBColA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminItemAColA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authEPersonColA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAnonymousColA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void siteWithAdministratorFeatureTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        Authorization authAdminSite = new Authorization(this.admin, this.administratorFeature, (BaseObjectRest)siteRest);
        Authorization authAdminComASite = new Authorization(this.adminComA, this.administratorFeature, (BaseObjectRest)siteRest);
        Authorization authAdminColASite = new Authorization(this.adminColA, this.administratorFeature, (BaseObjectRest)siteRest);
        Authorization authAdminItemASite = new Authorization(this.adminItemA, this.administratorFeature, (BaseObjectRest)siteRest);
        Authorization authEPersonSite = new Authorization(this.eperson, this.administratorFeature, (BaseObjectRest)siteRest);
        Authorization authAnonymousSite = new Authorization(null, this.administratorFeature, (BaseObjectRest)siteRest);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminSite))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authEPersonSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminComASite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminColASite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminItemASite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authEPersonSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAnonymousSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void itemWithAdministratorFeatureTest() throws Exception {
        ItemRest itemRestA = this.itemConverter.convert(this.itemInCollectionA, DefaultProjection.DEFAULT);
        ItemRest itemRestB = this.itemConverter.convert(this.itemInCollectionB, DefaultProjection.DEFAULT);
        String tokenAdminItemA = this.getAuthToken(this.adminItemA.getEmail(), this.password);
        String tokenAdminItemB = this.getAuthToken(this.adminItemB.getEmail(), this.password);
        String tokenAdminColA = this.getAuthToken(this.adminColA.getEmail(), this.password);
        String tokenAdminColB = this.getAuthToken(this.adminColB.getEmail(), this.password);
        String tokenAdminComA = this.getAuthToken(this.adminComA.getEmail(), this.password);
        String tokenAdminComB = this.getAuthToken(this.adminComB.getEmail(), this.password);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        Authorization authAdminSiteItemA = new Authorization(this.admin, this.administratorFeature, (BaseObjectRest)itemRestA);
        Authorization authAdminComAItemA = new Authorization(this.adminComA, this.administratorFeature, (BaseObjectRest)itemRestA);
        Authorization authAdminColAItemA = new Authorization(this.adminColA, this.administratorFeature, (BaseObjectRest)itemRestA);
        Authorization authAdminItemAItemA = new Authorization(this.adminItemA, this.administratorFeature, (BaseObjectRest)itemRestA);
        Authorization authAdminSiteItemB = new Authorization(this.admin, this.administratorFeature, (BaseObjectRest)itemRestB);
        Authorization authAdminComBItemB = new Authorization(this.adminComB, this.administratorFeature, (BaseObjectRest)itemRestB);
        Authorization authAdminColBItemB = new Authorization(this.adminColB, this.administratorFeature, (BaseObjectRest)itemRestB);
        Authorization authAdminItemBItemB = new Authorization(this.adminItemB, this.administratorFeature, (BaseObjectRest)itemRestB);
        Authorization authAdminComBItemA = new Authorization(this.adminComB, this.administratorFeature, (BaseObjectRest)itemRestA);
        Authorization authAdminColBItemA = new Authorization(this.adminColB, this.administratorFeature, (BaseObjectRest)itemRestA);
        Authorization authAdminItemBItemA = new Authorization(this.adminItemB, this.administratorFeature, (BaseObjectRest)itemRestA);
        Authorization authEPersonItemA = new Authorization(this.eperson, this.administratorFeature, (BaseObjectRest)itemRestA);
        Authorization authAnonymousItemA = new Authorization(null, this.administratorFeature, (BaseObjectRest)itemRestA);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSiteItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminSiteItemA))));
        this.getClient(tokenAdminComA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminComAItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminComAItemA))));
        this.getClient(tokenAdminColA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminColAItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminColAItemA))));
        this.getClient(tokenAdminItemA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminItemAItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminItemAItemA))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSiteItemB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminSiteItemB))));
        this.getClient(tokenAdminComB).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminComBItemB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminComBItemB))));
        this.getClient(tokenAdminColB).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminColBItemB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminColBItemB))));
        this.getClient(tokenAdminItemB).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminItemBItemB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminItemBItemB))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminComBItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminColBItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminItemBItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authEPersonItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAnonymousItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

