/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CCLicenseFeatureRestIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private Utils utils;
    private AuthorizationFeature ccLicenseFeature;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ccLicenseFeature = this.authorizationFeatureService.find("cclicense");
    }

    @Test
    public void authorizedAsAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("A collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Item to withdraw").build();
        this.context.restoreAuthSystemState();
        ItemRest itemRest = this.itemConverter.convert(item, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        Authorization authAdminCCLicense = new Authorization(this.admin, this.ccLicenseFeature, (BaseObjectRest)itemRest);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminCCLicense.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminCCLicense))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.admin.getID().toString()}).param("feature", new String[]{this.ccLicenseFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminCCLicense)))));
    }

    @Test
    public void checkAuthorizationAsCommunityAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A community").withAdminGroup(new EPerson[]{this.eperson}).build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("A collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Item to withdraw").build();
        this.context.restoreAuthSystemState();
        ItemRest itemRest = this.itemConverter.convert(item, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        Authorization authAdminCCLicense = new Authorization(this.eperson, this.ccLicenseFeature, (BaseObjectRest)itemRest);
        String comAdminToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminCCLicense.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminCCLicense))));
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.ccLicenseFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminCCLicense)))));
        this.configurationService.setProperty("core.authorization.item-admin.cc-license", (Object)false);
        this.configurationService.setProperty("core.authorization.collection-admin.item-admin.cc-license", (Object)false);
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminCCLicense.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminCCLicense))));
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.ccLicenseFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminCCLicense)))));
        this.configurationService.setProperty("core.authorization.community-admin.item-admin.cc-license", (Object)false);
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminCCLicense.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.ccLicenseFeature.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void checkAuthorizationAsCollectionAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("A collection").withAdminGroup(new EPerson[]{this.eperson}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Item to withdraw").build();
        this.context.restoreAuthSystemState();
        ItemRest itemRest = this.itemConverter.convert(item, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        Authorization authAdminCCLicense = new Authorization(this.eperson, this.ccLicenseFeature, (BaseObjectRest)itemRest);
        String colAdminToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminCCLicense.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminCCLicense))));
        this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.ccLicenseFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminCCLicense)))));
        this.configurationService.setProperty("core.authorization.item-admin.cc-license", (Object)false);
        this.configurationService.setProperty("core.authorization.collection-admin.item-admin.cc-license", (Object)false);
        this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminCCLicense.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.ccLicenseFeature.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void checkAuthorizationAsItemAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("A collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Item to withdraw").build();
        ResourcePolicy resource = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(11).withDspaceObject((DSpaceObject)item).build();
        this.context.restoreAuthSystemState();
        ItemRest itemRest = this.itemConverter.convert(item, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        Authorization authAdminCCLicense = new Authorization(this.eperson, this.ccLicenseFeature, (BaseObjectRest)itemRest);
        String itemAdminToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(itemAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminCCLicense.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminCCLicense))));
        this.getClient(itemAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.ccLicenseFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminCCLicense)))));
        this.configurationService.setProperty("core.authorization.item-admin.cc-license", (Object)false);
        this.getClient(itemAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminCCLicense.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(itemAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.ccLicenseFeature.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void notAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)com).withName("A collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Item to withdraw").build();
        this.context.restoreAuthSystemState();
        ItemRest itemRest = this.itemConverter.convert(item, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        Authorization authEpersonCCLicense = new Authorization(this.eperson, this.ccLicenseFeature, (BaseObjectRest)itemRest);
        Authorization authAnonymousCCLicense = new Authorization(null, this.ccLicenseFeature, (BaseObjectRest)itemRest);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authEpersonCCLicense.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("eperson", new String[]{this.eperson.getID().toString()}).param("feature", new String[]{this.ccLicenseFeature.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAnonymousCCLicense.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("feature", new String[]{this.ccLicenseFeature.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }
}

