/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CanManageRelationshipsFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    private Item itemA;
    private Item itemB;
    private EPerson userA;
    private EPerson userB;
    private EPerson userColAadmin;
    private EPerson userColBadmin;
    private EPerson userComAdmin;
    private Community communityA;
    private Collection collectionA;
    private Collection collectionB;
    private AuthorizationFeature canManageRelationshipsFeature;
    final String feature = "canManageRelationships";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.canManageRelationshipsFeature = this.authorizationFeatureService.find("canManageRelationships");
        this.userA = EPersonBuilder.createEPerson((Context)this.context).withEmail("userEmail@test.com").withPassword(this.password).build();
        this.userB = EPersonBuilder.createEPerson((Context)this.context).withEmail("userB.email@test.com").withPassword(this.password).build();
        this.userColAadmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("userColAadmin@test.com").withPassword(this.password).build();
        this.userColBadmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("userColBadmin@test.com").withPassword(this.password).build();
        this.userComAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("userComAdmin@test.com").withPassword(this.password).build();
        this.communityA = CommunityBuilder.createCommunity((Context)this.context).withName("communityA").withAdminGroup(new EPerson[]{this.userComAdmin}).build();
        this.collectionA = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("Collection A").withAdminGroup(new EPerson[]{this.userColAadmin}).build();
        this.collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("Collection B").withAdminGroup(new EPerson[]{this.userColBadmin}).build();
        this.itemA = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionA).withTitle("Item A").build();
        this.itemB = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionB).withTitle("Item B").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void canManageRelationshipsFeatureTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.itemA, 1, this.userA);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.itemB, 1, this.userB);
        this.context.restoreAuthSystemState();
        ItemRest itemRestA = this.itemConverter.convert(this.itemA, DefaultProjection.DEFAULT);
        ItemRest itemRestB = this.itemConverter.convert(this.itemB, DefaultProjection.DEFAULT);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenComAdmin = this.getAuthToken(this.userComAdmin.getEmail(), this.password);
        String tokenColAadmin = this.getAuthToken(this.userColAadmin.getEmail(), this.password);
        String tokenColBadmin = this.getAuthToken(this.userColBadmin.getEmail(), this.password);
        String tokenAUser = this.getAuthToken(this.userA.getEmail(), this.password);
        String tokenBUser = this.getAuthToken(this.userB.getEmail(), this.password);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        Authorization admin2ItemA = new Authorization(this.admin, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestA);
        Authorization admin2ItemB = new Authorization(this.admin, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestB);
        Authorization comAdmin2ItemA = new Authorization(this.userComAdmin, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestA);
        Authorization comAdmin2ItemB = new Authorization(this.userComAdmin, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestB);
        Authorization colAadmin2ItemA = new Authorization(this.userColAadmin, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestA);
        Authorization colBadmin2ItemB = new Authorization(this.userColBadmin, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestB);
        Authorization userA2ItemA = new Authorization(this.userA, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestA);
        Authorization userB2ItemB = new Authorization(this.userB, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestB);
        Authorization userB2ItemA = new Authorization(this.userB, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestA);
        Authorization userA2ItemB = new Authorization(this.userA, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestB);
        Authorization eperson2ItemA = new Authorization(this.eperson, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestA);
        Authorization eperson2ItemB = new Authorization(this.eperson, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestB);
        Authorization anonymous2ItemA = new Authorization(null, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestA);
        Authorization anonymous2ItemB = new Authorization(null, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestB);
        Authorization colAadmin2ItemB = new Authorization(this.userColAadmin, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestB);
        Authorization colBadmin2ItemA = new Authorization(this.userColBadmin, this.canManageRelationshipsFeature, (BaseObjectRest)itemRestA);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + admin2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(admin2ItemA))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + admin2ItemB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(admin2ItemB))));
        this.getClient(tokenComAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + comAdmin2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(comAdmin2ItemA))));
        this.getClient(tokenComAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + comAdmin2ItemB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(comAdmin2ItemB))));
        this.getClient(tokenColAadmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + colAadmin2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(colAadmin2ItemA))));
        this.getClient(tokenColBadmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + colBadmin2ItemB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(colBadmin2ItemB))));
        this.getClient(tokenAUser).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + userA2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(userA2ItemA))));
        this.getClient(tokenBUser).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + userB2ItemB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(userB2ItemB))));
        this.getClient(tokenColAadmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + colAadmin2ItemB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenColBadmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + colBadmin2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenBUser).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + userB2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenAUser).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + userA2ItemB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + eperson2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + eperson2ItemB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + anonymous2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + anonymous2ItemB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

