/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import jakarta.servlet.http.HttpServletRequest;
import org.dspace.app.rest.converter.RootConverter;
import org.dspace.app.rest.model.RootRest;
import org.dspace.app.util.Util;
import org.dspace.services.ConfigurationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.mock.web.MockHttpServletRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class RootConverterTest {
    @InjectMocks
    private RootConverter rootConverter;
    @Mock
    private ConfigurationService configurationService;
    private MockHttpServletRequest request = new MockHttpServletRequest();
    private String serverURL = "https://dspace-rest/server";
    private String serverSSRURL = "http://internal-rest:8080/server";

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.configurationService.getProperty("dspace.ui.url")).thenReturn((Object)"dspaceurl");
        Mockito.when((Object)this.configurationService.getProperty("dspace.name")).thenReturn((Object)"dspacename");
        Mockito.when((Object)this.configurationService.getProperty("dspace.server.url")).thenReturn((Object)this.serverURL);
        Mockito.when((Object)this.configurationService.getProperty("dspace.server.ssr.url", this.serverURL)).thenReturn((Object)this.serverSSRURL);
    }

    @Test
    public void testReturnCorrectClass() throws Exception {
        Assert.assertEquals(this.rootConverter.convert((HttpServletRequest)this.request).getClass(), RootRest.class);
    }

    @Test
    public void testCorrectPropertiesSetFromConfigurationService() throws Exception {
        String restUrl = "/server/api";
        this.request.setScheme("https");
        this.request.setServerName("dspace-rest");
        this.request.setServerPort(443);
        this.request.setRequestURI(restUrl);
        RootRest rootRest = this.rootConverter.convert((HttpServletRequest)this.request);
        Assert.assertEquals((Object)"dspaceurl", (Object)rootRest.getDspaceUI());
        Assert.assertEquals((Object)"dspacename", (Object)rootRest.getDspaceName());
        Assert.assertEquals((Object)this.serverURL, (Object)rootRest.getDspaceServer());
        Assert.assertEquals((Object)("DSpace " + Util.getSourceVersion()), (Object)rootRest.getDspaceVersion());
    }

    @Test
    public void testReturnNotNull() throws Exception {
        Assert.assertNotNull((Object)this.rootConverter.convert((HttpServletRequest)this.request));
    }

    @Test
    public void testCorrectInternalUrlSetFromConfigurationService() throws Exception {
        String restUrl = "/server/api";
        this.request.setScheme("http");
        this.request.setServerName("internal-rest");
        this.request.setServerPort(8080);
        this.request.setRequestURI(restUrl);
        RootRest rootRest = this.rootConverter.convert((HttpServletRequest)this.request);
        Assert.assertEquals((Object)"dspaceurl", (Object)rootRest.getDspaceUI());
        Assert.assertEquals((Object)"dspacename", (Object)rootRest.getDspaceName());
        Assert.assertEquals((Object)this.serverSSRURL, (Object)rootRest.getDspaceServer());
        Assert.assertEquals((Object)("DSpace " + Util.getSourceVersion()), (Object)rootRest.getDspaceVersion());
    }
}

