/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.QAEvent;
import org.dspace.qaevent.service.dto.NotifyMessageDTO;
import org.dspace.qaevent.service.dto.OpenaireMessageDTO;
import org.dspace.qaevent.service.dto.QAMessageDTO;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsAnything;

public class QAEventMatcher {
    private QAEventMatcher() {
    }

    public static Matcher<? super Object> matchQAEventFullEntry(QAEvent event) {
        return Matchers.allOf(QAEventMatcher.matchQAEventEntry(event), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.topic.name", (Matcher)Matchers.is((Object)event.getTopic())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.target.id", (Matcher)Matchers.is((Object)event.getTarget())), (Matcher)(event.getRelated() != null ? JsonPathMatchers.hasJsonPath((String)"$._embedded.related.id", (Matcher)Matchers.is((Object)event.getRelated())) : JsonPathMatchers.hasJsonPath((String)"$._embedded.related", (Matcher)Matchers.is((Matcher)Matchers.emptyOrNullString()))));
    }

    public static Matcher<? super Object> matchQAEventEntry(QAEvent event) {
        try {
            JsonMapper jsonMapper = new JsonMapper();
            DecimalFormat decimalFormat = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.ENGLISH));
            return Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)event.getEventId())), JsonPathMatchers.hasJsonPath((String)"$.originalId", (Matcher)Matchers.is((Object)event.getOriginalId())), JsonPathMatchers.hasJsonPath((String)"$.title", (Matcher)Matchers.is((Object)event.getTitle())), JsonPathMatchers.hasJsonPath((String)"$.trust", (Matcher)Matchers.is((Object)decimalFormat.format(event.getTrust()))), JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.equalToIgnoringCase((String)event.getStatus())), JsonPathMatchers.hasJsonPath((String)"$.message", QAEventMatcher.matchMessage(event.getTopic(), (QAMessageDTO)jsonMapper.readValue(event.getMessage(), OpenaireMessageDTO.class))), JsonPathMatchers.hasJsonPath((String)"$._links.target.href", (Matcher)Matchers.endsWith((String)(event.getEventId() + "/target"))), JsonPathMatchers.hasJsonPath((String)"$._links.related.href", (Matcher)Matchers.endsWith((String)(event.getEventId() + "/related"))), JsonPathMatchers.hasJsonPath((String)"$._links.topic.href", (Matcher)Matchers.endsWith((String)(event.getEventId() + "/topic"))), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"qualityassuranceevent"))});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Matcher<? super Object> matchQAEventNotifyEntry(QAEvent event) {
        try {
            JsonMapper jsonMapper = new JsonMapper();
            DecimalFormat decimalFormat = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.ENGLISH));
            return Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)event.getEventId())), JsonPathMatchers.hasJsonPath((String)"$.originalId", (Matcher)Matchers.is((Object)event.getOriginalId())), JsonPathMatchers.hasJsonPath((String)"$.title", (Matcher)Matchers.is((Object)event.getTitle())), JsonPathMatchers.hasJsonPath((String)"$.trust", (Matcher)Matchers.is((Object)decimalFormat.format(event.getTrust()))), JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.equalToIgnoringCase((String)event.getStatus())), JsonPathMatchers.hasJsonPath((String)"$.message", QAEventMatcher.matchMessage(event.getTopic(), (QAMessageDTO)jsonMapper.readValue(event.getMessage(), NotifyMessageDTO.class))), JsonPathMatchers.hasJsonPath((String)"$._links.target.href", (Matcher)Matchers.endsWith((String)(event.getEventId() + "/target"))), JsonPathMatchers.hasJsonPath((String)"$._links.related.href", (Matcher)Matchers.endsWith((String)(event.getEventId() + "/related"))), JsonPathMatchers.hasJsonPath((String)"$._links.topic.href", (Matcher)Matchers.endsWith((String)(event.getEventId() + "/topic"))), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"qualityassuranceevent"))});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static Matcher<? super Object> matchMessage(String topic, QAMessageDTO message) {
        if (message instanceof OpenaireMessageDTO) {
            OpenaireMessageDTO oadto = (OpenaireMessageDTO)message;
            if (StringUtils.endsWith((CharSequence)topic, (CharSequence)"/ABSTRACT")) {
                return Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.abstract", (Matcher)Matchers.is((Object)oadto.getAbstracts()))});
            }
            if (StringUtils.endsWith((CharSequence)topic, (CharSequence)"/PID")) {
                return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)oadto.getValue())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)oadto.getType())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.pidHref", (Matcher)Matchers.is((Object)QAEventMatcher.calculateOpenairePidHref(oadto.getType(), oadto.getValue()))));
            }
            if (StringUtils.endsWith((CharSequence)topic, (CharSequence)"/PROJECT")) {
                return Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.openaireId", (Matcher)Matchers.is((Object)oadto.getOpenaireId())), JsonPathMatchers.hasJsonPath((String)"$.acronym", (Matcher)Matchers.is((Object)oadto.getAcronym())), JsonPathMatchers.hasJsonPath((String)"$.code", (Matcher)Matchers.is((Object)oadto.getCode())), JsonPathMatchers.hasJsonPath((String)"$.funder", (Matcher)Matchers.is((Object)oadto.getFunder())), JsonPathMatchers.hasJsonPath((String)"$.fundingProgram", (Matcher)Matchers.is((Object)oadto.getFundingProgram())), JsonPathMatchers.hasJsonPath((String)"$.jurisdiction", (Matcher)Matchers.is((Object)oadto.getJurisdiction())), JsonPathMatchers.hasJsonPath((String)"$.title", (Matcher)Matchers.is((Object)oadto.getTitle()))});
            }
        } else if (message instanceof NotifyMessageDTO) {
            NotifyMessageDTO notifyDTO = (NotifyMessageDTO)message;
            if (StringUtils.endsWith((CharSequence)topic, (CharSequence)"/REVIEW")) {
                return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.serviceName", (Matcher)Matchers.is((Object)notifyDTO.getServiceName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.serviceId", (Matcher)Matchers.is((Object)notifyDTO.getServiceId())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.href", (Matcher)Matchers.is((Object)notifyDTO.getHref())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.relationship", (Matcher)Matchers.is((Object)notifyDTO.getRelationship())));
            }
            if (StringUtils.endsWith((CharSequence)topic, (CharSequence)"/ENDORSEMENT")) {
                return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.serviceName", (Matcher)Matchers.is((Object)notifyDTO.getServiceName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.serviceId", (Matcher)Matchers.is((Object)notifyDTO.getServiceId())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.href", (Matcher)Matchers.is((Object)notifyDTO.getHref())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.relationship", (Matcher)Matchers.is((Object)notifyDTO.getRelationship())));
            }
        }
        return IsAnything.anything();
    }

    private static String calculateOpenairePidHref(String type, String value) {
        if (type == null) {
            return null;
        }
        String hrefPrefix = null;
        switch (type) {
            case "arxiv": {
                hrefPrefix = "https://arxiv.org/abs/";
                break;
            }
            case "handle": {
                hrefPrefix = "https://hdl.handle.net/";
                break;
            }
            case "urn": {
                hrefPrefix = "";
                break;
            }
            case "doi": {
                hrefPrefix = "https://doi.org/";
                break;
            }
            case "pmc": {
                hrefPrefix = "https://www.ncbi.nlm.nih.gov/pmc/articles/";
                break;
            }
            case "pmid": {
                hrefPrefix = "https://pubmed.ncbi.nlm.nih.gov/";
                break;
            }
            case "ncid": {
                hrefPrefix = "https://ci.nii.ac.jp/ncid/";
                break;
            }
        }
        return hrefPrefix != null ? hrefPrefix + value : null;
    }
}

