/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.converter.DSpaceRunnableParameterConverter;
import org.dspace.app.rest.matcher.ProcessMatcher;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ProcessBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.ProcessStatus;
import org.dspace.content.Site;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.curate.CurationClientOptions;
import org.dspace.eperson.EPerson;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.scripts.service.ScriptService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CurationScriptIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private DSpaceRunnableParameterConverter dSpaceRunnableParameterConverter;
    @Autowired
    private ScriptService scriptService;
    private static final String SCRIPTS_ENDPOINT = "/api/system/scripts";
    private static final String CURATE_SCRIPT_ENDPOINT = "/api/system/scripts/curate/processes";

    @Test
    public void curateScript_invalidTaskOption() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", publicItem1.getHandle()));
        parameters.add(new DSpaceCommandLineParameter("-t", "invalidTaskOption"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void curateScript_MissingHandle() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-t", (String)CurationClientOptions.getTaskOptions().get(0)));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void curateScript_invalidHandle() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", "invalidhandle"));
        parameters.add(new DSpaceCommandLineParameter("-t", (String)CurationClientOptions.getTaskOptions().get(0)));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void curateScript_MissingTaskOrTaskFile() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", publicItem1.getHandle()));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void curateScript_InvalidScope() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", "all"));
        parameters.add(new DSpaceCommandLineParameter("-s", "invalidScope"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void curateScript_InvalidTaskFile() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", "all"));
        parameters.add(new DSpaceCommandLineParameter("-T", "invalidTaskFile"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void curateScript_validRequest_Task() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", publicItem1.getHandle()));
        parameters.add(new DSpaceCommandLineParameter("-t", (String)CurationClientOptions.getTaskOptions().get(0)));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("curate", String.valueOf(this.admin.getID()), parameters, ProcessStatus.COMPLETED)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void curateScript_validRequest_TaskFile() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        File taskFile = new File(testProps.get("test.curateTaskFile").toString());
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-i", publicItem1.getHandle()));
        parameters.add(new DSpaceCommandLineParameter("-T", taskFile.getAbsolutePath()));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("curate", String.valueOf(this.admin.getID()), parameters, ProcessStatus.COMPLETED)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void curateScript_EPersonInParametersFails() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-e", this.eperson.getEmail()));
        parameters.add(new DSpaceCommandLineParameter("-i", publicItem1.getHandle()));
        parameters.add(new DSpaceCommandLineParameter("-t", (String)CurationClientOptions.getTaskOptions().get(0)));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        AtomicReference idRef = new AtomicReference();
        this.context.restoreAuthSystemState();
        try {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("curate", String.valueOf(this.admin.getID()), parameters, ProcessStatus.FAILED)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void securityCurateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson comAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("comAdmin@example.com").withPassword(this.password).build();
        EPerson colAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("colAdmin@example.com").withPassword(this.password).build();
        EPerson itemAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("itemAdmin@example.com").withPassword(this.password).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Community").withAdminGroup(new EPerson[]{comAdmin}).build();
        Community anotherCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Another Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").withAdminGroup(new EPerson[]{colAdmin}).build();
        Collection anotherCollection = CollectionBuilder.createCollection((Context)this.context, (Community)anotherCommunity).withName("AnotherCollection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withAdminUser(itemAdmin).withTitle("Test item to curate").build();
        Item anotherItem = ItemBuilder.createItem((Context)this.context, (Collection)anotherCollection).withTitle("Another Test item to curate").build();
        Site site = ContentServiceFactory.getInstance().getSiteService().findSite(this.context);
        this.context.restoreAuthSystemState();
        LinkedList<DSpaceCommandLineParameter> siteParameters = new LinkedList<DSpaceCommandLineParameter>();
        siteParameters.add(new DSpaceCommandLineParameter("-i", site.getHandle()));
        siteParameters.add(new DSpaceCommandLineParameter("-t", "noop"));
        LinkedList<DSpaceCommandLineParameter> comParameters = new LinkedList<DSpaceCommandLineParameter>();
        comParameters.add(new DSpaceCommandLineParameter("-i", community.getHandle()));
        comParameters.add(new DSpaceCommandLineParameter("-t", "noop"));
        LinkedList<DSpaceCommandLineParameter> anotherComParameters = new LinkedList<DSpaceCommandLineParameter>();
        anotherComParameters.add(new DSpaceCommandLineParameter("-i", anotherCommunity.getHandle()));
        anotherComParameters.add(new DSpaceCommandLineParameter("-t", "noop"));
        LinkedList<DSpaceCommandLineParameter> colParameters = new LinkedList<DSpaceCommandLineParameter>();
        colParameters.add(new DSpaceCommandLineParameter("-i", collection.getHandle()));
        colParameters.add(new DSpaceCommandLineParameter("-t", "noop"));
        LinkedList<DSpaceCommandLineParameter> anotherColParameters = new LinkedList<DSpaceCommandLineParameter>();
        anotherColParameters.add(new DSpaceCommandLineParameter("-i", anotherCollection.getHandle()));
        anotherColParameters.add(new DSpaceCommandLineParameter("-t", "noop"));
        LinkedList<DSpaceCommandLineParameter> itemParameters = new LinkedList<DSpaceCommandLineParameter>();
        itemParameters.add(new DSpaceCommandLineParameter("-i", item.getHandle()));
        itemParameters.add(new DSpaceCommandLineParameter("-t", "noop"));
        LinkedList<DSpaceCommandLineParameter> anotherItemParameters = new LinkedList<DSpaceCommandLineParameter>();
        anotherItemParameters.add(new DSpaceCommandLineParameter("-i", anotherItem.getHandle()));
        anotherItemParameters.add(new DSpaceCommandLineParameter("-t", "noop"));
        String comAdminToken = this.getAuthToken(comAdmin.getEmail(), this.password);
        String colAdminToken = this.getAuthToken(colAdmin.getEmail(), this.password);
        String itemAdminToken = this.getAuthToken(itemAdmin.getEmail(), this.password);
        List listCurateSite = siteParameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        List listCom = comParameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        List listAnotherCom = anotherComParameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        List listCol = colParameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        List listAnotherCol = anotherColParameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        List listItem = itemParameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        List listAnotherItem = anotherItemParameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        LinkedList<ProcessStatus> acceptableProcessStatuses = new LinkedList<ProcessStatus>();
        acceptableProcessStatuses.addAll(Arrays.asList(ProcessStatus.SCHEDULED, ProcessStatus.RUNNING, ProcessStatus.COMPLETED));
        AtomicReference idSiteRef = new AtomicReference();
        AtomicReference idComRef = new AtomicReference();
        AtomicReference idComColRef = new AtomicReference();
        AtomicReference idComItemRef = new AtomicReference();
        AtomicReference idColRef = new AtomicReference();
        AtomicReference idColItemRef = new AtomicReference();
        AtomicReference idItemRef = new AtomicReference();
        ScriptConfiguration curateScriptConfiguration = this.scriptService.getScriptConfiguration("curate");
        try {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listCurateSite)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("curate", String.valueOf(this.admin.getID()), siteParameters, acceptableProcessStatuses)))).andDo(result -> idSiteRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listCom)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("curate", String.valueOf(comAdmin.getID()), comParameters, acceptableProcessStatuses)))).andDo(result -> idComRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listCol)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("curate", String.valueOf(comAdmin.getID()), colParameters, acceptableProcessStatuses)))).andDo(result -> idComColRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listItem)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("curate", String.valueOf(comAdmin.getID()), itemParameters, acceptableProcessStatuses)))).andDo(result -> idComItemRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listCurateSite)})).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listAnotherCom)})).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listAnotherCol)})).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(comAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listAnotherItem)})).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listCol)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("curate", String.valueOf(colAdmin.getID()), colParameters, acceptableProcessStatuses)))).andDo(result -> idColRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listItem)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("curate", String.valueOf(colAdmin.getID()), itemParameters, acceptableProcessStatuses)))).andDo(result -> idColItemRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listCurateSite)})).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listCom)})).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listAnotherCol)})).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(colAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listAnotherItem)})).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(itemAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listItem)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("curate", String.valueOf(itemAdmin.getID()), itemParameters, acceptableProcessStatuses)))).andDo(result -> idItemRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            this.getClient(itemAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listCurateSite)})).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(itemAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listCom)})).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(itemAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listCol)})).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(itemAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/system/scripts/" + curateScriptConfiguration.getName() + "/processes"), (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(listAnotherItem)})).andExpect(MockMvcResultMatchers.status().isForbidden());
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idSiteRef.get()));
            ProcessBuilder.deleteProcess((Integer)((Integer)idComRef.get()));
            ProcessBuilder.deleteProcess((Integer)((Integer)idComColRef.get()));
            ProcessBuilder.deleteProcess((Integer)((Integer)idComItemRef.get()));
            ProcessBuilder.deleteProcess((Integer)((Integer)idColRef.get()));
            ProcessBuilder.deleteProcess((Integer)((Integer)idColItemRef.get()));
            ProcessBuilder.deleteProcess((Integer)((Integer)idItemRef.get()));
        }
    }

    @Test
    public void testURLRedirectCurateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withMetadata("dc", "identifier", "uri", "demo.dspace.org/home").withMetadata("dc", "description", null, "https://google.com").withMetadata("dc", "description", "uri", "https://demo7.dspace.org/handle/123456789/1").withMetadata("dc", "description", "uri", "https://www.atmire.com/broken-link").withSubject("ExtraEntry").build();
        String[] args = new String[]{"curate", "-t", "checklinks", "-i", publicItem1.getHandle()};
        TestDSpaceRunnableHandler handler = new TestDSpaceRunnableHandler();
        ScriptService scriptService = ScriptServiceFactory.getInstance().getScriptService();
        ScriptConfiguration scriptConfiguration = scriptService.getScriptConfiguration(args[0]);
        DSpaceRunnable script = null;
        if (scriptConfiguration != null) {
            script = scriptService.createDSpaceRunnableForScriptConfiguration(scriptConfiguration);
        }
        if (script != null) {
            script.initialize(args, (DSpaceRunnableHandler)handler, this.admin);
            script.run();
        }
        Assert.assertFalse((boolean)this.checkIfInfoTextLoggedByHandler(handler, "demo.dspace.org/home"));
        Assert.assertTrue((boolean)this.checkIfInfoTextLoggedByHandler(handler, "https://demo7.dspace.org/handle/123456789/1 = 200 - OK"));
        Assert.assertTrue((boolean)this.checkIfInfoTextLoggedByHandler(handler, "https://google.com = 200 - OK"));
        Assert.assertTrue((boolean)this.checkIfInfoTextLoggedByHandler(handler, "https://www.atmire.com/broken-link = 404 - FAILED"));
    }

    boolean checkIfInfoTextLoggedByHandler(TestDSpaceRunnableHandler handler, String text) {
        for (String message : handler.getInfoMessages()) {
            if (!StringUtils.containsIgnoreCase((CharSequence)message, (CharSequence)text)) continue;
            return true;
        }
        return false;
    }
}

