/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.google.client;

import java.util.List;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.google.client.GoogleAnalytics4ClientRequestBuilder;
import org.dspace.google.client.GoogleAnalyticsClientImpl;
import org.dspace.google.client.UniversalAnalyticsClientRequestBuilder;
import org.dspace.utils.DSpace;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class GoogleAnalyticsClientIT
extends AbstractIntegrationTestWithDatabase {
    @Test
    public void testConfiguredGoogleAnalyticsClients() {
        List clients = new DSpace().getServiceManager().getServicesByType(GoogleAnalyticsClientImpl.class);
        MatcherAssert.assertThat((Object)clients, (Matcher)Matchers.hasSize((int)2));
        GoogleAnalyticsClientImpl ga4Client = this.getClientByKeyPrefix(clients, "G-");
        MatcherAssert.assertThat((Object)ga4Client, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)ga4Client.getRequestBuilder(), (Matcher)Matchers.instanceOf(GoogleAnalytics4ClientRequestBuilder.class));
        MatcherAssert.assertThat((Object)ga4Client.isAnalyticsKeySupported("G-12345"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ga4Client.isAnalyticsKeySupported("UA-12345"), (Matcher)Matchers.is((Object)false));
        GoogleAnalyticsClientImpl uaClient = this.getClientByKeyPrefix(clients, "UA-");
        MatcherAssert.assertThat((Object)uaClient, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)uaClient.getRequestBuilder(), (Matcher)Matchers.instanceOf(UniversalAnalyticsClientRequestBuilder.class));
        MatcherAssert.assertThat((Object)uaClient.isAnalyticsKeySupported("G-12345"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)uaClient.isAnalyticsKeySupported("UA-12345"), (Matcher)Matchers.is((Object)true));
    }

    private GoogleAnalyticsClientImpl getClientByKeyPrefix(List<GoogleAnalyticsClientImpl> clients, String keyPrefix) {
        return clients.stream().filter(client -> keyPrefix.equals(client.getKeyPrefix())).findFirst().orElse(null);
    }
}

