/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.OrcidQueueRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.orcid.OrcidQueue;
import org.dspace.orcid.service.OrcidQueueService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="eperson.orcidqueues")
@ConditionalOnProperty(value={"orcid.synchronization-enabled"})
public class OrcidQueueRestRepository
extends DSpaceRestRepository<OrcidQueueRest, Integer> {
    @Autowired
    private OrcidQueueService orcidQueueService;

    @Override
    @PreAuthorize(value="hasPermission(#id, 'ORCID_QUEUE', 'READ')")
    public OrcidQueueRest findOne(Context context, Integer id) {
        OrcidQueue orcidQueue = null;
        try {
            orcidQueue = this.orcidQueueService.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (orcidQueue == null) {
            return null;
        }
        return (OrcidQueueRest)this.converter.toRest(orcidQueue, this.utils.obtainProjection());
    }

    @Override
    public Page<OrcidQueueRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'ORCID_QUEUE', 'DELETE')")
    protected void delete(Context context, Integer id) throws AuthorizeException {
        OrcidQueue orcidQueue = null;
        try {
            orcidQueue = this.orcidQueueService.find(context, id.intValue());
            if (orcidQueue == null) {
                throw new ResourceNotFoundException("eperson.orcidqueue with id: " + id + " not found");
            }
            this.orcidQueueService.deleteById(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to delete OrcidQueue with id = " + id, e);
        }
    }

    @SearchRestMethod(name="findByProfileItem")
    @PreAuthorize(value="hasPermission(#profileItemId, 'ORCID_QUEUE_SEARCH', 'READ')")
    public Page<OrcidQueueRest> findByProfileItemId(@Parameter(value="profileItemId", required=true) String profileItemId, Pageable pageable) {
        Context context = this.obtainContext();
        try {
            UUID id = UUID.fromString(profileItemId);
            List result = this.orcidQueueService.findByProfileItemId(context, id, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            long totalCount = this.orcidQueueService.countByProfileItemId(context, id);
            return this.converter.toRestPage(result, pageable, totalCount, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Class<OrcidQueueRest> getDomainClass() {
        return OrcidQueueRest.class;
    }
}

