/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Item;
import org.dspace.content.QAEvent;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.qaevent.service.QAEventService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="integration.qualityassuranceevents.related")
public class QAEventRelatedLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private QAEventService qaEventService;
    @Autowired
    private ItemService itemService;

    @PreAuthorize(value="hasPermission(#id, 'QUALITYASSURANCEEVENT', 'READ')")
    public ItemRest getRelated(@Nullable HttpServletRequest request, String id, @Nullable Pageable pageable, Projection projection) {
        Context context = this.obtainContext();
        QAEvent qaEvent = this.qaEventService.findEventByEventId(id);
        if (qaEvent == null) {
            throw new ResourceNotFoundException("No qa event with ID: " + id);
        }
        if (qaEvent.getRelated() == null) {
            return null;
        }
        UUID itemUuid = UUID.fromString(qaEvent.getRelated());
        try {
            Item item = (Item)this.itemService.find(context, itemUuid);
            if (item == null) {
                throw new ResourceNotFoundException("No related item found with id : " + id);
            }
            return (ItemRest)this.converter.toRest(item, projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

