/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.util.DateUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.jwt.JWTTokenHandler;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.springframework.stereotype.Component;

@Component
public class ShortLivedJWTTokenHandler
extends JWTTokenHandler {
    @Override
    protected boolean isValidToken(HttpServletRequest request, SignedJWT signedJWT, JWTClaimsSet jwtClaimsSet, EPerson ePerson) throws JOSEException {
        if (ePerson == null || StringUtils.isBlank((CharSequence)ePerson.getSessionSalt())) {
            return false;
        }
        MACVerifier verifier = new MACVerifier(this.buildSigningKey(ePerson));
        Date expirationTime = jwtClaimsSet.getExpirationTime();
        return signedJWT.verify((JWSVerifier)verifier) && expirationTime != null && DateUtils.isAfter((Date)expirationTime, (Date)new Date(), (long)0L);
    }

    @Override
    protected EPerson updateSessionSalt(Context context, Date previousLoginDate) {
        return context.getCurrentUser();
    }

    @Override
    protected String getTokenSecretConfigurationKey() {
        return "jwt.shortLived.token.secret";
    }

    @Override
    protected String getEncryptionSecretConfigurationKey() {
        return "jwt.shortLived.encryption.secret";
    }

    @Override
    protected String getTokenExpirationConfigurationKey() {
        return "jwt.shortLived.token.expiration";
    }

    @Override
    protected String getEncryptionEnabledConfigurationKey() {
        return "jwt.shortLived.encryption.enabled";
    }

    @Override
    protected String getCompressionEnabledConfigurationKey() {
        return "jwt.shortLived.compression.enabled";
    }
}

