/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.security.jwt.JWTClaimProvider;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpecialGroupClaimProvider
implements JWTClaimProvider {
    private static final Logger log = LogManager.getLogger();
    public static final String SPECIAL_GROUPS = "sg";
    @Autowired
    private AuthenticationService authenticationService;

    @Override
    public String getKey() {
        return SPECIAL_GROUPS;
    }

    @Override
    public Object getValue(Context context, HttpServletRequest request) {
        List groups = new ArrayList();
        try {
            groups = this.authenticationService.getSpecialGroups(context, request);
        }
        catch (SQLException e) {
            log.error("SQLException while retrieving special groups", (Throwable)e);
            return null;
        }
        List groupIds = groups.stream().map(group -> group.getID().toString()).collect(Collectors.toList());
        return groupIds;
    }

    @Override
    public void parseClaim(Context context, HttpServletRequest request, JWTClaimsSet jwtClaimsSet) {
        try {
            List groupIds = jwtClaimsSet.getStringListClaim(SPECIAL_GROUPS);
            for (String groupId : CollectionUtils.emptyIfNull((Collection)groupIds)) {
                context.setSpecialGroup(UUID.fromString(groupId));
            }
        }
        catch (ParseException e) {
            log.error("Error while trying to access specialgroups from ClaimSet", (Throwable)e);
        }
    }
}

