/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.processor.item;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.signposting.model.LinksetNode;
import org.dspace.app.rest.signposting.model.LinksetRelationType;
import org.dspace.app.rest.signposting.processor.item.ItemSignpostingProcessor;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.util.FrontendUrlService;

public class ItemDescribedbyProcessor
extends ItemSignpostingProcessor {
    private static final Logger log = LogManager.getLogger(ItemDescribedbyProcessor.class);
    private final ConfigurationService configurationService;

    public ItemDescribedbyProcessor(FrontendUrlService frontendUrlService, ConfigurationService configurationService) {
        super(frontendUrlService);
        this.configurationService = configurationService;
        this.setRelation(LinksetRelationType.DESCRIBED_BY);
    }

    @Override
    public void addLinkSetNodes(Context context, HttpServletRequest request, Item item, List<LinksetNode> linksetNodes) {
        try {
            String signpostingPath = this.configurationService.getProperty("signposting.path");
            String baseUrl = this.configurationService.getProperty("dspace.ui.url");
            String mimeType = this.configurationService.getProperty("signposting.describedby.mime-type");
            String profile = this.configurationService.getProperty("signposting.describedby.profile");
            String describedByUrl = baseUrl + "/" + signpostingPath + "/describedby/" + item.getID();
            LinksetNode node = profile != null ? new LinksetNode(describedByUrl, this.getRelation(), mimeType, profile, this.buildAnchor(context, item)) : new LinksetNode(describedByUrl, this.getRelation(), mimeType, this.buildAnchor(context, item));
            linksetNodes.add(node);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

