/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemimport;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.itemimport.ItemImport;
import org.dspace.app.rest.converter.DSpaceRunnableParameterConverter;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.matcher.ProcessMatcher;
import org.dspace.app.rest.matcher.RelationshipMatcher;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractEntityIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ProcessBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.ProcessStatus;
import org.dspace.content.Relationship;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.core.Context;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.Process;
import org.dspace.scripts.service.ProcessService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ItemImportIT
extends AbstractEntityIntegrationTest {
    private static final String publicationTitle = "A Tale of Two Cities";
    private static final String personTitle = "Person Test";
    @Autowired
    private ItemService itemService;
    @Autowired
    private RelationshipService relationshipService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private DSpaceRunnableParameterConverter dSpaceRunnableParameterConverter;
    @Autowired
    private ObjectMapper mapper;
    private Collection collection;
    private Path workDir;
    private static final String TEMP_DIR = ItemImport.TEMP_DIR;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").withEntityType("Publication").build();
        this.context.restoreAuthSystemState();
        File file = new File(this.configurationService.getProperty("org.dspace.app.batchitemimport.work.dir"));
        if (!file.exists()) {
            Files.createDirectory(Path.of(file.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        this.workDir = Path.of(file.getAbsolutePath(), new String[0]);
    }

    @After
    public void destroy() throws Exception {
        for (Path path : Files.list(this.workDir).collect(Collectors.toList())) {
            PathUtils.delete((Path)path);
        }
        super.destroy();
    }

    @Test
    public void importItemByZipSafWithBitstreams() throws Exception {
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-a", ""));
        parameters.add(new DSpaceCommandLineParameter("-c", this.collection.getID().toString()));
        parameters.add(new DSpaceCommandLineParameter("-z", "saf-bitstreams.zip"));
        MockMultipartFile bitstreamFile = new MockMultipartFile("file", "saf-bitstreams.zip", "application/octet-stream", ((Object)((Object)this)).getClass().getResourceAsStream("saf-bitstreams.zip"));
        this.perfomImportScript(parameters, bitstreamFile);
        this.checkMetadata();
        this.checkMetadataWithAnotherSchema();
        this.checkBitstream();
        File workTempDir = new File(this.workDir + File.separator + TEMP_DIR);
        Assert.assertTrue((boolean)workTempDir.exists());
    }

    @Test
    public void importItemByZipSafWithRelationships() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection collectionPerson = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection Person").withEntityType("Person").build();
        Item person = ItemBuilder.createItem((Context)this.context, (Collection)collectionPerson).withTitle(personTitle).build();
        this.context.restoreAuthSystemState();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-a", ""));
        parameters.add(new DSpaceCommandLineParameter("-p", ""));
        parameters.add(new DSpaceCommandLineParameter("-c", this.collection.getID().toString()));
        parameters.add(new DSpaceCommandLineParameter("-z", "saf-relationships.zip"));
        MockMultipartFile bitstreamFile = new MockMultipartFile("file", "saf-relationships.zip", "application/octet-stream", ((Object)((Object)this)).getClass().getResourceAsStream("saf-relationships.zip"));
        this.perfomImportScript(parameters, bitstreamFile);
        this.checkMetadata();
        this.checkRelationship();
    }

    private void checkMetadata() throws Exception {
        Item item = (Item)this.itemService.findByMetadataField(this.context, "dc", "title", null, publicationTitle).next();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.title", publicationTitle), MetadataMatcher.matchMetadata("dc.date.issued", "1990"), MetadataMatcher.matchMetadata("dc.title.alternative", "J'aime les Printemps"))));
    }

    private void checkMetadataWithAnotherSchema() throws Exception {
        Item item = (Item)this.itemService.findByMetadataField(this.context, "dc", "title", null, publicationTitle).next();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("dcterms.title", publicationTitle)})));
    }

    private void checkBitstream() throws Exception {
        Bitstream bitstream = (Bitstream)((Bundle)((Item)this.itemService.findByMetadataField(this.context, "dc", "title", null, publicationTitle).next()).getBundles("ORIGINAL").get(0)).getBitstreams().get(0);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataMatcher.matchMetadata("dc.title", "file1.txt")})));
    }

    private void checkRelationship() throws Exception {
        Item item = (Item)this.itemService.findByMetadataField(this.context, "dc", "title", null, publicationTitle).next();
        Item author = (Item)this.itemService.findByMetadataField(this.context, "dc", "title", null, personTitle).next();
        List relationships = this.relationshipService.findByItem(this.context, item);
        Assert.assertEquals((long)1L, (long)relationships.size());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + ((Relationship)relationships.get(0)).getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftPlace", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)author.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightPlace", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RelationshipMatcher.matchRelationship((Relationship)relationships.get(0)))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void perfomImportScript(LinkedList<DSpaceCommandLineParameter> parameters, MockMultipartFile bitstreamFile) throws Exception {
        Process process = null;
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        try {
            AtomicReference idRef = new AtomicReference();
            this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/api/system/scripts/import/processes", (Object[])new Object[0]).file(bitstreamFile).param("properties", new String[]{this.mapper.writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("import", String.valueOf(this.admin.getID()), parameters, ProcessStatus.COMPLETED)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            process = this.processService.find(this.context, ((Integer)idRef.get()).intValue());
            this.checkProcess(process);
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)process.getID());
        }
    }

    private void checkProcess(Process process) {
        Assert.assertNotNull((Object)process.getBitstreams());
        Assert.assertEquals((long)3L, (long)process.getBitstreams().size());
        Assert.assertEquals((long)1L, (long)process.getBitstreams().stream().filter(b -> StringUtils.equals((CharSequence)b.getName(), (CharSequence)ItemImport.MAPFILE_FILENAME)).count());
        Assert.assertEquals((long)1L, (long)process.getBitstreams().stream().filter(b -> StringUtils.contains((CharSequence)b.getName(), (CharSequence)".log")).count());
        Assert.assertEquals((long)1L, (long)process.getBitstreams().stream().filter(b -> StringUtils.contains((CharSequence)b.getName(), (CharSequence)".zip")).count());
    }
}

