/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.tools.ant.filters.StringInputStream;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.junit.Assert;
import org.mockito.Mockito;

public class AbstractLiveImportIntegrationTest
extends AbstractControllerIntegrationTest {
    protected void matchRecords(ArrayList<ImportRecord> recordsImported, ArrayList<ImportRecord> records2match) {
        Assert.assertEquals((long)records2match.size(), (long)recordsImported.size());
        for (int i = 0; i < recordsImported.size(); ++i) {
            ImportRecord imported = recordsImported.get(i);
            ImportRecord toMatch = records2match.get(i);
            this.checkMetadataValue(imported.getValueList(), toMatch.getValueList());
        }
    }

    private void checkMetadataValue(List<MetadatumDTO> list, List<MetadatumDTO> list2) {
        Assert.assertEquals((long)list.size(), (long)list2.size());
        for (int i = 0; i < list.size(); ++i) {
            Assert.assertTrue((boolean)this.sameMetadatum(list.get(i), list2.get(i)));
        }
    }

    private boolean sameMetadatum(MetadatumDTO metadatum, MetadatumDTO metadatum2) {
        return StringUtils.equals((CharSequence)metadatum.getSchema(), (CharSequence)metadatum2.getSchema()) && StringUtils.equals((CharSequence)metadatum.getElement(), (CharSequence)metadatum2.getElement()) && StringUtils.equals((CharSequence)metadatum.getQualifier(), (CharSequence)metadatum2.getQualifier()) && StringUtils.equals((CharSequence)metadatum.getValue(), (CharSequence)metadatum2.getValue());
    }

    protected MetadatumDTO createMetadatumDTO(String schema, String element, String qualifier, String value) {
        MetadatumDTO metadatumDTO = new MetadatumDTO();
        metadatumDTO.setSchema(schema);
        metadatumDTO.setElement(element);
        metadatumDTO.setQualifier(qualifier);
        metadatumDTO.setValue(value);
        return metadatumDTO;
    }

    protected CloseableHttpResponse mockResponse(String xmlExample, int statusCode, String reason) throws UnsupportedEncodingException {
        BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
        basicHttpEntity.setChunked(true);
        basicHttpEntity.setContent((InputStream)new StringInputStream(xmlExample));
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)this.statusLine(statusCode, reason));
        Mockito.when((Object)response.getEntity()).thenReturn((Object)basicHttpEntity);
        return response;
    }

    protected StatusLine statusLine(final int statusCode, final String reason) {
        return new StatusLine(){

            public ProtocolVersion getProtocolVersion() {
                return new ProtocolVersion("http", 1, 1);
            }

            public int getStatusCode() {
                return statusCode;
            }

            public String getReasonPhrase() {
                return reason;
            }
        };
    }
}

