/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.services.ConfigurationService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class AltchaCaptchaRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ConfigurationService configurationService;

    @Before
    public void setup() {
        this.configurationService.setProperty("captcha.provider", (Object)"altcha");
        this.configurationService.setProperty("altcha.hmac.key", (Object)"onetwothreesecret");
    }

    @After
    public void tearDown() {
        this.configurationService.setProperty("captcha.provider", (Object)"google");
    }

    @Test
    public void testGetAltchaChallengeAuthenticated() throws Exception {
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/captcha/challenge", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Content-Type", "application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.header().exists("Cache-Control")).andExpect(MockMvcResultMatchers.header().exists("Expires")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.algorithm", (Object[])new Object[0]).value((Object)"SHA-256")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.challenge", (Object[])new Object[0]).isString()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.salt", (Object[])new Object[0]).isString()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.signature", (Object[])new Object[0]).isString());
    }

    @Test
    public void testGetAltchaChallengeUnauthenticated() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/captcha/challenge", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Content-Type", "application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.algorithm", (Object[])new Object[0]).value((Object)"SHA-256")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.challenge", (Object[])new Object[0]).isString()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.salt", (Object[])new Object[0]).isString()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.signature", (Object[])new Object[0]).isString());
    }

    @Test
    public void testGetAltchaChallengeWithMissingHmacKey() throws Exception {
        this.configurationService.setProperty("altcha.hmac.key", null);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/captcha/challenge", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.configurationService.setProperty("altcha.hmac.key", (Object)"onetwothreesecret");
    }
}

