/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.converter.BitstreamFormatConverter;
import org.dspace.app.rest.matcher.BitstreamFormatMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.model.BitstreamFormatRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.BitstreamFormatBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class BitstreamFormatRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    BitstreamFormatService bitstreamFormatService;
    @Autowired
    private BitstreamFormatConverter bitstreamFormatConverter;
    @Autowired
    private ObjectMapper mapper;
    private final int DEFAULT_AMOUNT_FORMATS = 86;

    @Test
    public void findAllPaginationTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreamformats", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)"/api/core/bitstreamformats")));
    }

    @Test
    @Ignore
    public void unknownFormatRequiredByDefault() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreamformats", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)"/api/core/bitstreamformats"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bitstreamformats", (Matcher)Matchers.is(BitstreamFormatMatcher.matchBitstreamFormatMimeType("Unknown"))));
    }

    @Test
    @Ignore
    public void findAllMimeTypeCheck() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withMimeType("application/octet-stream").withDescription("Description").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreamformats", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bitstreamformats", (Matcher)Matchers.contains(BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription()))));
    }

    @Test
    public void findOne() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withMimeType("application/octet-stream").withDescription("Description").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription()))));
    }

    @Test
    public void findOneNonExistentIDInURL() throws Exception {
        String nonExistentBitstreamFormatID = "404404404";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreamformats/" + nonExistentBitstreamFormatID), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createAdminAccess() throws Exception {
        BitstreamFormatRest bitstreamFormatRest = this.createRandomMockBitstreamRest(false);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/bitstreamformats/", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andReturn();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)this.mapper.readValue(content, Map.class);
            String newlyCreatedBitstreamID = String.valueOf(map.get("id"));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreamformats/" + newlyCreatedBitstreamID), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BitstreamFormatMatcher.matchBitstreamFormat(Integer.parseInt(newlyCreatedBitstreamID), bitstreamFormatRest.getMimetype(), bitstreamFormatRest.getDescription(), bitstreamFormatRest.getShortDescription())))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        }
        finally {
            BitstreamFormatBuilder.deleteBitstreamFormat((int)((Integer)idRef.get()));
        }
    }

    @Test
    public void createNonValidSupportLevel() throws Exception {
        BitstreamFormatRest bitstreamFormatRest = this.createRandomMockBitstreamRest(false);
        bitstreamFormatRest.setSupportLevel("NONVALID SUPPORT LVL");
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/bitstreamformats/", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreamformats/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)86)));
    }

    @Test
    public void createNoAccess() throws Exception {
        BitstreamFormatRest bitstreamFormatRest = this.createRandomMockBitstreamRest(false);
        this.getClient(null).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/bitstreamformats/", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreamformats/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)86)));
    }

    @Test
    public void createNonAdminAccess() throws Exception {
        BitstreamFormatRest bitstreamFormatRest = this.createRandomMockBitstreamRest(false);
        this.context.turnOffAuthorisationSystem();
        EPerson user = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("first", "last").withEmail("testaze@gmail.com").withPassword(this.password).withLanguage(I18nUtil.getDefaultLocale().getLanguage()).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(user.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/bitstreamformats/", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreamformats/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)86)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createAlreadyExisting() throws Exception {
        BitstreamFormatRest bitstreamFormatRest = this.createRandomMockBitstreamRest(true);
        AtomicReference idRef = new AtomicReference();
        try {
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/bitstreamformats/", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/bitstreamformats/", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isInternalServerError());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/bitstreamformats/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)87)));
        }
        finally {
            BitstreamFormatBuilder.deleteBitstreamFormat((int)((Integer)idRef.get()));
        }
    }

    @Test
    public void updateAdminAccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withMimeType("application/octet-stream").withDescription("Description - updateAdminAccess").build();
        this.context.restoreAuthSystemState();
        BitstreamFormatRest bitstreamFormatRest = this.bitstreamFormatConverter.convert(bitstreamFormat, Projection.DEFAULT);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        bitstreamFormatRest.setShortDescription("Test short UPDATED");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormatRest.getMimetype(), bitstreamFormatRest.getDescription(), bitstreamFormatRest.getShortDescription()))));
    }

    @Test
    public void updateNonValidSupportLevel() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withMimeType("application/octet-stream").withDescription("Description - updateAdminAccess").withSupportLevel(2).build();
        this.context.restoreAuthSystemState();
        BitstreamFormatRest bitstreamFormatRest = this.bitstreamFormatConverter.convert(bitstreamFormat, Projection.DEFAULT);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        bitstreamFormatRest.setShortDescription("Test short UPDATED");
        bitstreamFormatRest.setSupportLevel("NONVALID SUPPORT LEVEL");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription(), bitstreamFormat.getShortDescription(), this.bitstreamFormatService.getSupportLevelText(bitstreamFormat)))));
    }

    @Test
    public void updateNonExistingIDInURLAndJSON() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withShortDescription("Test short").withMimeType("application/octet-stream").withDescription("Description - updateNonExistingIDInURLAndJSON").build();
        this.context.restoreAuthSystemState();
        int nonExistentBitstreamFormatID = 404404404;
        BitstreamFormatRest bitstreamFormatRest = this.bitstreamFormatConverter.convert(bitstreamFormat, Projection.DEFAULT);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        bitstreamFormatRest.setShortDescription("Test short UPDATED");
        bitstreamFormatRest.setId((Serializable)Integer.valueOf(nonExistentBitstreamFormatID));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreamformats/" + nonExistentBitstreamFormatID), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription(), bitstreamFormat.getShortDescription()))));
    }

    @Test
    public void updateNonExistingIDInJustURL() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withShortDescription("Test short").withMimeType("application/octet-stream").withDescription("Description - updateNonExistingIDInJustURL").build();
        this.context.restoreAuthSystemState();
        int nonExistentBitstreamFormatID = 404404404;
        BitstreamFormatRest bitstreamFormatRest = this.bitstreamFormatConverter.convert(bitstreamFormat, Projection.DEFAULT);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        bitstreamFormatRest.setShortDescription("Test short UPDATED");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreamformats/" + nonExistentBitstreamFormatID), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription(), bitstreamFormat.getShortDescription()))));
    }

    @Test
    public void updateNonExistingIDInJSONButValidInURL() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withShortDescription("Test short").withMimeType("application/octet-stream").withDescription("Description - updateNonExistingIDInJSONButValidInURL").build();
        this.context.restoreAuthSystemState();
        int nonExistentBitstreamFormatID = 404404404;
        BitstreamFormatRest bitstreamFormatRest = this.bitstreamFormatConverter.convert(bitstreamFormat, Projection.DEFAULT);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        bitstreamFormatRest.setShortDescription("Test short UPDATED");
        bitstreamFormatRest.setId((Serializable)Integer.valueOf(nonExistentBitstreamFormatID));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription(), bitstreamFormat.getShortDescription()))));
    }

    @Test
    public void updateNotMatchingIDsInJSONAndURL() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat1 = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withShortDescription("Test short").withMimeType("application/octet-stream").withDescription("Description - updateNotMatchingIDsInJSONAndURL 1").build();
        BitstreamFormat bitstreamFormat2 = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withMimeType("application/octet-stream").withDescription("Description - updateNotMatchingIDsInJSONAndURL 2").build();
        this.context.restoreAuthSystemState();
        BitstreamFormatRest bitstreamFormatRest = this.bitstreamFormatConverter.convert(bitstreamFormat1, Projection.DEFAULT);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        bitstreamFormatRest.setShortDescription("Test short UPDATED");
        bitstreamFormatRest.setId((Serializable)bitstreamFormat2.getID());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreamformats/" + bitstreamFormat1.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreamformats/" + bitstreamFormat1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat1.getID(), bitstreamFormat1.getMIMEType(), bitstreamFormat1.getDescription(), bitstreamFormat1.getShortDescription()))));
    }

    @Test
    public void updateNoAccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withShortDescription("Test short").withMimeType("application/octet-stream").withDescription("Description - updateNoAccess").build();
        this.context.restoreAuthSystemState();
        BitstreamFormatRest bitstreamFormatRest = this.bitstreamFormatConverter.convert(bitstreamFormat, Projection.DEFAULT);
        bitstreamFormatRest.setShortDescription("Test short UPDATED");
        this.getClient(null).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription(), bitstreamFormat.getShortDescription()))));
    }

    @Test
    public void updateNonAdminAccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withMimeType("application/octet-stream").withDescription("Description - updateNonAdminAccess").build();
        EPerson user = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("first", "last").withEmail("testaze@gmail.com").withPassword(this.password).withLanguage(I18nUtil.getDefaultLocale().getLanguage()).build();
        this.context.restoreAuthSystemState();
        BitstreamFormatRest bitstreamFormatRest = this.bitstreamFormatConverter.convert(bitstreamFormat, Projection.DEFAULT);
        String token = this.getAuthToken(user.getEmail(), this.password);
        bitstreamFormatRest.setShortDescription("Test short UPDATED");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)bitstreamFormatRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void deleteAdminAccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withMimeType("application/octet-stream").withDescription("Description - updateAdminAccess").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteNonExistingID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withMimeType("application/octet-stream").withDescription("Description - updateAdminAccess").build();
        this.context.restoreAuthSystemState();
        String nonExistentID = "404404404";
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bitstreamformats/" + nonExistentID), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteNoAccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withMimeType("application/octet-stream").withDescription("Description - updateAdminAccess").build();
        this.context.restoreAuthSystemState();
        this.getClient(null).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription(), bitstreamFormat.getShortDescription()))));
    }

    @Test
    public void deleteNonAdminAccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        BitstreamFormat bitstreamFormat = BitstreamFormatBuilder.createBitstreamFormat((Context)this.context).withMimeType("application/octet-stream").withDescription("Description - updateAdminAccess").build();
        EPerson user = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("first", "last").withEmail("testaze@gmail.com").withPassword(this.password).withLanguage(I18nUtil.getDefaultLocale().getLanguage()).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(user.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreamformats/" + bitstreamFormat.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BitstreamFormatMatcher.matchBitstreamFormat(bitstreamFormat.getID(), bitstreamFormat.getMIMEType(), bitstreamFormat.getDescription(), bitstreamFormat.getShortDescription()))));
    }

    private BitstreamFormatRest createRandomMockBitstreamRest(boolean withRand) {
        BitstreamFormatRest bitstreamFormatRest = new BitstreamFormatRest();
        String random = null;
        if (withRand) {
            Random rand = new Random();
            random = String.valueOf(rand.nextInt(100) + 1);
        }
        bitstreamFormatRest.setShortDescription("Test short" + random);
        bitstreamFormatRest.setDescription("Full description of Test short");
        bitstreamFormatRest.setMimetype("text/plain");
        bitstreamFormatRest.setSupportLevel("KNOWN");
        bitstreamFormatRest.setInternal(false);
        bitstreamFormatRest.setExtensions(Arrays.asList("txt", "asc"));
        return bitstreamFormatRest;
    }
}

