/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.time.Period;
import org.dspace.app.rest.matcher.BrowseEntryResourceMatcher;
import org.dspace.app.rest.matcher.BrowseIndexMatcher;
import org.dspace.app.rest.matcher.ItemMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class BrowsesResourceControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    MetadataAuthorityService metadataAuthorityService;

    @Test
    public void findAll() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.browses", (Matcher)Matchers.hasSize((int)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.browses", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{BrowseIndexMatcher.dateIssuedBrowseIndex("asc"), BrowseIndexMatcher.contributorBrowseIndex("asc"), BrowseIndexMatcher.titleBrowseIndex("asc"), BrowseIndexMatcher.subjectBrowseIndex("asc"), BrowseIndexMatcher.hierarchicalBrowseIndex("srsc")})));
    }

    @Test
    public void findBrowseByTitle() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/title", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BrowseIndexMatcher.titleBrowseIndex("asc")));
    }

    @Test
    public void findBrowseByDateIssued() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/dateissued", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BrowseIndexMatcher.dateIssuedBrowseIndex("asc")));
    }

    @Test
    public void findBrowseByContributor() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/author", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BrowseIndexMatcher.contributorBrowseIndex("asc")));
    }

    @Test
    public void findBrowseByVocabulary() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/srsc", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BrowseIndexMatcher.hierarchicalBrowseIndex("srsc")));
    }

    @Test
    public void findBrowseBySubject() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BrowseIndexMatcher.subjectBrowseIndex("asc")));
    }

    @Test
    public void findBrowseBySubjectEntries() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item withdrawnItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn item 1").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").withSubject("WithdrawnEntry").withdrawn().build();
        Item privateItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private item 1").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").withSubject("PrivateEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/entries", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains((Matcher[])new Matcher[]{BrowseEntryResourceMatcher.matchBrowseEntry("AnotherTest", 1), BrowseEntryResourceMatcher.matchBrowseEntry("ExtraEntry", 3), BrowseEntryResourceMatcher.matchBrowseEntry("TestingForMore", 2)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/entries", (Object[])new Object[0]).param("sort", new String[]{"value,desc"})).andExpect(MockMvcResultMatchers.status().isOk()).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains((Matcher[])new Matcher[]{BrowseEntryResourceMatcher.matchBrowseEntry("TestingForMore", 2), BrowseEntryResourceMatcher.matchBrowseEntry("ExtraEntry", 3), BrowseEntryResourceMatcher.matchBrowseEntry("AnotherTest", 1)})));
    }

    @Test
    public void findBrowseBySubjectEntriesWithAuthority() throws Exception {
        this.configurationService.setProperty("choices.plugin.dc.subject", (Object)"SolrSubjectAuthority");
        this.configurationService.setProperty("authority.controlled.dc.subject", (Object)"true");
        this.metadataAuthorityService.clearCache();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("History of religion", "VR110102", 600).build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("Church studies", "VR110103", 600).withSubject("History of religion", "VR110102", 600).build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("Missionary studies", "VR110104", 600).withSubject("Church studies", "VR110103", 600).withSubject("History of religion", "VR110102", 600).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/entries", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains((Matcher[])new Matcher[]{BrowseEntryResourceMatcher.matchBrowseEntry("Church studies", "VR110103", 2), BrowseEntryResourceMatcher.matchBrowseEntry("History of religion", "VR110102", 3), BrowseEntryResourceMatcher.matchBrowseEntry("Missionary studies", "VR110104", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/entries", (Object[])new Object[0]).param("sort", new String[]{"value,desc"})).andExpect(MockMvcResultMatchers.status().isOk()).andDo(MockMvcResultHandlers.print()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains((Matcher[])new Matcher[]{BrowseEntryResourceMatcher.matchBrowseEntry("Missionary studies", "VR110104", 1), BrowseEntryResourceMatcher.matchBrowseEntry("History of religion", "VR110102", 3), BrowseEntryResourceMatcher.matchBrowseEntry("Church studies", "VR110103", 2)})));
        DSpaceServicesFactory.getInstance().getConfigurationService().reloadConfig();
        this.metadataAuthorityService.clearCache();
    }

    @Test
    public void findBrowseBySubjectItems() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("zPublic item more").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withSubject("AnotherTest").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 3").withIssueDate("2016-02-14").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").build();
        Item withdrawnItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn item 1").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").withSubject("WithdrawnEntry").withdrawn().build();
        Item privateItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private item 1").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").withSubject("PrivateEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/items", (Object[])new Object[0]).param("filterValue", new String[]{"ExtraEntry"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains(ItemMatcher.matchItemWithTitleAndDateIssued(publicItem1, "zPublic item more", "2017-10-17"))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/items", (Object[])new Object[0]).param("filterValue", new String[]{"AnotherTest"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(publicItem2, "Public item 2", "2016-02-13"), ItemMatcher.matchItemWithTitleAndDateIssued(publicItem3, "Public item 3", "2016-02-14"), ItemMatcher.matchItemWithTitleAndDateIssued(publicItem1, "zPublic item more", "2017-10-17")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/items", (Object[])new Object[0]).param("filterValue", new String[]{"PrivateEntry"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/items", (Object[])new Object[0]).param("filterValue", new String[]{"WithdrawnEntry"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20)));
    }

    @Test
    public void findBrowseBySubjectItemsWithScope() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("zPublic item more").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withSubject("AnotherTest").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 3").withIssueDate("2016-02-14").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").build();
        Item withdrawnItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn item 1").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").withSubject("WithdrawnEntry").withdrawn().build();
        Item privateItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private item 1").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").withSubject("PrivateEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/items", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(col2.getID())}).param("filterValue", new String[]{"ExtraEntry"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/items", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(col2.getID())}).param("filterValue", new String[]{"AnotherTest"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(publicItem2, "Public item 2", "2016-02-13"), ItemMatcher.matchItemWithTitleAndDateIssued(publicItem3, "Public item 3", "2016-02-14")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/items", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(col2.getID())}).param("filterValue", new String[]{"PrivateEntry"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/items", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(col2.getID())}).param("filterValue", new String[]{"WithdrawnEntry"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20)));
    }

    @Test
    public void findBrowseBySubjectItemsWithScopeAsAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("zPublic item more").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withSubject("AnotherTest").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 3").withIssueDate("2016-02-14").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").build();
        Item withdrawnItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn item 1").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").withSubject("WithdrawnEntry").withdrawn().build();
        Item privateItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private item 1").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").withSubject("PrivateEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/items", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(col2.getID())}).param("filterValue", new String[]{"ExtraEntry"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/items", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(col2.getID())}).param("filterValue", new String[]{"AnotherTest"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(publicItem2, "Public item 2", "2016-02-13"), ItemMatcher.matchItemWithTitleAndDateIssued(publicItem3, "Public item 3", "2016-02-14")})));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/items", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(col2.getID())}).param("filterValue", new String[]{"PrivateEntry"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/items", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(col2.getID())}).param("filterValue", new String[]{"WithdrawnEntry"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20)));
    }

    @Test
    public void findBrowseByTitleItems() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("Java").withSubject("Unit Testing").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("Angular").withSubject("Unit Testing").build();
        Item privateItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("This is a private item").withIssueDate("2015-03-12").withAuthor("Duck, Donald").withSubject("Cartoons").withSubject("Ducks").makeUnDiscoverable().build();
        Item embargoedItem = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("An embargoed publication").withIssueDate("2017-08-10").withAuthor("Mouse, Mickey").withSubject("Cartoons").withSubject("Mice").withEmbargoPeriod(Period.ofMonths(12)).build();
        Group internalGroup = GroupBuilder.createGroup((Context)this.context).withName("Internal Group").build();
        Item internalItem = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Internal publication").withIssueDate("2016-09-19").withAuthor("Doe, John").withSubject("Unknown").withReaderGroup(internalGroup).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/title/items", (Object[])new Object[0]).param("sort", new String[]{"title,desc"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(publicItem2, "Public item 2", "2016-02-13"), ItemMatcher.matchItemWithTitleAndDateIssued(publicItem1, "Public item 1", "2017-10-17")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items[*].metadata", (Matcher)Matchers.allOf((Matcher)Matchers.not(MetadataMatcher.matchMetadata("dc.title", "This is a private item")), (Matcher)Matchers.not(MetadataMatcher.matchMetadata("dc.title", "Internal publication")))));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/title/items", (Object[])new Object[0]).param("sort", new String[]{"title,desc"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(publicItem2, "Public item 2", "2016-02-13"), ItemMatcher.matchItemWithTitleAndDateIssued(publicItem1, "Public item 1", "2017-10-17"), ItemMatcher.matchItemWithTitleAndDateIssued(internalItem, "Internal publication", "2016-09-19"), ItemMatcher.matchItemWithTitleAndDateIssued(embargoedItem, "An embargoed publication", "2017-08-10")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items[*].metadata", (Matcher)Matchers.allOf((Matcher)Matchers.not(MetadataMatcher.matchMetadata("dc.title", "This is a private item")), (Matcher)Matchers.not(MetadataMatcher.matchMetadata("dc.title", "Internal publication")))));
    }

    @Test
    public void findBrowseByTitleItemsWithScope() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("Java").withSubject("Unit Testing").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("Angular").withSubject("Unit Testing").build();
        Item privateItem = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("This is a private item").withIssueDate("2015-03-12").withAuthor("Duck, Donald").withSubject("Cartoons").withSubject("Ducks").makeUnDiscoverable().build();
        Item embargoedItem = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("An embargoed publication").withIssueDate("2017-08-10").withAuthor("Mouse, Mickey").withSubject("Cartoons").withSubject("Mice").withEmbargoPeriod(Period.ofMonths(12)).build();
        Group internalGroup = GroupBuilder.createGroup((Context)this.context).withName("Internal Group").build();
        Item internalItem = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Internal publication").withIssueDate("2016-09-19").withAuthor("Doe, John").withSubject("Unknown").withReaderGroup(internalGroup).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/title/items", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(col2.getID())}).param("sort", new String[]{"title,desc"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains(ItemMatcher.matchItemWithTitleAndDateIssued(publicItem2, "Public item 2", "2016-02-13")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items[*].metadata", (Matcher)Matchers.allOf((Matcher)Matchers.not(MetadataMatcher.matchMetadata("dc.title", "This is a private item")), (Matcher)Matchers.not(MetadataMatcher.matchMetadata("dc.title", "Internal publication")))));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/title/items", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(col2.getID())}).param("sort", new String[]{"title,desc"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(publicItem2, "Public item 2", "2016-02-13"), ItemMatcher.matchItemWithTitleAndDateIssued(internalItem, "Internal publication", "2016-09-19"), ItemMatcher.matchItemWithTitleAndDateIssued(embargoedItem, "An embargoed publication", "2017-08-10")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items[*].metadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.not(MetadataMatcher.matchMetadata("dc.title", "This is a private item"))})));
    }

    @Test
    public void browsePaginationWithoutExplicitParams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        for (int i = 0; i <= 20; ++i) {
            ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item " + String.format("%02d", i)).withIssueDate("2017-10-17").withAuthor("Test, Author" + String.format("%02d", i)).withSubject("Java").withSubject("Unit Testing").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/title/items", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)21))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"/api/discover/browses/title/items?"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.containsString((String)"/api/discover/browses/title/items?"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)"/api/discover/browses/title/items")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/author/entries", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)21))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"/api/discover/browses/author/entries?"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.containsString((String)"/api/discover/browses/author/entries?"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)"/api/discover/browses/author/entries")));
    }

    @Test
    public void testPaginationBrowseByDateIssuedItems() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Item 1").withIssueDate("2017-10-17").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Item 2").withIssueDate("2016-02-13").build();
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Item 3").withIssueDate("2016-02-12").build();
        Item item4 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Item 4").withIssueDate("2016-02-11").build();
        Item item5 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Item 5").withIssueDate("2016-02-10").build();
        Item item6 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Item 6").withIssueDate("2016-01-13").build();
        Item item7 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Item 7").withIssueDate("2016-01-12").build();
        Item withdrawnItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn item 1").withIssueDate("2016-02-13").withdrawn().build();
        Item privateItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private item 1").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/dateissued/items", (Object[])new Object[0]).param("sort", new String[]{"title,asc"}).param("size", new String[]{"5"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)7))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(item1, "Item 1", "2017-10-17"), ItemMatcher.matchItemWithTitleAndDateIssued(item2, "Item 2", "2016-02-13"), ItemMatcher.matchItemWithTitleAndDateIssued(item3, "Item 3", "2016-02-12"), ItemMatcher.matchItemWithTitleAndDateIssued(item4, "Item 4", "2016-02-11"), ItemMatcher.matchItemWithTitleAndDateIssued(item5, "Item 5", "2016-02-10")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/dateissued/items", (Object[])new Object[0]).param("sort", new String[]{"title,asc"}).param("size", new String[]{"5"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)7))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(item6, "Item 6", "2016-01-13"), ItemMatcher.matchItemWithTitleAndDateIssued(item7, "Item 7", "2016-01-12")})));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/dateissued/items", (Object[])new Object[0]).param("sort", new String[]{"title,asc"}).param("size", new String[]{"5"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)7))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(item6, "Item 6", "2016-01-13"), ItemMatcher.matchItemWithTitleAndDateIssued(item7, "Item 7", "2016-01-12")})));
    }

    @Test
    public void testPaginationBrowseByDateIssuedItemsWithScope() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Item 1").withIssueDate("2017-10-17").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Item 2").withIssueDate("2016-02-13").build();
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Item 3").withIssueDate("2016-02-12").build();
        Item item4 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Item 4").withIssueDate("2016-02-11").build();
        Item item5 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Item 5").withIssueDate("2016-02-10").build();
        Item item6 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Item 6").withIssueDate("2016-01-13").build();
        Item item7 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Item 7").withIssueDate("2016-01-12").build();
        Item withdrawnItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn item 1").withIssueDate("2016-02-13").withdrawn().build();
        Item privateItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private item 1").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/dateissued/items", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(col2.getID())}).param("sort", new String[]{"title,asc"}).param("size", new String[]{"5"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(item2, "Item 2", "2016-02-13"), ItemMatcher.matchItemWithTitleAndDateIssued(item4, "Item 4", "2016-02-11"), ItemMatcher.matchItemWithTitleAndDateIssued(item6, "Item 6", "2016-01-13")})));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/dateissued/items", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(col2.getID())}).param("sort", new String[]{"title,asc"}).param("size", new String[]{"5"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(item2, "Item 2", "2016-02-13"), ItemMatcher.matchItemWithTitleAndDateIssued(item4, "Item 4", "2016-02-11"), ItemMatcher.matchItemWithTitleAndDateIssued(item6, "Item 6", "2016-01-13")})));
    }

    @Test
    public void testBrowseByEntriesStartsWith() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Alan Turing").withAuthor("Turing, Alan Mathison").withIssueDate("1912-06-23").withSubject("Computing").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Blade Runner").withAuthor("Scott, Ridley").withIssueDate("1982-06-25").withSubject("Science Fiction").build();
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Python").withAuthor("Van Rossum, Guido").withIssueDate("1990").withSubject("Computing").build();
        Item item4 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Java").withAuthor("Gosling, James").withIssueDate("1995-05-23").withSubject("Computing").build();
        Item item5 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Zeta Reticuli").withAuthor("Universe").withIssueDate("2018-01-01").withSubject("Astronomy").build();
        Item item6 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Moon").withAuthor("Universe").withIssueDate("2018-01-02").withSubject("Astronomy").build();
        Item item7 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("T-800").withAuthor("Cameron, James").withIssueDate("2029").withSubject("Science Fiction").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/author/entries?startsWith=U", (Object[])new Object[0]).param("size", new String[]{"2"}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains(BrowseEntryResourceMatcher.matchBrowseEntry("Universe", 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"?startsWith=U")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/author/entries?startsWith=T", (Object[])new Object[0]).param("scope", new String[]{col1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains(BrowseEntryResourceMatcher.matchBrowseEntry("Turing, Alan Mathison", 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"?startsWith=T")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/entries?startsWith=C", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains(BrowseEntryResourceMatcher.matchBrowseEntry("Computing", 3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"?startsWith=C")));
    }

    @Test
    public void testBrowseByEntriesStartsWithAndDiacritics() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Item1").withAuthor("\u00c1lvarez, Nombre").withIssueDate("1912-06-23").withSubject("Tel\u00e9fono").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Item2").withAuthor("\u00d6gren, Name").withIssueDate("1982-06-25").withSubject("Televisor").build();
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Item3").withAuthor("Azuaga, Nombre").withIssueDate("1990").withSubject("Telecomunicaciones").build();
        Item item4 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Item4").withAuthor("Alonso, Nombre").withAuthor("Ortiz, Nombre").withIssueDate("1995-05-23").withSubject("Guion").build();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/author/entries?startsWith=A", (Object[])new Object[0]).param("size", new String[]{"4"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains((Matcher[])new Matcher[]{BrowseEntryResourceMatcher.matchBrowseEntry("Alonso, Nombre", 1), BrowseEntryResourceMatcher.matchBrowseEntry("\u00c1lvarez, Nombre", 1), BrowseEntryResourceMatcher.matchBrowseEntry("Azuaga, Nombre", 1)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"?startsWith=A")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/author/entries?startsWith=\u00d3", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains((Matcher[])new Matcher[]{BrowseEntryResourceMatcher.matchBrowseEntry("\u00d6gren, Name", 1), BrowseEntryResourceMatcher.matchBrowseEntry("Ortiz, Nombre", 1)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"?startsWith=\u00d3")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/entries?startsWith=Tele", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains((Matcher[])new Matcher[]{BrowseEntryResourceMatcher.matchBrowseEntry("Telecomunicaciones", 1), BrowseEntryResourceMatcher.matchBrowseEntry("Tel\u00e9fono", 1), BrowseEntryResourceMatcher.matchBrowseEntry("Televisor", 1)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"?startsWith=Tele")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/subject/entries?startsWith=Gui\u00f3n", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains(BrowseEntryResourceMatcher.matchBrowseEntry("Guion", 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"?startsWith=Gui\u00f3n")));
    }

    @Test
    public void testBrowseByItemsStartsWith() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Alan Turing").withAuthor("Turing, Alan Mathison").withIssueDate("1912-06-23").withSubject("Computing").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Blade Runner").withAuthor("Scott, Ridley").withIssueDate("1982-06-25").withSubject("Science Fiction").build();
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Python").withAuthor("Van Rossum, Guido").withIssueDate("1990").withSubject("Computing").build();
        Item item4 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Java").withAuthor("Gosling, James").withIssueDate("1995-05-23").withSubject("Computing").build();
        Item item5 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Zeta Reticuli").withAuthor("Universe").withIssueDate("2018-01-01").withSubject("Astronomy").build();
        Item item6 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Moon").withAuthor("Universe").withIssueDate("2018-01-02").withSubject("Astronomy").build();
        Item item7 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("T-800").withAuthor("Cameron, James").withIssueDate("2029").withSubject("Science Fiction").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/dateissued/items?startsWith=199", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(item3, "Python", "1990"), ItemMatcher.matchItemWithTitleAndDateIssued(item4, "Java", "1995-05-23")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/title/items?startsWith=T", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"startsWith=T"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains(ItemMatcher.matchItemWithTitleAndDateIssued(item7, "T-800", "2029"))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/title/items?startsWith=Blade", (Object[])new Object[0]).param("scope", new String[]{col1.getID().toString()}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"startsWith=Blade"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains(ItemMatcher.matchItemWithTitleAndDateIssued(item2, "Blade Runner", "1982-06-25"))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/title/items?startsWith=Blade Runner", (Object[])new Object[0]).param("scope", new String[]{col1.getID().toString()}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"startsWith=Blade Runner"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains(ItemMatcher.matchItemWithTitleAndDateIssued(item2, "Blade Runner", "1982-06-25"))));
    }

    @Test
    public void testBrowseByStartsWithAndPage() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Alan Turing").withAuthor("Turing, Alan Mathison").withIssueDate("1912-06-23").withSubject("Computing").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Blade Runner").withAuthor("Scott, Ridley").withIssueDate("1982-06-25").withSubject("Science Fiction").build();
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Java").withAuthor("Gosling, James").withIssueDate("1995-05-23").withSubject("Computing").build();
        Item item4 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Moon").withAuthor("Universe").withIssueDate("2018-01-02").withSubject("Astronomy").build();
        Item item5 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Python").withAuthor("Van Rossum, Guido").withIssueDate("1990").withSubject("Computing").build();
        Item item6 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("T-800").withAuthor("Cameron, James").withIssueDate("2029").withSubject("Science Fiction").build();
        Item item7 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Zeta Reticuli").withAuthor("Universe").withIssueDate("2018-01-01").withSubject("Astronomy").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/dateissued/items?startsWith=199", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"startsWith=199"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains(ItemMatcher.matchItemWithTitleAndDateIssued(item3, "Java", "1995-05-23"))));
    }

    @Test
    public void testBrowseByTitleStartsWithAndDiacritics() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("N\u00famero 1").withAuthor("Surname, Name").withIssueDate("2020").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Numero 2").withAuthor("Surname, Name").withIssueDate("2010").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/title/items?startsWith=Num", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"startsWith=Num"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(item1, "N\u00famero 1", "2020"), ItemMatcher.matchItemWithTitleAndDateIssued(item2, "Numero 2", "2010")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/title/items?startsWith=N\u00fam", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"startsWith=N\u00fam"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items", (Matcher)Matchers.contains((Matcher[])new Matcher[]{ItemMatcher.matchItemWithTitleAndDateIssued(item1, "N\u00famero 1", "2020"), ItemMatcher.matchItemWithTitleAndDateIssued(item2, "Numero 2", "2010")})));
    }

    @Test
    public void findBrowseByTitleItemsFullProjectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("Java").withSubject("Unit Testing").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/title/items", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items[0]._embedded.owningCollection._embedded.adminGroup", (Object[])new Object[0]).doesNotExist());
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/title/items", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items[0]._embedded.owningCollection._embedded.adminGroup", (Matcher)Matchers.nullValue()));
    }

    @Test
    public void browseByAuthorFullProjectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        for (int i = 0; i <= 20; ++i) {
            ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item " + String.format("%02d", i)).withIssueDate("2017-10-17").withAuthor("Test, Author" + String.format("%02d", i)).withSubject("Java").withSubject("Unit Testing").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/author/entries", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)21))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"/api/discover/browses/author/entries"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.containsString((String)"/api/discover/browses/author/entries"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)"/api/discover/browses/author/entries")));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/author/entries", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)21))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"/api/discover/browses/author/entries"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.containsString((String)"/api/discover/browses/author/entries"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)"/api/discover/browses/author/entries")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/author/entries", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)21))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"/api/discover/browses/author/entries"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.containsString((String)"/api/discover/browses/author/entries"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)"/api/discover/browses/author/entries")));
    }

    @Test
    public void testBrowseByDateIssuedItemsFullProjectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Item 1").withIssueDate("2017-10-17").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/dateissued/items", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items[0]._embedded.owningCollection._embedded.adminGroup", (Object[])new Object[0]).doesNotExist());
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/dateissued/items", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.items[0]._embedded.owningCollection._embedded.adminGroup", (Matcher)Matchers.nullValue()));
    }

    @Test
    public void findOneLinked() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/search/byFields", (Object[])new Object[0]).param("fields", new String[]{"dc.contributor.author"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.browseType", (Matcher)Matchers.is((Object)"valueList")));
    }

    @Test
    public void findOneLinkedPassingTwoFields() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/search/byFields", (Object[])new Object[0]).param("fields", new String[]{"dc.contributor.author"}).param("fields", new String[]{"dc.date.issued"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.browseType", (Matcher)Matchers.is((Object)"valueList")));
    }

    @Test
    public void findUnconfiguredFields() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/search/byFields", (Object[])new Object[0]).param("fields", new String[]{"dc.identifier.uri"})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findBrowseLinksWithMissingParameter() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/search/byFields", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }
}

