/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.ArrayList;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CCLicenseAddPatchOperationIT
extends AbstractControllerIntegrationTest {
    @Test
    public void patchSubmissionCCLicense() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withTitle("Workspace Item").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/sections/cclicense/uri", (Object)"https://creativecommons.org/licenses/by-nc-sa/4.0/");
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.cclicense", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uri", (Matcher)Matchers.is((Object)"https://creativecommons.org/licenses/by-nc-sa/4.0/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.rights", (Matcher)Matchers.is((Object)"Attribution-NonCommercial-ShareAlike 4.0 International")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.file.name", (Matcher)Matchers.is((Object)"license_rdf")))));
    }

    @Test
    public void patchSubmissionCCLicenseInvalid() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withTitle("Workspace Item").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/sections/cclicense/uri", (Object)"invalid-license-uri");
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.cclicense", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uri", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.rights", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.file", (Matcher)Matchers.nullValue()))));
    }
}

