/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.ArrayList;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.RemoveOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CCLicenseRemovePatchOperationIT
extends AbstractControllerIntegrationTest {
    @Test
    public void patchRemoveSubmissionCCLicense() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withTitle("Workspace Item").build();
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/sections/cclicense/uri", (Object)"https://creativecommons.org/licenses/by-nc-sa/4.0/");
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.cclicense", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uri", (Matcher)Matchers.is((Object)"https://creativecommons.org/licenses/by-nc-sa/4.0/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.rights", (Matcher)Matchers.is((Object)"Attribution-NonCommercial-ShareAlike 4.0 International")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.file.name", (Matcher)Matchers.is((Object)"license_rdf")))));
        ArrayList<Operation> removeOps = new ArrayList<Operation>();
        RemoveOperation removeOperation = new RemoveOperation("/sections/cclicense/uri");
        removeOps.add((Operation)removeOperation);
        String removePatch = this.getPatchContent(removeOps);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0]).content(removePatch).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.cclicense", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uri", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.rights", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.file", (Matcher)Matchers.nullValue()))));
    }

    @Test
    public void patchRemoveSubmissionCCLicenseNonExisting() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withTitle("Workspace Item").build();
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> removeOps = new ArrayList<Operation>();
        RemoveOperation removeOperation = new RemoveOperation("/sections/cclicense/uri");
        removeOps.add((Operation)removeOperation);
        String removePatch = this.getPatchContent(removeOps);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + workspaceItem.getID()), (Object[])new Object[0]).content(removePatch).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }
}

