/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.matcher.GroupMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.workflow.WorkflowService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CollectionGroupRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private GroupService groupService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private ObjectMapper mapper;
    Collection collection;

    @Before
    public void setup() {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("test").build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void getCollectionAdminGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = GroupBuilder.createCollectionAdminGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void getCollectionAdminGroupTestParentCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = GroupBuilder.createCollectionAdminGroup((Context)this.context, (Collection)this.collection).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void getCollectionAdminGroupTestCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = GroupBuilder.createCollectionAdminGroup((Context)this.context, (Collection)this.collection).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void getCollectionAdminGroupUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionAdminGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getCollectionAdminGroupForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionAdminGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getCollectionAdminGroupNoContentTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void getCollectionAdminGroupWrongCollectionUuidResourceNotFoundTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + UUID.randomUUID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void postCollectionAdminGroupCreateAdminGroupExtraMetadataSuccess() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group adminGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "testingDescription"), MetadataMatcher.matchMetadata("dc.subject", "testSubject")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void postCollectionAdminGroupCreateAdminGroupSuccess() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        groupRest.setMetadata(metadataRest);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group adminGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void postCollectionAdminGroupCreateAdminGroupDcTitleUnprocessable() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        metadataRest.put("dc.title", new MetadataValueRest[]{new MetadataValueRest("testTitle")});
        groupRest.setMetadata(metadataRest);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCollectionAdminGroupCreateAdminGroupSuccessParentCommunityAdmin() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group adminGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void postCollectionAdminGroupCreateAdminGroupSuccessCollectionAdmin() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group adminGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void postCollectionAdminGroupCreateAdminGroupUnAuthorized() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCollectionAdminGroupCreateAdminGroupForbidden() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCollectionAdminGroupCreateAdminGroupNotFound() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + UUID.randomUUID() + "/adminGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void postCollectionAdminGroupCreateAdminGroupUnProcessableName() throws Exception {
        GroupRest groupRest = new GroupRest();
        groupRest.setName("Fail");
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCollectionAdminGroupCreateAdminGroupUnProcessablePermanent() throws Exception {
        GroupRest groupRest = new GroupRest();
        groupRest.setPermanent(true);
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCollectionAdminGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionAdminGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCollectionAdminGroupTestParentCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionAdminGroup((Context)this.context, (Collection)this.collection).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCollectionAdminGroupTestCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionAdminGroup((Context)this.context, (Collection)this.collection).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteCollectionAdminGroupUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = GroupBuilder.createCollectionAdminGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void deleteCollectionAdminGroupForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = GroupBuilder.createCollectionAdminGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void deleteCollectionAdminGroupNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = GroupBuilder.createCollectionAdminGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + UUID.randomUUID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void getCollectionSubmittersGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group submitters = GroupBuilder.createCollectionSubmitterGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(submitters.getID(), submitters.getName())));
    }

    @Test
    public void getCollectionSubmittersGroupTestParentCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group submitters = GroupBuilder.createCollectionSubmitterGroup((Context)this.context, (Collection)this.collection).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(submitters.getID(), submitters.getName())));
    }

    @Test
    public void getCollectionSubmittersGroupTestCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group submitters = GroupBuilder.createCollectionSubmitterGroup((Context)this.context, (Collection)this.collection).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(submitters.getID(), submitters.getName())));
    }

    @Test
    public void getCollectionSubmittersGroupUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionSubmitterGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getCollectionSubmittersGroupForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionSubmitterGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getCollectionSubmittersGroupNoContentTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void getCollectionSubmittersGroupWrongCollectionUuidResourceNotFoundTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + UUID.randomUUID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void postCollectionSubmitterGroupCreateSubmitterGroupExtraMetadataSuccess() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group submittersGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "testingDescription"), MetadataMatcher.matchMetadata("dc.subject", "testSubject")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(submittersGroup.getID(), submittersGroup.getName())));
    }

    @Test
    public void postCollectionSubmitterGroupCreateSubmitterGroupSuccess() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group submittersGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(submittersGroup.getID(), submittersGroup.getName())));
    }

    @Test
    public void postCollectionSubmittersGroupCreateSubmittersGroupDcTitleUnprocessable() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        metadataRest.put("dc.title", new MetadataValueRest[]{new MetadataValueRest("testTitle")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCollectionSubmittersGroupCreateSubmittersGroupSuccessParentCommunityAdmin() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group submittersGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(submittersGroup.getID(), submittersGroup.getName())));
    }

    @Test
    public void postCollectionSubmittersGroupCreateSubmittersGroupSuccessCollectionAdmin() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group submittersGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(submittersGroup.getID(), submittersGroup.getName())));
    }

    @Test
    public void postCollectionSubmittersGroupCreateSubmittersGroupUnAuthorized() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCollectionSubmittersGroupCreateSubmittersGroupForbidden() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCollectionSubmittersGroupCreateSubmittersGroupNotFound() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + UUID.randomUUID() + "/submittersGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void postCollectionSubmittersGroupCreateSubmittersGroupUnProcessableName() throws Exception {
        GroupRest groupRest = new GroupRest();
        groupRest.setName("Fail");
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCollectionSubmittersGroupCreateSubmittersGroupUnProcessablePermanent() throws Exception {
        GroupRest groupRest = new GroupRest();
        groupRest.setPermanent(true);
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCollectionSubmitterGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionSubmitterGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCollectionSubmittersGroupTestParentCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionSubmitterGroup((Context)this.context, (Collection)this.collection).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCollectionSubmittersGroupTestCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionSubmitterGroup((Context)this.context, (Collection)this.collection).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCollectionSubmittersGroupUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group submittersGroup = GroupBuilder.createCollectionSubmitterGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(submittersGroup.getID(), submittersGroup.getName())));
    }

    @Test
    public void deleteCollectionSubmittersGroupForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group submittersGroup = GroupBuilder.createCollectionSubmitterGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(submittersGroup.getID(), submittersGroup.getName())));
    }

    @Test
    public void deleteCollectionSubmittersGroupNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionSubmitterGroup((Context)this.context, (Collection)this.collection).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + UUID.randomUUID() + "/submittersGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getCollectionItemReadGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String itemGroupString = "ITEM";
        int defaultItemRead = 10;
        Group role = GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)itemGroupString, (int)defaultItemRead).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(role.getID(), role.getName())));
    }

    @Test
    public void getCollectionDefaultItemReadGroupTestParentCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String itemGroupString = "ITEM";
        int defaultItemRead = 10;
        Group role = GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)itemGroupString, (int)defaultItemRead).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(role.getID(), role.getName())));
    }

    @Test
    public void getCollectionDefaultItemReadGroupTestCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String itemGroupString = "ITEM";
        int defaultItemRead = 10;
        Group role = GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)itemGroupString, (int)defaultItemRead).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(role.getID(), role.getName())));
    }

    @Test
    public void getCollectionDefaultItemReadGroupUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String itemGroupString = "ITEM";
        int defaultItemRead = 10;
        GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)itemGroupString, (int)defaultItemRead).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getCollectionDefaultItemReadGroupForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String itemGroupString = "ITEM";
        int defaultItemRead = 10;
        GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)itemGroupString, (int)defaultItemRead).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getCollectionDefaultItemReadGroupAnonymousGroupTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void getCollectionDefaultItemReadGroupWrongCollectionUuidResourceNotFoundTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + UUID.randomUUID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void postCollectionDefaultItemReadGroupCreateDefaultItemReadGroupSuccess() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group itemReadGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(itemReadGroup.getID(), itemReadGroup.getName())));
    }

    @Test
    public void postCollectionDefaultItemReadGroupCreateDefaultItemReadGroupDcTitleUnprocessable() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        metadataRest.put("dc.title", new MetadataValueRest[]{new MetadataValueRest("testTitle")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void postCollectionDefaultItemReadGroupCreateDefaultItemReadGroupSuccessParentCommunityAdmin() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group itemReadGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(itemReadGroup.getID(), itemReadGroup.getName())));
    }

    @Test
    public void postCollectionDefaultItemReadGroupCreateDefaultItemReadGroupSuccessCollectionAdmin() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group itemReadGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(itemReadGroup.getID(), itemReadGroup.getName())));
    }

    @Test
    public void postCollectionDefaultItemReadGroupCreateDefaultItemReadGroupUnAuthorized() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void postCollectionDefaultItemReadGroupCreateDefaultItemReadGroupForbidden() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void postCollectionDefaultItemReadGroupCreateDefaultItemReadGroupNotFound() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + UUID.randomUUID() + "/itemReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void postCollectionDefaultItemReadGroupCreateDefaultItemReadGroupUnProcessableName() throws Exception {
        GroupRest groupRest = new GroupRest();
        groupRest.setName("Fail");
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void postCollectionDefaultItemReadGroupCreateDefaultItemReadGroupUnProcessablePermanent() throws Exception {
        GroupRest groupRest = new GroupRest();
        groupRest.setPermanent(true);
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void deleteCollectionDefaultItemReadGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String itemGroupString = "ITEM";
        int defaultItemRead = 10;
        GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)itemGroupString, (int)defaultItemRead).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void deleteCollectionDefaultItemReadGroupTestParentCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String itemGroupString = "ITEM";
        int defaultItemRead = 10;
        GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)itemGroupString, (int)defaultItemRead).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void deleteCollectionDefaultItemReadGroupTestCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String itemGroupString = "ITEM";
        int defaultItemRead = 10;
        GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)itemGroupString, (int)defaultItemRead).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void deleteCollectionDefaultItemReadGroupUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String itemGroupString = "ITEM";
        int defaultItemRead = 10;
        Group role = GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)itemGroupString, (int)defaultItemRead).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(role.getID(), role.getName())));
    }

    @Test
    public void deleteCollectionDefaultItemReadGroupForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String itemGroupString = "ITEM";
        int defaultItemRead = 10;
        Group role = GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)itemGroupString, (int)defaultItemRead).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(role.getID(), role.getName())));
    }

    @Test
    public void deleteCollectionDefaultItemReadGroupNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String itemGroupString = "ITEM";
        int defaultItemRead = 10;
        GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)itemGroupString, (int)defaultItemRead).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + UUID.randomUUID() + "/itemReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getCollectionBitstreamReadGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamGroupString = "BITSTREAM";
        int defaultBitstreamRead = 9;
        Group role = GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)bitstreamGroupString, (int)defaultBitstreamRead).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(role.getID(), role.getName())));
    }

    @Test
    public void getCollectionDefaultBitstreamReadGroupTestParentCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamGroupString = "BITSTREAM";
        int defaultBitstreamRead = 9;
        Group role = GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)bitstreamGroupString, (int)defaultBitstreamRead).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(role.getID(), role.getName())));
    }

    @Test
    public void getCollectionDefaultBitstreamReadGroupTestCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamGroupString = "BITSTREAM";
        int defaultBitstreamRead = 9;
        Group role = GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)bitstreamGroupString, (int)defaultBitstreamRead).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(role.getID(), role.getName())));
    }

    @Test
    public void getCollectionDefaultBitstreamReadGroupUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamGroupString = "BITSTREAM";
        int defaultBitstreamRead = 9;
        GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)bitstreamGroupString, (int)defaultBitstreamRead).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getCollectionDefaultBitstreamReadGroupForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamGroupString = "BITSTREAM";
        int defaultBitstreamRead = 9;
        GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)bitstreamGroupString, (int)defaultBitstreamRead).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getCollectionDefaultBitstreamReadGroupNoContentTest() throws Exception {
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void getCollectionDefaultBitstreamReadGroupWrongCollectionUuidResourceNotFoundTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + UUID.randomUUID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void postCollectionDefaultBitstreamReadGroupCreateDefaultBitstreamReadGroupSuccess() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group bitstreamReadGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(bitstreamReadGroup.getID(), bitstreamReadGroup.getName())));
    }

    @Test
    public void postCollectionDefaultBitstreamReadGroupCreateDefaultBitstreamReadGroupDcTitleUnprocessable() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        metadataRest.put("dc.title", new MetadataValueRest[]{new MetadataValueRest("testTitle")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void postCollectionDefaultBitstreamReadGroupCreateDefaultBitstreamReadGroupSuccessParentCommunityAdmin() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group bitstreamReadGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(bitstreamReadGroup.getID(), bitstreamReadGroup.getName())));
    }

    @Test
    public void postCollectionDefaultBitstreamReadGroupCreateDefaultBitstreamReadGroupSuccessCollectionAdmin() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group bitstreamReadGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(bitstreamReadGroup.getID(), bitstreamReadGroup.getName())));
    }

    @Test
    public void postCollectionDefaultBitstreamReadGroupCreateDefaultBitstreamReadGroupUnAuthorized() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void postCollectionDefaultBitstreamReadGroupCreateDefaultBitstreamReadGroupForbidden() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void postCollectionDefaultBitstreamReadGroupCreateDefaultBitstreamReadGroupNotFound() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + UUID.randomUUID() + "/bitstreamReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void postCollectionDefaultBitstreamReadGroupCreateDefaultBitstreamReadGroupUnProcessableName() throws Exception {
        GroupRest groupRest = new GroupRest();
        groupRest.setName("Fail");
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void postCollectionDefaultBitstreamReadGroupCreateDefaultBitstreamReadGroupUnProcessablePermanent() throws Exception {
        GroupRest groupRest = new GroupRest();
        groupRest.setPermanent(true);
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void deleteCollectionDefaultBitstreamReadGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamGroupString = "BITSTREAM";
        int defaultBitstreamRead = 9;
        GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)bitstreamGroupString, (int)defaultBitstreamRead).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void deleteCollectionDefaultBitstreamReadGroupTestParentCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamGroupString = "BITSTREAM";
        int defaultBitstreamRead = 9;
        GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)bitstreamGroupString, (int)defaultBitstreamRead).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void deleteCollectionDefaultBitstreamReadGroupTestCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamGroupString = "BITSTREAM";
        int defaultBitstreamRead = 9;
        GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)bitstreamGroupString, (int)defaultBitstreamRead).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        Group anon = this.groupService.findByName(this.context, "Anonymous");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(anon.getID(), anon.getName())));
    }

    @Test
    public void deleteCollectionDefaultBitstreamReadGroupUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamGroupString = "BITSTREAM";
        int defaultBitstreamRead = 9;
        Group role = GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)bitstreamGroupString, (int)defaultBitstreamRead).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(role.getID(), role.getName())));
    }

    @Test
    public void deleteCollectionDefaultBitstreamReadGroupForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamGroupString = "BITSTREAM";
        int defaultBitstreamRead = 9;
        GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)bitstreamGroupString, (int)defaultBitstreamRead).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void deleteCollectionDefaultBitstreamReadGroupNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamGroupString = "BITSTREAM";
        int defaultBitstreamRead = 9;
        GroupBuilder.createCollectionDefaultReadGroup((Context)this.context, (Collection)this.collection, (String)bitstreamGroupString, (int)defaultBitstreamRead).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + UUID.randomUUID() + "/bitstreamReadGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getWorkflowGroupForCollectionAndRole() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(group.getID(), group.getName())));
    }

    @Test
    public void getWorkflowGroupForCollectionAndRoleParentCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(group.getID(), group.getName())));
    }

    @Test
    public void getWorkflowGroupForCollectionAndRoleWrongUUIDCollectionNotFound() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + UUID.randomUUID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getWorkflowGroupForCollectionAndRoleWrongRoleNotFound() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + UUID.randomUUID() + "/workflowGroups/wrongRole"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getWorkflowGroupCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(group.getID(), group.getName())));
    }

    @Test
    public void getWorkflowGroupCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(group.getID(), group.getName())));
    }

    @Test
    public void getWorkflowGroupUnAuthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getWorkflowGroupForbidden() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void postCollectionWorkflowGroupCreateWorkflowGroupSuccess() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        groupRest.setMetadata(metadataRest);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group workflowGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(workflowGroup.getID(), workflowGroup.getName())));
    }

    @Test
    public void postCollectionWorkflowGroupCreateWorkflowGroupExtraMetadataSuccess() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group workflowGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "testingDescription"), MetadataMatcher.matchMetadata("dc.subject", "testSubject")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(workflowGroup.getID(), workflowGroup.getName())));
    }

    @Test
    public void postCollectionWorkflowGroupWrongCollectionId() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + UUID.randomUUID() + "/workflowGroups/reviewer"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void postCollectionWorkflowGroupCreateWorkflowGroupWrongRole() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/wrongRole"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void postCollectionWorkflowGroupCreateWorkflowGroupDcTitleUnprocessable() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        metadataRest.put("dc.title", new MetadataValueRest[]{new MetadataValueRest("testTitle")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCollectionWorkflowGroupCreateWorkflowGroupSuccessParentCommunityAdmin() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group workflowGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(workflowGroup.getID(), workflowGroup.getName())));
    }

    @Test
    public void postCollectionWorkflowGroupCreateWorkflowGroupSuccessCollectionAdmin() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group workflowGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(workflowGroup.getID(), workflowGroup.getName())));
    }

    @Test
    public void postCollectionWorkflowGroupCreateWorkflowGroupUnAuthorized() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCollectionWorkflowGroupCreateWorkflowGroupForbidden() throws Exception {
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCollectionWorkflowGroupCreateWorkflowGroupUnProcessableName() throws Exception {
        GroupRest groupRest = new GroupRest();
        groupRest.setName("Fail");
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCollectionWorkflowGroupCreateWorkflowGroupUnProcessablePermanent() throws Exception {
        GroupRest groupRest = new GroupRest();
        groupRest.setPermanent(true);
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCollectionWorkflowGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCollectionWorkflowGroupTestParentCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCollectionWorkflowGroupTestCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCollectionWorkflowGroupUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(group.getID(), group.getName())));
    }

    @Test
    public void deleteCollectionWorkflowGroupForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(group.getID(), group.getName())));
    }

    @Test
    public void deleteCollectionWorkflowGroupNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + UUID.randomUUID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteCollectionWorkflowGroupWithPooledTaskTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group reviewer = GroupBuilder.createCollectionWorkflowRoleGroup((Context)this.context, (Collection)this.collection, (String)"reviewer").build();
        this.groupService.addMember(this.context, reviewer, this.eperson);
        this.workflowService.start(this.context, WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)this.collection).withTitle("Dummy Item").build());
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + this.collection.getID() + "/workflowGroups/reviewer"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }
}

