/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import junit.framework.TestCase;
import org.dspace.app.rest.converter.CommunityConverter;
import org.dspace.app.rest.matcher.CollectionMatcher;
import org.dspace.app.rest.matcher.CommunityMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.matcher.PageMatcher;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.test.MetadataPatchSuite;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CommunityRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    CommunityConverter communityConverter;
    @Autowired
    CommunityService communityService;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    ResourcePolicyService resoucePolicyService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private ObjectMapper mapper;
    private Community topLevelCommunityA;
    private Community subCommunityA;
    private Community communityB;
    private Community communityC;
    private Collection collectionA;
    private EPerson topLevelCommunityAAdmin;
    private EPerson subCommunityAAdmin;
    private EPerson collectionAdmin;
    private EPerson submitter;

    @Test
    public void singularEndpointShouldNotExist() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/community", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createTest() throws Exception {
        CommunityRest comm = new CommunityRest();
        CommunityRest commNoembeds = new CommunityRest();
        comm.setName("Test Top-Level Community");
        commNoembeds.setName("Test Top-Level Community Full");
        MetadataRest metadataRest = new MetadataRest();
        MetadataValueRest description = new MetadataValueRest();
        description.setValue("<p>Some cool HTML code here</p>");
        metadataRest.put("dc.description", new MetadataValueRest[]{description});
        MetadataValueRest abs = new MetadataValueRest();
        abs.setValue("Sample top-level community created via the REST API");
        metadataRest.put("dc.description.abstract", new MetadataValueRest[]{abs});
        MetadataValueRest contents = new MetadataValueRest();
        contents.setValue("<p>HTML News</p>");
        metadataRest.put("dc.description.tableofcontents", new MetadataValueRest[]{contents});
        MetadataValueRest copyright = new MetadataValueRest();
        copyright.setValue("Custom Copyright Text");
        metadataRest.put("dc.rights", new MetadataValueRest[]{copyright});
        MetadataValueRest title = new MetadataValueRest();
        title.setValue("Title Text");
        metadataRest.put("dc.title", new MetadataValueRest[]{title});
        comm.setMetadata(metadataRest);
        commNoembeds.setMetadata(metadataRest);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        AtomicReference idRefNoEmbeds = new AtomicReference();
        AtomicReference handle = new AtomicReference();
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/communities", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)comm)).contentType(this.contentType).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchNonAdminEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"Title Text")), JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"community")), JsonPathMatchers.hasJsonPath((String)"$._links.collections.href", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$._links.logo.href", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$._links.subcommunities.href", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "<p>Some cool HTML code here</p>"), MetadataMatcher.matchMetadata("dc.description.abstract", "Sample top-level community created via the REST API"), MetadataMatcher.matchMetadata("dc.description.tableofcontents", "<p>HTML News</p>"), MetadataMatcher.matchMetadata("dc.rights", "Custom Copyright Text"), MetadataMatcher.matchMetadata("dc.title", "Title Text")))}))).andDo(result -> handle.set((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.handle", (Predicate[])new Predicate[0]))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadataNotEmpty("dc.identifier.uri"), MetadataMatcher.matchMetadataStringEndsWith("dc.identifier.uri", (String)handle.get()))))).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/communities", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)commNoembeds)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andDo(result -> idRefNoEmbeds.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        }
        finally {
            CommunityBuilder.deleteCommunity((UUID)((UUID)idRef.get()));
            CommunityBuilder.deleteCommunity((UUID)((UUID)idRefNoEmbeds.get()));
        }
    }

    @Test
    public void createSubCommunityUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.context.restoreAuthSystemState();
        CommunityRest comm = new CommunityRest();
        comm.setName("Test Sub-Level Community");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/communities", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)comm)).param("parent", new String[]{this.parentCommunity.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/communities", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)comm)).param("parent", new String[]{this.parentCommunity.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSubCommunityAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.context.setCurrentUser(this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 3, this.eperson);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        CommunityRest comm = new CommunityRest();
        comm.setName("Test Sub-Level Community");
        comm.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample top-level community created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
        AtomicReference idRef = new AtomicReference();
        AtomicReference handle = new AtomicReference();
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/communities", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)comm)).param("parent", new String[]{this.parentCommunity.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"Title Text")), JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"community")), JsonPathMatchers.hasJsonPath((String)"$._links.collections.href", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$._links.logo.href", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$._links.subcommunities.href", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.not((Matcher)Matchers.empty())), JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "<p>Some cool HTML code here</p>"), MetadataMatcher.matchMetadata("dc.description.abstract", "Sample top-level community created via the REST API"), MetadataMatcher.matchMetadata("dc.description.tableofcontents", "<p>HTML News</p>"), MetadataMatcher.matchMetadata("dc.rights", "Custom Copyright Text"), MetadataMatcher.matchMetadata("dc.title", "Title Text")))}))).andDo(result -> handle.set((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.handle", (Predicate[])new Predicate[0]))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadataNotEmpty("dc.identifier.uri"), MetadataMatcher.matchMetadataStringEndsWith("dc.identifier.uri", (String)handle.get()))))).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        }
        finally {
            CommunityBuilder.deleteCommunity((UUID)((UUID)idRef.get()));
        }
    }

    @Test
    public void createUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CommunityRest comm = new CommunityRest();
        comm.setName("Test Top-Level Community");
        MetadataRest metadataRest = new MetadataRest();
        MetadataValueRest title = new MetadataValueRest();
        title.setValue("Title Text");
        metadataRest.put("dc.title", new MetadataValueRest[]{title});
        comm.setMetadata(metadataRest);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/communities", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)comm)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/communities", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)comm)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities", (Object[])new Object[0]).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunityEntryNonAdminEmbeds(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle()), CommunityMatcher.matchCommunityEntryNonAdminEmbeds(child1.getName(), child1.getID(), child1.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findOneTestWithEmbedsNoPageSize() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child0 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 0").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 1").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 2").build();
        Community child3 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 3").build();
        Community child4 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 4").build();
        Community child5 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 5").build();
        Community child6 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 6").build();
        Community child7 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 7").build();
        Community child8 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 8").build();
        Community child9 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 9").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID()), (Object[])new Object[0]).param("embed", new String[]{"subcommunities"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchCommunity(this.parentCommunity))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities._embedded.subcommunities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunity(child0), CommunityMatcher.matchCommunity(child1), CommunityMatcher.matchCommunity(child2), CommunityMatcher.matchCommunity(child3), CommunityMatcher.matchCommunity(child4), CommunityMatcher.matchCommunity(child5), CommunityMatcher.matchCommunity(child6), CommunityMatcher.matchCommunity(child7), CommunityMatcher.matchCommunity(child8), CommunityMatcher.matchCommunity(child9)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities.page.totalElements", (Matcher)Matchers.is((Object)10)));
    }

    @Test
    public void findOneTestWithEmbedsWithPageSize() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child0 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 0").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 1").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 2").build();
        Community child3 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 3").build();
        Community child4 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 4").build();
        Community child5 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 5").build();
        Community child6 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 6").build();
        Community child7 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 7").build();
        Community child8 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 8").build();
        Community child9 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 9").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID()), (Object[])new Object[0]).param("embed", new String[]{"subcommunities"}).param("embed.size", new String[]{"subcommunities=5"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchCommunity(this.parentCommunity))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities._embedded.subcommunities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunity(child0), CommunityMatcher.matchCommunity(child1), CommunityMatcher.matchCommunity(child2), CommunityMatcher.matchCommunity(child3), CommunityMatcher.matchCommunity(child4)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities.page.totalElements", (Matcher)Matchers.is((Object)10)));
    }

    @Test
    public void findOneTestWithEmbedsWithInvalidPageSize() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child0 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 0").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 1").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 2").build();
        Community child3 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 3").build();
        Community child4 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 4").build();
        Community child5 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 5").build();
        Community child6 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 6").build();
        Community child7 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 7").build();
        Community child8 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 8").build();
        Community child9 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 9").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID()), (Object[])new Object[0]).param("embed", new String[]{"subcommunities"}).param("embed.size", new String[]{"subcommunities=invalidPage"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchCommunity(this.parentCommunity))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities._embedded.subcommunities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunity(child0), CommunityMatcher.matchCommunity(child1), CommunityMatcher.matchCommunity(child2), CommunityMatcher.matchCommunity(child3), CommunityMatcher.matchCommunity(child4), CommunityMatcher.matchCommunity(child5), CommunityMatcher.matchCommunity(child6), CommunityMatcher.matchCommunity(child7), CommunityMatcher.matchCommunity(child8), CommunityMatcher.matchCommunity(child9)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities.page.totalElements", (Matcher)Matchers.is((Object)10)));
    }

    @Test
    public void findAllNoDuplicatesOnMultipleCommunityTitlesTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        List<String> titles = Arrays.asList("First title", "Second title", "Third title", "Fourth title");
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName(titles.get(0)).withTitle(titles.get(1)).withTitle(titles.get(2)).withTitle(titles.get(3)).build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities", (Object[])new Object[0]).param("size", new String[]{"2"}).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunityEntryMultipleTitles(titles, this.parentCommunity.getID(), this.parentCommunity.getHandle()), CommunityMatcher.matchCommunityEntryNonAdminEmbeds(child1.getName(), child1.getID(), child1.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAllNoDuplicatesOnMultipleCommunityTitlesPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        List<String> titles = Arrays.asList("First title", "Second title", "Third title", "Fourth title");
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName(titles.get(0)).withTitle(titles.get(1)).withTitle(titles.get(2)).withTitle(titles.get(3)).build();
        Community childCommunity = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("test").build();
        Community secondParentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("testing").build();
        Community thirdParentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("testingTitleTwo").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities", (Object[])new Object[0]).param("size", new String[]{"2"}).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunityEntryMultipleTitles(titles, this.parentCommunity.getID(), this.parentCommunity.getHandle()), CommunityMatcher.matchCommunityEntryNonAdminEmbeds(childCommunity.getName(), childCommunity.getID(), childCommunity.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", PageMatcher.pageEntryWithTotalPagesAndElements(0, 2, 2, 4)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities", (Object[])new Object[0]).param("size", new String[]{"2"}).param("page", new String[]{"1"}).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunityEntryNonAdminEmbeds(secondParentCommunity.getName(), secondParentCommunity.getID(), secondParentCommunity.getHandle()), CommunityMatcher.matchCommunityEntryNonAdminEmbeds(thirdParentCommunity.getName(), thirdParentCommunity.getID(), thirdParentCommunity.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", PageMatcher.pageEntryWithTotalPagesAndElements(1, 2, 2, 4)));
    }

    @Test
    public void findAllNoNameCommunityIsReturned() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("test").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities", (Object[])new Object[0]).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.contains(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAllCommunitiesAreReturnedInCorrectOrder() throws Exception {
        this.context.turnOffAuthorisationSystem();
        List<String> orderedTitles = Arrays.asList("Abc", "Bcd", "Cde");
        Community community1 = CommunityBuilder.createCommunity((Context)this.context).withName(orderedTitles.get(0)).build();
        Community community2 = CommunityBuilder.createCommunity((Context)this.context).withName(orderedTitles.get(1)).build();
        Community community3 = CommunityBuilder.createCommunity((Context)this.context).withName(orderedTitles.get(2)).build();
        this.context.restoreAuthSystemState();
        MvcResult result = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities", (Object[])new Object[0])).andReturn();
        String response = result.getResponse().getContentAsString();
        JSONArray communities = new JSONObject(response).getJSONObject("_embedded").getJSONArray("communities");
        List responseTitles = StreamSupport.stream(communities.spliterator(), false).map(JSONObject.class::cast).map(x -> x.getString("name")).collect(Collectors.toList());
        TestCase.assertEquals(orderedTitles, responseTitles);
    }

    @Test
    public void findAllPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities", (Object[])new Object[0]).param("size", new String[]{"1"}).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.contains(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.not((Matcher)Matchers.contains(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(child1.getName(), child1.getID(), child1.getHandle()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/communities?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/communities?"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/communities?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/communities?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"1"}).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.contains(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(child1.getName(), child1.getID(), child1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.not((Matcher)Matchers.contains(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/communities?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/communities?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/communities?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/communities?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findAllUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 2").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)this.parentCommunity, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)child1, 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.contains(CommunityMatcher.matchCommunity(child2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAllForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 2").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)this.parentCommunity, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)child1, 0);
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.contains(CommunityMatcher.matchCommunity(child2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAllGrantAccessAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson parentAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{parentAdmin}).build();
        EPerson child1Admin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 1").withAdminGroup(new EPerson[]{child1Admin}).build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 2").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)this.parentCommunity, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)child1, 0);
        this.context.restoreAuthSystemState();
        String tokenParentAdmin = this.getAuthToken(parentAdmin.getEmail(), "qwerty01");
        this.getClient(tokenParentAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunity(this.parentCommunity), CommunityMatcher.matchCommunity(child1), CommunityMatcher.matchCommunity(child2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        String tokenChild1Admin = this.getAuthToken(child1Admin.getEmail(), "qwerty02");
        this.getClient(tokenChild1Admin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunity(child1), CommunityMatcher.matchCommunity(child2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchNonAdminEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchCommunityEntry(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchLinks(this.parentCommunity.getID()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchProperties(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle())));
    }

    @Test
    public void findOneFullProjectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchCommunityEntryFullProjection(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not(CommunityMatcher.matchCommunityEntryFullProjection(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle()))));
    }

    @Test
    public void findOneUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community privateCommunity = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Private Community").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)privateCommunity, 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + privateCommunity.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community privateCommunity = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Private Community").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)privateCommunity, 0);
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + privateCommunity.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneGrantAccessAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{this.eperson}).build();
        EPerson privateCommunityAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("comunityAdmin@mail.com").withPassword("qwerty01").build();
        Community privateCommunity = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{privateCommunityAdmin}).build();
        EPerson privateCommunityAdmin2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("comunityAdmin2@mail.com").withPassword("qwerty02").build();
        Community privateCommunity2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 2").withAdminGroup(new EPerson[]{privateCommunityAdmin2}).build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)privateCommunity, 0);
        this.context.restoreAuthSystemState();
        String tokenParentComunityAdmin = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenParentComunityAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + privateCommunity.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CommunityMatcher.matchCommunity(privateCommunity))));
        String tokenCommunityAdmin = this.getAuthToken(privateCommunityAdmin.getEmail(), "qwerty01");
        this.getClient(tokenCommunityAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + privateCommunity.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CommunityMatcher.matchCommunity(privateCommunity))));
        String tokenComunityAdmin2 = this.getAuthToken(privateCommunityAdmin2.getEmail(), "qwerty02");
        this.getClient(tokenComunityAdmin2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + privateCommunity.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneRelsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)Matchers.is(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(child1.getName(), child1.getID(), child1.getHandle()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.logo.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID().toString() + "/logo")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.collections.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID().toString() + "/collections")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.subcommunities.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID().toString() + "/subcommunities"))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString() + "/logo"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + child1.getID().toString() + "/logo"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString() + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + child1.getID().toString() + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + child1.getID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findAllSearchTop() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community parentCommunity2 = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community 2").withLogo("SomeTest").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child12 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)child1).withName("Sub Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/top", (Object[])new Object[0]).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunityEntryNonAdminEmbeds(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle()), CommunityMatcher.matchCommunityEntryNonAdminEmbeds(parentCommunity2.getName(), parentCommunity2.getID(), parentCommunity2.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunityEntryNonAdminEmbeds(child1.getName(), child1.getID(), child1.getHandle()), CommunityMatcher.matchCommunityEntryNonAdminEmbeds(child12.getName(), child12.getID(), child12.getHandle())})))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities/search/top"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findAllSubCommunities() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community parentCommunity2 = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community 2").withLogo("SomeTest").build();
        Community parentCommunityChild1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community parentCommunityChild2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community2").build();
        Community parentCommunityChild2Child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)parentCommunityChild2).withName("Sub Sub Community").build();
        Community parentCommunity2Child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)parentCommunity2).withName("Sub2 Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)parentCommunityChild1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunity(parentCommunityChild1), CommunityMatcher.matchCommunity(parentCommunityChild2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities", (Matcher)Matchers.not((Matcher)Matchers.anyOf(CommunityMatcher.matchCommunity(this.parentCommunity), CommunityMatcher.matchCommunity(parentCommunity2), CommunityMatcher.matchCommunity(parentCommunity2Child1), CommunityMatcher.matchCommunity(parentCommunityChild2Child1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + parentCommunityChild2.getID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities", (Matcher)Matchers.contains(CommunityMatcher.matchCommunity(parentCommunityChild2Child1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities", (Matcher)Matchers.not((Matcher)Matchers.anyOf(CommunityMatcher.matchCommunity(this.parentCommunity), CommunityMatcher.matchCommunity(parentCommunity2), CommunityMatcher.matchCommunity(parentCommunity2Child1), CommunityMatcher.matchCommunity(parentCommunityChild2Child1), CommunityMatcher.matchCommunity(parentCommunityChild1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + parentCommunityChild2.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + parentCommunityChild2Child1.getID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + parentCommunityChild2Child1.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findAllSubCommunitiesUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community communityChild1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community communityChild2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community2").build();
        Community communityChild2Child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)communityChild2).withName("Sub Community2").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)communityChild2, 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + communityChild2.getID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities", (Matcher)Matchers.contains(CommunityMatcher.matchCommunity(communityChild1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunity(communityChild1), CommunityMatcher.matchCommunity(communityChild2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findAllSubCommunitiesForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community communityChild1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community communityChild2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community2").build();
        Community communityChild2Child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)communityChild2).withName("Sub Community2").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)communityChild2, 0);
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities", (Matcher)Matchers.contains(CommunityMatcher.matchCommunity(communityChild1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + communityChild2.getID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllSubCommunitiesGrantAccessAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson parentComAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").withAdminGroup(new EPerson[]{parentComAdmin}).build();
        EPerson child1Admin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        Community communityChild1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{child1Admin}).build();
        EPerson child2Admin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson3@mail.com").withPassword("qwerty03").build();
        Community communityChild2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community2").withAdminGroup(new EPerson[]{child2Admin}).build();
        Community communityChild1Child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)communityChild1).withName("Sub1 Community 1").build();
        Community communityChild2Child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)communityChild2).withName("Sub2 Community 1").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)this.parentCommunity, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)communityChild1, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)communityChild2, 0);
        this.context.restoreAuthSystemState();
        String tokenParentAdmin = this.getAuthToken(parentComAdmin.getEmail(), "qwerty01");
        this.getClient(tokenParentAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subcommunities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunity(communityChild1), CommunityMatcher.matchCommunity(communityChild2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        String tokenChild1Admin = this.getAuthToken(child1Admin.getEmail(), "qwerty02");
        this.getClient(tokenChild1Admin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenChild2Admin = this.getAuthToken(child2Admin.getEmail(), "qwerty03");
        this.getClient(tokenChild2Admin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + communityChild1.getID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllCollectionsUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection child1Col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1 child 1").build();
        Collection child1Col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2 child 1").build();
        Collection child2Col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 1 child 2").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)child1Col2, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)child2, 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + child1.getID().toString() + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollection(child1Col1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + child2.getID().toString() + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllCollectionsForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 1").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 2").build();
        Collection child1Col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1 child 1").build();
        Collection child1Col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2 child 1").build();
        Collection child2Col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 1 child 2").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)child1Col2, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)child2, 0);
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + child1.getID().toString() + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollection(child1Col1), CollectionMatcher.matchCollection(child1Col2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + child2.getID().toString() + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollection(child2Col1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + child2.getID().toString() + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllCollectionsGrantAccessAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson parentAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").withAdminGroup(new EPerson[]{parentAdmin}).build();
        EPerson child1Admin = EPersonBuilder.createEPerson((Context)this.context).withEmail("child1admin@mail.com").withPassword("qwerty02").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{child1Admin}).build();
        EPerson child2Admin = EPersonBuilder.createEPerson((Context)this.context).withEmail("child2admin@mail.com").withPassword("qwerty03").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").withAdminGroup(new EPerson[]{child2Admin}).build();
        Collection child1Col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Child 1 Collection 1").build();
        Collection child1Col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Child 1 Collection 2").build();
        Collection child2Col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Child 2 Collection 1").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)child1Col2, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)child2, 0);
        this.context.restoreAuthSystemState();
        String tokenParentAdmin = this.getAuthToken(parentAdmin.getEmail(), "qwerty01");
        this.getClient(tokenParentAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + child1.getID().toString() + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollection(child1Col1), CollectionMatcher.matchCollection(child1Col2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenParentAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + child2.getID().toString() + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollection(child2Col1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String tokenChild2Admin = this.getAuthToken(child2Admin.getEmail(), "qwerty03");
        this.getClient(tokenChild2Admin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + child1.getID().toString() + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollection(child1Col1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAllSubCommunitiesWithUnexistentUUID() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + UUID.randomUUID().toString() + "/subcommunities"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneTestWrongUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void updateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)Matchers.is(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(child1.getName(), child1.getID(), child1.getHandle()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities")));
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.turnOffAuthorisationSystem();
        CommunityRest communityRest = this.communityConverter.convert(this.parentCommunity, Projection.DEFAULT);
        communityRest.setMetadata(new MetadataRest().put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Electronic theses and dissertations")}));
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(this.mapper.writeValueAsBytes((Object)communityRest))).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CommunityMatcher.matchCommunityEntryNonAdminEmbeds("Electronic theses and dissertations", this.parentCommunity.getID(), this.parentCommunity.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities")));
    }

    @Test
    public void deleteTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community parentCommunity2 = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community 2").withLogo("SomeTest").build();
        Community parentCommunityChild1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community parentCommunityChild2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community2").build();
        Community parentCommunityChild2Child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)parentCommunityChild2).withName("Sub Sub Community").build();
        Community parentCommunity2Child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)parentCommunity2).withName("Sub2 Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)parentCommunityChild1).withName("Collection 1").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + parentCommunityChild1.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteTestUnAuthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community parentCommunity2 = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community 2").withLogo("SomeTest").build();
        Community parentCommunityChild1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community parentCommunityChild2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community2").build();
        Community parentCommunityChild2Child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)parentCommunityChild2).withName("Sub Sub Community").build();
        Community parentCommunity2Child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)parentCommunity2).withName("Sub2 Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)parentCommunityChild1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void deleteCommunityEpersonWithDeleteRightsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.context.setCurrentUser(this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 2, this.eperson);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.authorizeService.removePoliciesActionFilter(this.context, (DSpaceObject)this.eperson, 2);
    }

    @Test
    public void updateCommunityEpersonWithWriteRightsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(this.parentCommunity.getName(), this.parentCommunity.getID(), this.parentCommunity.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)Matchers.is(CommunityMatcher.matchCommunityEntryNonAdminEmbeds(child1.getName(), child1.getID(), child1.getHandle()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities")));
        this.context.turnOffAuthorisationSystem();
        CommunityRest communityRest = this.communityConverter.convert(this.parentCommunity, Projection.DEFAULT);
        communityRest.setMetadata(new MetadataRest().put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Electronic theses and dissertations")}));
        this.context.setCurrentUser(this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 1, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(this.mapper.writeValueAsBytes((Object)communityRest))).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CommunityMatcher.getNonAdminEmbeds()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CommunityMatcher.matchCommunityEntryNonAdminEmbeds("Electronic theses and dissertations", this.parentCommunity.getID(), this.parentCommunity.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities")));
        this.authorizeService.removePoliciesActionFilter(this.context, (DSpaceObject)this.eperson, 2);
    }

    @Test
    public void patchCommunityMetadataAuthorized() throws Exception {
        this.runPatchMetadataTests(this.admin, 200);
    }

    @Test
    public void patchCommunityMetadataUnauthorized() throws Exception {
        this.runPatchMetadataTests(this.eperson, 403);
    }

    @Test
    public void patchReplaceMultipleDescriptionCommunity() throws Exception {
        this.context.turnOffAuthorisationSystem();
        List<String> communityDescriptions = List.of("FIRST", "SECOND", "THIRD");
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.communityService.addMetadata(this.context, (DSpaceObject)this.parentCommunity, MetadataSchemaEnum.DC.getName(), "description", null, "*", communityDescriptions);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", communityDescriptions.get(0), 0), MetadataMatcher.matchMetadata("dc.description", communityDescriptions.get(1), 1), MetadataMatcher.matchMetadata("dc.description", communityDescriptions.get(2), 2))));
        List<ReplaceOperation> ops = List.of(new ReplaceOperation("/metadata/dc.description/0", (Object)communityDescriptions.get(2)), new ReplaceOperation("/metadata/dc.description/1", (Object)communityDescriptions.get(0)), new ReplaceOperation("/metadata/dc.description/2", (Object)communityDescriptions.get(1)));
        String requestBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/communities/" + this.parentCommunity.getID()), (Object[])new Object[0]).content(requestBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", communityDescriptions.get(2), 0), MetadataMatcher.matchMetadata("dc.description", communityDescriptions.get(0), 1), MetadataMatcher.matchMetadata("dc.description", communityDescriptions.get(1), 2))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", communityDescriptions.get(2), 0), MetadataMatcher.matchMetadata("dc.description", communityDescriptions.get(0), 1), MetadataMatcher.matchMetadata("dc.description", communityDescriptions.get(1), 2))));
    }

    private void runPatchMetadataTests(EPerson asUser, int expectedStatus) throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(asUser.getEmail(), this.password);
        new MetadataPatchSuite(this.mapper).runWith(this.getClient(token), "/api/core/communities/" + this.parentCommunity.getID(), expectedStatus);
    }

    @Test
    public void createTestInvalidParentCommunityBadRequest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CommunityRest comm = new CommunityRest();
        comm.setName("Test Top-Level Community");
        MetadataRest metadataRest = new MetadataRest();
        MetadataValueRest description = new MetadataValueRest();
        description.setValue("<p>Some cool HTML code here</p>");
        metadataRest.put("dc.description", new MetadataValueRest[]{description});
        MetadataValueRest abs = new MetadataValueRest();
        abs.setValue("Sample top-level community created via the REST API");
        metadataRest.put("dc.description.abstract", new MetadataValueRest[]{abs});
        MetadataValueRest contents = new MetadataValueRest();
        contents.setValue("<p>HTML News</p>");
        metadataRest.put("dc.description.tableofcontents", new MetadataValueRest[]{contents});
        MetadataValueRest copyright = new MetadataValueRest();
        copyright.setValue("Custom Copyright Text");
        metadataRest.put("dc.rights", new MetadataValueRest[]{copyright});
        MetadataValueRest title = new MetadataValueRest();
        title.setValue("Title Text");
        metadataRest.put("dc.title", new MetadataValueRest[]{title});
        comm.setMetadata(metadataRest);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/communities", (Object[])new Object[0]).param("parent", new String[]{"123"}).content(this.mapper.writeValueAsBytes((Object)comm)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    public void setUpAuthorizedSearch() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.topLevelCommunityAAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("topLevelCommunityAAdmin@my.edu").withPassword(this.password).build();
        this.topLevelCommunityA = CommunityBuilder.createCommunity((Context)this.context).withName("The name of this community is topLevelCommunityA").withAdminGroup(new EPerson[]{this.topLevelCommunityAAdmin}).build();
        this.subCommunityAAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("subCommunityAAdmin@my.edu").withPassword(this.password).build();
        this.subCommunityA = CommunityBuilder.createCommunity((Context)this.context).withName("The name of this sub-community is subCommunityA").withAdminGroup(new EPerson[]{this.subCommunityAAdmin}).addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.submitter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("submitter@my.edu").withPassword(this.password).build();
        this.collectionAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("collectionAdmin@my.edu").withPassword(this.password).build();
        this.collectionA = CollectionBuilder.createCollection((Context)this.context, (Community)this.subCommunityA).withName("The name of this collection is collectionA").withAdminGroup(new EPerson[]{this.collectionAdmin}).withSubmitterGroup(new EPerson[]{this.submitter}).build();
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)"true");
    }

    @Test
    public void testAdminAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").withAdminGroup(new EPerson[]{this.admin}).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchProperties(this.topLevelCommunityA.getName(), this.topLevelCommunityA.getID(), this.topLevelCommunityA.getHandle()), CommunityMatcher.matchProperties(this.subCommunityA.getName(), this.subCommunityA.getID(), this.subCommunityA.getHandle()), CommunityMatcher.matchProperties(this.communityB.getName(), this.communityB.getID(), this.communityB.getHandle()), CommunityMatcher.matchProperties(this.communityC.getName(), this.communityC.getID(), this.communityC.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchProperties(this.communityB.getName(), this.communityB.getID(), this.communityB.getHandle())})));
    }

    @Test
    public void testCommunityAdminAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").withAdminGroup(new EPerson[]{this.topLevelCommunityAAdmin}).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is named topLevelCommunityC").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.topLevelCommunityAAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchProperties(this.topLevelCommunityA.getName(), this.topLevelCommunityA.getID(), this.topLevelCommunityA.getHandle()), CommunityMatcher.matchProperties(this.subCommunityA.getName(), this.subCommunityA.getID(), this.subCommunityA.getHandle()), CommunityMatcher.matchProperties(this.communityB.getName(), this.communityB.getID(), this.communityB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchProperties(this.communityB.getName(), this.communityB.getID(), this.communityB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubCommunityAdminAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").addParentCommunity(this.context, this.topLevelCommunityA).withAdminGroup(new EPerson[]{this.subCommunityAAdmin}).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.subCommunityAAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchProperties(this.subCommunityA.getName(), this.subCommunityA.getID(), this.subCommunityA.getHandle()), CommunityMatcher.matchProperties(this.communityB.getName(), this.communityB.getID(), this.communityB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchProperties(this.communityB.getName(), this.communityB.getID(), this.communityB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCollectionAdminAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.collectionAdmin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubmitterAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.submitter.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfAdminGroupAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("adminSubGroup").withParent(this.groupService.findByName(this.context, "Administrator")).addMember(this.eperson).build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchProperties(this.topLevelCommunityA.getName(), this.topLevelCommunityA.getID(), this.topLevelCommunityA.getHandle()), CommunityMatcher.matchProperties(this.subCommunityA.getName(), this.subCommunityA.getID(), this.subCommunityA.getHandle()), CommunityMatcher.matchProperties(this.communityB.getName(), this.communityB.getID(), this.communityB.getHandle()), CommunityMatcher.matchProperties(this.communityC.getName(), this.communityC.getID(), this.communityC.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchProperties(this.communityB.getName(), this.communityB.getID(), this.communityB.getHandle())})));
    }

    @Test
    public void testSubGroupOfCommunityAdminGroupAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("communityAdminSubGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunityA.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)this.groupService.findByName(this.context, "COMMUNITY_" + this.topLevelCommunityA.getID() + "_ADMIN")).withDspaceObject((DSpaceObject)this.communityB).withAction(11).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchProperties(this.topLevelCommunityA.getName(), this.topLevelCommunityA.getID(), this.topLevelCommunityA.getHandle()), CommunityMatcher.matchProperties(this.subCommunityA.getName(), this.subCommunityA.getID(), this.subCommunityA.getHandle()), CommunityMatcher.matchProperties(this.communityB.getName(), this.communityB.getID(), this.communityB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchProperties(this.communityB.getName(), this.communityB.getID(), this.communityB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfSubCommunityAdminGroupAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("communityAdminSubGroup").withParent(this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunityA.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").addParentCommunity(this.context, this.topLevelCommunityA).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)this.groupService.findByName(this.context, "COMMUNITY_" + this.subCommunityA.getID() + "_ADMIN")).withDspaceObject((DSpaceObject)this.communityB).withAction(11).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchProperties(this.subCommunityA.getName(), this.subCommunityA.getID(), this.subCommunityA.getHandle()), CommunityMatcher.matchProperties(this.communityB.getName(), this.communityB.getID(), this.communityB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchProperties(this.communityB.getName(), this.communityB.getID(), this.communityB.getHandle())})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfCollectionAdminGroupAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("collectionAdminSubGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collectionA.getID() + "_ADMIN")).addMember(this.eperson).build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").addParentCommunity(this.context, this.topLevelCommunityA).build();
        Collection collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityB).withName("collectionB").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)this.groupService.findByName(this.context, "COLLECTION_" + this.collectionA.getID() + "_ADMIN")).withDspaceObject((DSpaceObject)collectionB).withAction(11).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testSubGroupOfSubmitterGroupAuthorizedSearch() throws Exception {
        this.setUpAuthorizedSearch();
        this.context.turnOffAuthorisationSystem();
        GroupBuilder.createGroup((Context)this.context).withName("collectionAdminSubGroup").withParent(this.groupService.findByName(this.context, "COLLECTION_" + this.collectionA.getID() + "_SUBMIT")).addMember(this.eperson).build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("topLevelCommunityB is a very original name").addParentCommunity(this.context, this.topLevelCommunityA).build();
        Collection collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityB).withName("collectionB").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)this.groupService.findByName(this.context, "COLLECTION_" + this.collectionA.getID() + "_SUBMIT")).withDspaceObject((DSpaceObject)collectionB).withAction(3).build();
        this.communityC = CommunityBuilder.createCommunity((Context)this.context).withName("the last community is topLevelCommunityC").addParentCommunity(this.context, this.topLevelCommunityA).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityB.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{this.communityC.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testAdminAuthorizedSearchUnauthenticated() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllSearchTopEmbeddedPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community 2").withLogo("SomeTest").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/top", (Object[])new Object[0]).param("size", new String[]{"1"}).param("embed", new String[]{"subcommunities"}).param("embed", new String[]{"collections"}).param("embed.size", new String[]{"subcommunities=1"}).param("embed.size", new String[]{"collections=1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.contains(CommunityMatcher.matchCommunity(this.parentCommunity)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities[0]._embedded.subcommunities._embedded.subcommunities", (Matcher)Matchers.contains(CommunityMatcher.matchCommunity(child1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities[0]._embedded.subcommunities._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID() + "/subcommunities?size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities[0]._embedded.subcommunities._links.next.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID() + "/subcommunities?page=1&size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities[0]._embedded.subcommunities._links.last.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID() + "/subcommunities?page=1&size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities[0]._embedded.collections._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollection(col)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities[0]._embedded.collections._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID() + "/collections?size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities[0]._embedded.collections._links.next.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID() + "/collections?page=1&size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities[0]._embedded.collections._links.last.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID() + "/collections?page=1&size=1")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities/search/top?size=1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.containsString((String)"/api/core/communities/search/top?page=0&size=1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"/api/core/communities/search/top?page=1&size=1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.containsString((String)"/api/core/communities/search/top?page=1&size=1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/top", (Object[])new Object[0]).param("size", new String[]{"1"}).param("embed", new String[]{"subcommunities"}).param("embed", new String[]{"collections"}).param("embed.size", new String[]{"subcommunities=2"}).param("embed.size", new String[]{"collections=2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.contains(CommunityMatcher.matchCommunity(this.parentCommunity)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities[0]._embedded.subcommunities._embedded.subcommunities", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CommunityMatcher.matchCommunity(child1), CommunityMatcher.matchCommunity(child2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities[0]._embedded.subcommunities._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID() + "/subcommunities?size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities[0]._embedded.collections._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollection(col), CollectionMatcher.matchCollection(col2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities[0]._embedded.collections._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/communities/" + this.parentCommunity.getID() + "/collections?size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/communities/search/top?size=1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.containsString((String)"/api/core/communities/search/top?page=0&size=1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"/api/core/communities/search/top?page=1&size=1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.containsString((String)"/api/core/communities/search/top?page=1&size=1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void removeComAdminGroupToCheckReindexingTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Root Community").build();
        Community subCommunity = CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("MyTestCom").withAdminGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{"MyTestCom"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.contains(CommunityMatcher.matchProperties(subCommunity.getName(), subCommunity.getID(), subCommunity.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/communities/" + subCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{"MyTestCom"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void addComAdminGroupToCheckReindexingTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Root Community").build();
        Community subCommunity = CommunityBuilder.createSubCommunity((Context)this.context, (Community)rootCommunity).withName("MyTestCom").build();
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{"MyTestCom"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        AtomicReference idRef = new AtomicReference();
        GroupRest groupRest = new GroupRest();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/communities/" + subCommunity.getID() + "/adminGroup"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + idRef.get() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + this.eperson.getID()));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/communities/search/findAdminAuthorized", (Object[])new Object[0]).param("query", new String[]{"MyTestCom"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.communities", (Matcher)Matchers.contains(CommunityMatcher.matchProperties(subCommunity.getName(), subCommunity.getID(), subCommunity.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }
}

