/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.UUID;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CorrectionTypeRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ItemService itemService;
    @Autowired
    private AuthorizeService authorizeService;

    @Test
    public void findAllAdminTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.correctiontypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.equalTo((Object)"request-withdrawn")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.topic", (Matcher)Matchers.equalTo((Object)"REQUEST/WITHDRAWN")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.equalTo((Object)"correctiontype"))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.equalTo((Object)"request-reinstate")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.topic", (Matcher)Matchers.equalTo((Object)"REQUEST/REINSTATE")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.equalTo((Object)"correctiontype")))})));
    }

    @Test
    public void findAllEPersonTest() throws Exception {
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.correctiontypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.equalTo((Object)"request-withdrawn")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.topic", (Matcher)Matchers.equalTo((Object)"REQUEST/WITHDRAWN")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.equalTo((Object)"correctiontype"))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.equalTo((Object)"request-reinstate")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.topic", (Matcher)Matchers.equalTo((Object)"REQUEST/REINSTATE")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.equalTo((Object)"correctiontype")))})));
    }

    @Test
    public void findAllUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneAdminTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/request-withdrawn", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.equalTo((Object)"request-withdrawn"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.topic", (Matcher)Matchers.equalTo((Object)"REQUEST/WITHDRAWN"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.equalTo((Object)"correctiontype")));
    }

    @Test
    public void findOneEPersonTest() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/request-withdrawn", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.equalTo((Object)"request-withdrawn"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.topic", (Matcher)Matchers.equalTo((Object)"REQUEST/WITHDRAWN"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.equalTo((Object)"correctiontype")));
    }

    @Test
    public void findOneUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/request-withdrawn", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneNotFoundTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/test", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findByItemWithoutUUIDParameterTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/search/findByItem", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findByItemNotFoundTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void findByItemUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).build();
        Item privateItem = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)privateItem);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{privateItem.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findByNotArchivedItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        item.setArchived(false);
        this.itemService.update(this.context, (DSpaceObject)item);
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{item.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByWithdrawnItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withdrawn().build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{item.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.correctiontypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.equalTo((Object)"request-reinstate")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.topic", (Matcher)Matchers.equalTo((Object)"REQUEST/REINSTATE")))})));
    }

    @Test
    public void findByNotDiscoverableItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        item.setDiscoverable(false);
        this.itemService.update(this.context, (DSpaceObject)item);
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{item.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.correctiontypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.equalTo((Object)"request-withdrawn")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.topic", (Matcher)Matchers.equalTo((Object)"REQUEST/WITHDRAWN")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.equalTo((Object)"correctiontype")))})));
    }

    @Test
    public void findByPersonalArchiveItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).build();
        Item itemOne = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{itemOne.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.correctiontypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.equalTo((Object)"request-withdrawn")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.topic", (Matcher)Matchers.equalTo((Object)"REQUEST/WITHDRAWN")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.equalTo((Object)"correctiontype")))})));
    }

    @Test
    public void findByItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{item.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.correctiontypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.equalTo((Object)"request-withdrawn")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.topic", (Matcher)Matchers.equalTo((Object)"REQUEST/WITHDRAWN")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.equalTo((Object)"correctiontype")))})));
    }

    @Test
    public void findByTopicWithoutTopicParameterTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/search/findByTopic", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findByWrongTopicTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"wrongValue"})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findByTopicAdminTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"REQUEST/WITHDRAWN"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.equalTo((Object)"request-withdrawn"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.topic", (Matcher)Matchers.equalTo((Object)"REQUEST/WITHDRAWN"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.equalTo((Object)"correctiontype")));
    }

    @Test
    public void findByTopicEPersonTest() throws Exception {
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"REQUEST/WITHDRAWN"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.equalTo((Object)"request-withdrawn"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.topic", (Matcher)Matchers.equalTo((Object)"REQUEST/WITHDRAWN"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.equalTo((Object)"correctiontype")));
    }

    @Test
    public void findByTopicUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/correctiontypes/search/findByTopic", (Object[])new Object[0]).param("topic", new String[]{"REQUEST/WITHDRAWN"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }
}

