/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.app.rest.AbstractLiveImportIntegrationTest;
import org.dspace.importer.external.datacite.DataCiteProjectImportMetadataSourceServiceImpl;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.liveimportclient.service.LiveImportClientImpl;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.kernel.ServiceManager;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class DataCiteProjectImportMetadataSourceServiceIT
extends AbstractLiveImportIntegrationTest {
    @Autowired
    private LiveImportClientImpl liveImportClientImpl;
    private DataCiteProjectImportMetadataSourceServiceImpl dataCiteProjectServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataCiteProjectImportMetadataGetRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ServiceManager serviceManager = DSpaceServicesFactory.getInstance().getServiceManager();
        this.dataCiteProjectServiceImpl = (DataCiteProjectImportMetadataSourceServiceImpl)serviceManager.getServiceByName("DataCiteProjectImportService", DataCiteProjectImportMetadataSourceServiceImpl.class);
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream dataCiteResp = ((Object)((Object)this)).getClass().getResourceAsStream("dataCiteProject-test.json");){
            String dataCiteRespXmlResp = IOUtils.toString((InputStream)dataCiteResp, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(dataCiteRespXmlResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            Collection recordsImported = this.dataCiteProjectServiceImpl.getRecords("10.60872/ror", 0, -1);
            Assert.assertEquals((long)1L, (long)recordsImported.size());
            this.matchRecords(new ArrayList<ImportRecord>(recordsImported), collection2match);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    private ArrayList<ImportRecord> getRecords() {
        ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
        ArrayList<MetadatumDTO> metadatums = new ArrayList<MetadatumDTO>();
        MetadatumDTO title = this.createMetadatumDTO("dc", "title", null, "Affiliations and Identifiers for Research Organizations (ROR)");
        MetadatumDTO title1 = this.createMetadatumDTO("dc", "title", null, "Identifying Organizations");
        MetadatumDTO projectidentifier = this.createMetadatumDTO("dc", "identifier", null, "10.60872/ror");
        MetadatumDTO contributor1 = this.createMetadatumDTO("project", "investigator", null, "Ted Habermann");
        MetadatumDTO description1 = this.createMetadatumDTO("dc", "description", null, "The Research Organization Registry (ROR) is a community-led project launched in January 2019 to develop an open, sustainable, usable, and unique identifier for every research organization in the world. Metadata Game Changers worked with Dryad in the first large-scale adoption of RORs by a repository. We connected to papers related to Dryad datasets, found affiliations from Crossref and other sources, searched the early ROR for identifiers, and added them to the Dryad metadata. Since that time, we have been involved in re-curating repositories to add RORs and other kinds of identifiers.");
        MetadatumDTO subject1 = this.createMetadatumDTO("dc", "subject", null, "ROR");
        MetadatumDTO subject2 = this.createMetadatumDTO("dc", "subject", null, "Research Organizations");
        MetadatumDTO subject3 = this.createMetadatumDTO("dc", "subject", null, "Identifiers");
        MetadatumDTO subject4 = this.createMetadatumDTO("dc", "subject", null, "Affiliations");
        MetadatumDTO subject5 = this.createMetadatumDTO("dc", "subject", null, "Metadata");
        metadatums.add(title);
        metadatums.add(title1);
        metadatums.add(projectidentifier);
        metadatums.add(contributor1);
        metadatums.add(description1);
        metadatums.add(subject1);
        metadatums.add(subject2);
        metadatums.add(subject3);
        metadatums.add(subject4);
        metadatums.add(subject5);
        ImportRecord firstRecord = new ImportRecord(metadatums);
        records.add(firstRecord);
        return records;
    }
}

