/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.UrlEscapers;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.Period;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.CharEncoding;
import org.apache.commons.io.IOUtils;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.model.Notification;
import org.dspace.app.rest.matcher.AppliedFilterMatcher;
import org.dspace.app.rest.matcher.FacetEntryMatcher;
import org.dspace.app.rest.matcher.FacetValueMatcher;
import org.dspace.app.rest.matcher.ItemMatcher;
import org.dspace.app.rest.matcher.PageMatcher;
import org.dspace.app.rest.matcher.SearchFilterMatcher;
import org.dspace.app.rest.matcher.SearchResultMatcher;
import org.dspace.app.rest.matcher.SortOptionMatcher;
import org.dspace.app.rest.matcher.WorkflowItemMatcher;
import org.dspace.app.rest.matcher.WorkspaceItemMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.ClaimedTaskBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.LDNMessageBuilder;
import org.dspace.builder.NotifyServiceBuilder;
import org.dspace.builder.PoolTaskBuilder;
import org.dspace.builder.SupervisionOrderBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.core.Context;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.supervision.SupervisionOrder;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class DiscoveryRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    MetadataAuthorityService metadataAuthorityService;
    @Autowired
    ChoiceAuthorityService choiceAuthorityService;
    @Autowired
    private ObjectMapper mapper;
    List<Matcher<? super Object>> customSidebarFacets = List.of();
    List<Matcher<? super Object>> customSearchFilters = List.of();
    List<Matcher<? super Object>> customSortFields = List.of();

    @Test
    public void rootDiscoverTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.facets.href", (Matcher)Matchers.containsString((String)"api/discover/facets"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.search.href", (Matcher)Matchers.containsString((String)"api/discover/search"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover")));
    }

    @Test
    public void discoverFacetsTestWithoutParameters() throws Exception {
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets)));
    }

    @Test
    public void discoverFacetsAuthorTestWithSizeParameter() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.is((Object)"text"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"api/discover/facets/author?page"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryAuthor("Doe, Jane"), FacetValueMatcher.entryAuthor("Smith, Maria")})));
    }

    @Test
    public void discoverFacetsAuthorWithAuthorityWithSizeParameter() throws Exception {
        this.configurationService.setProperty("choices.plugin.dc.contributor.author", (Object)"SolrAuthorAuthority");
        this.configurationService.setProperty("authority.controlled.dc.contributor.author", (Object)"true");
        this.metadataAuthorityService.clearCache();
        this.choiceAuthorityService.clearCache();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald", "test_authority", 600).withAuthor("Doe, John", "test_authority_2", 600).withSubject("History of religion").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria", "test_authority_3", 600).withAuthor("Doe, Jane", "test_authority_4", 600).withSubject("Church studies").withSubject("History of religion").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria", "test_authority_3", 600).withAuthor("Doe, Jane", "test_authority_4", 600).withAuthor("test, test", "test_authority_5", 600).withAuthor("test2, test2", "test_authority_6", 600).withAuthor("Maybe, Maybe", "test_authority_7", 600).withSubject("Missionary studies").withSubject("Church studies").withSubject("History of religion").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"api/discover/facets/author?page"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryAuthorWithAuthority("Doe, Jane", "test_authority_4", 2), FacetValueMatcher.entryAuthorWithAuthority("Smith, Maria", "test_authority_3", 2)})));
        DSpaceServicesFactory.getInstance().getConfigurationService().reloadConfig();
        this.metadataAuthorityService.clearCache();
        this.choiceAuthorityService.clearCache();
    }

    @Test
    public void discoverFacetsAuthorTestWithPrefix() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author?prefix=smith", (Object[])new Object[0]).param("size", new String[]{"10"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.is((Object)"text"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/author?prefix=smith"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 10)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryAuthor("Smith, Maria"), FacetValueMatcher.entryAuthor("Smith, Donald")})));
    }

    @Test
    public void discoverFacetsAuthorTestWithPrefix_Capital_And_Special_Chars() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, John").withAuthor("Jan, Doe").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("S\u2019Idan, Mo").withAuthor("Tick&Tock").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item 3").withIssueDate("2016-02-13").withAuthor("M Akai").withAuthor("stIjn, SmITH").build();
        Item publicItem4 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item 4").withIssueDate("2012-05-13").withSubject("St Augustine").build();
        Item publicItem5 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item 5").withIssueDate("2015-11-23").withSubject("Health & Medicine").build();
        Item publicItem6 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item 6").withIssueDate("2003-07-11").withSubject("1% economy").build();
        Item publicItem7 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item 7").withIssueDate("2008-12-31").withSubject("I.T.").build();
        Item publicItem8 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item 8").withIssueDate("2013-07-21").withSubject("?Unknown").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("prefix", new String[]{"Smith"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryFacetWithoutSelfLink("Smith, John"), FacetValueMatcher.entryFacetWithoutSelfLink("stIjn, SmITH")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("prefix", new String[]{"S"})).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryFacetWithoutSelfLink("Smith, John"), FacetValueMatcher.entryFacetWithoutSelfLink("S\u2019Idan, Mo"), FacetValueMatcher.entryFacetWithoutSelfLink("stIjn, SmITH"), FacetValueMatcher.entryFacetWithoutSelfLink("stIjn, SmITH")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("prefix", new String[]{"M A"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryFacetWithoutSelfLink("M Akai")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("prefix", new String[]{"S\u2019I"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryFacetWithoutSelfLink("S\u2019Idan, Mo")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("prefix", new String[]{"Jan, D"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryFacetWithoutSelfLink("Jan, Doe")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("prefix", new String[]{"Tick&"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryFacetWithoutSelfLink("Tick&Tock")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"St A"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryFacetWithoutSelfLink("St Augustine")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"Health & M"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryFacetWithoutSelfLink("Health & Medicine")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"1% e"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryFacetWithoutSelfLink("1% economy")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"I."})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryFacetWithoutSelfLink("I.T.")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"U"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryFacetWithoutSelfLink("?Unknown")})));
    }

    @Test
    public void discoverFacetsAuthorTestWithPrefixFirstName() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Parent Collection").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 1").withAuthor("Smith, John").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 2").withAuthor("Smith, Jane").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("prefix", new String[]{"john"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryAuthor("Smith, John")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("prefix", new String[]{"jane"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryAuthor("Smith, Jane")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("prefix", new String[]{"j"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryAuthor("Smith, John"), FacetValueMatcher.entryAuthor("Smith, Jane")})));
    }

    @Test
    public void discoverFacetsAuthorWithAuthorityTestWithPrefixFirstName() throws Exception {
        this.configurationService.setProperty("choices.plugin.dc.contributor.author", (Object)"SolrAuthorAuthority");
        this.configurationService.setProperty("authority.controlled.dc.contributor.author", (Object)"true");
        this.metadataAuthorityService.clearCache();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Parent Collection").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 1").withAuthor("Smith, John", "test_authority_1", 600).build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 2").withAuthor("Smith, Jane", "test_authority_2", 600).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("prefix", new String[]{"j"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryAuthorWithAuthority("Smith, John", "test_authority_1", 1), FacetValueMatcher.entryAuthorWithAuthority("Smith, Jane", "test_authority_2", 1)})));
        DSpaceServicesFactory.getInstance().getConfigurationService().reloadConfig();
        this.metadataAuthorityService.clearCache();
    }

    @Test
    public void discoverFacetsAuthorTestForHasMoreFalse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.is((Object)"text"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryAuthor("Doe, Jane"), FacetValueMatcher.entryAuthor("Smith, Maria"), FacetValueMatcher.entryAuthor("Doe, John"), FacetValueMatcher.entryAuthor("Smith, Donald")})));
    }

    @Test
    public void discoverFacetsAuthorTestForPagination() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Doe, John").withAuthor("Smith, Donald").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("size", new String[]{"2"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.is((Object)"text"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"api/discover/facets/author?page"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntry(1, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryAuthor("Doe, John"), FacetValueMatcher.entryAuthor("Smith, Donald")})));
    }

    @Test
    public void discoverFacetsTestWithSimpleQueryAndSearchFilter() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("f.title", new String[]{"test,contains"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.is((Object)"text"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"f.title=test,contains"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.appliedFilters", (Matcher)Matchers.contains(AppliedFilterMatcher.appliedFilterEntry("title", "contains", "test", "test")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryAuthor("Smith, Donald"), FacetValueMatcher.entryAuthor("Testing, Works")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryAuthor("Smith, Maria"), FacetValueMatcher.entryAuthor("Doe, Jane")}))));
    }

    @Test
    public void discoverFacetsDateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2000-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/dateIssued", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"dateIssued"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.is((Object)"date"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/dateIssued"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryDateIssued(), FacetValueMatcher.entryDateIssued()})));
    }

    @Test
    public void discoverFacetsTestWithScope() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("scope", new String[]{"testScope"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.is((Object)"text"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.scope", (Matcher)Matchers.is((Object)"testScope"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/author?scope=testScope"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryAuthor("Doe, Jane"), FacetValueMatcher.entryAuthor("Smith, Maria"), FacetValueMatcher.entryAuthor("Doe, John"), FacetValueMatcher.entryAuthor("Smith, Donald")})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("scope", new String[]{"testScope"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.is((Object)"text"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.scope", (Matcher)Matchers.is((Object)"testScope"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/author?scope=testScope"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"api/discover/facets/author?scope=testScope&page=1&size=2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryAuthor("Doe, Jane"), FacetValueMatcher.entryAuthor("Smith, Maria")})));
    }

    @Test
    public void discoverFacetsDateTestForHasMore() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("1940-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem4 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("1950-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem5 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("1960-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem6 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("1970-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem7 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("1980-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/dateIssued", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"dateIssued"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.is((Object)"date"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/dateIssued"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"api/discover/facets/dateIssued?page"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryDateIssued(), FacetValueMatcher.entryDateIssued()})));
    }

    @Test
    public void discoverFacetsDateTestWithSearchFilter() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/dateIssued", (Object[])new Object[0]).param("f.title", new String[]{"test,contains"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"dateIssued"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.is((Object)"date"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/dateIssued"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.appliedFilters", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AppliedFilterMatcher.appliedFilterEntry("title", "contains", "test", "test")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryDateIssuedWithCountOne(), FacetValueMatcher.entryDateIssuedWithCountOne()})));
    }

    @Test
    public void discoverSearchTest() throws Exception {
        ArrayList<Matcher<? super Object>> allExpectedSearchFilters = new ArrayList<Matcher<? super Object>>(this.customSearchFilters);
        allExpectedSearchFilters.addAll(List.of(SearchFilterMatcher.titleFilter(), SearchFilterMatcher.authorFilter(), SearchFilterMatcher.subjectFilter(), SearchFilterMatcher.dateIssuedFilter(), SearchFilterMatcher.hasContentInOriginalBundleFilter(), SearchFilterMatcher.hasFileNameInOriginalBundleFilter(), SearchFilterMatcher.hasFileDescriptionInOriginalBundleFilter(), SearchFilterMatcher.hasGeospatialMetadataFilter(), SearchFilterMatcher.entityTypeFilter(), SearchFilterMatcher.accessStatusFilter(), SearchFilterMatcher.isAuthorOfPublicationRelation(), SearchFilterMatcher.isProjectOfPublicationRelation(), SearchFilterMatcher.isOrgUnitOfPublicationRelation(), SearchFilterMatcher.isPublicationOfJournalIssueRelation(), SearchFilterMatcher.isJournalOfPublicationRelation(), SearchFilterMatcher.pointFilter()));
        ArrayList<Matcher<? super Object>> allExpectedSortFields = new ArrayList<Matcher<? super Object>>(this.customSortFields);
        allExpectedSortFields.addAll(List.of(SortOptionMatcher.sortOptionMatcher("score", DiscoverySortFieldConfiguration.SORT_ORDER.desc.name()), SortOptionMatcher.sortOptionMatcher("dc.title", DiscoverySortFieldConfiguration.SORT_ORDER.asc.name()), SortOptionMatcher.sortOptionMatcher("dc.date.issued", DiscoverySortFieldConfiguration.SORT_ORDER.desc.name()), SortOptionMatcher.sortOptionMatcher("dc.date.accessioned", DiscoverySortFieldConfiguration.SORT_ORDER.desc.name())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.objects.href", (Matcher)Matchers.containsString((String)"api/discover/search/objects"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/search"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.filters", (Matcher)Matchers.containsInAnyOrder(allExpectedSearchFilters))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sortOptions", (Matcher)Matchers.contains(allExpectedSortFields)));
    }

    @Test
    public void checkSortOrderInPersonOrOrgunitConfigurationTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search", (Object[])new Object[0]).param("configuration", new String[]{"personOrOrgunit"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.objects.href", (Matcher)Matchers.containsString((String)"api/discover/search/objects"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/search"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sortOptions", (Matcher)Matchers.contains((Matcher[])new Matcher[]{SortOptionMatcher.sortOptionMatcher("dspace.entity.type", DiscoverySortFieldConfiguration.SORT_ORDER.desc.name()), SortOptionMatcher.sortOptionMatcher("organization.legalName", DiscoverySortFieldConfiguration.SORT_ORDER.asc.name()), SortOptionMatcher.sortOptionMatcher("organization.address.addressCountry", DiscoverySortFieldConfiguration.SORT_ORDER.asc.name()), SortOptionMatcher.sortOptionMatcher("organization.address.addressLocality", DiscoverySortFieldConfiguration.SORT_ORDER.asc.name()), SortOptionMatcher.sortOptionMatcher("organization.foundingDate", DiscoverySortFieldConfiguration.SORT_ORDER.desc.name()), SortOptionMatcher.sortOptionMatcher("dc.date.accessioned", DiscoverySortFieldConfiguration.SORT_ORDER.desc.name()), SortOptionMatcher.sortOptionMatcher("person.familyName", DiscoverySortFieldConfiguration.SORT_ORDER.asc.name()), SortOptionMatcher.sortOptionMatcher("person.givenName", DiscoverySortFieldConfiguration.SORT_ORDER.asc.name()), SortOptionMatcher.sortOptionMatcher("person.birthDate", DiscoverySortFieldConfiguration.SORT_ORDER.desc.name())})));
    }

    @Test
    public void discoverSearchByFieldNotConfiguredTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("sort", new String[]{"dc.date.accessioned, ASC"}).param("configuration", new String[]{"workspace"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void discoverSearchObjectsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 7)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match(), SearchResultMatcher.match(), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsWithSpecialCharacterTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).build();
        ItemBuilder.createItem((Context)this.context, (Collection)collection).withAuthor("DSpace & friends").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("sort", new String[]{"score,DESC"}).param("page", new String[]{"0"}).param("size", new String[]{"10"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"author")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.values", (Matcher)Matchers.hasItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.search.href", (Matcher)Matchers.containsString((String)"DSpace%20%26%20friends"))))))));
    }

    @Test
    public void discoverSearchBrowsesWithSpecialCharacterTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).build();
        ItemBuilder.createItem((Context)this.context, (Collection)collection).withAuthor("DSpace & friends").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/browses/author/entries", (Object[])new Object[0]).param("sort", new String[]{"default,ASC"}).param("page", new String[]{"0"}).param("size", new String[]{"20"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)"DSpace & friends")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.items.href", (Matcher)Matchers.containsString((String)"DSpace%20%26%20friends"))))));
    }

    @Test
    public void discoverSearchObjectsTestHasMoreAuthorFacet() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withAuthor("a1, a1").withAuthor("b, b").withAuthor("c, c").withAuthor("d, d").withAuthor("e, e").withAuthor("f, f").withAuthor("g, g").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(true), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 7)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match(), SearchResultMatcher.match(), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestHasMoreSubjectFacet() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").withSubject("a").withSubject("b").withSubject("c").withSubject("d").withSubject("e").withSubject("f").withSubject("g").withSubject("h").withSubject("i").withSubject("j").withSubject("k").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(true), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 7)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match(), SearchResultMatcher.match(), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestWithBasicQuery() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("f.title", new String[]{"test,contains"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.appliedFilters", (Matcher)Matchers.contains(AppliedFilterMatcher.appliedFilterEntry("title", "contains", "test", "test")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("query", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("query", new String[]{"test:"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void discoverSearchObjectsTestWithInvalidSolrQuery() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("query", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("query", new String[]{"test:"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void discoverSearchObjectsTestWithScope() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("scope", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 7)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.scope", (Matcher)Matchers.is((Object)"test"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match(), SearchResultMatcher.match(), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestWithDsoType() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacetsWithDsoTypeItem = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacetsWithDsoTypeItem.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("dsoType", new String[]{"Item"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacetsWithDsoTypeItem))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacetsWithDsoTypesComCol = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacetsWithDsoTypesComCol.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("dsoType", new String[]{"Community"}).param("dsoType", new String[]{"Collection"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 4)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match("core", "collection", "collections"), SearchResultMatcher.match("core", "collection", "collections")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacetsWithDsoTypesComCol))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacetsWithDsoTypesColItem = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacetsWithDsoTypesColItem.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("dsoType", new String[]{"Collection"}).param("dsoType", new String[]{"Item"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 5)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.match("core", "collection", "collections"), SearchResultMatcher.match("core", "collection", "collections"), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacetsWithDsoTypesColItem))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacetsWithDsoTypesComColItem = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacetsWithDsoTypesComColItem.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("dsoType", new String[]{"Community"}).param("dsoType", new String[]{"Collection"}).param("dsoType", new String[]{"Item"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 7)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match("core", "collection", "collections"), SearchResultMatcher.match("core", "collection", "collections"), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacetsWithDsoTypesComColItem))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestWithDsoTypeAndSort() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Testing").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("dsoType", new String[]{"Item"}).param("sort", new String[]{"dc.title,ASC"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.contains((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Public"), SearchResultMatcher.matchOnItemName("item", "items", "Test"), SearchResultMatcher.matchOnItemName("item", "items", "Testing")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sort", (Matcher)Matchers.is(SortOptionMatcher.sortByAndOrder("dc.title", "ASC")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    @Ignore
    public void discoverFacetsDateTestWithLabels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem6 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public").withIssueDate("2017-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem7 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem8 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem9 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public").withIssueDate("1970-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem10 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public").withIssueDate("1950-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem11 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public").withIssueDate("1930-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem12 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public").withIssueDate("1910-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem13 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public").withIssueDate("1890-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem14 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public").withIssueDate("1866-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/dateIssued", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entryDateIssuedWithLabel("2000 - 2017"), FacetValueMatcher.entryDateIssuedWithLabel("1980 - 1999"), FacetValueMatcher.entryDateIssuedWithLabel("1960 - 1979"), FacetValueMatcher.entryDateIssuedWithLabel("1940 - 1959"), FacetValueMatcher.entryDateIssuedWithLabel("1920 - 1939"), FacetValueMatcher.entryDateIssuedWithLabel("1880 - 1899"), FacetValueMatcher.entryDateIssuedWithLabel("1866 - 1879"), FacetValueMatcher.entryDateIssuedWithLabel("1900 - 1919")})));
    }

    @Test
    public void discoverSearchObjectsTestForPaginationAndNextLinks() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("t, t").withAuthor("t, y").withAuthor("t, r").withAuthor("t, e").withAuthor("t, z").withAuthor("t, a").withAuthor("t, tq").withAuthor("t, ts").withAuthor("t, td").withAuthor("t, tf").withAuthor("t, tg").withAuthor("t, th").withAuthor("t, tj").withAuthor("t, tk").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").withSubject("a").withSubject("b").withSubject("c").withSubject("d").withSubject("e").withSubject("f").withSubject("g").withSubject("h").withSubject("i").withSubject("j").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(true), FacetEntryMatcher.subjectFacet(true), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("size", new String[]{"2"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(1, 2, 4, 7)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.match(), SearchResultMatcher.match()}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestWithContentInABitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Bitstream bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withMimeType("text/plain").build();
        }
        this.runDSpaceScript(new String[]{"filter-media", "-f", "-i", publicItem1.getHandle()});
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("query", new String[]{"ThisIsSomeDummyText"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.contains(SearchResultMatcher.matchOnItemName("item", "items", "Test")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestForEmbargoedItemsAndPrivateItems() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").makeUnDiscoverable().build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Embargoed item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").withEmbargoPeriod(Period.ofMonths(12)).build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 5)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match(), SearchResultMatcher.match(), SearchResultMatcher.matchOnItemName("item", "items", "Test")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.not((Matcher)Matchers.anyOf(SearchResultMatcher.matchOnItemName("item", "items", "Test 2"), SearchResultMatcher.matchOnItemName("item", "items", "Embargoed item 2"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    @Ignore
    public void discoverSearchObjectsTestWithContentInAPrivateBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Group internalGroup = GroupBuilder.createGroup((Context)this.context).withName("Internal Group").build();
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Bitstream bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("Test Private Bitstream").withMimeType("text/plain").withReaderGroup(internalGroup).build();
        }
        this.runDSpaceScript(new String[]{"filter-media", "-f", "-i", publicItem1.getHandle()});
        this.context.restoreAuthSystemState();
        this.context.setCurrentUser(null);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("query", new String[]{"ThisIsSomeDummyText"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.object", (Matcher)Matchers.not((Matcher)Matchers.contains(SearchResultMatcher.matchOnItemName("item", "items", "Test"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestForScope() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        UUID scope = col2.getID();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(scope)})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.scope", (Matcher)Matchers.is((Object)String.valueOf(scope)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Test 2"), SearchResultMatcher.matchOnItemName("item", "items", "Public item 2")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestForScopeWithPrivateItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        UUID scope = col2.getID();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("scope", new String[]{String.valueOf(scope)})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.scope", (Matcher)Matchers.is((Object)String.valueOf(scope)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.contains(SearchResultMatcher.matchOnItemName("item", "items", "Test 2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.not((Matcher)Matchers.contains(SearchResultMatcher.matchOnItemName("item", "items", "Public item 2"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestForWorkspaceItemInCollectionScope() throws Exception {
        this.context.setCurrentUser(this.eperson);
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        Collection collection1 = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection 1").build();
        Collection collection2 = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection 2").build();
        WorkspaceItem wsi1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection1).withTitle("Workspace Item 1").build();
        WorkspaceItem wsi2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection2).withTitle("Workspace Item 2").build();
        this.context.restoreAuthSystemState();
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workspace"}).param("scope", new String[]{collection1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.scope", (Matcher)Matchers.is((Object)collection1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.allOf((Matcher)Matchers.hasSize((int)1), (Matcher)JsonPathMatchers.hasJsonPath((String)"$[0]._embedded.indexableObject", WorkspaceItemMatcher.matchProperties(wsi1)))));
    }

    @Test
    public void discoverSearchObjectsTestForWorkflowItemInCollectionScope() throws Exception {
        this.context.setCurrentUser(this.eperson);
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        Collection collection1 = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        Collection collection2 = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        XmlWorkflowItem wfi1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)collection1).withTitle("Workflow Item 1").build();
        XmlWorkflowItem wfi2 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)collection2).withTitle("Workflow Item 2").build();
        this.context.restoreAuthSystemState();
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workspace"}).param("scope", new String[]{collection1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.scope", (Matcher)Matchers.is((Object)collection1.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.allOf((Matcher)Matchers.hasSize((int)1), (Matcher)JsonPathMatchers.hasJsonPath((String)"$[0]._embedded.indexableObject", WorkflowItemMatcher.matchProperties(wfi1)))));
    }

    @Test
    public void discoverSearchObjectsTestForHitHighlights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String query = "Public";
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("query", new String[]{query})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.contains(SearchResultMatcher.matchOnItemNameAndHitHighlight("item", "items", "Public item 2", query, "dc.title")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestForHitHighlightsWithPrivateItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String query = "Public";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("query", new String[]{query})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.not((Matcher)Matchers.contains(SearchResultMatcher.matchOnItemNameAndHitHighlight("item", "items", "Public item 2", query, "dc.title"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsWithQueryOperatorContains_query() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("f.title", new String[]{"test*,query"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Test"), SearchResultMatcher.matchOnItemName("item", "items", "Test 2")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsWithQueryOperatorContains() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("f.title", new String[]{"test,contains"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Test"), SearchResultMatcher.matchOnItemName("item", "items", "Test 2")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsWithQueryOperatorNotContains_query() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("f.title", new String[]{"-test*,query"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.hasItem(SearchResultMatcher.matchOnItemName("item", "items", "Public item 2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsWithQueryOperatorNotContains() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("f.title", new String[]{"test,notcontains"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.hasItem(SearchResultMatcher.matchOnItemName("item", "items", "Public item 2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestForMinMaxValues() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("t, t").withAuthor("t, y").withAuthor("t, r").withAuthor("t, e").withAuthor("t, z").withAuthor("t, a").withAuthor("t, tq").withAuthor("t, ts").withAuthor("t, td").withAuthor("t, tf").withAuthor("t, tg").withAuthor("t, th").withAuthor("t, tj").withAuthor("t, tk").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").withSubject("a").withSubject("b").withSubject("c").withSubject("d").withSubject("e").withSubject("f").withSubject("g").withSubject("h").withSubject("i").withSubject("j").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacetWithMinMax(true, "Doe, Jane", "Testing, Works"), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(true), FacetEntryMatcher.dateIssuedFacetWithMinMax(false, "1990-02-13", "2010-10-17"), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("size", new String[]{"2"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(1, 2, 4, 7)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.match(), SearchResultMatcher.match()}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchFacetsTestForMinMaxValues() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("t, t").withAuthor("t, y").withAuthor("t, r").withAuthor("t, e").withAuthor("t, z").withAuthor("t, a").withAuthor("t, tq").withAuthor("t, ts").withAuthor("t, td").withAuthor("t, tf").withAuthor("t, tg").withAuthor("t, th").withAuthor("t, tj").withAuthor("t, tk").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").withSubject("a").withSubject("b").withSubject("c").withSubject("d").withSubject("e").withSubject("f").withSubject("g").withSubject("h").withSubject("i").withSubject("j").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacetWithMinMax(true, "Doe, Jane", "Testing, Works"), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(true), FacetEntryMatcher.dateIssuedFacetWithMinMax(false, "1990-02-13", "2010-10-17"), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/facets", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/facets")));
    }

    @Test
    public void discoverSearchObjectsWithQueryOperatorEquals_query() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("f.title", new String[]{"Test,query"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Test")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsWithQueryOperatorEquals() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("f.title", new String[]{"Test,equals"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Test")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsWithQueryOperatorNotEquals_query() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("f.title", new String[]{"-Test,query"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Test 2"), SearchResultMatcher.matchOnItemName("item", "items", "Public item 2")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsWithQueryOperatorNotEquals() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("f.title", new String[]{"Test,notequals"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Test 2"), SearchResultMatcher.matchOnItemName("item", "items", "Public item 2")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsWithQueryOperatorNotAuthority_query() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("f.title", new String[]{"-id:test,query"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.hasItem(SearchResultMatcher.matchOnItemName("item", "items", "Public item 2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsWithQueryOperatorNotAuthority() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("f.title", new String[]{"test,notauthority"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.hasItem(SearchResultMatcher.matchOnItemName("item", "items", "Public item 2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsWithMissingQueryOperator() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("f.title", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void discoverSearchObjectsWithNotValidQueryOperator() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("f.title", new String[]{"test,operator"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void discoverSearchObjectsTestWithDateIssuedQueryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            Bitstream bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withMimeType("text/plain").build();
        }
        this.runDSpaceScript(new String[]{"filter-media", "-f", "-i", publicItem1.getHandle()});
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("query", new String[]{"dc.date.issued:\"2010-02-13\""})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.contains(SearchResultMatcher.matchOnItemName("item", "items", "Public item 2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("query", new String[]{"dc.date.issued:\"2013-02-13\""})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 0, 0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestWithLuceneSyntaxQueryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("TestItem2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("azeazeazeazeazeaze").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("query", new String[]{"((dc.date.issued:2010 OR dc.date.issued:1990-02-13) AND (dc.title:Test OR dc.title:TestItem2))"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Test"), SearchResultMatcher.matchOnItemName("item", "items", "TestItem2")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.not((Matcher)Matchers.contains(SearchResultMatcher.matchOnItemName("item", "items", "azeazeazeazeazeaze"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestWithEscapedLuceneCharactersTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Faithful Infidel: Exploring Conformity (2nd edition)").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("NotAProperTestTitle").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("query", new String[]{"\"Faithful Infidel: Exploring Conformity (2nd edition)\""})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.contains(SearchResultMatcher.matchOnItemName("item", "items", "Faithful Infidel: Exploring Conformity (2nd edition)")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Test"), SearchResultMatcher.matchOnItemName("item", "items", "NotAProperTestTitle")})))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestWithUnEscapedLuceneCharactersTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Faithful Infidel: Exploring Conformity (2nd edition)").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("NotAProperTestTitle").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("query", new String[]{"OR"})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void discoverSearchObjectsWithInProgressSubmissionTest() throws Exception {
        String[] tokens;
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.setCurrentUser(this.eperson);
        WorkspaceItem wsItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").build();
        WorkspaceItem wsItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Workspace Item 2").build();
        XmlWorkflowItem wfItem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 1").build();
        ClaimedTask cTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)this.admin).withTitle("Claimed Item").build();
        this.context.setCurrentUser(this.admin);
        WorkspaceItem wsItem1Admin = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Admin Workspace Item 1").build();
        WorkspaceItem wsItem2Admin = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Admin Workspace Item 2").build();
        XmlWorkflowItem wfItem1Admin = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Admin Workflow Item 1").build();
        this.context.restoreAuthSystemState();
        ArrayList<Matcher<? super Object>> allExpectedSidebarFacets = new ArrayList<Matcher<? super Object>>(this.customSidebarFacets);
        allExpectedSidebarFacets.addAll(List.of(FacetEntryMatcher.authorFacet(false), FacetEntryMatcher.subjectFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.hasContentInOriginalBundleFacet(false), FacetEntryMatcher.entityTypeFacet(false), FacetEntryMatcher.accessStatusFacet(false)));
        for (String token : tokens = new String[]{null, this.getAuthToken(this.eperson.getEmail(), this.password), this.getAuthToken(this.admin.getEmail(), this.password)}) {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 7)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match("core", "community", "communities"), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match("core", "item", "items"), SearchResultMatcher.match(), SearchResultMatcher.match()}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder(allExpectedSidebarFacets))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        }
    }

    @Test
    public void discoverSearchObjectsWorkspaceConfigurationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item from submitter").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        WorkspaceItem wsItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2010-07-23").build();
        WorkspaceItem wsItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Workspace Item 2").withIssueDate("2010-11-03").build();
        XmlWorkflowItem wfItem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 1").withIssueDate("2010-11-03").build();
        ClaimedTask cTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)this.admin).withTitle("Claimed Item").withIssueDate("2010-11-03").build();
        this.context.setCurrentUser(this.admin);
        WorkspaceItem wsItem1Admin = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withIssueDate("2010-07-23").withTitle("Admin Workspace Item 1").build();
        WorkspaceItem wsItem2Admin = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withIssueDate("2010-11-03").withTitle("Admin Workspace Item 2").build();
        XmlWorkflowItem wfItem1Admin = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withIssueDate("2010-11-03").withTitle("Admin Workflow Item 1").build();
        this.context.restoreAuthSystemState();
        String submitterToken = this.getAuthToken(submitter.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workspace"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 5)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf(SearchResultMatcher.match("core", "item", "items"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is(ItemMatcher.matchItemWithTitleAndDateIssued(publicItem3, "Public item from submitter", "2010-02-13")))), Matchers.allOf(SearchResultMatcher.match("submission", "workspaceitem", "workspaceitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(wsItem1, "Workspace Item 1", "2010-07-23")))), Matchers.allOf(SearchResultMatcher.match("submission", "workspaceitem", "workspaceitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(wsItem2, "Workspace Item 2", "2010-11-03")))), Matchers.allOf(SearchResultMatcher.match("workflow", "workflowitem", "workflowitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(wfItem1, "Workflow Item 1", "2010-11-03")))), Matchers.allOf(SearchResultMatcher.match("workflow", "workflowitem", "workflowitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(cTask.getWorkflowItem(), "Claimed Item", "2010-11-03"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetEntryMatcher.resourceTypeFacet(false), FacetEntryMatcher.typeFacet(false), FacetEntryMatcher.dateIssuedFacet(false)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workspace"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf(SearchResultMatcher.match("submission", "workspaceitem", "workspaceitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(wsItem1Admin, "Admin Workspace Item 1", "2010-07-23")))), Matchers.allOf(SearchResultMatcher.match("submission", "workspaceitem", "workspaceitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(wsItem2Admin, "Admin Workspace Item 2", "2010-11-03")))), Matchers.allOf(SearchResultMatcher.match("workflow", "workflowitem", "workflowitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(wfItem1Admin, "Admin Workflow Item 1", "2010-11-03"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetEntryMatcher.resourceTypeFacet(false), FacetEntryMatcher.typeFacet(false), FacetEntryMatcher.dateIssuedFacet(false)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsWorkflowConfigurationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{this.admin, reviewer1}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.setCurrentUser(this.eperson);
        WorkspaceItem wsItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2010-07-23").build();
        WorkspaceItem wsItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Workspace Item 2").withIssueDate("2010-11-03").build();
        XmlWorkflowItem wfItem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 1").withIssueDate("2010-11-03").build();
        ClaimedTask cTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)this.admin).withTitle("Claimed Item").withIssueDate("2010-11-03").build();
        this.context.setCurrentUser(this.admin);
        WorkspaceItem wsItem1Admin = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withIssueDate("2010-07-23").withTitle("Admin Workspace Item 1").build();
        WorkspaceItem wsItem2Admin = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withIssueDate("2010-11-03").withTitle("Admin Workspace Item 2").build();
        XmlWorkflowItem wfItem1Admin = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withIssueDate("2010-11-03").withTitle("Admin Workflow Item 1").build();
        ClaimedTask cTask2 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)this.admin).withTitle("Pool Step2 Item").withIssueDate("2010-11-04").build();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + cTask2.getID()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.context.restoreAuthSystemState();
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workflow"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 0, 0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workflow"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf(SearchResultMatcher.match("workflow", "pooltask", "pooltasks"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Workflow Item 1", "2010-11-03")))), Matchers.allOf(SearchResultMatcher.match("workflow", "pooltask", "pooltasks"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Admin Workflow Item 1", "2010-11-03"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetEntryMatcher.resourceTypeFacet(false), FacetEntryMatcher.typeFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.submitterFacet(false)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workflow"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf(SearchResultMatcher.match("workflow", "pooltask", "pooltasks"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Workflow Item 1", "2010-11-03")))), Matchers.allOf(SearchResultMatcher.match("workflow", "pooltask", "pooltasks"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Admin Workflow Item 1", "2010-11-03")))), Matchers.allOf(SearchResultMatcher.match("workflow", "claimedtask", "claimedtask"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Claimed Item", "2010-11-03"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetEntryMatcher.resourceTypeFacet(false), FacetEntryMatcher.typeFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.submitterFacet(false)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workflow"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf(SearchResultMatcher.match("workflow", "pooltask", "pooltasks"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Pool Step2 Item", "2010-11-04"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetEntryMatcher.resourceTypeFacet(false), FacetEntryMatcher.typeFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.submitterFacet(false)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsWorkflowAdminConfigurationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{this.admin, reviewer1}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.setCurrentUser(this.eperson);
        WorkspaceItem wsItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2010-07-23").build();
        WorkspaceItem wsItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Workspace Item 2").withIssueDate("2010-11-03").build();
        XmlWorkflowItem wfItem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 1").withIssueDate("2010-11-03").build();
        ClaimedTask cTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)this.admin).withTitle("Claimed Item").withIssueDate("2010-11-03").build();
        this.context.setCurrentUser(this.admin);
        WorkspaceItem wsItem1Admin = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withIssueDate("2010-07-23").withTitle("Admin Workspace Item 1").build();
        WorkspaceItem wsItem2Admin = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withIssueDate("2010-11-03").withTitle("Admin Workspace Item 2").build();
        XmlWorkflowItem wfItem1Admin = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withIssueDate("2010-11-03").withTitle("Admin Workflow Item 1").build();
        ClaimedTask cTask2 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)this.admin).withTitle("Pool Step2 Item").withIssueDate("2010-11-04").build();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + cTask2.getID()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.context.restoreAuthSystemState();
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workflowAdmin"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 0, 0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workflowAdmin"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 0, 0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workflowAdmin"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 4)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf(SearchResultMatcher.match("workflow", "workflowitem", "workflowitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Workflow Item 1", "2010-11-03")))), Matchers.allOf(SearchResultMatcher.match("workflow", "workflowitem", "workflowitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Admin Workflow Item 1", "2010-11-03")))), Matchers.allOf(SearchResultMatcher.match("workflow", "workflowitem", "workflowitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Pool Step2 Item", "2010-11-04")))), Matchers.allOf(SearchResultMatcher.match("workflow", "workflowitem", "workflowitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Claimed Item", "2010-11-03"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetEntryMatcher.resourceTypeFacet(false), FacetEntryMatcher.typeFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.submitterFacet(false)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workflowAdmin"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 0, 0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestForWithdrawnOrPrivateItemsNonAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("WithdrawnTest 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("ExtraEntry").withdrawn().build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private Test item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String query = "Test";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"undiscoverable"}).param("query", new String[]{query})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.empty())).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestForWithdrawnOrPrivateItemsByAdminUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("ExtraEntry").withdrawn().build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private Test item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String query = "Test";
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"undiscoverable"}).param("query", new String[]{query})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Private Test item 2"), SearchResultMatcher.matchOnItemName("item", "items", "Withdrawn Test 2")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestForAdministrativeViewAnonymous() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public Test Item").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn Test Item").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("ExtraEntry").withdrawn().build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private Test Item").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("query", new String[]{"Test"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.contains(SearchResultMatcher.matchOnItemName("item", "items", "Public Test Item")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestForAdministrativeViewEPerson() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public Test Item").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn Test Item").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("ExtraEntry").withdrawn().build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private Test Item").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("query", new String[]{"Test"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.contains(SearchResultMatcher.matchOnItemName("item", "items", "Public Test Item")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestForAdministrativeViewAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public Test Item").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn Test Item").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("ExtraEntry").withdrawn().build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private Test Item").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("query", new String[]{"Test"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Public Test Item"), SearchResultMatcher.matchOnItemName("item", "items", "Withdrawn Test Item"), SearchResultMatcher.matchOnItemName("item", "items", "Private Test Item")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"discoverable")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.values", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.label", (Matcher)Matchers.is((Object)"true")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.count", (Matcher)Matchers.is((Object)2))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.label", (Matcher)Matchers.is((Object)"false")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.count", (Matcher)Matchers.is((Object)1)))}))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"withdrawn")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.values", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.label", (Matcher)Matchers.is((Object)"true")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.count", (Matcher)Matchers.is((Object)1))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.label", (Matcher)Matchers.is((Object)"false")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.count", (Matcher)Matchers.is((Object)2)))})))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestForAdministrativeViewWithFilters() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public Test Item").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn Test Item").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("ExtraEntry").withdrawn().build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private Test Item").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("query", new String[]{"Test"}).param("f.withdrawn", new String[]{"true,contains"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.contains(SearchResultMatcher.matchOnItemName("item", "items", "Withdrawn Test Item")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("query", new String[]{"Test"}).param("f.withdrawn", new String[]{"false,contains"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Public Test Item"), SearchResultMatcher.matchOnItemName("item", "items", "Private Test Item")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("query", new String[]{"Test"}).param("f.discoverable", new String[]{"true,contains"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Public Test Item"), SearchResultMatcher.matchOnItemName("item", "items", "Withdrawn Test Item")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("query", new String[]{"Test"}).param("f.discoverable", new String[]{"false,contains"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.contains(SearchResultMatcher.matchOnItemName("item", "items", "Private Test Item")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsTestForAdministrativeViewWithFiltersEquals() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public Test Item").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn Test Item").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("ExtraEntry").withdrawn().build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private Test Item").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("query", new String[]{"Test"}).param("f.withdrawn", new String[]{"true,equals"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.contains(SearchResultMatcher.matchOnItemName("item", "items", "Withdrawn Test Item")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("query", new String[]{"Test"}).param("f.withdrawn", new String[]{"false,equals"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Public Test Item"), SearchResultMatcher.matchOnItemName("item", "items", "Private Test Item")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("query", new String[]{"Test"}).param("f.discoverable", new String[]{"true,equals"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchOnItemName("item", "items", "Public Test Item"), SearchResultMatcher.matchOnItemName("item", "items", "Withdrawn Test Item")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("query", new String[]{"Test"}).param("f.discoverable", new String[]{"false,equals"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.contains(SearchResultMatcher.matchOnItemName("item", "items", "Private Test Item")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchPoolTaskObjectsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer, this.admin}).build();
        ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Punnett square").withIssueDate("2016-02-13").withAuthor("Bandola, Roman").withSubject("ExtraEntry").build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col, (EPerson)reviewer).withTitle("Metaphysics").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col, (EPerson)reviewer).withTitle("Mathematical Theory").withIssueDate("2020-01-19").withAuthor("Tommaso, Gattari").withSubject("ExtraEntry").build();
        PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col, (EPerson)reviewer).withTitle("Test Metaphysics").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workflow"}).param("sort", new String[]{"dc.date.issued,DESC"}).param("query", new String[]{"Mathematical Theory"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.query", (Matcher)Matchers.is((Object)"Mathematical Theory"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.configuration", (Matcher)Matchers.is((Object)"workflow"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.contains(SearchResultMatcher.match("workflow", "pooltask", "pooltasks")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workflow"}).param("sort", new String[]{"dc.date.issued,DESC"}).param("query", new String[]{"Metaphysics"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.query", (Matcher)Matchers.is((Object)"Metaphysics"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.configuration", (Matcher)Matchers.is((Object)"workflow"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.match("workflow", "pooltask", "pooltasks"), SearchResultMatcher.match("workflow", "pooltask", "pooltasks")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void discoverSearchPoolTaskObjectsEmptyQueryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer, this.admin}).build();
        ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Punnett square").withIssueDate("2016-02-13").withAuthor("Bandola, Roman").withSubject("ExtraEntry").build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col, (EPerson)reviewer).withTitle("Metaphysics").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col, (EPerson)reviewer).withTitle("Mathematical Theory").withIssueDate("2020-01-19").withAuthor("Tommaso, Gattari").withSubject("ExtraEntry").build();
        PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col, (EPerson)reviewer).withTitle("Test Metaphysics").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"workflow"}).param("sort", new String[]{"dc.date.issued,DESC"}).param("query", new String[]{""})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.configuration", (Matcher)Matchers.is((Object)"workflow"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.match("workflow", "pooltask", "pooltasks"), SearchResultMatcher.match("workflow", "pooltask", "pooltasks"), SearchResultMatcher.match("workflow", "pooltask", "pooltasks")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page.totalElements", (Matcher)Matchers.is((Object)3)));
    }

    @Test
    public void discoverSearchFacetValuesTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public Test Item").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn Test Item").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("ExtraEntry").withdrawn().build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private Test Item").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/discoverable", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("sort", new String[]{"score,DESC"}).param("page", new String[]{"0"}).param("size", new String[]{"10"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/facets/discoverable?configuration=administrativeView&sort=score,DESC"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SearchResultMatcher.matchEmbeddedFacetValues("true", 2, "discover", "/api/discover/search/objects?configuration=administrativeView&f.discoverable=true,equals"), SearchResultMatcher.matchEmbeddedFacetValues("false", 1, "discover", "/api/discover/search/objects?configuration=administrativeView&f.discoverable=false,equals")})));
    }

    @Test
    public void discoverSearchFacetValuesPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public Test Item").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Withdrawn Test Item").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("ExtraEntry").withdrawn().build();
        ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Private Test Item").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/discoverable", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("sort", new String[]{"score,DESC"}).param("page", new String[]{"0"}).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/facets/discoverable?configuration=administrativeView&sort=score,DESC"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"/api/discover/facets/discoverable?configuration=administrativeView&sort=score,DESC&page=1&size=1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.contains(SearchResultMatcher.matchEmbeddedFacetValues("true", 2, "discover", "/api/discover/search/objects?configuration=administrativeView&f.discoverable=true,equals"))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/discoverable", (Object[])new Object[0]).param("configuration", new String[]{"administrativeView"}).param("sort", new String[]{"score,DESC"}).param("page", new String[]{"1"}).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.containsString((String)"/api/discover/facets/discoverable?configuration=administrativeView&sort=score,DESC&page=0&size=1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.containsString((String)"/api/discover/facets/discoverable?configuration=administrativeView&sort=score,DESC&page=0&size=1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/facets/discoverable?configuration=administrativeView&sort=score,DESC&page=1&size=1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.contains(SearchResultMatcher.matchEmbeddedFacetValues("false", 1, "discover", "/api/discover/search/objects?configuration=administrativeView&f.discoverable=false,equals"))));
    }

    @Test
    public void discoverFacetsTestWithQueryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2019-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2020-02-13").withAuthor("Doe, Jane").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2020-02-13").withAuthor("Anton, Senek").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/author", (Object[])new Object[0]).param("query", new String[]{"Donald"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"author"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.is((Object)"text"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.scope", (Matcher)Matchers.is((Matcher)Matchers.emptyOrNullString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/author?query=Donald"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values[0].label", (Matcher)Matchers.is((Object)"Smith, Donald"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values[0].count", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values[0]._links.search.href", (Matcher)Matchers.containsString((String)("api/discover/search/objects?query=Donald&f.author=" + UrlEscapers.urlPathSegmentEscaper().escape("Smith, Donald,equals"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Object[])new Object[0]).value(Matchers.hasSize((int)1)));
    }

    @Test
    public void discoverFacetsTestWithDsoTypeTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2020-02-13").withAuthor("Doe, Jane").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2020-02-13").withAuthor("Anton, Senek").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/dateIssued", (Object[])new Object[0]).param("dsoType", new String[]{"Item"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"dateIssued"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.is((Object)"date"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.scope", (Matcher)Matchers.is((Matcher)Matchers.emptyOrNullString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/dateIssued?dsoType=Item"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values[0].label", (Matcher)Matchers.is((Object)"2017 - 2020"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values[0].count", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values[0]._links.search.href", (Matcher)Matchers.containsString((String)("api/discover/search/objects?dsoType=Item&f.dateIssued=" + UrlEscapers.urlPathSegmentEscaper().escape("[2017 TO 2020],equals"))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Object[])new Object[0]).value(Matchers.hasSize((int)1)));
    }

    @Test
    public void discoverFacetsSubjectTestWithCapitalAndSpecialChars() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Parent Collection").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 1").withSubject("Value with: Multiple Words ").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 2").withSubject("Multiple worded subject ").build();
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 3").withSubject("Subject with a lot of Word values").build();
        Item item4 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 4").withSubject("With, Values").build();
        Item item5 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 5").withSubject("Test:of:the:colon").build();
        Item item6 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 6").withSubject("Test,of,comma").build();
        Item item7 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 7").withSubject("N\u2019guyen").build();
        Item item8 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 8").withSubject("test;Semicolon").build();
        Item item9 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 9").withSubject("test||of|Pipe").build();
        Item item10 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 10").withSubject("Test-Subject").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"with a lot of word"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubject("Subject with a lot of Word values", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"multiple words"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubject("Value with: Multiple Words", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"mUltiPle wor"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubject("Multiple worded subject", 1), FacetValueMatcher.entrySubject("Value with: Multiple Words", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"with"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubject("With, Values", 1), FacetValueMatcher.entrySubject("Subject with a lot of Word values", 1), FacetValueMatcher.entrySubject("Value with: Multiple Words", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"of"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubject("Subject with a lot of Word values", 1), FacetValueMatcher.entrySubject("Test,of,comma", 1), FacetValueMatcher.entrySubject("Test:of:the:colon", 1), FacetValueMatcher.entrySubject("test||of|Pipe", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"tEsT"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubject("Test,of,comma", 1), FacetValueMatcher.entrySubject("Test-Subject", 1), FacetValueMatcher.entrySubject("Test:of:the:colon", 1), FacetValueMatcher.entrySubject("test;Semicolon", 1), FacetValueMatcher.entrySubject("test||of|Pipe", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"colon"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubject("Test:of:the:colon", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"coMma"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubject("Test,of,comma", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"guyen"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubject("N\u2019guyen", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"semiColon"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubject("test;Semicolon", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"pipe"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubject("test||of|Pipe", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"Subject"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubject("Multiple worded subject", 1), FacetValueMatcher.entrySubject("Test-Subject", 1), FacetValueMatcher.entrySubject("Subject with a lot of Word values", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"Subject of word"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"Value with words"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void discoverFacetsSubjectWithAuthorityTest() throws Exception {
        this.configurationService.setProperty("choices.plugin.dc.subject", (Object)"SolrSubjectAuthority");
        this.configurationService.setProperty("authority.controlled.dc.subject", (Object)"true");
        this.metadataAuthorityService.clearCache();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Parent Collection").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 1").withSubject("Value with: Multiple Words", "test_authority_1", 600).build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 2").withSubject("Multiple worded subject ", "test_authority_2", 600).build();
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Item 3").withSubject("Subject with a lot of Word values", "test_authority_3", 600).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"with a lot of word"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubjectWithAuthority("Subject with a lot of Word values", "test_authority_3", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"mUltiPle wor"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubjectWithAuthority("Multiple worded subject", "test_authority_2", 1), FacetValueMatcher.entrySubjectWithAuthority("Value with: Multiple Words", "test_authority_1", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"Subject"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySubjectWithAuthority("Multiple worded subject", "test_authority_2", 1), FacetValueMatcher.entrySubjectWithAuthority("Subject with a lot of Word values", "test_authority_3", 1)})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"Subject of word"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/subject", (Object[])new Object[0]).param("prefix", new String[]{"Value with words"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
        DSpaceServicesFactory.getInstance().getConfigurationService().reloadConfig();
        this.metadataAuthorityService.clearCache();
    }

    @Test
    public void discoverFacetsSupervisedByTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        WorkspaceItem wsItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withTitle("Workspace Item 1").withIssueDate("2010-07-23").build();
        WorkspaceItem wsItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withTitle("Workspace Item 2").withIssueDate("2010-11-03").build();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(this.eperson).build();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("group B").addMember(this.eperson).build();
        SupervisionOrder supervisionOrderOne = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wsItem1.getItem(), (Group)groupA).build();
        SupervisionOrder supervisionOrderTwo = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wsItem1.getItem(), (Group)groupB).build();
        SupervisionOrder supervisionOrderThree = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wsItem2.getItem(), (Group)groupA).build();
        SupervisionOrder supervisionOrderFour = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wsItem2.getItem(), (Group)groupB).build();
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/supervisedBy", (Object[])new Object[0]).param("configuration", new String[]{"supervision"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"supervisedBy"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.equalTo((Object)"authority"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/supervisedBy?configuration=supervision"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySupervisedBy(groupA.getName(), groupA.getID().toString(), 2), FacetValueMatcher.entrySupervisedBy(groupB.getName(), groupB.getID().toString(), 2)})));
    }

    @Test
    public void discoverFacetsSupervisedByWithPrefixTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        WorkspaceItem wsItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withTitle("Workspace Item 1").withIssueDate("2010-07-23").build();
        WorkspaceItem wsItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withTitle("Workspace Item 2").withIssueDate("2010-11-03").build();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(this.eperson).build();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("group B").addMember(this.eperson).build();
        SupervisionOrder supervisionOrderOneA = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wsItem1.getItem(), (Group)groupA).build();
        SupervisionOrder supervisionOrderOneB = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wsItem1.getItem(), (Group)groupB).build();
        SupervisionOrder supervisionOrderTwoA = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wsItem2.getItem(), (Group)groupA).build();
        SupervisionOrder supervisionOrderTwoB = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wsItem2.getItem(), (Group)groupB).build();
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/facets/supervisedBy", (Object[])new Object[0]).param("configuration", new String[]{"supervision"}).param("prefix", new String[]{"group B"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)"supervisedBy"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.facetType", (Matcher)Matchers.equalTo((Object)"authority"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/discover/facets/supervisedBy?prefix=group%20B&configuration=supervision"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.is(PageMatcher.pageEntry(0, 20)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.values", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetValueMatcher.entrySupervisedBy(groupB.getName(), groupB.getID().toString(), 2)})));
    }

    @Test
    public void discoverSearchObjectsSupervisionConfigurationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        EPerson userA = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("userA@test.com").withPassword(this.password).build();
        EPerson userB = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("userB@test.com").withPassword(this.password).build();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(userA).build();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("group B").addMember(userB).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{this.admin, reviewer1}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withAuthor("Testing, Works").withSubject("ExtraEntry").build();
        Item publicItem2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test 2").withIssueDate("1990-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("Testing, Works").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        Item publicItem3 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Public item 2").withIssueDate("2010-02-13").withAuthor("Smith, Maria").withAuthor("Doe, Jane").withAuthor("test,test").withAuthor("test2, test2").withAuthor("Maybe, Maybe").withSubject("AnotherTest").withSubject("TestingForMore").withSubject("ExtraEntry").build();
        this.context.setCurrentUser(this.eperson);
        WorkspaceItem wsItem1 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2010-07-23").build();
        WorkspaceItem wsItem2 = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withTitle("Workspace Item 2").withIssueDate("2010-11-03").build();
        XmlWorkflowItem wfItem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 1").withIssueDate("2010-11-03").build();
        SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wsItem1.getItem(), (Group)groupA).build();
        SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wsItem2.getItem(), (Group)groupA).build();
        SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wfItem1.getItem(), (Group)groupA).build();
        SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wfItem1.getItem(), (Group)groupB).build();
        ClaimedTask cTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)this.admin).withTitle("Claimed Item").withIssueDate("2010-11-03").build();
        this.context.setCurrentUser(this.admin);
        WorkspaceItem wsItem1Admin = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withIssueDate("2010-07-23").withTitle("Admin Workspace Item 1").build();
        WorkspaceItem wsItem2Admin = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col2).withIssueDate("2010-11-03").withTitle("Admin Workspace Item 2").build();
        XmlWorkflowItem wfItem1Admin = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withIssueDate("2010-11-03").withTitle("Admin Workflow Item 1").build();
        SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wsItem1Admin.getItem(), (Group)groupA).build();
        SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wsItem2Admin.getItem(), (Group)groupA).build();
        SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wfItem1Admin.getItem(), (Group)groupA).build();
        SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)wfItem1Admin.getItem(), (Group)groupB).build();
        ClaimedTask cTask2 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)this.admin).withTitle("Pool Step2 Item").withIssueDate("2010-11-04").build();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + cTask2.getID()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.context.restoreAuthSystemState();
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"supervision"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 0, 0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"supervision"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 0, 0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"supervision"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 8)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult._embedded.objects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf(SearchResultMatcher.match("workflow", "workflowitem", "workflowitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Workflow Item 1", "2010-11-03")))), Matchers.allOf(SearchResultMatcher.match("workflow", "workflowitem", "workflowitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Admin Workflow Item 1", "2010-11-03")))), Matchers.allOf(SearchResultMatcher.match("workflow", "workflowitem", "workflowitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Pool Step2 Item", "2010-11-04")))), Matchers.allOf(SearchResultMatcher.match("workflow", "workflowitem", "workflowitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "Claimed Item", "2010-11-03")))), Matchers.allOf(SearchResultMatcher.match("submission", "workspaceitem", "workspaceitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(wsItem1, "Workspace Item 1", "2010-07-23")))), Matchers.allOf(SearchResultMatcher.match("submission", "workspaceitem", "workspaceitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(wsItem2, "Workspace Item 2", "2010-11-03")))), Matchers.allOf(SearchResultMatcher.match("submission", "workspaceitem", "workspaceitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(wsItem1Admin, "Admin Workspace Item 1", "2010-07-23")))), Matchers.allOf(SearchResultMatcher.match("submission", "workspaceitem", "workspaceitems"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.indexableObject", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssued(wsItem2Admin, "Admin Workspace Item 2", "2010-11-03"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetEntryMatcher.resourceTypeFacet(false), FacetEntryMatcher.typeFacet(false), FacetEntryMatcher.dateIssuedFacet(false), FacetEntryMatcher.submitterFacet(false), FacetEntryMatcher.supervisedByFacet(false)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets[4]._embedded.values", (Matcher)Matchers.contains((Matcher[])new Matcher[]{FacetValueMatcher.entrySupervisedBy(groupA.getName(), groupA.getID().toString(), 6), FacetValueMatcher.entrySupervisedBy(groupB.getName(), groupB.getID().toString(), 2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"supervision"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 0, 0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsNOTIFYIncomingConfigurationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("item title").build();
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyService = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("service url").withLdnUrl("https://overlay-journal.com/inbox/").build();
        InputStream announceEndorsementStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_announce_endorsement.json");
        String announceEndorsement = IOUtils.toString((InputStream)announceEndorsementStream, (Charset)Charset.defaultCharset());
        announceEndorsementStream.close();
        String message = announceEndorsement.replaceAll("<<object>>", object);
        message = message.replaceAll("<<object_handle>>", object);
        Notification notification = (Notification)this.mapper.readValue(message, Notification.class);
        LDNMessageBuilder.createNotifyServiceBuilder((Context)this.context, (Notification)notification).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"NOTIFY.incoming"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetEntryMatcher.relatedItemFacet(false), FacetEntryMatcher.originFacet(false), FacetEntryMatcher.targetFacet(false), FacetEntryMatcher.queueStatusFacet(false), FacetEntryMatcher.activityStreamTypeFacet(false), FacetEntryMatcher.coarNotifyTypeFacet(false), FacetEntryMatcher.notificationTypeFacet(false)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }

    @Test
    public void discoverSearchObjectsNOTIFYOutgoingConfigurationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("item title").build();
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyService = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("service url").withLdnUrl("https://generic-service.com/system/inbox/").build();
        InputStream announceReviewStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_announce_review.json");
        String announceReview = IOUtils.toString((InputStream)announceReviewStream, (Charset)Charset.defaultCharset());
        announceReviewStream.close();
        String message = announceReview.replaceAll("<<object>>", object);
        message = message.replaceAll("<<object_handle>>", object);
        Notification notification = (Notification)this.mapper.readValue(message, Notification.class);
        LDNMessageBuilder.createNotifyServiceBuilder((Context)this.context, (Notification)notification).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/discover/search/objects", (Object[])new Object[0]).param("configuration", new String[]{"NOTIFY.outgoing"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"discover"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.searchResult.page", (Matcher)Matchers.is(PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.facets", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{FacetEntryMatcher.relatedItemFacet(false), FacetEntryMatcher.originFacet(false), FacetEntryMatcher.targetFacet(false), FacetEntryMatcher.queueStatusFacet(false), FacetEntryMatcher.activityStreamTypeFacet(false), FacetEntryMatcher.coarNotifyTypeFacet(false), FacetEntryMatcher.notificationTypeFacet(false)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/discover/search/objects")));
    }
}

