/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.MetadataField;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.RegistrationTypeEnum;
import org.dspace.eperson.dto.RegistrationDataChanges;
import org.dspace.eperson.dto.RegistrationDataPatch;
import org.dspace.eperson.service.AccountService;
import org.dspace.eperson.service.RegistrationDataService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class EPersonRegistrationRestControllerIT
extends AbstractControllerIntegrationTest {
    private static MockedStatic<Email> emailMockedStatic;
    @Autowired
    private AccountService accountService;
    @Autowired
    private RegistrationDataService registrationDataService;
    @Autowired
    private MetadataFieldService metadataFieldService;
    private RegistrationData orcidRegistration;
    private MetadataField orcidMf;
    private MetadataField firstNameMf;
    private MetadataField lastNameMf;
    private EPerson customEPerson;
    private String customPassword;

    @BeforeClass
    public static void init() throws Exception {
        emailMockedStatic = Mockito.mockStatic(Email.class);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        emailMockedStatic.close();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.orcidRegistration = this.registrationDataService.create(this.context, "0000-0000-0000-0000", RegistrationTypeEnum.ORCID);
        this.orcidMf = this.metadataFieldService.findByElement(this.context, "eperson", "orcid", null);
        this.firstNameMf = this.metadataFieldService.findByElement(this.context, "eperson", "firstname", null);
        this.lastNameMf = this.metadataFieldService.findByElement(this.context, "eperson", "lastname", null);
        this.registrationDataService.addMetadata(this.context, this.orcidRegistration, this.orcidMf, "0000-0000-0000-0000");
        this.registrationDataService.addMetadata(this.context, this.orcidRegistration, this.firstNameMf, "Vincenzo");
        this.registrationDataService.addMetadata(this.context, this.orcidRegistration, this.lastNameMf, "Mecca");
        this.registrationDataService.update(this.context, (Object)this.orcidRegistration);
        this.customPassword = "vins-01";
        this.customEPerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("vins-01@fake.mail").withNameInMetadata("Vins", "4Science").withPassword(this.customPassword).withCanLogin(true).build();
        this.context.restoreAuthSystemState();
    }

    @After
    public void destroy() throws Exception {
        RegistrationData found = (RegistrationData)this.context.reloadEntity((ReloadableEntity)this.orcidRegistration);
        if (found != null) {
            this.registrationDataService.delete(this.context, (Object)found);
        }
        super.destroy();
    }

    @Test
    public void givenOrcidToken_whenPostForMerge_thenUnauthorized() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/epersons/" + this.customEPerson.getID()), (Object[])new Object[0]).param("token", new String[]{this.orcidRegistration.getToken()}).param("override", new String[]{"eperson.firtname,eperson.lastname,eperson.orcid"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void givenExpiredToken_whenPostForMerge_thenUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.registrationDataService.markAsExpired(this.context, this.orcidRegistration);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/epersons/" + this.customEPerson.getID()), (Object[])new Object[0]).param("token", new String[]{this.orcidRegistration.getToken()}).param("override", new String[]{"eperson.firtname,eperson.lastname,eperson.orcid"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void givenExpiredToken_whenPostAuthForMerge_thenForbidden() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.registrationDataService.markAsExpired(this.context, this.orcidRegistration);
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/epersons/" + this.customEPerson.getID()), (Object[])new Object[0]).param("token", new String[]{this.orcidRegistration.getToken()}).param("override", new String[]{"eperson.firtname,eperson.lastname,eperson.orcid"})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void givenValidationRegistration_whenPostAuthDiffersFromIdPathParam_thenForbidden() throws Exception {
        this.context.turnOffAuthorisationSystem();
        RegistrationData validationRegistration = this.registrationDataService.create(this.context, "0000-0000-0000-0000", RegistrationTypeEnum.VALIDATION_ORCID);
        this.context.restoreAuthSystemState();
        try {
            String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/epersons/" + this.customEPerson.getID()), (Object[])new Object[0]).param("token", new String[]{validationRegistration.getToken()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        }
        finally {
            RegistrationData found = (RegistrationData)this.context.reloadEntity((ReloadableEntity)validationRegistration);
            if (found != null) {
                this.registrationDataService.delete(this.context, (Object)found);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenValidationRegistration_whenPostWithoutOverride_thenCreated() throws Exception {
        Email spy = (Email)Mockito.spy(Email.class);
        ((Email)Mockito.doNothing().when((Object)spy)).send();
        emailMockedStatic.when(() -> Email.getEmail((String)((String)ArgumentMatchers.any()))).thenReturn((Object)spy);
        this.context.turnOffAuthorisationSystem();
        RegistrationDataChanges changes = new RegistrationDataChanges("vins-01@fake.mail", RegistrationTypeEnum.VALIDATION_ORCID);
        RegistrationData validationRegistration = this.accountService.renewRegistrationForEmail(this.context, new RegistrationDataPatch(this.orcidRegistration, changes));
        this.context.restoreAuthSystemState();
        try {
            String customToken = this.getAuthToken(this.customEPerson.getEmail(), this.customPassword);
            this.getClient(customToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/epersons/" + this.customEPerson.getID()), (Object[])new Object[0]).param("token", new String[]{validationRegistration.getToken()})).andExpect(MockMvcResultMatchers.status().isCreated());
        }
        finally {
            RegistrationData found = (RegistrationData)this.context.reloadEntity((ReloadableEntity)validationRegistration);
            if (found != null) {
                this.registrationDataService.delete(this.context, (Object)found);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenValidationRegistration_whenPostWithOverride_thenCreated() throws Exception {
        Email spy = (Email)Mockito.spy(Email.class);
        ((Email)Mockito.doNothing().when((Object)spy)).send();
        emailMockedStatic.when(() -> Email.getEmail((String)((String)ArgumentMatchers.any()))).thenReturn((Object)spy);
        this.context.turnOffAuthorisationSystem();
        RegistrationDataChanges changes = new RegistrationDataChanges("vins-01@fake.mail", RegistrationTypeEnum.VALIDATION_ORCID);
        RegistrationData validationRegistration = this.accountService.renewRegistrationForEmail(this.context, new RegistrationDataPatch(this.orcidRegistration, changes));
        this.context.restoreAuthSystemState();
        try {
            String customToken = this.getAuthToken(this.customEPerson.getEmail(), this.customPassword);
            this.getClient(customToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/epersons/" + this.customEPerson.getID()), (Object[])new Object[0]).param("token", new String[]{validationRegistration.getToken()}).param("override", new String[]{"eperson.firstname,eperson.lastname"})).andExpect(MockMvcResultMatchers.status().isCreated());
        }
        finally {
            RegistrationData found = (RegistrationData)this.context.reloadEntity((ReloadableEntity)validationRegistration);
            if (found != null) {
                this.registrationDataService.delete(this.context, (Object)found);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenValidationRegistration_whenPostWithoutOverride_thenOnlyNewMetadataAdded() throws Exception {
        Email spy = (Email)Mockito.spy(Email.class);
        ((Email)Mockito.doNothing().when((Object)spy)).send();
        emailMockedStatic.when(() -> Email.getEmail((String)((String)ArgumentMatchers.any()))).thenReturn((Object)spy);
        this.context.turnOffAuthorisationSystem();
        RegistrationDataChanges changes = new RegistrationDataChanges("vins-01@fake.mail", RegistrationTypeEnum.VALIDATION_ORCID);
        RegistrationData validationRegistration = this.accountService.renewRegistrationForEmail(this.context, new RegistrationDataPatch(this.orcidRegistration, changes));
        this.context.restoreAuthSystemState();
        try {
            String customToken = this.getAuthToken(this.customEPerson.getEmail(), this.customPassword);
            this.getClient(customToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/epersons/" + this.customEPerson.getID()), (Object[])new Object[0]).param("token", new String[]{validationRegistration.getToken()})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netid", (Matcher)Matchers.equalTo((Object)"0000-0000-0000-0000"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("eperson.firstname", "Vins"), MetadataMatcher.matchMetadata("eperson.lastname", "4Science"), MetadataMatcher.matchMetadata("eperson.orcid", "0000-0000-0000-0000"))));
        }
        finally {
            RegistrationData found = (RegistrationData)this.context.reloadEntity((ReloadableEntity)validationRegistration);
            if (found != null) {
                this.registrationDataService.delete(this.context, (Object)found);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenValidationRegistration_whenPostWithOverride_thenMetadataReplaced() throws Exception {
        Email spy = (Email)Mockito.spy(Email.class);
        ((Email)Mockito.doNothing().when((Object)spy)).send();
        emailMockedStatic.when(() -> Email.getEmail((String)((String)ArgumentMatchers.any()))).thenReturn((Object)spy);
        this.context.turnOffAuthorisationSystem();
        RegistrationDataChanges changes = new RegistrationDataChanges("vins-01@fake.mail", RegistrationTypeEnum.VALIDATION_ORCID);
        RegistrationData validationRegistration = this.accountService.renewRegistrationForEmail(this.context, new RegistrationDataPatch(this.orcidRegistration, changes));
        this.context.restoreAuthSystemState();
        try {
            String customToken = this.getAuthToken(this.customEPerson.getEmail(), this.customPassword);
            this.getClient(customToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/epersons/" + this.customEPerson.getID()), (Object[])new Object[0]).param("token", new String[]{validationRegistration.getToken()}).param("override", new String[]{"eperson.firstname,eperson.lastname"})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.netid", (Matcher)Matchers.equalTo((Object)"0000-0000-0000-0000"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("eperson.firstname", "Vincenzo"), MetadataMatcher.matchMetadata("eperson.lastname", "Mecca"), MetadataMatcher.matchMetadata("eperson.orcid", "0000-0000-0000-0000"))));
        }
        finally {
            RegistrationData found = (RegistrationData)this.context.reloadEntity((ReloadableEntity)validationRegistration);
            if (found != null) {
                this.registrationDataService.delete(this.context, (Object)found);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenValidationRegistration_whenPostWithOverrideAndMetadataNotFound_thenBadRequest() throws Exception {
        Email spy = (Email)Mockito.spy(Email.class);
        ((Email)Mockito.doNothing().when((Object)spy)).send();
        emailMockedStatic.when(() -> Email.getEmail((String)((String)ArgumentMatchers.any()))).thenReturn((Object)spy);
        this.context.turnOffAuthorisationSystem();
        RegistrationDataChanges changes = new RegistrationDataChanges("vins-01@fake.mail", RegistrationTypeEnum.VALIDATION_ORCID);
        RegistrationData validationRegistration = this.accountService.renewRegistrationForEmail(this.context, new RegistrationDataPatch(this.orcidRegistration, changes));
        try {
            this.context.restoreAuthSystemState();
            String customToken = this.getAuthToken(this.customEPerson.getEmail(), this.customPassword);
            this.getClient(customToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/epersons/" + this.customEPerson.getID()), (Object[])new Object[0]).param("token", new String[]{validationRegistration.getToken()}).param("override", new String[]{"eperson.phone"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.context.turnOffAuthorisationSystem();
            MetadataField phoneMf = this.metadataFieldService.findByElement(this.context, "eperson", "phone", null);
            this.registrationDataService.addMetadata(this.context, validationRegistration, phoneMf, "1234567890");
            this.context.restoreAuthSystemState();
            this.getClient(customToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/epersons/" + this.customEPerson.getID()), (Object[])new Object[0]).param("token", new String[]{validationRegistration.getToken()}).param("override", new String[]{"eperson.phone"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        }
        finally {
            RegistrationData found = (RegistrationData)this.context.reloadEntity((ReloadableEntity)validationRegistration);
            if (found != null) {
                this.registrationDataService.delete(this.context, (Object)found);
            }
        }
    }
}

