/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.Arrays;
import java.util.List;
import org.dspace.app.rest.matcher.EntityTypeMatcher;
import org.dspace.app.rest.matcher.ExternalSourceEntryMatcher;
import org.dspace.app.rest.matcher.ExternalSourceMatcher;
import org.dspace.app.rest.matcher.PageMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.content.EntityType;
import org.dspace.core.Context;
import org.dspace.external.provider.AbstractExternalDataProvider;
import org.dspace.external.service.ExternalDataService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ExternalSourcesRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ExternalDataService externalDataService;

    @Test
    public void findAllExternalSources() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalsources", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{ExternalSourceMatcher.matchExternalSource("mock", "mock", false), ExternalSourceMatcher.matchExternalSource("orcid", "orcid", false), ExternalSourceMatcher.matchExternalSource("suggestion", "suggestion", false), ExternalSourceMatcher.matchExternalSource("scopus", "scopus", false), ExternalSourceMatcher.matchExternalSource("sherpaJournalIssn", "sherpaJournalIssn", false), ExternalSourceMatcher.matchExternalSource("sherpaJournal", "sherpaJournal", false), ExternalSourceMatcher.matchExternalSource("sherpaPublisher", "sherpaPublisher", false), ExternalSourceMatcher.matchExternalSource("pubmed", "pubmed", false), ExternalSourceMatcher.matchExternalSource("openaireFunding", "openaireFunding", false), ExternalSourceMatcher.matchExternalSource("openalexPublication", "openalexPublication", false), ExternalSourceMatcher.matchExternalSource("openalexPublicationByAuthorId", "openalexPublicationByAuthorId", false), ExternalSourceMatcher.matchExternalSource("openalexPublicationByDOI", "openalexPublicationByDOI", false), ExternalSourceMatcher.matchExternalSource("openalexPerson", "openalexPerson", false), ExternalSourceMatcher.matchExternalSource("openalexInstitution", "openalexInstitution", false), ExternalSourceMatcher.matchExternalSource("openalexPublisher", "openalexPublisher", false), ExternalSourceMatcher.matchExternalSource("openalexFunder", "openalexFunder", false), ExternalSourceMatcher.matchExternalSource("openalexJournal", "openalexJournal", false)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)20)));
    }

    @Test
    public void findOneExternalSourcesExistingSources() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mock", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ExternalSourceMatcher.matchExternalSource("mock", "mock", false))));
    }

    @Test
    public void findOneExternalSourcesNotExistingSources() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mock2", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneExternalSourceEntryValue() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mock/entryValues/one", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ExternalSourceEntryMatcher.matchExternalSourceEntry("one", "one", "one", "mock"))));
    }

    @Test
    public void findOneExternalSourceEntryValueInvalidEntryId() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mock/entryValues/entryIdInvalid", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneExternalSourceEntryValueInvalidSource() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mocktwo/entryValues/one", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneExternalSourceEntriesInvalidSource() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mocktwo/entries", (Object[])new Object[0]).param("query", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneExternalSourceEntriesApplicableQuery() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mock/entries", (Object[])new Object[0]).param("query", new String[]{"one"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ExternalSourceEntryMatcher.matchExternalSourceEntry("one", "one", "one", "mock"), ExternalSourceEntryMatcher.matchExternalSourceEntry("onetwo", "onetwo", "onetwo", "mock")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2)));
    }

    @Test
    public void findOneExternalSourceEntriesApplicableQueryPagination() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mock/entries", (Object[])new Object[0]).param("query", new String[]{"one"}).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.hasItem(ExternalSourceEntryMatcher.matchExternalSourceEntry("onetwo", "onetwo", "onetwo", "mock")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", PageMatcher.pageEntryWithTotalPagesAndElements(0, 1, 2, 2)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mock/entries", (Object[])new Object[0]).param("query", new String[]{"one"}).param("size", new String[]{"1"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.hasItem(ExternalSourceEntryMatcher.matchExternalSourceEntry("one", "one", "one", "mock")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", PageMatcher.pageEntryWithTotalPagesAndElements(1, 1, 2, 2)));
    }

    @Test
    public void findOneExternalSourceEntriesNoReturnQuery() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mock/entries", (Object[])new Object[0]).param("query", new String[]{"randomqueryfornoresults"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findOneExternalSourceEntriesNoQuery() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mock/entries", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findExternalSourcesByEntityTypeTest() throws Exception {
        List publicationProviders = this.externalDataService.getExternalDataProvidersForEntityType("Publication");
        List journalProviders = this.externalDataService.getExternalDataProvidersForEntityType("Journal");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/search/findByEntityType", (Object[])new Object[0]).param("entityType", new String[]{"Publication"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalsources", ExternalSourceMatcher.matchAllExternalSources(publicationProviders, 20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)publicationProviders.size())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/search/findByEntityType", (Object[])new Object[0]).param("entityType", new String[]{"Journal"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalsources", ExternalSourceMatcher.matchAllExternalSources(journalProviders, 20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)journalProviders.size())));
    }

    @Test
    public void findExternalSourcesByEntityTypeBadRequestTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/search/findByEntityType", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findExternalSourcesByEntityTypePaginationTest() throws Exception {
        List journalProviders = this.externalDataService.getExternalDataProvidersForEntityType("Journal");
        int numJournalProviders = journalProviders.size();
        int pageSize = 2;
        int numberOfPages = (int)Math.ceil((double)numJournalProviders / (double)pageSize);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/search/findByEntityType", (Object[])new Object[0]).param("entityType", new String[]{"Journal"}).param("size", new String[]{String.valueOf(pageSize)})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalsources", ExternalSourceMatcher.matchAllExternalSources(journalProviders, pageSize))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)numberOfPages))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)numJournalProviders)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/search/findByEntityType", (Object[])new Object[0]).param("entityType", new String[]{"Journal"}).param("page", new String[]{"1"}).param("size", new String[]{String.valueOf(pageSize)})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalsources", ExternalSourceMatcher.matchAllExternalSources(journalProviders.subList(2, journalProviders.size()), pageSize))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)numberOfPages))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)numJournalProviders)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void findSupportedEntityTypesOfAnExternalDataProviderTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        EntityType orgUnit = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"OrgUnit").build();
        EntityType project = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Project").build();
        EntityType funding = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Funding").build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        try {
            ((AbstractExternalDataProvider)this.externalDataService.getExternalDataProvider("mock")).setSupportedEntityTypes(Arrays.asList("Publication", "OrgUnit"));
            ((AbstractExternalDataProvider)this.externalDataService.getExternalDataProvider("pubmed")).setSupportedEntityTypes(Arrays.asList("Project", "Publication", "Funding"));
            this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mock/entityTypes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entityTypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(publication), EntityTypeMatcher.matchEntityTypeEntry(orgUnit)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
            this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/pubmed/entityTypes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entityTypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(project), EntityTypeMatcher.matchEntityTypeEntry(publication), EntityTypeMatcher.matchEntityTypeEntry(funding)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        }
        finally {
            ((AbstractExternalDataProvider)this.externalDataService.getExternalDataProvider("mock")).setSupportedEntityTypes(null);
            ((AbstractExternalDataProvider)this.externalDataService.getExternalDataProvider("pubmed")).setSupportedEntityTypes(null);
        }
    }

    @Test
    public void findSupportedEntityTypesOfAnExternalDataProviderNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/WrongProvider/entityTypes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findSupportedEntityTypesOfAnExternalDataProviderEmptyResponseTest() throws Exception {
        ((AbstractExternalDataProvider)this.externalDataService.getExternalDataProvider("mock")).setSupportedEntityTypes(null);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mock/entityTypes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entityTypes", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void findSupportedEntityTypesOfAnExternalDataProviderPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        EntityType orgUnit = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"OrgUnit").build();
        EntityType project = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Project").build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        try {
            ((AbstractExternalDataProvider)this.externalDataService.getExternalDataProvider("mock")).setSupportedEntityTypes(Arrays.asList("Publication", "OrgUnit", "Project"));
            this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mock/entityTypes", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entityTypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(publication), EntityTypeMatcher.matchEntityTypeEntry(project)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
            this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/mock/entityTypes", (Object[])new Object[0]).param("page", new String[]{"1"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entityTypes", (Matcher)Matchers.contains(EntityTypeMatcher.matchEntityTypeEntry(orgUnit)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        }
        finally {
            ((AbstractExternalDataProvider)this.externalDataService.getExternalDataProvider("mock")).setSupportedEntityTypes(null);
        }
    }
}

