/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.Map;
import org.dspace.app.rest.configuration.ActuatorConfiguration;
import org.dspace.app.rest.link.search.HealthIndicatorMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.boot.actuate.health.Status;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class HealthIndicatorsIT
extends AbstractControllerIntegrationTest {
    private static final String HEALTH_PATH = "/actuator/health";

    @Test
    public void testWithAnonymousUser() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)HEALTH_PATH, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.status", (Matcher)Matchers.is((Object)ActuatorConfiguration.UP_WITH_ISSUES_STATUS.getCode()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.components", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testWithNotAdminUser() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)HEALTH_PATH, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.status", (Matcher)Matchers.is((Object)ActuatorConfiguration.UP_WITH_ISSUES_STATUS.getCode()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.components", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testWithAdminUser() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)HEALTH_PATH, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.status", (Matcher)Matchers.is((Object)ActuatorConfiguration.UP_WITH_ISSUES_STATUS.getCode()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.components", (Matcher)Matchers.allOf(HealthIndicatorMatcher.matchDatabase(Status.UP), HealthIndicatorMatcher.match("solrSearchCore", Status.UP, Map.of("status", 0, "detectedPathType", "root")), HealthIndicatorMatcher.match("solrStatisticsCore", Status.UP, Map.of("status", 0, "detectedPathType", "root")), HealthIndicatorMatcher.match("geoIp", ActuatorConfiguration.UP_WITH_ISSUES_STATUS, Map.of("reason", "The required 'dbfile' configuration is missing in usage-statistics.cfg!")))));
    }
}

