/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.TemplateItemRest;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ItemTemplateRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ResourcePolicyService resourcePolicyService;
    @Autowired
    private ObjectMapper mapper;
    private String adminAuthToken;
    private Collection childCollection;
    private TemplateItemRest testTemplateItem;
    private String patchBody;

    @Before
    public void createStructure() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.childCollection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.adminAuthToken = this.getAuthToken(this.admin.getEmail(), this.password);
    }

    private void setupTestTemplate() {
        this.testTemplateItem = new TemplateItemRest();
        this.testTemplateItem.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("dc description content")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("dc description abstract content")}));
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ArrayList values = new ArrayList();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "table of contents");
        values.add(value);
        AddOperation addOperation = new AddOperation("/metadata/dc.description.tableofcontents", values);
        ops.add((Operation)addOperation);
        this.patchBody = this.getPatchContent(ops);
    }

    private String installTestTemplate() throws Exception {
        MvcResult mvcResult = this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getCollectionTemplateItemUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)this.testTemplateItem)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
        String content = mvcResult.getResponse().getContentAsString();
        Map map = (Map)this.mapper.readValue(content, Map.class);
        return String.valueOf(map.get("id"));
    }

    @Test
    public void createTemplateItemNotLoggedIn() throws Exception {
        this.setupTestTemplate();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getCollectionTemplateItemUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)this.testTemplateItem)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void createTemplateItem() throws Exception {
        this.setupTestTemplate();
        this.installTestTemplate();
    }

    @Test
    public void createTemplateItemNoRights() throws Exception {
        this.setupTestTemplate();
        String userToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getCollectionTemplateItemUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)this.testTemplateItem)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void createDuplicateTemplateItem() throws Exception {
        this.setupTestTemplate();
        this.installTestTemplate();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getCollectionTemplateItemUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)this.testTemplateItem)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createTemplateItemForNonexisting() throws Exception {
        this.setupTestTemplate();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)this.getCollectionTemplateItemUrlTemplate("16a4b65b-3b3f-4ef5-8058-ef6f5a653ef9"), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)this.testTemplateItem)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getTemplateItemFromCollection() throws Exception {
        this.setupTestTemplate();
        String itemUuidString = this.installTestTemplate();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)this.getCollectionTemplateItemUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"itemtemplate")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "dc description content"), MetadataMatcher.matchMetadata("dc.description.abstract", "dc description abstract content"))))));
    }

    @Test
    public void getTemplateItemFromCollectionForbiddenTest() throws Exception {
        this.setupTestTemplate();
        String itemUuidString = this.installTestTemplate();
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)this.childCollection, 0);
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)this.getCollectionTemplateItemUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getTemplateItemFromItemId() throws Exception {
        this.setupTestTemplate();
        String itemUuidString = this.installTestTemplate();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)this.getTemplateItemUrlTemplate(itemUuidString), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)itemUuidString)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"itemtemplate")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "dc description content"), MetadataMatcher.matchMetadata("dc.description.abstract", "dc description abstract content"))))));
    }

    @Test
    public void patchTemplateItemNotLoggedIn() throws Exception {
        this.setupTestTemplate();
        String itemId = this.installTestTemplate();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.patch((String)this.getTemplateItemUrlTemplate(itemId), (Object[])new Object[0]).content(this.patchBody).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void patchTemplateItem() throws Exception {
        this.setupTestTemplate();
        String itemId = this.installTestTemplate();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)this.getTemplateItemUrlTemplate(itemId), (Object[])new Object[0]).content(this.patchBody).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"itemtemplate")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "dc description content"), MetadataMatcher.matchMetadata("dc.description.abstract", "dc description abstract content"), MetadataMatcher.matchMetadata("dc.description.tableofcontents", "table of contents"))))));
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)this.getCollectionTemplateItemUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"itemtemplate")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "dc description content"), MetadataMatcher.matchMetadata("dc.description.abstract", "dc description abstract content"), MetadataMatcher.matchMetadata("dc.description.tableofcontents", "table of contents"))))));
    }

    @Test
    public void patchTemplateItemAsCollectionAdmin() throws Exception {
        this.setupTestTemplate();
        String itemId = this.installTestTemplate();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(11).withDspaceObject((DSpaceObject)this.childCollection).build();
        String collAdminToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(collAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)this.getTemplateItemUrlTemplate(itemId), (Object[])new Object[0]).content(this.patchBody).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"itemtemplate"))})));
        this.getClient(collAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)this.getCollectionTemplateItemUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"itemtemplate"))})));
    }

    @Test
    public void patchIllegalInArchiveTemplateItem() throws Exception {
        this.setupTestTemplate();
        String itemId = this.installTestTemplate();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/inArchive", (Object)true);
        ops.add((Operation)replaceOperation);
        String illegalPatchBody = this.getPatchContent(ops);
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)this.getTemplateItemUrlTemplate(itemId), (Object[])new Object[0]).content(illegalPatchBody).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void patchIllegalDiscoverableTemplateItem() throws Exception {
        this.setupTestTemplate();
        String itemId = this.installTestTemplate();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/discoverable", (Object)true);
        ops.add((Operation)replaceOperation);
        String illegalPatchBody = this.getPatchContent(ops);
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)this.getTemplateItemUrlTemplate(itemId), (Object[])new Object[0]).content(illegalPatchBody).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchIllegalWithdrawnTemplateItem() throws Exception {
        this.setupTestTemplate();
        String itemId = this.installTestTemplate();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation replaceOperation = new ReplaceOperation("/withdrawn", (Object)true);
        ops.add((Operation)replaceOperation);
        String illegalPatchBody = this.getPatchContent(ops);
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)this.getTemplateItemUrlTemplate(itemId), (Object[])new Object[0]).content(illegalPatchBody).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void patchTemplateItemNoRights() throws Exception {
        this.setupTestTemplate();
        String itemId = this.installTestTemplate();
        String userToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)this.getTemplateItemUrlTemplate(itemId), (Object[])new Object[0]).content(this.patchBody).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void patchTemplateItemNonexisting() throws Exception {
        this.setupTestTemplate();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)this.getTemplateItemUrlTemplate("16a4b65b-3b3f-4ef5-8058-ef6f5a653ef9"), (Object[])new Object[0]).content(this.patchBody).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteTemplateItemNotLoggedIn() throws Exception {
        this.setupTestTemplate();
        String itemId = this.installTestTemplate();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getTemplateItemUrlTemplate(itemId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void deleteTemplateItem() throws Exception {
        this.setupTestTemplate();
        String itemId = this.installTestTemplate();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getTemplateItemUrlTemplate(itemId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteTemplateItemAsCollectionAdmin() throws Exception {
        this.setupTestTemplate();
        String itemId = this.installTestTemplate();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withAction(11).withDspaceObject((DSpaceObject)this.childCollection).build();
        String collAdminToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(collAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getTemplateItemUrlTemplate(itemId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteTemplateItemNoRights() throws Exception {
        this.setupTestTemplate();
        String itemId = this.installTestTemplate();
        String userToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getTemplateItemUrlTemplate(itemId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void deleteTemplateItemForNonexisting() throws Exception {
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getTemplateItemUrlTemplate("16a4b65b-3b3f-4ef5-8058-ef6f5a653ef9"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private String getCollectionTemplateItemUrlTemplate(String uuid) {
        return "/api/core/collections/" + uuid + "/itemtemplate";
    }

    private String getTemplateItemUrlTemplate(String uuid) {
        return "/api/core/itemtemplates/" + uuid;
    }
}

