/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.dspace.app.ldn.LDNMessageEntity;
import org.dspace.app.ldn.NotifyPatternToTrigger;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.model.Notification;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.app.ldn.service.NotifyPatternToTriggerService;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.NotifyServiceBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Community;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.matcher.QASourceMatcher;
import org.dspace.matcher.QATopicMatcher;
import org.dspace.qaevent.service.QAEventService;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.service.VersioningService;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class LDNInboxControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private LDNMessageService ldnMessageService;
    @Autowired
    private ObjectMapper mapper;
    private QAEventService qaEventService = (QAEventService)new DSpace().getSingletonService(QAEventService.class);
    @Autowired
    private XmlWorkflowService workflowService;
    @Autowired
    private VersioningService versioningService;
    @Autowired
    private InstallItemService installItemService;
    @Autowired
    private WorkspaceItemService workspaceItemService;
    @Autowired
    private NotifyPatternToTriggerService notifyPatternToTriggerService;

    @Test
    public void ldnInboxAnnounceEndorsementTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).build();
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("service url").withLdnUrl("https://overlay-journal.com/inbox/").withLowerIp("127.0.0.1").withUpperIp("127.0.0.3").build();
        this.context.restoreAuthSystemState();
        InputStream announceEndorsementStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_announce_endorsement.json");
        String announceEndorsement = IOUtils.toString((InputStream)announceEndorsementStream, (Charset)Charset.defaultCharset());
        announceEndorsementStream.close();
        String message = announceEndorsement.replaceAll("<<object>>", object);
        message = message.replaceAll("<<object_handle>>", object);
        Notification notification = (Notification)this.mapper.readValue(message, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(message)).andExpect(MockMvcResultMatchers.status().isAccepted());
        LDNMessageEntity ldnMessage = this.ldnMessageService.find(this.context, notification.getId());
        this.checkStoredLDNMessage(notification, ldnMessage, object);
    }

    @Test
    public void ldnInboxAnnounceReviewTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).build();
        InputStream announceReviewStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_announce_review.json");
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://review-service.com/inbox/about/").withLdnUrl("https://review-service.com/inbox/").withScore(BigDecimal.valueOf(0.6)).withStatus(true).withLowerIp("127.0.0.1").withUpperIp("127.0.0.3").build();
        String announceReview = IOUtils.toString((InputStream)announceReviewStream, (Charset)Charset.defaultCharset());
        announceReviewStream.close();
        String message = announceReview.replaceAll("<<object>>", object);
        message = message.replaceAll("<<object_handle>>", object);
        Notification notification = (Notification)this.mapper.readValue(message, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(message)).andExpect(MockMvcResultMatchers.status().isAccepted());
        this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        MatcherAssert.assertThat((Object)this.qaEventService.findAllSources(this.context, 0L, 20), (Matcher)Matchers.hasItem((Matcher)QASourceMatcher.with((String)"coar-notify", (long)1L)));
        MatcherAssert.assertThat((Object)this.qaEventService.findAllTopicsBySource(this.context, "coar-notify", 0L, 20L, "topic", true), (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with((String)"ENRICH/MORE/REVIEW", (long)1L)));
    }

    @Test
    public void ldnInboxEndorsementActionBadRequestTest() throws Exception {
        InputStream offerEndorsementStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_offer_endorsement_badrequest.json");
        String message = IOUtils.toString((InputStream)offerEndorsementStream, (Charset)Charset.defaultCharset());
        offerEndorsementStream.close();
        Notification notification = (Notification)this.mapper.readValue(message, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(message)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void ldnInboxOfferReviewAndACKTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).build();
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://review-service.com/inbox/about/").withLdnUrl("https://review-service.com/inbox/").withScore(BigDecimal.valueOf(0.6)).withStatus(true).withLowerIp("127.0.0.1").withUpperIp("127.0.0.3").build();
        InputStream offerReviewStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_offer_review.json");
        String announceReview = IOUtils.toString((InputStream)offerReviewStream, (Charset)Charset.defaultCharset());
        offerReviewStream.close();
        String message = announceReview.replaceAll("<<object_handle>>", object);
        Notification notification = (Notification)this.mapper.readValue(message, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(message)).andExpect(MockMvcResultMatchers.status().isAccepted());
        int processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)1L);
        processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)0L);
        InputStream ackReviewStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_ack_review_reject.json");
        String ackReview = IOUtils.toString((InputStream)ackReviewStream, (Charset)Charset.defaultCharset());
        offerReviewStream.close();
        String ackMessage = ackReview.replaceAll("<<object_handle>>", object);
        ackMessage = ackMessage.replaceAll("<<ldn_offer_review_uuid>>", "urn:uuid:0370c0fb-bb78-4a9b-87f5-bed307a509de");
        Notification ackNotification = (Notification)this.mapper.readValue(ackMessage, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(ackMessage)).andExpect(MockMvcResultMatchers.status().isAccepted());
        int ackProcessed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)ackProcessed, (long)1L);
        ackProcessed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)ackProcessed, (long)0L);
    }

    @Test
    public void ldnInboxOfferReviewAndTentativeRejectTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("Test Item").build();
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://review-service.com/inbox/about/").withLdnUrl("https://review-service.com/inbox/").withScore(BigDecimal.valueOf(0.6)).withStatus(true).withLowerIp("127.0.0.1").withUpperIp("127.0.0.3").build();
        InputStream ackReviewStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_ack_review_reject.json");
        String ackReview = IOUtils.toString((InputStream)ackReviewStream, (Charset)Charset.defaultCharset());
        String ackMessage = ackReview.replaceAll("<<object_handle>>", object);
        ackMessage = ackMessage.replaceAll("<<ldn_offer_endorsement_uuid>>", "urn:uuid:0370c0fb-bb78-4a9b-87f5-bed307a509da");
        ObjectMapper mapper = new ObjectMapper();
        Notification notification = (Notification)mapper.readValue(ackMessage, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(ackMessage)).andExpect(MockMvcResultMatchers.status().isAccepted());
        int processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)1L);
        processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)0L);
    }

    @Test
    public void ldnInboxAnnounceReleaseTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).build();
        InputStream announceRelationshipStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_announce_release.json");
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://review-service.com/inbox/about/").withLdnUrl("https://review-service.com/inbox/").withScore(BigDecimal.valueOf(0.6)).withStatus(true).withLowerIp("127.0.0.1").withUpperIp("127.0.0.3").build();
        String announceRelationship = IOUtils.toString((InputStream)announceRelationshipStream, (Charset)Charset.defaultCharset());
        announceRelationshipStream.close();
        String message = announceRelationship.replaceAll("<<object>>", object);
        message = message.replaceAll("<<object_handle>>", object);
        Notification notification = (Notification)this.mapper.readValue(message, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(message)).andExpect(MockMvcResultMatchers.status().isAccepted());
        this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        MatcherAssert.assertThat((Object)this.qaEventService.findAllSources(this.context, 0L, 20), (Matcher)Matchers.hasItem((Matcher)QASourceMatcher.with((String)"coar-notify", (long)1L)));
        MatcherAssert.assertThat((Object)this.qaEventService.findAllTopicsBySource(this.context, "coar-notify", 0L, 20L, "topic", true), (Matcher)Matchers.hasItem((Matcher)QATopicMatcher.with((String)"ENRICH/MORE/LINK", (long)1L)));
    }

    private void checkStoredLDNMessage(Notification notification, LDNMessageEntity ldnMessage, String object) throws Exception {
        Notification storedMessage = (Notification)this.mapper.readValue(ldnMessage.getMessage(), Notification.class);
        Assert.assertNotNull((Object)ldnMessage);
        Assert.assertNotNull((Object)ldnMessage.getObject());
        Assert.assertEquals((Object)ldnMessage.getObject().getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().toString('.').equals("dc.identifier.uri")).map(metadataValue -> metadataValue.getValue()).findFirst().get(), (Object)object);
        Assert.assertEquals((Object)notification.getId(), (Object)storedMessage.getId());
        Assert.assertEquals((Object)notification.getOrigin().getInbox(), (Object)storedMessage.getOrigin().getInbox());
        Assert.assertEquals((Object)notification.getTarget().getInbox(), (Object)storedMessage.getTarget().getInbox());
        Assert.assertEquals((Object)notification.getObject().getId(), (Object)storedMessage.getObject().getId());
        Assert.assertEquals((Object)notification.getType(), (Object)storedMessage.getType());
    }

    @Test
    public void ldnInboxAnnounceEndorsementInvalidIpTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).build();
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("service url").withLdnUrl("https://overlay-journal.com/inbox/").withLowerIp("127.0.0.1").withUpperIp("127.0.0.1").build();
        this.context.restoreAuthSystemState();
        InputStream announceEndorsementStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_announce_endorsement.json");
        String announceEndorsement = IOUtils.toString((InputStream)announceEndorsementStream, (Charset)Charset.defaultCharset());
        announceEndorsementStream.close();
        String message = announceEndorsement.replaceAll("<<object>>", object);
        message = message.replaceAll("<<object_handle>>", object);
        Notification notification = (Notification)this.mapper.readValue(message, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).with(LDNInboxControllerIT.remoteHost("mydocker.url", "172.23.0.1")).contentType("application/ld+json").content(message)).andExpect(MockMvcResultMatchers.status().isBadRequest());
        int processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)0L);
        LDNMessageEntity ldnMessage = this.ldnMessageService.find(this.context, notification.getId());
        Assert.assertNull((Object)ldnMessage);
    }

    @Test
    public void ldnInboxAnnounceEndorsementInvalidInboxTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).build();
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("service url").withLdnUrl("https://overlay-journal.com/inbox/").withLowerIp("127.0.0.2").withUpperIp("127.0.0.5").build();
        this.context.restoreAuthSystemState();
        InputStream announceEndorsementStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_origin_inbox_unregistered.json");
        String announceEndorsement = IOUtils.toString((InputStream)announceEndorsementStream, (Charset)Charset.defaultCharset());
        announceEndorsementStream.close();
        String message = announceEndorsement.replaceAll("<<object>>", object);
        message = message.replaceAll("<<object_handle>>", object);
        Notification notification = (Notification)this.mapper.readValue(message, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(message)).andExpect(MockMvcResultMatchers.status().isBadRequest());
        int processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)0L);
    }

    @Test
    public void ldnInboxOutOfRangeIPwithDisabledCheckTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (org.dspace.content.Collection)collection).build();
        this.configurationService.setProperty("ldn.notify.inbox.block-untrusted-ip", (Object)false);
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("service url").withLdnUrl("https://overlay-journal.com/inbox/").withLowerIp("127.0.0.1").withUpperIp("127.0.0.1").build();
        this.context.restoreAuthSystemState();
        InputStream announceEndorsementStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_announce_endorsement.json");
        String announceEndorsement = IOUtils.toString((InputStream)announceEndorsementStream, (Charset)Charset.defaultCharset());
        announceEndorsementStream.close();
        String message = announceEndorsement.replaceAll("<<object>>", object);
        message = message.replaceAll("<<object_handle>>", object);
        Notification notification = (Notification)this.mapper.readValue(message, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).with(LDNInboxControllerIT.remoteHost("mydocker.url", "172.23.0.1")).contentType("application/ld+json").content(message)).andExpect(MockMvcResultMatchers.status().isAccepted());
        LDNMessageEntity ldnMessage = this.ldnMessageService.find(this.context, notification.getId());
        this.checkStoredLDNMessage(notification, ldnMessage, object);
        Assert.assertEquals((Object)ldnMessage.getQueueStatus(), (Object)LDNMessageEntity.QUEUE_STATUS_UNTRUSTED_IP);
    }

    @Test
    public void testLDNMessageConsumerRequestEndorsementResubmission() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("community").build();
        org.dspace.content.Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://review-service.com/inbox/about/").withLdnUrl("https://review-service.com/inbox/").withScore(BigDecimal.valueOf(0.6)).withStatus(true).withLowerIp("127.0.0.1").withUpperIp("127.0.0.3").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (org.dspace.content.Collection)collection).withTitle("Submission Item").withIssueDate("2023-11-20").withFulltext("test.txt", "test", InputStream.nullInputStream()).grantLicense().withCOARNotifyService(notifyServiceEntity, "request-endorsement").build();
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
        this.context.commit();
        int processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)1L);
        List messages = this.ldnMessageService.findAll(this.context);
        String notificationId = ((LDNMessageEntity)messages.get(0)).getID();
        processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)0L);
        String object = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle();
        InputStream ackReviewStream = ((Object)((Object)this)).getClass().getResourceAsStream("ldn_ack_review_reject.json");
        String ackReview = IOUtils.toString((InputStream)ackReviewStream, (Charset)Charset.defaultCharset());
        String ackMessage = ackReview.replaceAll("<<object_handle>>", object);
        ackMessage = ackMessage.replaceAll("<<ldn_offer_endorsement_uuid>>", notificationId);
        ObjectMapper mapper = new ObjectMapper();
        Notification notification = (Notification)mapper.readValue(ackMessage, Notification.class);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/ldn/inbox", (Object[])new Object[0]).contentType("application/ld+json").content(ackMessage)).andExpect(MockMvcResultMatchers.status().isAccepted());
        processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)1L);
        processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)0L);
        Version version = this.versioningService.createNewVersion(this.context, (Item)this.context.reloadEntity((ReloadableEntity)item));
        WorkspaceItem wsi = this.workspaceItemService.findByItem(this.context, version.getItem());
        NotifyPatternToTrigger notifyPatternToTrigger = this.notifyPatternToTriggerService.create(this.context);
        notifyPatternToTrigger.setItem(wsi.getItem());
        notifyPatternToTrigger.setNotifyService(notifyServiceEntity);
        notifyPatternToTrigger.setPattern("request-endorsement");
        this.notifyPatternToTriggerService.update(this.context, notifyPatternToTrigger);
        this.installItemService.installItem(this.context, (InProgressSubmission)wsi);
        this.context.commit();
        processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)1L);
        processed = this.ldnMessageService.extractAndProcessMessageFromQueue(this.context);
        Assert.assertEquals((long)processed, (long)0L);
    }

    private static RequestPostProcessor remoteHost(String remoteHost, String remoteAddr) {
        return request -> {
            request.setRemoteHost(remoteHost);
            request.setRemoteAddr(remoteAddr);
            return request;
        };
    }

    @After
    public void destroy() throws Exception {
        List ldnMessageEntities = this.ldnMessageService.findAll(this.context);
        if (CollectionUtils.isNotEmpty((Collection)ldnMessageEntities)) {
            ldnMessageEntities.forEach(ldnMessage -> {
                try {
                    this.ldnMessageService.delete(this.context, ldnMessage);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        super.destroy();
    }
}

