/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.CharEncoding;
import org.dspace.app.rest.matcher.EPersonMatcher;
import org.dspace.app.rest.matcher.WorkflowItemMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.PoolTaskBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class LoginAsEPersonIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private ObjectMapper mapper;

    @Before
    public void setup() {
        this.configurationService.setProperty("webui.user.assumelogin", (Object)true);
    }

    @Test
    public void loggedInUserRetrievalTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", EPersonMatcher.matchEPersonOnEmail(this.admin.getEmail())));
    }

    @Test
    public void loggedInAsOtherUserRetrievalTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).param("projection", new String[]{"full"}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.eperson", EPersonMatcher.matchEPersonOnEmail(this.eperson.getEmail())));
    }

    @Test
    public void loggedInAsOtherUserNotAUuidInHeaderBadRequestRetrievalTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).param("projection", new String[]{"full"}).header("X-On-Behalf-Of", new Object[]{"not-a-uuid"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void loggedInAsOtherUserWrongUuidInHeaderBadRequestRetrievalTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).param("projection", new String[]{"full"}).header("X-On-Behalf-Of", new Object[]{UUID.randomUUID()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void loggedInAsOtherUserNoPermissionForbiddenRetrievalTest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).param("projection", new String[]{"full"}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void loggedInUserPropertyFalseTest() throws Exception {
        this.configurationService.setProperty("webui.user.assumelogin", (Object)false);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void loggedInUserOtherAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson testEperson = EPersonBuilder.createEPerson((Context)this.context).withEmail("loginasuseradmin@test.com").build();
        Group adminGroup = this.groupService.findByName(this.context, "Administrator");
        this.groupService.addMember(this.context, adminGroup, testEperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0]).header("X-On-Behalf-Of", new Object[]{testEperson.getID()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createEmptyWorkspaceItemLoginOnBehalfOfCheckSubmitterTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        MvcResult mvcResult = this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/submission/workspaceitems", (Object[])new Object[0]).param("owningCollection", new String[]{col1.getID().toString()}).param("embed", new String[]{"collection"}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()}).contentType(MediaType.APPLICATION_JSON)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collection.id", (Matcher)Matchers.is((Object)col1.getID().toString()))).andReturn();
        String content = mvcResult.getResponse().getContentAsString();
        Map map = (Map)this.mapper.readValue(content, Map.class);
        String workspaceItemId = String.valueOf(map.get("id"));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + workspaceItemId), (Object[])new Object[0]).param("embed", new String[]{"submitter"})).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.submitter", EPersonMatcher.matchProperties(this.eperson)));
    }

    @Test
    public void claimTaskLoginOnBehalfOfTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = poolTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).header("X-On-Behalf-Of", new Object[]{reviewer.getID()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + poolTask.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))})));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.owner", (Matcher)Matchers.is(EPersonMatcher.matchEPersonOnEmail(reviewer.getEmail()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void deleteOneArchivedLoginOnBehalfOfNonAdminForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem, (InputStream)is).withName("Bitstream1").withMimeType("text/plain").build();
        }
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem.getID() + "/bundles"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + publicItem.getID() + "/bundles"))));
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + publicItem.getID()), (Object[])new Object[0]).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }
}

