/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.converter.MetadataSchemaConverter;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.MetadataschemaMatcher;
import org.dspace.app.rest.model.MetadataSchemaRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.MetadataSchemaBuilder;
import org.dspace.content.MetadataSchema;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class MetadataSchemaRestRepositoryIT
extends AbstractControllerIntegrationTest {
    private static final String TEST_NAME = "testSchemaName";
    private static final String TEST_NAMESPACE = "testSchemaNameSpace";
    private static final String TEST_NAME_UPDATED = "testSchemaNameUpdated";
    private static final String TEST_NAMESPACE_UPDATED = "testSchemaNameSpaceUpdated";
    @Autowired
    private MetadataSchemaConverter metadataSchemaConverter;
    @Autowired
    private ObjectMapper mapper;

    @Test
    public void findAll() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema metadataSchema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ATest", (String)"ANamespace").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadataschemas", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadataschemas", (Matcher)Matchers.hasItem(MetadataschemaMatcher.matchEntry()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/metadataschemas"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20)));
    }

    @Test
    public void findOne() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema metadataSchema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ATest", (String)"ANamespace").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(MetadataschemaMatcher.matchEntry(metadataSchema))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSuccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema metadataSchema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ATest", (String)"ANamespace").build();
        this.context.restoreAuthSystemState();
        MetadataSchemaRest metadataSchemaRest = this.metadataSchemaConverter.convert(metadataSchema, Projection.DEFAULT);
        metadataSchemaRest.setPrefix(TEST_NAME);
        metadataSchemaRest.setNamespace(TEST_NAMESPACE);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/metadataschemas", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)metadataSchemaRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/metadataschemas/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", MetadataschemaMatcher.matchEntry(TEST_NAME, TEST_NAMESPACE)));
        }
        finally {
            MetadataSchemaBuilder.deleteMetadataSchema((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void createUnprocessableEntity_prefixContainingInvalidCharacters() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema metadataSchema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ATest", (String)"ANamespace").build();
        this.context.restoreAuthSystemState();
        MetadataSchemaRest metadataSchemaRest = this.metadataSchemaConverter.convert(metadataSchema, Projection.DEFAULT);
        metadataSchemaRest.setPrefix("test.SchemaName");
        metadataSchemaRest.setNamespace(TEST_NAMESPACE);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/metadataschemas", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)metadataSchemaRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        metadataSchemaRest.setPrefix("test,SchemaName");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/metadataschemas", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)metadataSchemaRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        metadataSchemaRest.setPrefix("test SchemaName");
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/metadataschemas", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)metadataSchemaRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createUnauthorizedTest() throws Exception {
        MetadataSchemaRest metadataSchemaRest = new MetadataSchemaRest();
        metadataSchemaRest.setPrefix(TEST_NAME);
        metadataSchemaRest.setNamespace(TEST_NAMESPACE);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/metadataschemas", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)metadataSchemaRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void deleteSuccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema metadataSchema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"ATest", (String)"A namespace").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema metadataSchema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)TEST_NAME, (String)TEST_NAMESPACE).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteNonExisting() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema metadataSchema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)"A name", (String)"A namespace").build();
        this.context.restoreAuthSystemState();
        Integer id = metadataSchema.getID();
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/metadataschemas/" + id), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/metadataschemas/" + id), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void update() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema metadataSchema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)TEST_NAME, (String)TEST_NAMESPACE).build();
        this.context.restoreAuthSystemState();
        MetadataSchemaRest metadataSchemaRest = new MetadataSchemaRest();
        metadataSchemaRest.setId((Serializable)metadataSchema.getID());
        metadataSchemaRest.setPrefix(TEST_NAME);
        metadataSchemaRest.setNamespace(TEST_NAMESPACE_UPDATED);
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)metadataSchemaRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", MetadataschemaMatcher.matchEntry(TEST_NAME, TEST_NAMESPACE_UPDATED)));
    }

    @Test
    public void update_schemaNameShouldThrowError() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema metadataSchema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)TEST_NAME, (String)TEST_NAMESPACE).build();
        this.context.restoreAuthSystemState();
        MetadataSchemaRest metadataSchemaRest = new MetadataSchemaRest();
        metadataSchemaRest.setId((Serializable)metadataSchema.getID());
        metadataSchemaRest.setPrefix(TEST_NAME_UPDATED);
        metadataSchemaRest.setNamespace(TEST_NAMESPACE_UPDATED);
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)metadataSchemaRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", MetadataschemaMatcher.matchEntry(TEST_NAME, TEST_NAMESPACE)));
    }

    @Test
    public void updateUnauthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema metadataSchema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)TEST_NAME, (String)TEST_NAMESPACE).build();
        this.context.restoreAuthSystemState();
        MetadataSchemaRest metadataSchemaRest = new MetadataSchemaRest();
        metadataSchemaRest.setId((Serializable)metadataSchema.getID());
        metadataSchemaRest.setPrefix(TEST_NAME_UPDATED);
        metadataSchemaRest.setNamespace(TEST_NAMESPACE_UPDATED);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)metadataSchemaRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", MetadataschemaMatcher.matchEntry(TEST_NAME, TEST_NAMESPACE)));
    }

    @Test
    public void updateWrongRights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema metadataSchema = MetadataSchemaBuilder.createMetadataSchema((Context)this.context, (String)TEST_NAME, (String)TEST_NAMESPACE).build();
        this.context.restoreAuthSystemState();
        MetadataSchemaRest metadataSchemaRest = new MetadataSchemaRest();
        metadataSchemaRest.setId((Serializable)metadataSchema.getID());
        metadataSchemaRest.setPrefix(TEST_NAME_UPDATED);
        metadataSchemaRest.setNamespace(TEST_NAMESPACE_UPDATED);
        this.getClient(this.getAuthToken(this.eperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)metadataSchemaRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/metadataschemas/" + metadataSchema.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", MetadataschemaMatcher.matchEntry(TEST_NAME, TEST_NAMESPACE)));
    }

    @Test
    public void findAllPaginationTest() throws Exception {
        int numberOfSchema = ContentServiceFactory.getInstance().getMetadataSchemaService().findAll(this.context).size();
        int pageSize = 6;
        int numberOfPages = (int)Math.ceil((double)numberOfSchema / (double)pageSize);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadataschemas", (Object[])new Object[0]).param("size", new String[]{String.valueOf(pageSize)}).param("page", new String[]{"0"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadataschemas", (Matcher)Matchers.hasItem(MetadataschemaMatcher.matchEntry()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadataschemas?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadataschemas?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadataschemas?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadataschemas?"), (Matcher)Matchers.containsString((String)("page=" + (numberOfPages - 1))), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)numberOfSchema))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)numberOfPages))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)pageSize)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadataschemas", (Object[])new Object[0]).param("size", new String[]{String.valueOf(pageSize)}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadataschemas", (Matcher)Matchers.hasItem(MetadataschemaMatcher.matchEntry()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadataschemas?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadataschemas?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadataschemas?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadataschemas?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadataschemas?"), (Matcher)Matchers.containsString((String)("page=" + (numberOfPages - 1))), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)numberOfSchema))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)numberOfPages))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)pageSize)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/metadataschemas", (Object[])new Object[0]).param("size", new String[]{String.valueOf(pageSize)}).param("page", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.metadataschemas", (Matcher)Matchers.hasItem(MetadataschemaMatcher.matchEntry()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadataschemas?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadataschemas?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadataschemas?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/metadataschemas?"), (Matcher)Matchers.containsString((String)("page=" + (numberOfPages - 1))), (Matcher)Matchers.containsString((String)("size=" + pageSize))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)numberOfSchema))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)numberOfPages))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)pageSize)));
    }
}

