/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.service.NotifyService;
import org.dspace.app.rest.matcher.NotifyServiceMatcher;
import org.dspace.app.rest.model.NotifyServiceInboundPatternRest;
import org.dspace.app.rest.model.NotifyServiceRest;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.RemoveOperation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.NotifyServiceBuilder;
import org.dspace.builder.NotifyServiceInboundPatternBuilder;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class NotifyServiceRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private NotifyService notifyService;
    @Autowired
    private ObjectMapper mapper;

    @Test
    public void findAllUnAuthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/ldn/ldnservices", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntityOne = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name one").withDescription("service description one").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        NotifyServiceEntity notifyServiceEntityTwo = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name two").withDescription("service description two").withUrl("https://service2.ldn.org/about").withLdnUrl("https://service2.ldn.org/inbox").build();
        NotifyServiceEntity notifyServiceEntityThree = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name three").withDescription("service description three").withUrl("https://service3.ldn.org/about").withLdnUrl("https://service3.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/ldn/ldnservices", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.ldnservices", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyService(notifyServiceEntityOne.getID(), "service name one", "service description one", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), NotifyServiceMatcher.matchNotifyService(notifyServiceEntityTwo.getID(), "service name two", "service description two", "https://service2.ldn.org/about", "https://service2.ldn.org/inbox"), NotifyServiceMatcher.matchNotifyService(notifyServiceEntityThree.getID(), "service name three", "service description three", "https://service3.ldn.org/about", "https://service3.ldn.org/inbox")})));
    }

    @Test
    public void findOneUnAuthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/ldn/ldnservices/1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneNotFoundTest() throws Exception {
        this.getClient(this.getAuthToken(this.eperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/ldn/ldnservices/" + RandomUtils.nextInt()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox")));
    }

    @Test
    public void createForbiddenTest() throws Exception {
        NotifyServiceRest notifyServiceRest = new NotifyServiceRest();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/ldn/ldnservices", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)notifyServiceRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void createTestScoreFail() throws Exception {
        NotifyServiceInboundPatternRest inboundPatternRestOne = new NotifyServiceInboundPatternRest();
        inboundPatternRestOne.setPattern("patternA");
        inboundPatternRestOne.setConstraint("itemFilterA");
        inboundPatternRestOne.setAutomatic(true);
        NotifyServiceInboundPatternRest inboundPatternRestTwo = new NotifyServiceInboundPatternRest();
        inboundPatternRestTwo.setPattern("patternB");
        inboundPatternRestTwo.setAutomatic(false);
        NotifyServiceRest notifyServiceRest = new NotifyServiceRest();
        notifyServiceRest.setName("service name");
        notifyServiceRest.setDescription("service description");
        notifyServiceRest.setUrl("service url");
        notifyServiceRest.setLdnUrl("service ldn url");
        notifyServiceRest.setScore(BigDecimal.TEN);
        notifyServiceRest.setNotifyServiceInboundPatterns(List.of(inboundPatternRestOne, inboundPatternRestTwo));
        notifyServiceRest.setEnabled(false);
        notifyServiceRest.setUsesActorEmailId(false);
        AtomicReference idRef = new AtomicReference();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/ldn/ldnservices", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)notifyServiceRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createTest() throws Exception {
        NotifyServiceInboundPatternRest inboundPatternRestOne = new NotifyServiceInboundPatternRest();
        inboundPatternRestOne.setPattern("patternA");
        inboundPatternRestOne.setConstraint("itemFilterA");
        inboundPatternRestOne.setAutomatic(true);
        NotifyServiceInboundPatternRest inboundPatternRestTwo = new NotifyServiceInboundPatternRest();
        inboundPatternRestTwo.setPattern("patternB");
        inboundPatternRestTwo.setAutomatic(false);
        NotifyServiceRest notifyServiceRest = new NotifyServiceRest();
        notifyServiceRest.setName("service name");
        notifyServiceRest.setDescription("service description");
        notifyServiceRest.setUrl("https://service.ldn.org/about");
        notifyServiceRest.setLdnUrl("https://service.ldn.org/inbox");
        notifyServiceRest.setNotifyServiceInboundPatterns(List.of(inboundPatternRestOne, inboundPatternRestTwo));
        notifyServiceRest.setEnabled(false);
        notifyServiceRest.setUsesActorEmailId(false);
        notifyServiceRest.setLowerIp("192.168.0.1");
        notifyServiceRest.setUpperIp("192.168.0.5");
        AtomicReference idRef = new AtomicReference();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/ldn/ldnservices", (Object[])new Object[0]).content(this.mapper.writeValueAsBytes((Object)notifyServiceRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService("service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox", false, "192.168.0.1", "192.168.0.5"))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/ldn/ldnservices/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService((Integer)idRef.get(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox", false, "192.168.0.1", "192.168.0.5"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", true), NotifyServiceMatcher.matchNotifyServicePattern("patternB", null, false)})))));
        NotifyServiceBuilder.deleteNotifyService((Integer)((Integer)idRef.get()));
    }

    @Test
    public void notifyServicePatchOperationForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation operation = new AddOperation("/description", (Object)"add service description");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void notifyServiceDescriptionAddOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation operation = new AddOperation("/description", (Object)"add service description");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void notifyServiceDescriptionAddOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").isEnabled(false).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation operation = new AddOperation("/description", (Object)"add service description");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "add service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox", false)));
    }

    @Test
    public void notifyServiceDescriptionReplaceOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation operation = new ReplaceOperation("/description", (Object)"service description replaced");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void notifyServiceDescriptionReplaceOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation operation = new ReplaceOperation("/description", (Object)"service description replaced");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description replaced", "https://service.ldn.org/about", "https://service.ldn.org/inbox", false)));
    }

    @Test
    public void notifyServiceDescriptionRemoveOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").isEnabled(false).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation operation = new RemoveOperation("/description");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", null, "https://service.ldn.org/about", "https://service.ldn.org/inbox", false)));
    }

    @Test
    public void notifyServiceUrlAddOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation operation = new AddOperation("/url", (Object)"add service url");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void notifyServiceUrlAddOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation operation = new AddOperation("/url", (Object)"add service url");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "add service url", "https://service.ldn.org/inbox", false)));
    }

    @Test
    public void notifyServiceUrlReplaceOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation operation = new ReplaceOperation("/url", (Object)"service url replaced");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void notifyServiceUrlReplaceOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").isEnabled(true).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation operation = new ReplaceOperation("/url", (Object)"service url replaced");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "service url replaced", "https://service.ldn.org/inbox", true)));
    }

    @Test
    public void notifyServiceUrlRemoveOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation operation = new RemoveOperation("/url");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", null, "https://service.ldn.org/inbox")));
    }

    @Test
    @Ignore
    public void notifyServiceNameReplaceOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation operation = new ReplaceOperation("/name", (Object)"service name replaced");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void notifyServiceNameReplaceOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation operation = new ReplaceOperation("/name", (Object)"service name replaced");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name replaced", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox")));
    }

    @Test
    public void notifyServiceLdnUrlReplaceOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withUrl("https://service.ldn.org/about").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation operation = new ReplaceOperation("/ldnurl", (Object)"service ldn url replaced");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void notifyServiceLdnUrlReplaceOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation operation = new ReplaceOperation("/ldnurl", (Object)"service ldn url replaced");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "service ldn url replaced")));
    }

    @Test
    public void notifyServiceNameRemoveOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation operation = new RemoveOperation("/name");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    @Ignore
    public void notifyServiceLdnUrlRemoveOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation operation = new RemoveOperation("/ldnurl");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void findByLdnUrlUnAuthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/ldn/ldnservices/search/byLdnUrl", (Object[])new Object[0]).param("ldnUrl", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findByLdnUrlBadRequestTest() throws Exception {
        this.getClient(this.getAuthToken(this.eperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/ldn/ldnservices/search/byLdnUrl", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findByLdnUrlTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntityOne = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name one").withDescription("service description one").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        NotifyServiceEntity notifyServiceEntityTwo = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name two").withDescription("service description two").withUrl("https://service2.ldn.org/about").withLdnUrl("https://service2.ldn.org/inbox").build();
        NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name three").withDescription("service description three").withUrl("https://service3.ldn.org/about").withLdnUrl("https://service3.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/ldn/ldnservices/search/byLdnUrl", (Object[])new Object[0]).param("ldnUrl", new String[]{notifyServiceEntityOne.getLdnUrl()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntityOne.getID(), "service name one", "service description one", "https://service.ldn.org/about", "https://service.ldn.org/inbox")));
    }

    @Test
    public void deleteUnAuthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/ldn/ldnservices/" + RandomUtils.nextInt()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void deleteForbiddenTest() throws Exception {
        this.getClient(this.getAuthToken(this.eperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/ldn/ldnservices/" + RandomUtils.nextInt()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void deleteNotFoundTest() throws Exception {
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/ldn/ldnservices/" + RandomUtils.nextInt()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("service ldnUrl").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void NotifyServiceInboundPatternsAddOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
    }

    @Test
    public void NotifyServiceInboundPatternsAddOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void NotifyServiceInboundPatternRemoveOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        RemoveOperation inboundRemoveOperation = new RemoveOperation("notifyServiceInboundPatterns[0]");
        ops.clear();
        ops.add((Operation)inboundRemoveOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasItem(NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true))))));
    }

    @Test
    public void NotifyServiceInboundPatternsRemoveOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperation = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        ops.add((Operation)inboundAddOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false)})))));
        RemoveOperation inboundRemoveOperation = new RemoveOperation("notifyServiceInboundPatterns[1]");
        ops.clear();
        ops.add((Operation)inboundRemoveOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void NotifyServiceInboundPatternConstraintAddOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":null,\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", null, false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        AddOperation inboundAddOperation = new AddOperation("notifyServiceInboundPatterns[0]/constraint", (Object)"itemFilterA");
        ops.clear();
        ops.add((Operation)inboundAddOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
    }

    @Test
    public void NotifyServiceInboundPatternConstraintAddOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        AddOperation inboundAddOperation = new AddOperation("notifyServiceInboundPatterns[0]/constraint", (Object)"itemFilterA");
        ops.clear();
        ops.add((Operation)inboundAddOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void NotifyServiceInboundPatternConstraintReplaceOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        ReplaceOperation inboundReplaceOperation = new ReplaceOperation("notifyServiceInboundPatterns[0]/constraint", (Object)"itemFilterC");
        ops.clear();
        ops.add((Operation)inboundReplaceOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterC", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
    }

    @Test
    public void NotifyServiceInboundPatternConstraintReplaceOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":null,\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", null, false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        ReplaceOperation inboundReplaceOperation = new ReplaceOperation("notifyServiceInboundPatterns[0]/constraint", (Object)"itemFilterA");
        ops.clear();
        ops.add((Operation)inboundReplaceOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void NotifyServiceInboundPatternConstraintRemoveOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        RemoveOperation inboundRemoveOperation = new RemoveOperation("notifyServiceInboundPatterns[1]/constraint");
        ops.clear();
        ops.add((Operation)inboundRemoveOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", null, true)})))));
    }

    @Test
    public void NotifyServiceInboundPatternConstraintRemoveOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperation = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        ops.add((Operation)inboundAddOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false)})))));
        RemoveOperation inboundRemoveOperation = new RemoveOperation("notifyServiceInboundPatterns[1]/constraint");
        ops.clear();
        ops.add((Operation)inboundRemoveOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void NotifyServiceInboundPatternPatternAddOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":null,\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern(null, "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        AddOperation inboundAddOperation = new AddOperation("notifyServiceInboundPatterns[0]/pattern", (Object)"patternA");
        ops.clear();
        ops.add((Operation)inboundAddOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
    }

    @Test
    public void NotifyServiceInboundPatternPatternAddOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        AddOperation inboundAddOperation = new AddOperation("notifyServiceInboundPatterns[0]/pattern", (Object)"patternA");
        ops.clear();
        ops.add((Operation)inboundAddOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void NotifyServiceInboundPatternPatternReplaceOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        ReplaceOperation inboundReplaceOperation = new ReplaceOperation("notifyServiceInboundPatterns[0]/pattern", (Object)"patternC");
        ops.clear();
        ops.add((Operation)inboundReplaceOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternC", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
    }

    @Test
    public void NotifyServiceInboundPatternPatternReplaceOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":null,\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern(null, "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        ReplaceOperation inboundReplaceOperation = new ReplaceOperation("notifyServiceInboundPatterns[0]/pattern", (Object)"patternA");
        ops.clear();
        ops.add((Operation)inboundReplaceOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void NotifyServiceInboundPatternAutomaticReplaceOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        ReplaceOperation inboundReplaceOperation = new ReplaceOperation("notifyServiceInboundPatterns[0]/automatic", (Object)"true");
        ops.clear();
        ops.add((Operation)inboundReplaceOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", true), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
    }

    @Test
    public void NotifyServiceInboundPatternAutomaticReplaceOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        ReplaceOperation inboundReplaceOperation = new ReplaceOperation("notifyServiceInboundPatterns[0]/automatic", (Object)"test");
        ops.clear();
        ops.add((Operation)inboundReplaceOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void NotifyServiceInboundPatternsReplaceOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        ReplaceOperation inboundReplaceOperation = new ReplaceOperation("notifyServiceInboundPatterns", (Object)"[{\"pattern\":\"patternC\",\"constraint\":\"itemFilterC\",\"automatic\":\"true\"},{\"pattern\":\"patternD\",\"constraint\":\"itemFilterD\",\"automatic\":\"true\"}]");
        ops.clear();
        ops.add((Operation)inboundReplaceOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternC", "itemFilterC", true), NotifyServiceMatcher.matchNotifyServicePattern("patternD", "itemFilterD", true)})))));
    }

    @Test
    public void NotifyServiceInboundPatternsReplaceWithEmptyArrayOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        ReplaceOperation inboundReplaceOperation = new ReplaceOperation("notifyServiceInboundPatterns", (Object)"[]");
        ops.clear();
        ops.add((Operation)inboundReplaceOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.empty()));
    }

    @Test
    public void NotifyServiceInboundPatternsReplaceOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        ReplaceOperation inboundReplaceOperation = new ReplaceOperation("notifyServiceInboundPatterns", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.clear();
        ops.add((Operation)inboundReplaceOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void NotifyServiceInboundPatternsRemoveOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        RemoveOperation inboundRemoveOperation = new RemoveOperation("notifyServiceInboundPatterns");
        ops.clear();
        ops.add((Operation)inboundRemoveOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.empty()));
    }

    @Test
    public void NotifyServiceInboundPatternReplaceOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation inboundAddOperationOne = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternA\",\"constraint\":\"itemFilterA\",\"automatic\":\"false\"}");
        AddOperation inboundAddOperationTwo = new AddOperation("notifyServiceInboundPatterns/-", (Object)"{\"pattern\":\"patternB\",\"constraint\":\"itemFilterB\",\"automatic\":\"true\"}");
        ops.add((Operation)inboundAddOperationOne);
        ops.add((Operation)inboundAddOperationTwo);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternB", "itemFilterB", true)})))));
        ReplaceOperation inboundReplaceOperation = new ReplaceOperation("notifyServiceInboundPatterns[1]", (Object)"{\"pattern\":\"patternC\",\"constraint\":\"itemFilterC\",\"automatic\":\"false\"}");
        ops.clear();
        ops.add((Operation)inboundReplaceOperation);
        patchBody = this.getPatchContent(ops);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf(NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.contains((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyServicePattern("patternA", "itemFilterA", false), NotifyServiceMatcher.matchNotifyServicePattern("patternC", "itemFilterC", false)})))));
    }

    @Test
    public void findManualServicesByInboundPatternUnAuthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/ldn/ldnservices/search/byInboundPattern", (Object[])new Object[0]).param("pattern", new String[]{"pattern"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findManualServicesByInboundPatternBadRequestTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/ldn/ldnservices/search/byInboundPattern", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findManualServicesByInboundPatternTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntityOne = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name one").withDescription("service description one").withUrl("https://service.ldn.org/about").withStatus(true).withLdnUrl("https://service.ldn.org/inbox").build();
        NotifyServiceEntity notifyServiceEntityTwo = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name two").withDescription("service description two").withUrl("https://service2.ldn.org/about").withStatus(true).withLdnUrl("https://service2.ldn.org/inbox").build();
        NotifyServiceEntity notifyServiceEntityThree = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name three").withDescription("service description").withUrl("https://service3.ldn.org/about").withStatus(true).withLdnUrl("https://service3.ldn.org/inbox").build();
        NotifyServiceInboundPatternBuilder.createNotifyServiceInboundPatternBuilder((Context)this.context, (NotifyServiceEntity)notifyServiceEntityOne).withPattern("review").withConstraint("itemFilterA").isAutomatic(false).build();
        NotifyServiceInboundPatternBuilder.createNotifyServiceInboundPatternBuilder((Context)this.context, (NotifyServiceEntity)notifyServiceEntityOne).withPattern("review").withConstraint("itemFilterB").isAutomatic(true).build();
        NotifyServiceInboundPatternBuilder.createNotifyServiceInboundPatternBuilder((Context)this.context, (NotifyServiceEntity)notifyServiceEntityTwo).withPattern("review").withConstraint("itemFilterA").isAutomatic(false).build();
        NotifyServiceInboundPatternBuilder.createNotifyServiceInboundPatternBuilder((Context)this.context, (NotifyServiceEntity)notifyServiceEntityTwo).withPattern("review").withConstraint("itemFilterB").isAutomatic(true).build();
        NotifyServiceInboundPatternBuilder.createNotifyServiceInboundPatternBuilder((Context)this.context, (NotifyServiceEntity)notifyServiceEntityThree).withPattern("review").withConstraint("itemFilterB").isAutomatic(true).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/ldn/ldnservices/search/byInboundPattern", (Object[])new Object[0]).param("pattern", new String[]{"review"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.ldnservices", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{NotifyServiceMatcher.matchNotifyService(notifyServiceEntityOne.getID(), "service name one", "service description one", "https://service.ldn.org/about", "https://service.ldn.org/inbox"), NotifyServiceMatcher.matchNotifyService(notifyServiceEntityTwo.getID(), "service name two", "service description two", "https://service2.ldn.org/about", "https://service2.ldn.org/inbox")})));
    }

    @Test
    public void NotifyServiceStatusReplaceOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").isEnabled(true).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation inboundReplaceOperation = new ReplaceOperation("/enabled", (Object)"false");
        ops.add((Operation)inboundReplaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.notifyServiceInboundPatterns", (Matcher)Matchers.empty())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox", false)));
    }

    @Test
    public void NotifyServiceScoreReplaceOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withScore(BigDecimal.ZERO).withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation inboundReplaceOperation = new ReplaceOperation("/score", (Object)"0.522");
        ops.add((Operation)inboundReplaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox", false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.score", (Matcher)Matchers.notNullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.score", (Matcher)Matchers.closeTo((double)0.522, (double)0.001)));
    }

    @Test
    public void NotifyServiceScoreReplaceOperationTestUnprocessableTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("service url").withLdnUrl("service ldn url").withScore(BigDecimal.ZERO).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation inboundReplaceOperation = new ReplaceOperation("/score", (Object)"10");
        ops.add((Operation)inboundReplaceOperation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void notifyServiceScoreAddOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("service url").withLdnUrl("service ldn url").isEnabled(false).build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation operation = new AddOperation("/score", (Object)"1");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "service url", "service ldn url", false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.score", (Matcher)Matchers.notNullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.score", (Matcher)Matchers.closeTo((double)1.0, (double)0.001)));
    }

    @After
    public void destroy() throws Exception {
        List notifyServiceEntities = this.notifyService.findAll(this.context);
        if (CollectionUtils.isNotEmpty((Collection)notifyServiceEntities)) {
            notifyServiceEntities.forEach(notifyServiceEntity -> {
                try {
                    this.notifyService.delete(this.context, notifyServiceEntity);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        super.destroy();
    }

    @Test
    public void notifyServiceLowerIpReplaceOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withUrl("https://service.ldn.org/about").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation operation = new ReplaceOperation("/lowerIp", (Object)"192.168.0.1");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void notifyServiceLowerIpReplaceOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").withLowerIp("192.168.0.1").withUpperIp("192.168.0.5").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation operation = new ReplaceOperation("/lowerIp", (Object)"192.168.0.2");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox", false, "192.168.0.2", "192.168.0.5")));
    }

    @Test
    public void notifyServiceLowerIpRemoveOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").withLowerIp("192.168.0.1").withUpperIp("192.168.0.5").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation operation = new RemoveOperation("/lowerIp");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void notifyServiceUpperIpReplaceOperationBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withUrl("https://service.ldn.org/about").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation operation = new ReplaceOperation("/lowerIp", (Object)"192.168.0.8");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void notifyServiceUpperIpReplaceOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").withLowerIp("192.168.0.1").withUpperIp("192.168.0.5").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ReplaceOperation operation = new ReplaceOperation("/upperIp", (Object)"192.168.0.8");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", NotifyServiceMatcher.matchNotifyService(notifyServiceEntity.getID(), "service name", "service description", "https://service.ldn.org/about", "https://service.ldn.org/inbox", false, "192.168.0.1", "192.168.0.8")));
    }

    @Test
    public void notifyServiceUpperIpRemoveOperationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyServiceEntity = NotifyServiceBuilder.createNotifyServiceBuilder((Context)this.context, (String)"service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").withLowerIp("192.168.0.1").withUpperIp("192.168.0.5").build();
        this.context.restoreAuthSystemState();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation operation = new RemoveOperation("/upperIp");
        ops.add((Operation)operation);
        String patchBody = this.getPatchContent(ops);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/ldn/ldnservices/" + notifyServiceEntity.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }
}

