/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.ExternalSourceEntryMatcher;
import org.dspace.app.rest.matcher.ExternalSourceMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.openalex.service.OpenAlexImportMetadataSourceServiceImpl;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class OpenAlexFunderExternalSourcesIT
extends AbstractControllerIntegrationTest {
    @MockitoBean
    private LiveImportClient liveImportClient;
    @Autowired
    @Qualifier(value="openalexImportFunderService")
    private OpenAlexImportMetadataSourceServiceImpl openAlexImportMetadataSourceService;

    @Before
    public void setUp() {
        ReflectionTestUtils.setField((Object)this.openAlexImportMetadataSourceService, (String)"liveImportClient", (Object)this.liveImportClient);
    }

    @Test
    public void findOneOpenalexImportFunderExternalExternalSourceTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources?size=25", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalsources", (Matcher)Matchers.hasItem(ExternalSourceMatcher.matchExternalSource("openalexFunder", "openalexFunder", false))));
    }

    @Test
    public void findOpenalexFunderExternalSourceEntriesEmptyWithQueryTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-empty.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexFunder/entries", (Object[])new Object[0]).param("query", new String[]{"empty"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }

    @Test
    public void findOpenalexFunderExternalSourceEntriesTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-funder-single.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexFunder/entries", (Object[])new Object[0]).param("query", new String[]{"National"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].id", (Object[])new Object[0]).value((Object)"F4320321001")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].display", (Object[])new Object[0]).value((Object)"National Natural Science Foundation of China")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].externalSource", (Object[])new Object[0]).value((Object)"openalexFunder")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.openalex'][0].value", (Object[])new Object[0]).value((Object)"F4320321001")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.title'][0].value", (Object[])new Object[0]).value((Object)"National Natural Science Foundation of China")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['organization.legalName'][0].value", (Object[])new Object[0]).value((Object)"National Natural Science Foundation of China")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['organization.address.addressCountry'][0].value", (Object[])new Object[0]).value((Object)"CN")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][0].value", (Object[])new Object[0]).value((Object)"NNSF of China")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][1].value", (Object[])new Object[0]).value((Object)"Gu\u00f3ji\u0101 Z\u00ecr\u00e1n K\u0113xu\u00e9 J\u012bj\u012bn W\u011biyu\u00e1nhu\u00ec")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][2].value", (Object[])new Object[0]).value((Object)"NSF of China")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][3].value", (Object[])new Object[0]).value((Object)"The National Natural Science Foundation of China")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][4].value", (Object[])new Object[0]).value((Object)"\u56fd\u5bb6\u81ea\u7136\u79d1\u5b66\u57fa\u91d1\u59d4\u5458\u4f1a")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][5].value", (Object[])new Object[0]).value((Object)"National Nature Science Foundation of China")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][6].value", (Object[])new Object[0]).value((Object)"NSFC")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][7].value", (Object[])new Object[0]).value((Object)"National Science Foundation of China")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][8].value", (Object[])new Object[0]).value((Object)"Natural Science Foundation of China")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][9].value", (Object[])new Object[0]).value((Object)"NNSFC")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][10].value", (Object[])new Object[0]).value((Object)"Chinese National Science Foundation")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][11].value", (Object[])new Object[0]).value((Object)"NNSF")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][12].value", (Object[])new Object[0]).value((Object)"Chinese government body")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Object[])new Object[0]).value((Object)"http://localhost/api/integration/externalsources/openalexFunder/entries?page=0&size=20")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Object[])new Object[0]).value((Object)20)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Object[])new Object[0]).value((Object)1819)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Object[])new Object[0]).value((Object)91)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Object[])new Object[0]).value((Object)0));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }

    @Test
    public void findAllOpenalexFunderExternalSourceEntriesWithQueryTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-funder-multiple.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexFunder/entries", (Object[])new Object[0]).param("query", new String[]{"National"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ExternalSourceEntryMatcher.matchExternalSourceEntry("F4320321001", "National Natural Science Foundation of China", "National Natural Science Foundation of China", "openalexFunder"), ExternalSourceEntryMatcher.matchExternalSourceEntry("F4320306076", "National Science Foundation", "National Science Foundation", "openalexFunder")})));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }
}

