/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.ExternalSourceEntryMatcher;
import org.dspace.app.rest.matcher.ExternalSourceMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.openalex.service.OpenAlexImportMetadataSourceServiceImpl;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class OpenAlexInstitutionExternalSourcesIT
extends AbstractControllerIntegrationTest {
    @MockitoBean
    private LiveImportClient liveImportClient;
    @Autowired
    @Qualifier(value="openalexImportInstitutionService")
    private OpenAlexImportMetadataSourceServiceImpl openAlexImportMetadataSourceService;

    @Before
    public void setUp() {
        ReflectionTestUtils.setField((Object)this.openAlexImportMetadataSourceService, (String)"liveImportClient", (Object)this.liveImportClient);
    }

    @Test
    public void findOneOpenalexImportInstitutionExternalExternalSourceTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources?size=25", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalsources", (Matcher)Matchers.hasItem(ExternalSourceMatcher.matchExternalSource("openalexInstitution", "openalexInstitution", false))));
    }

    @Test
    public void findOpenalexInstitutionExternalSourceEntriesEmptyWithQueryTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-empty.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexInstitution/entries", (Object[])new Object[0]).param("query", new String[]{"empty"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }

    @Test
    public void findOpenalexInstitutionExternalSourceEntriesTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-institution-single.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexInstitution/entries", (Object[])new Object[0]).param("query", new String[]{"Centre"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].id", (Object[])new Object[0]).value((Object)"I1294671590")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].display", (Object[])new Object[0]).value((Object)"Centre National de la Recherche Scientifique")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].externalSource", (Object[])new Object[0]).value((Object)"openalexInstitution")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.openalex'][0].value", (Object[])new Object[0]).value((Object)"I1294671590")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.isni'][0].value", (Object[])new Object[0]).value((Object)"https://www.isni.org/wiki/1234")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.rid'][0].value", (Object[])new Object[0]).value((Object)"https://www.rid.org/wiki/1234")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.title'][0].value", (Object[])new Object[0]).value((Object)"Centre National de la Recherche Scientifique")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['organization.legalName'][0].value", (Object[])new Object[0]).value((Object)"Centre National de la Recherche Scientifique")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['organization.address.addressCountry'][0].value", (Object[])new Object[0]).value((Object)"FR")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['organization.address.addressLocality'][0].value", (Object[])new Object[0]).value((Object)"Paris Test Region France")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['organization.identifier.ror'][0].value", (Object[])new Object[0]).value((Object)"https://ror.org/02feahw73")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][0].value", (Object[])new Object[0]).value((Object)"CNRS")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'][1].value", (Object[])new Object[0]).value((Object)"French National Centre for Scientific Research"));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }

    @Test
    public void findAllOpenalexInstitutionExternalSourceEntriesWithQueryTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-institution-multiple.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexInstitution/entries", (Object[])new Object[0]).param("query", new String[]{"Centre"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ExternalSourceEntryMatcher.matchExternalSourceEntry("I1294671590", "Centre National de la Recherche Scientifique", "Centre National de la Recherche Scientifique", "openalexInstitution"), ExternalSourceEntryMatcher.matchExternalSourceEntry("I4210118689", "Joint Research Centre", "Joint Research Centre", "openalexInstitution")})));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }
}

