/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.ExternalSourceEntryMatcher;
import org.dspace.app.rest.matcher.ExternalSourceMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.openalex.service.OpenAlexImportMetadataSourceServiceImpl;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class OpenAlexJournalExternalSourcesIT
extends AbstractControllerIntegrationTest {
    @MockitoBean
    private LiveImportClient liveImportClient;
    @Autowired
    @Qualifier(value="openalexImportJournalService")
    private OpenAlexImportMetadataSourceServiceImpl openAlexImportMetadataSourceService;

    @Before
    public void setUp() {
        ReflectionTestUtils.setField((Object)this.openAlexImportMetadataSourceService, (String)"liveImportClient", (Object)this.liveImportClient);
    }

    @Test
    public void findOneOpenalexImportJournalServiceExternalSourceTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources?size=25", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalsources", (Matcher)Matchers.hasItem(ExternalSourceMatcher.matchExternalSource("openalexJournal", "openalexJournal", false))));
    }

    @Test
    public void findOpenalexJournalExternalSourceEntriesEmptyWithQueryTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-empty.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexJournal/entries", (Object[])new Object[0]).param("query", new String[]{"empty"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }

    @Test
    public void findOpenalexJournalExternalSourceEntriesTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-journal-single.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexJournal/entries", (Object[])new Object[0]).param("query", new String[]{"Chem"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].id", (Object[])new Object[0]).value((Object)"S41354064")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].display", (Object[])new Object[0]).value((Object)"ChemInform")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].externalSource", (Object[])new Object[0]).value((Object)"openalexJournal")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.openalex'][0].value", (Object[])new Object[0]).value((Object)"S41354064")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.title'][0].value", (Object[])new Object[0]).value((Object)"ChemInform")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['creativework.publisher'][0].value", (Object[])new Object[0]).value((Object)"Wiley")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['creativeworkseries.issn'].length()", (Object[])new Object[0]).value((Object)3)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.description'].length()", (Object[])new Object[0]).value((Object)8));
            ArgumentCaptor paramsCaptor = ArgumentCaptor.forClass(Map.class);
            ArgumentCaptor timeoutCaptor = ArgumentCaptor.forClass(Integer.class);
            ArgumentCaptor urlCaptor = ArgumentCaptor.forClass(String.class);
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(((Integer)timeoutCaptor.capture()).intValue(), (String)urlCaptor.capture(), (Map)paramsCaptor.capture());
            HashMap expectedParams = new HashMap();
            HashMap<String, String> uriParams = new HashMap<String, String>();
            expectedParams.put("uriParameters", uriParams);
            uriParams.put("filter", "type:journal,default.search:Chem");
            Assert.assertEquals(expectedParams, (Object)paramsCaptor.getValue());
        }
    }

    @Test
    public void findAllOpenalexJournalExternalSourceEntriesWithQueryTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-journal-multiple.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexJournal/entries", (Object[])new Object[0]).param("query", new String[]{"Chem"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ExternalSourceEntryMatcher.matchExternalSourceEntry("S41354064", "ChemInform", "ChemInform", "openalexJournal"), ExternalSourceEntryMatcher.matchExternalSourceEntry("S2764455111", "Chem", "Chem", "openalexJournal")})));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }
}

