/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.ExternalSourceEntryMatcher;
import org.dspace.app.rest.matcher.ExternalSourceMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.openalex.service.OpenAlexImportMetadataSourceServiceImpl;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class OpenAlexPersonExternalSourcesIT
extends AbstractControllerIntegrationTest {
    @MockitoBean
    private LiveImportClient liveImportClient;
    @Autowired
    @Qualifier(value="openalexImportPersonService")
    private OpenAlexImportMetadataSourceServiceImpl openAlexImportMetadataSourceService;

    @Before
    public void setUp() {
        ReflectionTestUtils.setField((Object)this.openAlexImportMetadataSourceService, (String)"liveImportClient", (Object)this.liveImportClient);
    }

    @Test
    public void findOneOpenalexImportPersonServiceExternalSourceTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources?size=25", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalsources", (Matcher)Matchers.hasItem(ExternalSourceMatcher.matchExternalSource("openalexPerson", "openalexPerson", false))));
    }

    @Test
    public void findOpenalexPersonExternalSourceEntriesEmptyWithQueryTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-empty.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexPerson/entries", (Object[])new Object[0]).param("query", new String[]{"empty"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }

    @Test
    public void findOpenalexPersonExternalSourceEntriesTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-person-single.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexPerson/entries", (Object[])new Object[0]).param("query", new String[]{"Claudio Cortese"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].id", (Matcher)Matchers.is((Object)"A5016721535"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].display", (Matcher)Matchers.is((Object)"Claudio Giovanni Cortese"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].value", (Matcher)Matchers.is((Object)"Claudio Giovanni Cortese"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].externalSource", (Matcher)Matchers.is((Object)"openalexPerson"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.openalex'][0].value", (Matcher)Matchers.is((Object)"A5016721535"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.givenName'][0].value", (Matcher)Matchers.is((Object)"Claudio Giovanni"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.familyName'][0].value", (Matcher)Matchers.is((Object)"Cortese"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.identifier.orcid'][0].value", (Matcher)Matchers.is((Object)"https://orcid.org/0000-0002-9429-5000"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.affiliation.name']", (Matcher)Matchers.hasSize((int)10))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.affiliation.name'][0].value", (Matcher)Matchers.is((Object)"University of Rome Tor Vergata"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.affiliation.name'][1].value", (Matcher)Matchers.is((Object)"Ospedali Riuniti di Ancona"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['person.affiliation.name'][2].value", (Matcher)Matchers.is((Object)"University of Naples Federico II")));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }

    @Test
    public void findAllOpenalexPersonExternalSourceEntriesWithQueryTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-person-multiple.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexPerson/entries", (Object[])new Object[0]).param("query", new String[]{"covid"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ExternalSourceEntryMatcher.matchExternalSourceEntry("A5016721535", "Claudio Cortese", "Claudio Cortese", "openalexPerson"), ExternalSourceEntryMatcher.matchExternalSourceEntry("A5008845767", "Claudio Giovanni Cortese", "Claudio Giovanni Cortese", "openalexPerson")})));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }
}

