/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.ExternalSourceMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.openalex.service.OpenAlexImportMetadataSourceServiceImpl;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.MediaType;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class OpenAlexPublicationByDOIExternalSourcesIT
extends AbstractControllerIntegrationTest {
    @MockitoBean
    private LiveImportClient liveImportClient;
    @Autowired
    @Qualifier(value="openalexImportPublicationByDOIService")
    private OpenAlexImportMetadataSourceServiceImpl openAlexImportMetadataSourceService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ReflectionTestUtils.setField((Object)this.openAlexImportMetadataSourceService, (String)"liveImportClient", (Object)this.liveImportClient);
    }

    @Test
    public void findOneOpenalexImportPublicationByDOIExternalSourceTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources?size=25", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalsources", (Matcher)Matchers.hasItem(ExternalSourceMatcher.matchExternalSource("openalexPublicationByDOI", "openalexPublicationByDOI", false))));
    }

    @Test
    public void findOpenalexPublicationByDOIExternalSourceEntriesEmptyWithQueryTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-empty.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexPublicationByDOI/entries", (Object[])new Object[0]).param("query", new String[]{"W1775749144"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        }
    }

    @Test
    public void findOneOpenalexPublicationByDOIExternalSourceEntriesWithQueryTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-publication-single.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexPublicationByDOI/entries", (Object[])new Object[0]).param("query", new String[]{"10.1016/s0021-9258(19)52451-6"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].id", (Object[])new Object[0]).value((Object)"W1775749144")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].display", (Object[])new Object[0]).value((Object)"PROTEIN MEASUREMENT WITH THE FOLIN PHENOL REAGENT")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].value", (Object[])new Object[0]).value((Object)"PROTEIN MEASUREMENT WITH THE FOLIN PHENOL REAGENT")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].externalSource", (Object[])new Object[0]).value((Object)"openalexPublicationByDOI")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.contributor.author']", (Matcher)Matchers.hasSize((int)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.contributor.author'][0].value", (Object[])new Object[0]).value((Object)"OliverH. Lowry")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.contributor.author'][1].value", (Object[])new Object[0]).value((Object)"NiraJ. Rosebrough")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.contributor.author'][2].value", (Object[])new Object[0]).value((Object)"A. Farr")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.contributor.author'][3].value", (Object[])new Object[0]).value((Object)"RoseJ. Randall")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.other']", (Matcher)Matchers.hasSize((int)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.other'][0].value", (Object[])new Object[0]).value((Object)"https://pubmed.ncbi.nlm.nih.gov/14907713")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.other'][1].value", (Object[])new Object[0]).value((Object)"https://doi.org/10.1016/s0021-9258(19)52451-6/pdf")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.other'][2].value", (Object[])new Object[0]).value((Object)"https://doi.org/10.1016/s0021-9258(19)52451-6")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.date.issued'][0].value", (Object[])new Object[0]).value((Object)"1951-11-01")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.openalex'][0].value", (Object[])new Object[0]).value((Object)"W1775749144")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['oaire.citation.volume'][0].value", (Object[])new Object[0]).value((Object)"193")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['oaire.citation.issue'][0].value", (Object[])new Object[0]).value((Object)"1")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['oaire.citation.startPage'][0].value", (Object[])new Object[0]).value((Object)"265")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['oaire.citation.endPage'][0].value", (Object[])new Object[0]).value((Object)"275")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['oaire.version'][0].value", (Object[])new Object[0]).value((Object)"http://purl.org/coar/version/c_970fb48d4fbd8a85")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['oaire.citation.title'][0].value", (Object[])new Object[0]).value((Object)"Journal of Biological Chemistry")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.issn']", (Matcher)Matchers.hasSize((int)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.identifier.doi'][0].value", (Object[])new Object[0]).value((Object)"10.1016/s0021-9258(19)52451-6")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.language.iso'][0].value", (Object[])new Object[0]).value((Object)"en")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.title'][0].value", (Object[])new Object[0]).value((Object)"PROTEIN MEASUREMENT WITH THE FOLIN PHENOL REAGENT")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.subject']", (Matcher)Matchers.hasSize((int)13))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.subject'][9].value", (Object[])new Object[0]).value((Object)"Peer Review, Research standards")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.subject'][12].value", (Object[])new Object[0]).value((Object)"Life Sciences Biochemistry, Genetics and Molecular Biology Molecular Biology Cancer and biochemical research")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.rights.license'][0].value", (Object[])new Object[0]).value((Object)"cc-by")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].metadata['dc.type'][0].value", (Object[])new Object[0]).value((Object)"Article")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Object[])new Object[0]).value((Object)1)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Object[])new Object[0]).value((Object)1)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Object[])new Object[0]).value((Object)20)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Object[])new Object[0]).value((Object)0));
            ArgumentCaptor urlCaptor = ArgumentCaptor.forClass(String.class);
            ArgumentCaptor paramsCaptor = ArgumentCaptor.forClass(Map.class);
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), (String)urlCaptor.capture(), (Map)paramsCaptor.capture());
            Assert.assertEquals((long)2L, (long)urlCaptor.getAllValues().size());
            Assert.assertEquals((Object)"https://api.openalex.org/works", urlCaptor.getAllValues().get(0));
            Assert.assertEquals((Object)"https://api.openalex.org/works", urlCaptor.getAllValues().get(1));
            Assert.assertEquals((long)2L, (long)paramsCaptor.getAllValues().size());
            Map capturedParams = (Map)paramsCaptor.getAllValues().get(0);
            Assert.assertTrue((boolean)capturedParams.containsKey("uriParameters"));
            Assert.assertEquals((Object)"doi:10.1016/s0021-9258(19)52451-6", ((Map)capturedParams.get("uriParameters")).get("filter"));
            Assert.assertEquals((Object)"20", ((Map)capturedParams.get("uriParameters")).get("per_page"));
            Assert.assertEquals((Object)"1", ((Map)capturedParams.get("uriParameters")).get("page"));
            Map capturedParams1 = (Map)paramsCaptor.getAllValues().get(1);
            Assert.assertTrue((boolean)capturedParams1.containsKey("uriParameters"));
            Assert.assertEquals((Object)"doi:10.1016/s0021-9258(19)52451-6", ((Map)capturedParams1.get("uriParameters")).get("filter"));
        }
    }

    @Test
    public void findOneOpenalexPublicationByDOIExternalSourceEntriesWithUrlDOIQueryTest() throws Exception {
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-publication-single.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openalexPublicationByDOI/entries", (Object[])new Object[0]).param("query", new String[]{"https://doi.org/10.1016/s0021-9258(19)52451-6"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries[0].id", (Object[])new Object[0]).value((Object)"W1775749144"));
            ArgumentCaptor urlCaptor = ArgumentCaptor.forClass(String.class);
            ArgumentCaptor paramsCaptor = ArgumentCaptor.forClass(Map.class);
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)2))).executeHttpGetRequest(ArgumentMatchers.anyInt(), (String)urlCaptor.capture(), (Map)paramsCaptor.capture());
            Assert.assertEquals((long)2L, (long)urlCaptor.getAllValues().size());
            Assert.assertEquals((Object)"https://api.openalex.org/works", urlCaptor.getAllValues().get(0));
            Assert.assertEquals((Object)"https://api.openalex.org/works", urlCaptor.getAllValues().get(1));
            Assert.assertEquals((long)2L, (long)paramsCaptor.getAllValues().size());
            Map capturedParams = (Map)paramsCaptor.getAllValues().get(0);
            Assert.assertTrue((boolean)capturedParams.containsKey("uriParameters"));
            Assert.assertEquals((Object)"doi:10.1016/s0021-9258(19)52451-6", ((Map)capturedParams.get("uriParameters")).get("filter"));
            Assert.assertEquals((Object)"20", ((Map)capturedParams.get("uriParameters")).get("per_page"));
            Assert.assertEquals((Object)"1", ((Map)capturedParams.get("uriParameters")).get("page"));
            Map capturedParams1 = (Map)paramsCaptor.getAllValues().get(1);
            Assert.assertTrue((boolean)capturedParams1.containsKey("uriParameters"));
            Assert.assertEquals((Object)"doi:10.1016/s0021-9258(19)52451-6", ((Map)capturedParams1.get("uriParameters")).get("filter"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createWorkspaceItemFromOpenAlexPubIdTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        AtomicReference idRef1 = new AtomicReference();
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("openalex-publication-by-author-id.json");){
            String jsonResponse = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            Mockito.when((Object)this.liveImportClient.executeHttpGetRequest(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenReturn((Object)jsonResponse);
            String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/submission/workspaceitems", (Object[])new Object[0]).param("owningCollection", new String[]{col1.getID().toString()}).param("embed", new String[]{"item,sections,collection"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost:8080/server/api/integration/externalsources/openalexPublicationByDOI/entryValues/W1775749144")).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef1.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.name", (Object[])new Object[0]).value((Object)"PROTEIN MEASUREMENT WITH THE FOLIN PHENOL REAGENT")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.contributor.author']", (Matcher)Matchers.hasSize((int)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.contributor.author'][0].value", (Object[])new Object[0]).value((Object)"OliverH. Lowry")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.contributor.author'][1].value", (Object[])new Object[0]).value((Object)"NiraJ. Rosebrough")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.contributor.author'][2].value", (Object[])new Object[0]).value((Object)"A. Farr")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.contributor.author'][3].value", (Object[])new Object[0]).value((Object)"RoseJ. Randall")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.identifier.other']", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.identifier.other'][0].value", (Object[])new Object[0]).value((Object)"https://pubmed.ncbi.nlm.nih.gov/14907713")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.identifier.other'][1].value", (Object[])new Object[0]).value((Object)"/best_oa_location/pdf_url")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.date.issued'][0].value", (Object[])new Object[0]).value((Object)"1951-11-01")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.identifier.openalex'][0].value", (Object[])new Object[0]).value((Object)"W1775749144")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['oaire.citation.volume'][0].value", (Object[])new Object[0]).value((Object)"193")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['oaire.citation.issue'][0].value", (Object[])new Object[0]).value((Object)"1")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['oaire.citation.startPage'][0].value", (Object[])new Object[0]).value((Object)"265")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['oaire.citation.endPage'][0].value", (Object[])new Object[0]).value((Object)"275")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['oaire.version'][0].value", (Object[])new Object[0]).value((Object)"http://purl.org/coar/version/c_970fb48d4fbd8a85")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['oaire.citation.title'][0].value", (Object[])new Object[0]).value((Object)"Journal of Biological Chemistry")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.identifier.issn']", (Matcher)Matchers.hasSize((int)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.identifier.doi'][0].value", (Object[])new Object[0]).value((Object)"10.1016/s0021-9258(19)52451-6")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.language.iso'][0].value", (Object[])new Object[0]).value((Object)"en")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.title'][0].value", (Object[])new Object[0]).value((Object)"PROTEIN MEASUREMENT WITH THE FOLIN PHENOL REAGENT")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.subject']", (Matcher)Matchers.hasSize((int)13))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.subject'][9].value", (Object[])new Object[0]).value((Object)"Peer Review, Research standards")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.subject'][12].value", (Object[])new Object[0]).value((Object)"Life Sciences Biochemistry, Genetics and Molecular Biology Molecular Biology Cancer and biochemical research")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.rights.license'][0].value", (Object[])new Object[0]).value((Object)"cc-by")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item.metadata['dc.type'][0].value", (Object[])new Object[0]).value((Object)"Article")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collection.id", (Matcher)Matchers.is((Object)col1.getID().toString())));
            ArgumentCaptor urlCaptor = ArgumentCaptor.forClass(String.class);
            ArgumentCaptor paramsCaptor = ArgumentCaptor.forClass(Map.class);
            ((LiveImportClient)Mockito.verify((Object)this.liveImportClient, (VerificationMode)Mockito.times((int)1))).executeHttpGetRequest(ArgumentMatchers.anyInt(), (String)urlCaptor.capture(), (Map)paramsCaptor.capture());
            Assert.assertEquals((long)1L, (long)urlCaptor.getAllValues().size());
            Assert.assertEquals((Object)"https://api.openalex.org/works/W1775749144", (Object)urlCaptor.getValue());
            Assert.assertTrue((boolean)((Map)paramsCaptor.getValue()).isEmpty());
        }
        finally {
            WorkspaceItemBuilder.deleteWorkspaceItem((Integer)((Integer)idRef1.get()));
        }
    }
}

